/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.swing;

import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.TabbedPane;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

class TabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private static final int MIN_TAB_SIZE = 5;
    protected boolean multiline = true;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean textNoRotate;
    protected Vector tabPages = new Vector();

    TabbedPane() {
    }

    private void addPage0(String string, Icon icon, boolean bl, int n, int n2) {
        if (n < 0 || n >= this.getTabCount()) {
            this.addTab(string, icon, (Component)new JLabel(), null);
            this.setEnabledAt(this.getTabCount() - 1, bl);
            if (n2 >= 0) {
                this.setDisplayedMnemonicIndexAt(this.getTabCount() - 1, n2);
            }
        } else {
            this.insertTab(string, icon, (Component)new JLabel(), null, n);
            this.setEnabledAt(n, bl);
            if (n2 >= 0) {
                this.setDisplayedMnemonicIndexAt(n, n2);
            }
        }
    }

    private void setPage0(String string, Icon icon, boolean bl, int n, int n2) {
        this.setTitleAt(n, string);
        this.setIconAt(n, icon);
        this.setEnabledAt(n, bl);
        if (n2 >= 0) {
            this.setDisplayedMnemonicIndexAt(n, n2);
        }
    }

    private void addPage(MyPage myPage, int n) {
        int n2 = -1;
        if (myPage.text != null && (n2 = myPage.text.indexOf(38)) >= 0) {
            if (n2 < myPage.text.length()) {
                myPage.text = new StringBuilder(myPage.text).deleteCharAt(n2).toString();
            } else {
                n2 = -1;
            }
        }
        if (this.isVertical()) {
            if (myPage.text != null) {
                if (myPage.icon != null) {
                    double d;
                    int n3;
                    int n4;
                    if (this.isLeft()) {
                        n4 = 2;
                        n3 = 3;
                        d = -Math.toRadians(90.0);
                    } else {
                        n4 = 4;
                        n3 = 1;
                        d = Math.toRadians(90.0);
                    }
                    Icon icon = IscobolBeanConstants.getTextIcon((Component)this, (String)myPage.text, (int)n4);
                    myPage.icon.setImage(IscobolBeanConstants.rotateImage((Image)myPage.icon.getImage(), (double)d));
                    this.addPage0("", IscobolBeanConstants.getGraphTextIcon((ImageIcon)myPage.icon, (Icon)icon, (int)n3), myPage.enabled, n, n2);
                } else {
                    Icon icon = IscobolBeanConstants.getTextIcon((Component)this, (String)myPage.text, (int)(this.isLeft() ? 2 : 4));
                    this.addPage0("", icon, myPage.enabled, n, n2);
                }
            } else if (myPage.icon != null) {
                this.addPage0("", (Icon)myPage.icon, myPage.enabled, n, n2);
            } else {
                this.addPage0("", null, myPage.enabled, n, n2);
            }
        } else {
            this.addPage0(myPage.text, (Icon)myPage.icon, myPage.enabled, n, n2);
        }
    }

    private void setPage(MyPage myPage, int n) {
        int n2 = -1;
        if (myPage.text != null && (n2 = myPage.text.indexOf(38)) >= 0) {
            if (n2 < myPage.text.length()) {
                myPage.text = new StringBuilder(myPage.text).deleteCharAt(n2).toString();
            } else {
                n2 = -1;
            }
        }
        if (this.isVertical() && !this.textNoRotate) {
            if (myPage.text != null) {
                if (myPage.icon != null) {
                    int n3;
                    int n4;
                    if (this.isLeft()) {
                        n4 = 2;
                        n3 = 3;
                    } else {
                        n4 = 4;
                        n3 = 1;
                    }
                    Icon icon = IscobolBeanConstants.getTextIcon((Component)this, (String)myPage.text, (int)n4);
                    this.setPage0("", IscobolBeanConstants.getGraphTextIcon((ImageIcon)myPage.icon, (Icon)icon, (int)n3), myPage.enabled, n, n2);
                } else {
                    Icon icon = IscobolBeanConstants.getTextIcon((Component)this, (String)myPage.text, (int)(this.isLeft() ? 2 : 4));
                    this.setPage0("", icon, myPage.enabled, n, n2);
                }
            } else if (myPage.icon != null) {
                this.setPage0("", (Icon)myPage.icon, myPage.enabled, n, n2);
            } else {
                this.setPage0("", null, myPage.enabled, n, n2);
            }
        } else {
            this.setPage0(myPage.text, (Icon)myPage.icon, myPage.enabled, n, n2);
        }
    }

    void resetTabInsets() {
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI != null) {
            try {
                Field field;
                Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                if (clazz.isAssignableFrom(tabbedPaneUI.getClass()) && (field = clazz.getDeclaredField("tabInsets")) != null && field.getType() == Insets.class) {
                    field.setAccessible(true);
                    Insets insets = (Insets)field.get(tabbedPaneUI);
                    if (insets == null) {
                        insets = new Insets(0, 0, 0, 0);
                    }
                    field.set(tabbedPaneUI, new Insets(insets.left, insets.top, insets.right, insets.bottom));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    void addPage(String string, ImageIcon imageIcon, boolean bl, int n) {
        MyPage myPage = new MyPage(string, imageIcon, bl);
        if (n < 0 || n >= this.tabPages.size()) {
            this.tabPages.addElement(myPage);
        } else {
            this.tabPages.add(n, myPage);
        }
        this.addPage(myPage, n);
    }

    void setPageIcon(ImageIcon imageIcon, int n) {
        MyPage myPage = (MyPage)this.tabPages.elementAt(n);
        myPage.icon = imageIcon;
        if (myPage.icon != null && this.isVertical()) {
            myPage.icon.setImage(IscobolBeanConstants.rotateImage((Image)myPage.icon.getImage(), (double)(this.isLeft() ? -Math.toRadians(90.0) : Math.toRadians(90.0))));
        }
        this.setPage(myPage, n);
        this.refreshBounds();
    }

    void setPageTitle(String string, int n) {
        MyPage myPage = (MyPage)this.tabPages.elementAt(n);
        myPage.text = string;
        this.setPage(myPage, n);
        this.refreshBounds();
    }

    void setPageEnabled(boolean bl, int n) {
        MyPage myPage = (MyPage)this.tabPages.elementAt(n);
        myPage.enabled = bl;
        this.setPage(myPage, n);
        this.refreshBounds();
    }

    void removePage(int n) {
        this.tabPages.removeElementAt(n);
        this.removeTabAt(n);
        this.refreshBounds();
    }

    void setTabOrientation(int n) {
        boolean bl = this.getTabPlacement() == 2 || this.getTabPlacement() == 4;
        boolean bl2 = n == 2 || n == 4;
        this.setTabPlacement(n);
        this.adjustTabs();
        if (bl != bl2 && !this.textNoRotate) {
            this.resetTabInsets();
        }
    }

    void setTextNoRotate(boolean bl) {
        this.textNoRotate = bl;
        this.adjustTabs();
    }

    void adjustTabs() {
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.setPage((MyPage)this.tabPages.elementAt(i), i);
        }
        this.refreshBounds();
    }

    void setMultiline(boolean bl) {
        if (this.multiline != bl) {
            this.multiline = bl;
            this.setTabLayoutPolicy(this.multiline ? 0 : 1);
            this.refreshBounds();
        }
    }

    private boolean isVertical() {
        return this.getTabPlacement() == 2 || this.getTabPlacement() == 4;
    }

    private boolean isLeft() {
        return this.getTabPlacement() == 2;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.refreshBounds();
    }

    protected void jtabbedpaneSetBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    void refreshBounds() {
        switch (this.getTabPlacement()) {
            case 1: {
                super.setBounds(0, 0, this.width, this.getTabHeight());
                break;
            }
            case 3: {
                super.setBounds(0, this.height - this.getTabHeight(), this.width, this.getTabHeight());
                break;
            }
            case 2: {
                super.setBounds(0, 0, this.getTabWidth(), this.height);
                break;
            }
            case 4: {
                super.setBounds(this.width - this.getTabWidth(), 0, this.getTabWidth(), this.height);
            }
        }
    }

    int getTabHeight() {
        if (this.getTabCount() == 0) {
            return 5;
        }
        TabbedPaneUI tabbedPaneUI = this.getUI();
        Rectangle rectangle = tabbedPaneUI.getTabBounds((JTabbedPane)this, 0);
        if (rectangle != null) {
            int n = rectangle.height;
            if (this.multiline) {
                n *= tabbedPaneUI.getTabRunCount((JTabbedPane)this);
            }
            return n + 5;
        }
        return 5;
    }

    int getTabWidth() {
        if (this.getTabCount() == 0) {
            return 5;
        }
        TabbedPaneUI tabbedPaneUI = this.getUI();
        Rectangle rectangle = tabbedPaneUI.getTabBounds((JTabbedPane)this, 0);
        if (rectangle != null) {
            int n = rectangle.width;
            if (this.multiline) {
                n *= tabbedPaneUI.getTabRunCount((JTabbedPane)this);
            }
            return n + 5;
        }
        return 5;
    }
}

