/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.screenpainter.beans.types.Alphabet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Alphabet {
    public static final String ASCII = "ASCII";
    public static final String EBCDIC = "EBCDIC";
    public static final String NATIVE = "NATIVE";
    public static final String STANDARD_1 = "STANDARD-1";
    public static final String STANDARD_2 = "STANDARD-2";
    public static final String[] STANDARD_ALPHABETS = new String[]{"ASCII", "EBCDIC", "NATIVE", "STANDARD-1", "STANDARD-2"};
    private List<Entry> entries = new ArrayList();
    private String name;
    private String predefinedType;

    public Alphabet() {
    }

    public Alphabet(Alphabet alphabet) {
        this.setName(alphabet.getName());
        this.setEntries(alphabet.getEntries());
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public void setEntries(Entry[] entryArray) {
        this.entries.clear();
        this.entries.addAll(Arrays.asList(entryArray));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPredefinedType() {
        return this.predefinedType;
    }

    public void setPredefinedType(String string) {
        this.predefinedType = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Alphabet)) {
            return false;
        }
        return this.name.equals(((Alphabet)object).getName());
    }

    public static Entry createSingleItemEntry(String string) {
        return new Entry(0, new String[]{string});
    }

    public static Entry createAlsoItemEntry(String[] stringArray) {
        return new Entry(1, stringArray);
    }

    public static Entry createThroughItemEntry(String string, String string2) {
        return new Entry(2, new String[]{string, string2});
    }

    public static boolean isStandardAlphabetName(String string) {
        for (String string2 : STANDARD_ALPHABETS) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

