/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import java.io.Serializable;

public class BackgroundColorType
extends ColorType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BackgroundColorType DISABLED_COLOR = new BackgroundColorType(0, false, false);
    public static final BackgroundColorType DISABLED_COLOR2 = new BackgroundColorType(0, false, false, true);
    private boolean partOfColorProp;

    public BackgroundColorType(int n) {
        super(n, 0, false, false, false, false, false, false, false, false);
    }

    public BackgroundColorType(int n, boolean bl, boolean bl2) {
        super(n, 0, bl, bl2, false, false, false, false, false, false);
    }

    public BackgroundColorType(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public BackgroundColorType(int n, boolean bl, boolean bl2, boolean bl3) {
        this(n, bl, bl2);
        this.setPartOfColorProp(bl3);
    }

    public boolean isPartOfColorProp() {
        return this.partOfColorProp;
    }

    public void setPartOfColorProp(boolean bl) {
        this.partOfColorProp = bl;
    }

    protected BackgroundColorType() {
    }

    public static BackgroundColorType getRgbBackgroundColorType(int n) {
        BackgroundColorType backgroundColorType = new BackgroundColorType();
        backgroundColorType.rgbBackground = n;
        backgroundColorType.color = -1;
        return backgroundColorType;
    }

    public boolean hasForeground() {
        return false;
    }

    public void setBackHigh(boolean bl) {
    }

    public void setBackLow(boolean bl) {
    }

    public void setProtected(boolean bl) {
    }

    public void setForeHigh(boolean bl) {
    }

    public void setForeLow(boolean bl) {
    }

    public void setBlink(boolean bl) {
    }

    public void setUnderline(boolean bl) {
    }

    public void setReverse(boolean bl) {
    }

    protected Color getColor(ColorPalette colorPalette, boolean bl) {
        if (!bl) {
            return null;
        }
        if (this.isRgb()) {
            return new Color(this.rgbBackground);
        }
        int n = this.getBackground() - 1;
        if (n < 0) {
            return null;
        }
        if (colorPalette != null) {
            return colorPalette.getColor(n);
        }
        return defaultColors[n];
    }

    public String toString() {
        if (this.getColor() < 0) {
            return "{" + IscobolBeanConstants.getRgbString((int)this.getRgbBackground()) + "}";
        }
        int n = this.getBackground();
        if (this.partOfColorProp) {
            --n;
        }
        return n >= 0 ? "{" + n + "}" : "";
    }

    public int getBackgroundColorValue() {
        if (this.getColor() < 0) {
            return this.getRgbBackground();
        }
        int n = this.getBackground();
        if (this.partOfColorProp) {
            --n;
        }
        return n;
    }

    public boolean equals(Object object) {
        ColorType colorType = (ColorType)object;
        if (this.isRgb()) {
            return colorType.isRgb() && this.getRgbBackground() == colorType.getRgbBackground();
        }
        return !colorType.isRgb() && this.getColor() == colorType.getColor();
    }
}

