/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.Serializable;

public class ColorType
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int REVERSE = 1024;
    public static final int LOW_INTENSITY = 2048;
    public static final int HIGH_INTENSITY = 4096;
    public static final int UNDERLINE = 8192;
    public static final int BLINK = 16384;
    public static final int PROTECTED = 32768;
    public static final int BKG_LOW_INTENSITY = 65536;
    public static final int BKG_HIGH_INTENSITY = 131072;
    public static final int BLACK = 1;
    public static final int DARK_BLUE = 2;
    public static final int DARK_GREEN = 3;
    public static final int DARK_CYAN = 4;
    public static final int DARK_RED = 5;
    public static final int DARK_MAGENTA = 6;
    public static final int DARK_BROWN = 7;
    public static final int GRAY = 8;
    public static final int DARK_GRAY = 9;
    public static final int BLUE = 10;
    public static final int GREEN = 11;
    public static final int CYAN = 12;
    public static final int RED = 13;
    public static final int MAGENTA = 14;
    public static final int YELLOW = 15;
    public static final int WHITE = 16;
    public static final ColorType STANDARD_COLOR = new ColorType(257);
    public static final ColorType INPUT_FIELD_COLOR = new ColorType(513);
    public static final ColorType DISABLED_COLOR = new ColorType(0);
    protected static final Color[] defaultColors = new Color[]{new Color(0, 0, 0), new Color(0, 0, 128), new Color(0, 128, 0), new Color(0, 128, 128), new Color(128, 0, 0), new Color(128, 0, 128), new Color(128, 128, 0), SystemColor.control, new Color(128, 128, 128), new Color(0, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(255, 255, 0), new Color(255, 255, 255)};
    private static final Color RPT_LIGHT_GRAY = new Color(192, 192, 192);
    protected int color = 0;
    protected int rgbForeground;
    protected int rgbBackground;

    protected ColorType() {
    }

    public ColorType(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        this.color = n * 32 + n2;
        if (bl) {
            this.color += 131072;
        } else if (bl2) {
            this.color += 65536;
        }
        if (bl3) {
            this.color += 4096;
        } else if (bl4) {
            this.color += 2048;
        }
        if (bl5) {
            this.color += 1024;
        }
        if (bl6) {
            this.color += 32768;
        }
        if (bl7) {
            this.color += 16384;
        }
        if (bl8) {
            this.color += 8192;
        }
    }

    public ColorType(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        if (n < 0) {
            n = 0;
        }
        this.color = n;
        if (bl) {
            this.color += 131072;
        } else if (bl2) {
            this.color += 65536;
        }
        if (bl3) {
            this.color += 4096;
        } else if (bl4) {
            this.color += 2048;
        }
        if (bl5) {
            this.color += 1024;
        }
        if (bl6) {
            this.color += 32768;
        }
        if (bl7) {
            this.color += 16384;
        }
        if (bl8) {
            this.color += 8192;
        }
    }

    public ColorType(int n, int n2) {
        this(-1, n, n2);
    }

    public ColorType(int n) {
        this(n, 0, 0);
    }

    public ColorType(int n, int n2, int n3) {
        this.rgbBackground = n2;
        this.rgbForeground = n3;
        this.color = n;
    }

    public static ColorType getColor(int n, int n2) {
        return new ColorType(n, n2, false, false, false, false, false, false, false, false);
    }

    public static ColorType getColor(int n) {
        return new ColorType(n);
    }

    public int getColor() {
        return this.color;
    }

    public int getRgbForeground() {
        return this.rgbForeground;
    }

    public int getRgbBackground() {
        return this.rgbBackground;
    }

    public int getForeground() {
        return this.color % 1024 % 32;
    }

    public int getBackground() {
        return this.color % 1024 / 32;
    }

    public boolean isBackHigh() {
        return this.color >= 0 && (this.color & 0x20000) == 131072;
    }

    public void setBackHigh(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isBackHigh()) {
                    this.color += 131072;
                }
            } else if (this.isBackHigh()) {
                this.color -= 131072;
            }
        }
    }

    public boolean isBackLow() {
        return this.color >= 0 && (this.color & 0x10000) == 65536;
    }

    public void setBackLow(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isBackLow()) {
                    this.color += 65536;
                }
            } else if (this.isBackLow()) {
                this.color -= 65536;
            }
        }
    }

    public boolean isProtected() {
        return this.color >= 0 && (this.color & 0x8000) == 32768;
    }

    public void setProtected(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isProtected()) {
                    this.color += 32768;
                }
            } else if (this.isProtected()) {
                this.color -= 32768;
            }
        }
    }

    public boolean isBlink() {
        return this.color >= 0 && (this.color & 0x4000) == 16384;
    }

    public void setBlink(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isBlink()) {
                    this.color += 16384;
                }
            } else if (this.isBlink()) {
                this.color -= 16384;
            }
        }
    }

    public boolean isUnderline() {
        return this.color >= 0 && (this.color & 0x2000) == 8192;
    }

    public void setUnderline(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isUnderline()) {
                    this.color += 8192;
                }
            } else if (this.isUnderline()) {
                this.color -= 8192;
            }
        }
    }

    public boolean isForeHigh() {
        return this.color >= 0 && (this.color & 0x1000) == 4096;
    }

    public void setForeHigh(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isForeHigh()) {
                    this.color += 4096;
                }
            } else if (this.isForeHigh()) {
                this.color -= 4096;
            }
        }
    }

    public boolean isForeLow() {
        return this.color >= 0 && (this.color & 0x800) == 2048;
    }

    public void setForeLow(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isForeLow()) {
                    this.color += 2048;
                }
            } else if (this.isForeLow()) {
                this.color -= 2048;
            }
        }
    }

    public boolean isReverse() {
        return this.color >= 0 && (this.color & 0x400) == 1024;
    }

    public void setReverse(boolean bl) {
        if (!this.isRgb()) {
            if (bl) {
                if (!this.isReverse()) {
                    this.color += 1024;
                }
            } else if (this.isReverse()) {
                this.color -= 1024;
            }
        }
    }

    public boolean isRgb() {
        return this.color < 0;
    }

    public boolean isDisabled() {
        return !this.isRgb() && this.color == 0;
    }

    public String toString() {
        if (this.color < 0) {
            return "[" + IscobolBeanConstants.getRgbString((int)this.rgbBackground) + "," + IscobolBeanConstants.getRgbString((int)this.rgbForeground) + "]";
        }
        return "{" + this.color + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ColorType)) {
            return false;
        }
        ColorType colorType = (ColorType)object;
        if (this.isRgb()) {
            return colorType.isRgb() && this.rgbForeground == colorType.rgbForeground && this.rgbBackground == colorType.rgbBackground;
        }
        return !colorType.isRgb() && this.color == colorType.color;
    }

    public Object clone() {
        ColorType colorType;
        try {
            colorType = (ColorType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        colorType.color = this.color;
        colorType.rgbBackground = this.rgbBackground;
        colorType.rgbForeground = this.rgbForeground;
        return colorType;
    }

    protected Color getColor(ColorPalette colorPalette, boolean bl) {
        if (this.isRgb()) {
            if (bl) {
                return new Color(this.rgbBackground);
            }
            return new Color(this.rgbForeground);
        }
        if (bl) {
            int n = this.getBackground() - 1;
            if (this.isBackHigh() && n < 8) {
                n += 8;
            }
            if (n < 0) {
                return null;
            }
            if (colorPalette != null) {
                return colorPalette.getColor(n);
            }
            return defaultColors[n];
        }
        int n = this.getForeground() - 1;
        if (this.isForeHigh() && n < 8) {
            n += 8;
        }
        if (n < 0) {
            return null;
        }
        if (colorPalette != null) {
            return colorPalette.getColor(n);
        }
        return defaultColors[n];
    }

    public Color getBackgroundColor(ColorPalette colorPalette) {
        return this.getColor(colorPalette, !this.isReverse());
    }

    public Color getForegroundColor(ColorPalette colorPalette) {
        return this.getColor(colorPalette, this.isReverse());
    }

    public boolean hasBackground() {
        return true;
    }

    public boolean hasForeground() {
        return true;
    }

    public static Color getDefaultColor(int n, boolean bl) {
        return !bl || n != 7 ? defaultColors[n] : RPT_LIGHT_GRAY;
    }
}

