/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.filedesigner.fileimport.Fd;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.DataSetList;
import com.iscobol.screenpainter.beans.types.FDAttributes;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.FileSection;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;

public class FileSection {
    private List<FDObj> fdEntries = new ArrayList();
    private List<FileEntry> slEntries = new ArrayList();
    private List<FileEntry> declEntries = new ArrayList();
    private Map<String, FDAttributes> fdAttributes = new HashMap();
    private DataSetList dataSets = new DataSetList();

    public FileEntry[] getFDEntries() {
        FileEntry[] fileEntryArray = new FileEntry[this.fdEntries.size()];
        int n = 0;
        for (FDObj fDObj : this.fdEntries) {
            fileEntryArray[n++] = fDObj.fEntry;
        }
        return fileEntryArray;
    }

    public void setFDEntries(FileEntry[] fileEntryArray) {
        this.fdEntries.clear();
        if (fileEntryArray != null) {
            for (int i = 0; i < fileEntryArray.length; ++i) {
                this.addFDEntry(fileEntryArray[i]);
            }
        }
    }

    public void addFDEntry(FileEntry fileEntry) {
        FDObj fDObj = new FDObj(fileEntry);
        if (this.fdEntries.contains(fDObj)) {
            this.fdEntries.remove(fDObj);
        }
        this.fdEntries.add(fDObj);
    }

    public void addFDEntry(FileEntry fileEntry, VariableTypeList variableTypeList) {
        FDObj fDObj = new FDObj(fileEntry);
        fDObj.vtList = variableTypeList;
        if (this.fdEntries.contains(fDObj)) {
            this.fdEntries.remove(fDObj);
        }
        this.fdEntries.add(fDObj);
    }

    private FDObj getFDEntry(String string, String string2) {
        for (FDObj fDObj : this.fdEntries) {
            if (!fDObj.fEntry.getFilename().equals(string) || !PluginUtilities.equals((Object)fDObj.fEntry.getReplacingPhrase(), (Object)string2)) continue;
            return fDObj;
        }
        return null;
    }

    public void removeFDEntry(FileEntry fileEntry) {
        FDObj fDObj = this.getFDEntry(fileEntry.getFilename(), fileEntry.getReplacingPhrase());
        if (fDObj != null) {
            this.fdEntries.remove(fDObj);
        }
    }

    public FileEntry[] getSLEntries() {
        return this.slEntries.toArray(new FileEntry[this.slEntries.size()]);
    }

    public void setSLEntries(FileEntry[] fileEntryArray) {
        this.slEntries.clear();
        if (fileEntryArray != null) {
            for (int i = 0; i < fileEntryArray.length; ++i) {
                this.addSLEntry(fileEntryArray[i]);
            }
        }
    }

    public void addSLEntry(FileEntry fileEntry) {
        if (this.slEntries.contains(fileEntry)) {
            this.slEntries.remove(fileEntry);
        }
        this.slEntries.add(fileEntry);
    }

    private FileEntry getSLEntry(String string) {
        for (FileEntry fileEntry : this.slEntries) {
            if (!fileEntry.getFilename().equals(string)) continue;
            return fileEntry;
        }
        return null;
    }

    public void removeSLEntry(FileEntry fileEntry) {
        if ((fileEntry = this.getSLEntry(fileEntry.getFilename())) != null) {
            this.slEntries.remove(fileEntry);
        }
    }

    public FileEntry[] getDeclarativeEntries() {
        return this.declEntries.toArray(new FileEntry[this.declEntries.size()]);
    }

    public void setDeclarativeEntries(FileEntry[] fileEntryArray) {
        this.declEntries.clear();
        if (fileEntryArray != null) {
            for (int i = 0; i < fileEntryArray.length; ++i) {
                this.addDeclarativeEntry(fileEntryArray[i]);
            }
        }
    }

    public void addDeclarativeEntry(FileEntry fileEntry) {
        if (this.declEntries.contains(fileEntry)) {
            this.declEntries.remove(fileEntry);
        }
        this.declEntries.add(fileEntry);
    }

    private FileEntry getDCEntry(String string) {
        for (FileEntry fileEntry : this.declEntries) {
            if (!fileEntry.getFilename().equals(string)) continue;
            return fileEntry;
        }
        return null;
    }

    public void removeDeclarativeEntry(FileEntry fileEntry) {
        if ((fileEntry = this.getDCEntry(fileEntry.getFilename())) != null) {
            this.declEntries.remove(fileEntry);
        }
    }

    public int findFDName(String string) {
        for (int i = 0; i < this.dataSets.getSettingCount(); ++i) {
            if (!((DataSet)this.dataSets.getSettingAt(i)).getFDName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public void addDataSet(int n, DataSet dataSet) {
        this.dataSets.addSetting(n, (SettingItem)dataSet);
    }

    public void addDataSet(DataSet dataSet) {
        this.dataSets.addSetting((SettingItem)dataSet);
    }

    public int findDataSet(String string) {
        for (int i = 0; i < this.dataSets.getSettingCount(); ++i) {
            if (!((DataSet)this.dataSets.getSettingAt(i)).getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public int removeDataSet(DataSet dataSet) {
        int n = this.findDataSet(dataSet.getName());
        if (n >= 0) {
            this.dataSets.removeSetting(n);
        }
        return n;
    }

    public void setDataSets(DataSet[] dataSetArray) {
        this.dataSets.setSettings((SettingItem[])dataSetArray);
    }

    public DataSet[] getDataSets() {
        DataSet[] dataSetArray = new DataSet[this.dataSets.getSettingCount()];
        this.dataSets.toArray((SettingItem[])dataSetArray);
        return dataSetArray;
    }

    public DataSetList getDataSetList() {
        return this.dataSets;
    }

    public void addFDAttributes(FDAttributes fDAttributes) {
        this.fdAttributes.put(fDAttributes.getFDName().toLowerCase(), fDAttributes);
    }

    public void removeFDAttributes(FDAttributes fDAttributes) {
        this.fdAttributes.remove(fDAttributes.getFDName().toLowerCase());
    }

    public void removeFDAttributes(String string) {
        this.fdAttributes.remove(string.toLowerCase());
    }

    public FDAttributes getFDAttributes(String string) {
        return (FDAttributes)this.fdAttributes.get(string.toLowerCase());
    }

    public void setFDAttributes(FDAttributes[] fDAttributesArray) {
        this.fdAttributes.clear();
        for (int i = 0; i < fDAttributesArray.length; ++i) {
            this.addFDAttributes(fDAttributesArray[i]);
        }
    }

    public FDAttributes[] getFDAttributes() {
        return this.fdAttributes.values().toArray(new FDAttributes[this.fdAttributes.size()]);
    }

    public VariableTypeList[] getFDEntryVariables(IProject iProject) {
        VariableTypeList[] variableTypeListArray = new VariableTypeList[this.fdEntries.size()];
        int n = 0;
        for (FDObj fDObj : this.fdEntries) {
            if (fDObj.vtList == null) {
                fDObj.vtList = this.analyzeCopy(fDObj, iProject);
            }
            variableTypeListArray[n++] = fDObj.vtList;
        }
        return variableTypeListArray;
    }

    private VariableTypeList analyzeCopy(FDObj fDObj, IProject iProject) {
        String string = null;
        if (!fDObj.fEntry.isLinked()) {
            string = fDObj.fEntry.getBody();
        }
        try {
            Fd fd = PluginUtilities.analyzeFD((String)string, (String)fDObj.fEntry.getPath(), (IProject)iProject);
            if (fd != null) {
                return fd.getVariableTypeList();
            }
        }
        catch (Exception exception) {
            ConsolePlugin.log((IStatus)new Status(4, "com.iscobol.plugins.screenpainter.IscobolScreenPainter", exception.getClass().hashCode(), exception.getMessage(), (Throwable)exception));
        }
        return new VariableTypeList();
    }
}

