/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.interfaces.runtime.IFontCmp;
import com.iscobol.interfaces.runtime.IRuntime;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.beans.types.ResourceWithHandleType;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.HashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class FontType
extends ResourceWithHandleType
implements Serializable,
Comparable,
Cloneable {
    public static final int STANDARD = 1;
    public static final int BOLD = 2;
    public static final int ITALIC = 4;
    public static final int UNDERLINE = 8;
    public static final int STRIKETHROUGH = 16;
    public static final String LARGE_FONT = "large-font";
    public static final String DEFAULT_FONT = "default-font";
    public static final String SMALL_FONT = "small-font";
    public static final String FIXED_FONT = "fixed-font";
    public static final String TRADITIONAL_FONT = "traditional-font";
    public static final String MEDIUM_FONT = "medium-font";
    private static final String[] STDFONT_NAMES = new String[]{"large-font", "default-font", "small-font", "fixed-font", "traditional-font", "medium-font"};
    private static final long serialVersionUID = 1L;
    private int style;
    private Font font;
    private String displayName;
    private String name;
    private float size;

    private FontType() {
    }

    public FontType(String string) {
        this();
        this.setName(string);
    }

    public FontType(String string, String string2, float f, int n, String string3) {
        this(string, string2, f, n, string3, 0);
    }

    public FontType(String string, String string2, float f, int n, String string3, int n2) {
        this.setDisplayName(string);
        this.setName(string2);
        this.setStyle(n);
        this.setSize(f);
        this.setHandleName(string3);
    }

    public static boolean isStandardFontName(String string) {
        for (int i = 0; i < STDFONT_NAMES.length; ++i) {
            if (!string.equalsIgnoreCase(STDFONT_NAMES[i])) continue;
            return true;
        }
        return false;
    }

    public static FontType getStandardFont(String string) {
        if (string == null || !FontType.isStandardFontName((String)string)) {
            string = "default-font";
        }
        return FontType.getFont((String)string, (String)string);
    }

    public static FontType getNullFont() {
        return FontType.getFont((String)"", (String)"default-font");
    }

    private static FontType getFont(String string, String string2) {
        FontType fontType = new FontType();
        fontType.displayName = string;
        fontType.style = 1;
        IRuntime iRuntime = Factory.getRuntime(null);
        IFontCmp iFontCmp = iRuntime.getStdFont(string2);
        fontType.name = iFontCmp.getName();
        fontType.size = iFontCmp.getSize();
        if ((iFontCmp.getStyle() & 1) == 1) {
            fontType.style += 2;
        }
        if ((iFontCmp.getStyle() & 2) == 2) {
            fontType.style += 4;
        }
        return fontType;
    }

    public void copyFrom(FontType fontType) {
        this.setDisplayName(fontType.displayName);
        this.setName(fontType.name);
        this.setStyle(fontType.style);
        this.setSize(fontType.size);
        this.setHandleName(fontType.handleName);
    }

    public void setHandleName(String string) {
        super.setHandleName(string);
        if (string != null && this.displayName == null) {
            this.displayName = string;
        }
    }

    public boolean isStandardFont() {
        return (this.style & 1) == 1;
    }

    public boolean isNullFont() {
        return this.displayName.length() == 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        if (this.displayName == null && string != null) {
            this.displayName = string;
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public boolean isBold() {
        return (this.style & 2) == 2;
    }

    public boolean isUnderline() {
        return (this.style & 8) == 8;
    }

    public boolean isItalic() {
        return (this.style & 4) == 4;
    }

    public boolean isStrikethrough() {
        return (this.style & 0x10) == 16;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int getStyle() {
        return this.style;
    }

    public static Font getFont(FontType fontType, int n) {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, fontType.name);
        float f = fontType.size * (float)n / 72.0f;
        hashMap.put(TextAttribute.SIZE, new Float(f));
        if (fontType.isBold()) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (fontType.isItalic()) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fontType.isUnderline()) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (fontType.isStrikethrough()) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(hashMap);
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = FontType.getFont((FontType)this, (int)Toolkit.getDefaultToolkit().getScreenResolution());
        }
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public Object clone() {
        FontType fontType = new FontType();
        fontType.setDisplayName(this.displayName);
        fontType.setHandleName(this.handleName);
        fontType.setHandle(this.getHandle());
        fontType.setSize(this.size);
        fontType.setStyle(this.style);
        fontType.setFont(this.font);
        fontType.setName(this.name);
        return fontType;
    }

    private int compareDisplayName(String string, String string2) {
        if (string != null) {
            return string2 != null ? string.compareToIgnoreCase(string2) : 1;
        }
        return string2 != null ? -1 : 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FontType)) {
            return 1;
        }
        FontType fontType = (FontType)object;
        int n = this.name.compareToIgnoreCase(fontType.name);
        if (n == 0) {
            n = this.style - fontType.style;
            if (n == 0) {
                n = (int)(this.size - fontType.size);
                if (n == 0) {
                    return this.compareDisplayName(this.displayName, fontType.displayName);
                }
                return n;
            }
            return n;
        }
        return n;
    }

    public String getDefaultHandleName() {
        if (this.isStandardFont()) {
            return null;
        }
        return this.displayName;
    }
}

