/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;

public class ForegroundColorType
extends ColorType {
    private static final long serialVersionUID = 1L;
    public static final ForegroundColorType DISABLED_COLOR = new ForegroundColorType(0, false, false);
    public static final ForegroundColorType DISABLED_COLOR2 = new ForegroundColorType(0, false, false, true);
    private boolean partOfColorProp;

    public ForegroundColorType(int n) {
        super(0, n, false, false, false, false, false, false, false, false);
    }

    public ForegroundColorType(int n, boolean bl, boolean bl2) {
        super(0, n, bl, bl2, false, false, false, false, false, false);
    }

    public ForegroundColorType(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ForegroundColorType(int n, boolean bl, boolean bl2, boolean bl3) {
        this(n, bl, bl2);
        this.setPartOfColorProp(bl3);
    }

    public boolean isPartOfColorProp() {
        return this.partOfColorProp;
    }

    public void setPartOfColorProp(boolean bl) {
        this.partOfColorProp = bl;
    }

    protected ForegroundColorType() {
    }

    public static ForegroundColorType getRgbForegroundColorType(int n) {
        ForegroundColorType foregroundColorType = new ForegroundColorType();
        foregroundColorType.rgbForeground = n;
        foregroundColorType.color = -1;
        return foregroundColorType;
    }

    public void setBackHigh(boolean bl) {
    }

    public void setBackLow(boolean bl) {
    }

    public void setProtected(boolean bl) {
    }

    public void setForeHigh(boolean bl) {
    }

    public void setForeLow(boolean bl) {
    }

    public void setBlink(boolean bl) {
    }

    public void setUnderline(boolean bl) {
    }

    public void setReverse(boolean bl) {
    }

    public String toString() {
        if (this.getColor() < 0) {
            return "{" + IscobolBeanConstants.getRgbString((int)this.getRgbForeground()) + "}";
        }
        int n = this.getForeground();
        if (this.partOfColorProp) {
            --n;
        }
        return n >= 0 ? "{" + n + "}" : "";
    }

    public int getForegroundColorValue() {
        if (this.getColor() < 0) {
            return this.getRgbForeground();
        }
        int n = this.getForeground();
        if (this.partOfColorProp) {
            --n;
        }
        return n;
    }

    protected Color getColor(ColorPalette colorPalette, boolean bl) {
        if (bl) {
            return null;
        }
        if (this.isRgb()) {
            return new Color(this.rgbForeground);
        }
        int n = this.getForeground() - 1;
        if (n < 0) {
            return null;
        }
        if (colorPalette != null) {
            return colorPalette.getColor(n);
        }
        return defaultColors[n];
    }

    public boolean hasBackground() {
        return false;
    }

    public boolean equals(Object object) {
        ColorType colorType = (ColorType)object;
        if (this.isRgb()) {
            return colorType.isRgb() && this.getRgbForeground() == colorType.getRgbForeground();
        }
        return !colorType.isRgb() && this.getColor() == colorType.getColor();
    }
}

