/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.screenpainter.beans.types.OccursClause;
import java.util.StringTokenizer;

public class OccursClause {
    public static final String OCCURS_PROPERTY_ID = "occurs";
    public static final String KEYS_PROPERTY_ID = "keys";
    public static final String INDEXED_PROPERTY_ID = "indexed";
    public static final String DYNAMIC_PROPERTY_ID = "dynamic";
    public static final String FIXED_PROPERTY_ID = "fixed";
    public static final String TIMES_PROPERTY_ID = "times";
    public static final String MIN_PROPERTY_ID = "min";
    public static final String MAX_PROPERTY_ID = "max";
    public static final String DEPENDING_ON_PROPERTY_ID = "depOn";
    public static final String KEY_LIST_PROPERTY_ID = "keyList";
    public static final String INDEXES_PROPERTY_ID = "indexes";
    public static final String CAPACITY_PROPERTY_ID = "capacity";
    private boolean occurs;
    private boolean keys;
    private boolean indexed;
    private boolean dynamic;
    private boolean fixed = true;
    private int times;
    private int min;
    private int max;
    private String depOn;
    private String keyList;
    private String indexes;
    private String capacity;

    public static OccursClause getOccurs() {
        return new OccursClause();
    }

    public static OccursClause getOccursFixed(int n) {
        OccursClause occursClause = new OccursClause();
        occursClause.setOccurs(true);
        occursClause.setFixed(true);
        occursClause.setTimes(n);
        return occursClause;
    }

    public static OccursClause getOccursDepOn(int n, int n2, String string) {
        OccursClause occursClause = new OccursClause();
        occursClause.setOccurs(true);
        occursClause.setFixed(false);
        occursClause.setMin(n);
        occursClause.setMax(n2);
        occursClause.setDepOn(string);
        return occursClause;
    }

    public static OccursClause getOccursDynamic() {
        OccursClause occursClause = new OccursClause();
        occursClause.setOccurs(true);
        occursClause.setDynamic(true);
        return occursClause;
    }

    public boolean isOccurs() {
        return this.occurs;
    }

    public void setOccurs(boolean bl) {
        this.occurs = bl;
    }

    public int getTimes() {
        return this.times;
    }

    public void setTimes(int n) {
        this.times = n;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String string) {
        this.capacity = string;
    }

    public String getDepOn() {
        return this.depOn;
    }

    public void setDepOn(String string) {
        this.depOn = string;
    }

    public String getKeyList() {
        return this.keyList;
    }

    public void setKeyList(String string) {
        this.keyList = string;
    }

    public void setKeyList(boolean[] blArray, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(blArray[i] ? (char)'A' : 'D');
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(";");
        }
        this.setKeyList(stringBuilder.toString());
    }

    public void getKeyList(KeyList keyList) {
        if (this.keyList == null) {
            keyList.ascending = new boolean[0];
            keyList.keys = new String[0];
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.keyList, ";");
            keyList.ascending = new boolean[stringTokenizer.countTokens()];
            keyList.keys = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                keyList.ascending[n] = string.charAt(0) == 'A';
                keyList.keys[n] = string.substring(1);
                ++n;
            }
        }
    }

    public boolean isKeys() {
        return this.keys;
    }

    public void setKeys(boolean bl) {
        this.keys = bl;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public void setIndexed(boolean bl) {
        this.indexed = bl;
    }

    public String getIndexes() {
        return this.indexes;
    }

    public void setIndexes(String string) {
        this.indexes = string;
    }

    public void setIndexList(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(",");
        }
        this.setIndexes(stringBuilder.toString());
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean bl) {
        this.dynamic = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.occurs) {
            return stringBuilder.toString();
        }
        if (this.dynamic) {
            stringBuilder.append(DYNAMIC_PROPERTY_ID);
            if (this.capacity != null && this.capacity.length() > 0) {
                stringBuilder.append(" [");
                stringBuilder.append(this.capacity);
                stringBuilder.append("]");
            }
        } else if (this.times > 0) {
            stringBuilder.append(this.times);
            stringBuilder.append(" times ");
        } else {
            stringBuilder.append(this.min);
            stringBuilder.append(" to ");
            stringBuilder.append(this.max);
            stringBuilder.append(" ");
            if (this.depOn != null && this.depOn.length() > 0) {
                stringBuilder.append("depending on ");
                stringBuilder.append(this.depOn);
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }
}

