/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.beans.types;

import com.iscobol.interfaces.compiler.ICompiler;
import com.iscobol.interfaces.compiler.IDataDivision;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.interfaces.compiler.IOptionList;
import com.iscobol.interfaces.compiler.IPcc;
import com.iscobol.interfaces.compiler.IVariableDeclaration;
import com.iscobol.interfaces.compiler.IVariableDeclarationList;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.plugins.editor.util.CobolFormatter;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.SettingTreeItemList;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableType78;
import com.iscobol.screenpainter.beans.types.VariableType88;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariableTypeList
extends SettingTreeItemList {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private Map<String, List<VariableType>> varMap = new TreeMap(PluginUtilities.ignoreCaseComparator);
    private String fdName;
    private boolean changed;
    private ScreenProgram screenProgram;

    public VariableTypeList() {
        this.setName("Variable list");
    }

    public VariableTypeList(VariableTypeList variableTypeList) {
        super((SettingTreeItemList)variableTypeList);
    }

    public static VariableType getVariable(String string, String string2, int n, int n2) {
        if (string2 != null && string2.length() > 0) {
            return VariableType.getVariable((String)string, (String)string2, (int)77);
        }
        if (VariableType.isHandleUsage((int)n2)) {
            return VariableType.getHandleVariable((int)n2, (String)string);
        }
        switch (n) {
            default: {
                return VariableType.getAlphanumericVariable((String)string);
            }
            case 1002: {
                return VariableType.getNumericVariable((String)string);
            }
            case 1009: {
                return VariableType.getIntegerVariable((String)string);
            }
            case 1010: {
                return VariableType.getUnsignedIntegerVariable((String)string);
            }
            case 1004: {
                return VariableType.getBooleanVariable((String)string);
            }
            case 1006: {
                return VariableType.getCobolGUIJavaBeanVariable((String)string);
            }
            case 1007: 
            case 1008: 
        }
        return VariableType.getVariable((String)string, (String)"", (int)1);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public VariableType[] getVariables() {
        VariableType[] variableTypeArray = new VariableType[this.getSettingCount()];
        this.settingList.toArray(variableTypeArray);
        return variableTypeArray;
    }

    public VariableType[] getConditions() {
        return this.getVariables(88);
    }

    public VariableType[] getConstants() {
        return this.getVariables(78);
    }

    public VariableType[] getVariables(int n) {
        Vector<VariableType> vector = new Vector<VariableType>();
        int n2 = this.getSettingCount();
        for (int i = 0; i < n2; ++i) {
            VariableType variableType = (VariableType)this.settingList.elementAt(i);
            if (variableType.getLevelAsInt() != n) continue;
            vector.addElement(variableType);
        }
        VariableType[] variableTypeArray = new VariableType[vector.size()];
        vector.toArray(variableTypeArray);
        return variableTypeArray;
    }

    public VariableType findVariable(String string) {
        return this.findVariable(string, this.fdName);
    }

    public VariableType findVariable(String string, String string2) {
        String string3 = string;
        int n = string3.indexOf(32);
        if (n >= 0) {
            string3 = string3.substring(0, n);
        } else {
            string = null;
        }
        return this.findVariable(string3, string, string2);
    }

    public VariableType findVariable(String string, String string2, String string3) {
        List list = (List)this.varMap.get(string);
        if (list == null) {
            return null;
        }
        if (string2 == null) {
            return (VariableType)list.get(0);
        }
        for (VariableType variableType : list) {
            if (variableType.getName().equalsIgnoreCase(string2)) {
                return variableType;
            }
            String string4 = variableType.getQName();
            if (string4.equalsIgnoreCase(string2)) {
                return variableType;
            }
            int n = string4.lastIndexOf(32);
            if (n >= 0 && (string + " of " + string4.substring(n + 1)).equalsIgnoreCase(string2)) {
                return variableType;
            }
            if (string3 == null || !(string + " of " + string3).equalsIgnoreCase(string2)) continue;
            return variableType;
        }
        return null;
    }

    public boolean hasDuplicateNames(VariableType variableType) {
        List list = (List)this.varMap.get(variableType.getName());
        return list != null && list.size() > 1;
    }

    public void putVar(VariableType variableType) {
        ArrayList<VariableType> arrayList = (ArrayList<VariableType>)this.varMap.get(variableType.getName());
        if (arrayList == null) {
            arrayList = new ArrayList<VariableType>();
            this.varMap.put(variableType.getName(), arrayList);
        }
        arrayList.add(variableType);
    }

    public void intRemoveVar(VariableType variableType) {
        List list = (List)this.varMap.get(variableType.getName());
        if (list == null) {
            return;
        }
        for (VariableType variableType2 : list) {
            if (!variableType2.getQName().equalsIgnoreCase(variableType.getQName())) continue;
            list.remove(variableType2);
            if (!list.isEmpty()) break;
            this.varMap.remove(variableType.getName());
            break;
        }
    }

    public void setSettingAt(int n, SettingItem settingItem) {
        if (n >= 0 && n < this.getSettingCount()) {
            VariableType variableType = (VariableType)this.getSettingAt(n);
            variableType.parent = null;
            variableType.parentList = null;
            this.intRemoveVar(variableType);
            this.settingList.setElementAt(settingItem, n);
            VariableType variableType2 = (VariableType)settingItem;
            variableType2.parent = null;
            variableType2.parentList = this;
            this.putVar(variableType2);
            this.changed = true;
        }
    }

    public void addVariable(int n, VariableType variableType) {
        this.addSetting(n, (SettingItem)variableType);
        this.changed = true;
    }

    public void addVariable(VariableType variableType) {
        this.addSetting(-1, (SettingItem)variableType);
        this.changed = true;
    }

    public void setVariables(SettingItem[] settingItemArray) {
        this.settingList.clear();
        this.varMap.clear();
        for (int i = 0; i < settingItemArray.length; ++i) {
            VariableType variableType = (VariableType)settingItemArray[i];
            this.addSetting((SettingItem)variableType);
            this.putVariables(variableType);
        }
        this.changed = true;
    }

    protected static VariableType check78_88(VariableType variableType) {
        if (variableType.getLevelAsInt() == 78 && !(variableType instanceof VariableType78)) {
            variableType = new VariableType78(variableType);
        } else if (variableType.getLevelAsInt() == 88 && !(variableType instanceof VariableType88)) {
            variableType = new VariableType88(variableType);
        }
        return variableType;
    }

    public void addSetting(int n, SettingItem settingItem) {
        if (settingItem != null) {
            VariableType variableType = VariableTypeList.check78_88((VariableType)((VariableType)settingItem));
            if (n >= 0 && n < this.getSettingCount()) {
                this.settingList.add(n, variableType);
            } else {
                this.settingList.addElement(variableType);
            }
            variableType.parent = null;
            variableType.parentList = this;
            this.putVar(variableType);
            this.changed = true;
        }
    }

    public void removeVariable(int n) {
        this.removeSetting(n);
        this.changed = true;
    }

    public void removeVariableFromTable(VariableType variableType) {
        this.intRemoveVar(variableType);
    }

    public void removeVariable(VariableType variableType) {
        int n;
        this.intRemoveVar(variableType);
        if (variableType.parent != null) {
            int n2 = variableType.parent.indexOf((SettingTreeItem)variableType);
            if (n2 >= 0) {
                variableType.parent.removeChild(n2);
            }
        } else if (variableType.parentList != null && (n = variableType.parentList.indexOf((SettingItem)variableType)) >= 0) {
            variableType.parentList.removeVariable(n);
        }
        this.changed = true;
    }

    public void renameVariable(String string, String string2) {
        VariableType variableType = this.findVariable(string, null);
        if (variableType != null) {
            this.intRemoveVar(variableType);
            variableType.setName(string2);
            this.putVar(variableType);
            this.changed = true;
        }
    }

    public void removeSetting(int n) {
        if (n >= 0 && n < this.settingList.size()) {
            VariableType variableType = (VariableType)this.getSettingAt(n);
            variableType.parent = null;
            variableType.parentList = null;
            this.intRemoveVar(variableType);
            this.settingList.removeElementAt(n);
            this.changed = true;
        }
    }

    public SettingItemList Clone() {
        return new VariableTypeList(this);
    }

    public SettingItem createNew() {
        return this.createNew(null, 0, null, null);
    }

    public SettingTreeItem createNew(SettingTreeItem settingTreeItem) {
        return this.createNew((VariableType)settingTreeItem, 0, null, null);
    }

    public SettingTreeItem createNew(VariableType variableType, int n, String string, String string2) {
        switch (n) {
            case 78: {
                return VariableType.get78Variable((String)this.getNewVariableName(string2 != null ? string2 : "const-item"));
            }
            case 88: {
                return VariableType.get88Variable((String)this.getNewVariableName(string2 != null ? string2 : "cond-item"));
            }
            case 77: {
                return VariableType.getDefault77Variable((String)this.getNewVariableName(string2 != null ? string2 : "wrk-item"), (String)string);
            }
            case 66: {
                return VariableType.get66Variable((String)this.getNewVariableName(string2 != null ? string2 : "ren-item"));
            }
        }
        return VariableType.getDefaultVariable((String)this.getNewVariableName(string2 != null ? string2 : "wrk-item"), (String)string, (VariableType)variableType);
    }

    public Class getType() {
        return VariableType.class;
    }

    private int getGenerationMode() {
        return this.screenProgram != null ? this.screenProgram.getCase() : IscobolScreenPainterPlugin.getIntFromStore((String)"iscobol.progfile.case");
    }

    public String getNewVariableName(String string, VariableType variableType) {
        String string2 = variableType != null ? variableType.getQName() + " of " : "";
        VariableType variableType2 = this.findVariable(string, string2 + string);
        if (variableType2 != null) {
            int n = 0;
            String string3 = string + n;
            while ((variableType2 = this.findVariable(string3, string2 + string3)) != null) {
                string3 = string + ++n;
            }
            string = string + n;
        }
        return CobolFormatter.formatUsername((String)string, (int)this.getGenerationMode());
    }

    public String getNewVariableName(String string) {
        int n;
        VariableType[] variableTypeArray = this.getAllVariables();
        VariableType variableType = null;
        for (n = 0; n < variableTypeArray.length; ++n) {
            if (!string.equalsIgnoreCase(variableTypeArray[n].getName())) continue;
            variableType = variableTypeArray[n];
            break;
        }
        if (variableType != null) {
            n = 0;
            String string2 = string + n;
            while (true) {
                variableType = null;
                for (int i = 0; i < variableTypeArray.length; ++i) {
                    if (!string2.equalsIgnoreCase(variableTypeArray[i].getName())) continue;
                    variableType = variableTypeArray[i];
                    break;
                }
                if (variableType == null) break;
                string2 = string + ++n;
            }
            string = string + n;
        }
        return CobolFormatter.formatUsername((String)string, (int)this.getGenerationMode());
    }

    public VariableType[] get01or77Variables() {
        return this.get01or77Variables(false);
    }

    public VariableType[] get01or77Variables(boolean bl) {
        Vector vector = new Vector();
        this.get01or77Variables(vector, bl);
        VariableType[] variableTypeArray = new VariableType[vector.size()];
        vector.toArray(variableTypeArray);
        return variableTypeArray;
    }

    public void get01or77Variables(Vector vector, boolean bl) {
        for (int i = 0; i < this.settingList.size(); ++i) {
            VariableType variableType = (VariableType)this.settingList.elementAt(i);
            if (bl && variableType.getLevelAsInt() == 78 || variableType.getNType() == 1000) continue;
            vector.addElement(variableType);
        }
    }

    public VariableType[] getAllVariables() {
        Vector vector = new Vector();
        this.getAllVariables(vector);
        VariableType[] variableTypeArray = new VariableType[vector.size()];
        vector.toArray(variableTypeArray);
        return variableTypeArray;
    }

    public VariableType[] getAllVariablesWithFiller() {
        Vector vector = new Vector();
        this.getAllVariablesWithFiller(vector);
        VariableType[] variableTypeArray = new VariableType[vector.size()];
        vector.toArray(variableTypeArray);
        return variableTypeArray;
    }

    public void getAllVariables(Vector vector) {
        int n = this.getSettingCount();
        for (int i = 0; i < n; ++i) {
            VariableType variableType = (VariableType)this.getSettingAt(i);
            this.addVariables(variableType, vector);
        }
    }

    public void getAllVariablesWithFiller(Vector vector) {
        int n = this.getSettingCount();
        for (int i = 0; i < n; ++i) {
            VariableType variableType = (VariableType)this.getSettingAt(i);
            this.addVariablesWithFiller(variableType, vector);
        }
    }

    private void putVariables(VariableType variableType) {
        variableType.parentList = this;
        this.putVar(variableType);
        int n = variableType.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.putVariables((VariableType)variableType.getChildAt(i));
        }
    }

    private void addVariables(VariableType variableType, Vector vector) {
        if (!variableType.isFiller()) {
            vector.addElement(variableType);
        }
        int n = variableType.getChildCount();
        for (int i = 0; i < n; ++i) {
            VariableType variableType2 = (VariableType)variableType.getChildAt(i);
            this.addVariables(variableType2, vector);
        }
    }

    private void addVariablesWithFiller(VariableType variableType, Vector vector) {
        vector.addElement(variableType);
        int n = variableType.getChildCount();
        for (int i = 0; i < n; ++i) {
            VariableType variableType2 = (VariableType)variableType.getChildAt(i);
            this.addVariablesWithFiller(variableType2, vector);
        }
    }

    public String getFdName() {
        return this.fdName;
    }

    public void setFdName(String string) {
        this.fdName = string;
    }

    public ScreenProgram getScreenProgram() {
        return this.screenProgram;
    }

    public void setScreenProgram(ScreenProgram screenProgram) {
        this.screenProgram = screenProgram;
    }

    public void reloadAllLinkedCopies(IProject iProject) {
        ArrayList arrayList = new ArrayList();
        this.getCopyRootVariables((SettingTreeItem[])this.getVariables(), arrayList);
        ICompiler iCompiler = Factory.getCompiler((IProject)iProject);
        for (VariableType variableType : arrayList) {
            int n;
            VariableType variableType2;
            int n2;
            String string = variableType.getCopyEntry();
            String string2 = variableType.getCopyFileReplacingPhrase();
            String string3 = variableType.getCopyFilePathName();
            String[] stringArray = variableType.getCopyFileOptions();
            File file = null;
            try {
                file = PluginUtilities.getCopyLocation((String)string3, (IProject)iProject);
                if (file == null) {
                }
            }
            catch (Exception exception) {}
            continue;
            VariableType variableType3 = variableType.getVParent();
            if (variableType3 != null) {
                n2 = variableType3.indexOf((SettingTreeItem)variableType);
                while (variableType3.getChildCount() > n2 && string.equals((variableType2 = (VariableType)variableType3.getChildAt(n2)).getCopyEntry()) && PluginUtilities.equals((Object)string2, (Object)variableType2.getCopyFileReplacingPhrase())) {
                    variableType3.removeChild(n2);
                }
                n = -1;
            } else {
                n = n2 = this.indexOf((SettingItem)variableType);
                while (this.getSettingCount() > n2 && string.equals((variableType2 = (VariableType)this.getSettingAt(n2)).getCopyEntry()) && PluginUtilities.equals((Object)string2, (Object)variableType2.getCopyFileReplacingPhrase())) {
                    this.removeVariable(n2);
                }
            }
            this.analyzeAndLoadCopy(variableType3, n2, new int[]{n}, file, string3, string, stringArray, variableType.isInLinkage(), iProject, iCompiler);
        }
    }

    private void getCopyRootVariables(SettingTreeItem[] settingTreeItemArray, List<VariableType> list) {
        String string = null;
        String string2 = null;
        for (SettingTreeItem settingTreeItem : settingTreeItemArray) {
            VariableType variableType = (VariableType)settingTreeItem;
            if (!PluginUtilities.equals((Object)variableType.getCopyEntry(), string) || !PluginUtilities.equals((Object)variableType.getCopyFileReplacingPhrase(), string2)) {
                string = variableType.getCopyEntry();
                string2 = variableType.getCopyFileReplacingPhrase();
                if (variableType.getCopyEntry() == null) continue;
                list.add(variableType);
                continue;
            }
            if (string != null) continue;
            this.getCopyRootVariables(variableType.getChildren(), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeAndLoadCopy(VariableType variableType, int n, int[] nArray, File file, String string, String string2, String[] stringArray, boolean bl, IProject iProject, ICompiler iCompiler) {
        StringReader stringReader = null;
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        try {
            String string3;
            Object object;
            CobolFormatter cobolFormatter;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = null;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("--replacing=")) {
                        string4 = stringArray[i].substring("--replacing=".length());
                        continue;
                    }
                    arrayList.add(stringArray[i]);
                }
            }
            arrayList.add("-sp=" + file.getParentFile().getAbsolutePath());
            arrayList.add("-efc");
            arrayList.add("-jj");
            arrayList.add(string);
            IOptionList iOptionList = iCompiler.newOptionList(arrayList.toArray(new String[arrayList.size()]));
            String string5 = null;
            if (this.screenProgram != null && (cobolFormatter = (object = this.screenProgram.getResourceRegistry()).getRepository().getEntries()) != null && ((CobolFormatter)cobolFormatter).length != 0) {
                string5 = "       repository." + EOL;
                for (int i = 0; i < ((CobolFormatter)cobolFormatter).length; ++i) {
                    string5 = string5 + "       class " + cobolFormatter[i].getCobolClassName() + EOL;
                    string5 = string5 + "            as \"" + cobolFormatter[i].getClassName() + "\"" + EOL;
                }
                string5 = string5 + ".";
            }
            object = new StringBuilder();
            cobolFormatter = new CobolFormatter(true, 0);
            ((StringBuilder)object).append(cobolFormatter.formatLine("copy '" + file.getAbsolutePath() + "'"));
            if (string4 != null) {
                ((StringBuilder)object).append("       replacing");
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string4));
                string3 = bufferedReader.readLine();
                if (string3 != null) {
                    ((StringBuilder)object).append(" ").append(string3);
                    string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        ((StringBuilder)object).append(EOL).append("       ").append(string3);
                        string3 = bufferedReader.readLine();
                    }
                }
                bufferedReader.close();
            }
            ((StringBuilder)object).append(EOL).append("       .").append(EOL);
            stringReader = PluginUtilities.getReader((String)((StringBuilder)object).toString(), null, (String)string5, (boolean)false, (boolean)true);
            PrintStream printStream3 = new PrintStream(PluginUtilities.dummyOutputStream);
            System.setOut(printStream3);
            System.setErr(printStream3);
            string3 = PluginUtilities.getClassLoader((IProject)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject));
            IPcc iPcc = VariableTypeList.pccAnalyze((String)string, (IOptionList)iOptionList, (StringReader)stringReader, (ClassLoader)((Object)string3), (ICompiler)iCompiler);
            IVariableDeclarationList iVariableDeclarationList = VariableTypeList.getVariables((IPcc)iPcc);
            if (iVariableDeclarationList == null || iVariableDeclarationList.getFirst() == null) {
                stringReader = PluginUtilities.getReader((String)((StringBuilder)object).toString(), null, (String)string5, (boolean)true, (boolean)true);
                iPcc = VariableTypeList.pccAnalyze((String)string, (IOptionList)iOptionList, (StringReader)stringReader, (ClassLoader)((Object)string3), (ICompiler)iCompiler);
                iVariableDeclarationList = VariableTypeList.getVariables((IPcc)iPcc);
            }
            if (iVariableDeclarationList != null) {
                File file2 = PluginUtilities.getCopyLocation((String)string, (IProject)iProject);
                IPcc iPcc2 = iPcc != null ? iPcc.getCobolProgram() : null;
                IVariableDeclaration iVariableDeclaration = iVariableDeclarationList.getFirst();
                while (iVariableDeclaration != null) {
                    this.loadVariable(iCompiler, iVariableDeclaration, iPcc2, variableType, n, nArray, string, string2, file2, stringArray, bl);
                    if (n >= 0) {
                        ++n;
                    }
                    iVariableDeclaration = iVariableDeclarationList.getNext();
                }
            }
        }
        catch (Exception exception) {
            PluginUtilities.log((String)exception.toString(), (Throwable)exception);
        }
        finally {
            if (stringReader != null) {
                stringReader.close();
            }
            System.setOut(printStream);
            System.setErr(printStream2);
        }
    }

    public static IPcc pccAnalyze(String string, IOptionList iOptionList, StringReader stringReader, ClassLoader classLoader, ICompiler iCompiler) {
        ClassLoader classLoader2 = null;
        Thread thread = Thread.currentThread();
        if (classLoader != null) {
            classLoader2 = thread.getContextClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        IPcc iPcc = iCompiler.analyze(string, iOptionList, iCompiler.newErrorsForCodeAnalyzer(), (Reader)stringReader, null);
        if (classLoader != null) {
            thread.setContextClassLoader(classLoader2);
        }
        return iPcc;
    }

    public static IVariableDeclarationList getVariables(IPcc iPcc) {
        IDataSection iDataSection;
        IDataDivision iDataDivision;
        IPcc iPcc2;
        if (iPcc == null || (iPcc2 = iPcc.getCobolProgram()) == null || (iDataDivision = iPcc2.getDataDivision()) == null || (iDataSection = iDataDivision.getWorkingStorageSection()) == null) {
            return null;
        }
        return iDataSection.getVariableDeclarationList();
    }

    private void loadVariable(ICompiler iCompiler, IVariableDeclaration iVariableDeclaration, IPcc iPcc, VariableType variableType, int n, int[] nArray, String string, String string2, File file, String[] stringArray, boolean bl) {
        VariableType variableType2 = VariableType.loadVariable((ICompiler)iCompiler, (IVariableDeclaration)iVariableDeclaration, (IPcc)iPcc, (VariableTypeList)this, (VariableType)variableType, (int)n, (int[])nArray, (boolean)false, (boolean)bl, (String)string, (String)string2, (File)file, (String[])stringArray);
        IVariableDeclarationList iVariableDeclarationList = iVariableDeclaration.getChildren();
        IVariableName iVariableName = iVariableDeclaration.getCapacity();
        IVariableDeclaration iVariableDeclaration2 = iVariableDeclarationList.getFirst();
        while (iVariableDeclaration2 != null) {
            if (iVariableName == null || !iVariableName.getName().equals(iVariableDeclaration2.getName())) {
                this.loadVariable(iCompiler, iVariableDeclaration2, iPcc, variableType2, -1, nArray, string, string2, file, stringArray, bl);
            }
            iVariableDeclaration2 = iVariableDeclarationList.getNext();
        }
    }
}

