/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.builder;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.builder.IIscobolProjectBuilder;
import com.iscobol.plugins.editor.builder.SourceLocation;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.builder.IscobolScreenPainterProjectBuilder;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.part.FileEditorInput;

/*
 * Exception performing whole class analysis ignored.
 */
public class IscobolScreenPainterProjectBuilder
implements IIscobolProjectBuilder {
    private Map<IFile, Item> cache = new HashMap();
    private boolean checkTimestamp = true;

    public IscobolScreenPainterProjectBuilder() {
    }

    public IscobolScreenPainterProjectBuilder(boolean bl) {
        this.checkTimestamp = bl;
    }

    public void build(IProject iProject, IProgressMonitor iProgressMonitor) {
        this.generateAll(iProject, this.checkTimestamp, iProgressMonitor);
    }

    public void generateAll(IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) {
        IscobolScreenPainterProjectBuilder.generateAllPrograms((IProject)iProject, (boolean)bl, (IProgressMonitor)iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateAllPrograms(IProject iProject, boolean bl, IProgressMonitor iProgressMonitor) {
        int n;
        IFile iFile;
        IContainer iContainer;
        Object object;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        ArrayList<ScreenFD_SL> arrayList = new ArrayList<ScreenFD_SL>();
        try {
            object = PluginUtilities.getFDFolder((IProject)iProject);
            if (object != null) {
                iContainer = object.members();
                for (int i = 0; i < ((IContainer)iContainer).length; ++i) {
                    if (iContainer[i].getType() != 1 || (iFile = (IFile)iContainer[i]).getFileExtension() == null || !iFile.getFileExtension().equals("idl")) continue;
                    arrayList.add(PluginUtilities.getDataLayout((IFile)iFile));
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        object = new ArrayList();
        try {
            iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
            if (iContainer != null) {
                iFile = iContainer.members();
                for (n = 0; n < ((IResource[])iFile).length; ++n) {
                    IFile iFile2;
                    if (iFile[n].getType() != 1 || (iFile2 = iFile[n]).getFileExtension() == null || !iFile2.getFileExtension().equals("isp")) continue;
                    object.add(PluginUtilities.getScreenProgram((IFile)iFile2));
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        iProgressMonitor.beginTask("Generate cobol sources...", (arrayList.size() + object.size()) * 2);
        try {
            com.iscobol.filedesigner.CodeGenerator codeGenerator;
            int n2 = 0;
            while (!arrayList.isEmpty()) {
                boolean bl2;
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iFile = (ScreenFD_SL)arrayList.remove(0);
                IFile iFile3 = iFile.getFile();
                iProgressMonitor.subTask("Load '" + iFile.getFile().getName() + "'");
                n = IscobolEditorPlugin.getIntFromStore((String)"iscobol.cobolgen.mode");
                codeGenerator = new com.iscobol.filedesigner.CodeGenerator((ScreenFD_SL)iFile, n);
                if (n2 == 0) {
                    codeGenerator.refreshFolders();
                }
                iProgressMonitor.worked(1);
                IFile iFile4 = null;
                try {
                    iFile4 = codeGenerator.getFDFile();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (bl) {
                    long l = new File(iFile3.getLocationURI()).lastModified();
                    long l2 = iFile4 != null ? new File(iFile4.getLocationURI()).lastModified() : Integer.MIN_VALUE;
                    bl2 = l > l2;
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    iProgressMonitor.subTask("Generate '" + iFile.getFdName() + "' files...");
                    codeGenerator.generateFD();
                    codeGenerator.generateSL();
                    codeGenerator.generatePRC();
                }
                iProgressMonitor.worked(1);
                ++n2;
            }
            n2 = 0;
            while (!object.isEmpty()) {
                boolean bl3;
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iFile = (ScreenProgram)object.remove(0);
                IFile iFile5 = iFile.getFile();
                iProgressMonitor.subTask("Load '" + iFile.getFile().getName() + "'");
                CodeGenerator codeGenerator2 = new CodeGenerator((ScreenProgram)iFile);
                if (n2 == 0) {
                    codeGenerator2.refreshFolders();
                }
                iProgressMonitor.worked(1);
                codeGenerator = null;
                try {
                    codeGenerator = codeGenerator2.getProgramFile();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (bl) {
                    long l = new File(iFile5.getLocationURI()).lastModified();
                    long l3 = codeGenerator != null ? new File(codeGenerator.getLocationURI()).lastModified() : Integer.MIN_VALUE;
                    bl3 = l > l3;
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    iProgressMonitor.subTask("Generate '" + iFile.getProgramName() + "' files...");
                    codeGenerator2.generate();
                }
                iProgressMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void clean(IProject iProject, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    public SourceLocation getScreenProgramLocation(IFile iFile, int n) {
        Item item;
        if (this.cache.containsKey(iFile)) {
            item = (Item)this.cache.get(iFile);
        } else {
            item = this.getItem(iFile);
            this.cache.put(iFile, item);
        }
        if (item != null && n > item.startEventParagraphLine) {
            return new SourceLocation(item.screenProgram.getFile(), n - item.startEventParagraphLine);
        }
        return null;
    }

    public IFile getScreenProgramFile(IFile iFile) {
        String string = iFile.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        try {
            IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iFile.getProject());
            IFile iFile2 = null;
            if (iContainer != null) {
                iFile2 = PluginUtilities.getScreenFolder((IProject)iFile.getProject()).getFile((IPath)new Path(string + "." + "isp"));
            }
            if (iFile2 != null && iFile2.exists()) {
                return iFile2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Item getItem(IFile iFile) {
        String string = iFile.getName();
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        try {
            IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iFile.getProject());
            IFile iFile2 = null;
            if (iContainer != null) {
                iFile2 = PluginUtilities.getScreenFolder((IProject)iFile.getProject()).getFile((IPath)new Path(string + "." + "isp"));
            }
            if (iFile2 == null) return null;
            if (!iFile2.exists()) {
                return null;
            }
            ScreenProgram screenProgram = PluginUtilities.getScreenProgram(iFile2);
            if (screenProgram == null) return null;
            Item item = new Item(null);
            item.screenProgram = screenProgram;
            if (!string2.equals(screenProgram.getProgramFileSuffix()) || screenProgram.getSplitSource()) {
                if (!string2.equals(screenProgram.getEventFileSuffix())) return null;
                if (!screenProgram.getSplitSource()) return null;
            }
            InputStream inputStream = iFile.getContents();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            try {
                String string3 = (screenProgram.getAnsiFormat() ? "      *" : "*>") + "start event editor code";
                String string4 = lineNumberReader.readLine();
                while (string4 != null) {
                    if (string4.equals(string3)) {
                        item.startEventParagraphLine = lineNumberReader.getLineNumber();
                        break;
                    }
                    string4 = lineNumberReader.readLine();
                }
                string4 = item;
                return string4;
            }
            catch (IOException iOException) {
                return null;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public IscobolEditor getIscobolEditor(IFile iFile) {
        ScreenProgramEditor[] screenProgramEditorArray = new ScreenProgramEditor[1];
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        new /* Unavailable Anonymous Inner Class!! */.start();
        if (screenProgramEditorArray[0] != null) {
            return screenProgramEditorArray[0].getEventParagraphsEditor();
        }
        return null;
    }
}

