/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class AddParagraphDialog
extends Dialog {
    private CCombo combo;
    private String parName;
    private int selIdx = 0;
    private String Default;
    private ElementsProvider provider;

    public AddParagraphDialog(Shell shell, String string, ElementsProvider elementsProvider) {
        super(shell);
        this.Default = string;
        this.provider = elementsProvider;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Add paragraph");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this.combo = new CCombo(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.combo.setLayoutData((Object)gridData);
        this.combo.setEditable(true);
        this.combo.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Object[] objectArray = this.provider.getElements();
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            ParagraphType paragraphType = (ParagraphType)objectArray[i];
            this.combo.add(paragraphType.getName());
            if (this.Default == null || !paragraphType.getName().equalsIgnoreCase(this.Default)) continue;
            n = i;
        }
        if (n >= 0) {
            this.combo.select(n);
            this.comboSelectionChanged();
        } else if (this.Default != null) {
            this.combo.setText(this.Default);
        }
        return composite2;
    }

    public ParagraphType openDialog() {
        if (this.open() == 0) {
            if (this.selIdx > 0) {
                return (ParagraphType)this.provider.getElements()[this.selIdx];
            }
            return new ParagraphType(this.parName);
        }
        return null;
    }

    public boolean isNewParagraph() {
        return this.selIdx <= 0;
    }

    protected void okPressed() {
        if (!PluginUtilities.isValidIdentifier((String)this.combo.getText())) {
            this.error("'" + this.parName + "' " + ISPBundle.getString((String)"invalid_identifier_msg"));
            return;
        }
        super.okPressed();
    }

    private void error(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText(this.getShell().getText());
        messageBox.setMessage(string);
        messageBox.open();
    }

    private void comboSelectionChanged() {
        this.parName = this.combo.getText();
        this.selIdx = this.combo.getSelectionIndex();
    }

    static /* synthetic */ CCombo access$000(AddParagraphDialog addParagraphDialog) {
        return addParagraphDialog.combo;
    }

    static /* synthetic */ int access$100(AddParagraphDialog addParagraphDialog) {
        return addParagraphDialog.selIdx;
    }

    static /* synthetic */ int access$102(AddParagraphDialog addParagraphDialog, int n) {
        addParagraphDialog.selIdx = n;
        return addParagraphDialog.selIdx;
    }

    static /* synthetic */ String access$202(AddParagraphDialog addParagraphDialog, String string) {
        addParagraphDialog.parName = string;
        return addParagraphDialog.parName;
    }

    static /* synthetic */ void access$300(AddParagraphDialog addParagraphDialog) {
        addParagraphDialog.comboSelectionChanged();
    }
}

