/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AddVariableDialog
extends Dialog {
    private static final int ALL = 0;
    private static final int TYPE_CONSTANT = 1;
    private static final int TYPE_OBJECT_REFERENCE = 2;
    private static final int TYPE_HANDLE_OF_WINDOW = 3;
    private static final int TYPE_HANDLE_OF_FONT = 4;
    private static final int TYPE_HANDLE_OF_MENU = 5;
    private static final int TYPE_HANDLE_OF_STATUS_BAR = 6;
    private static final int TYPE_HANDLE_OF_LAYOUT_MANAGER = 7;
    private static final int TYPE_HANDLE_OF_THREAD = 8;
    private static final int TYPE_HANDLE_OF_LABEL = 9;
    private static final int TYPE_HANDLE_OF_ENTRY_FIELD = 10;
    private static final int TYPE_HANDLE_OF_PUSH_BUTTON = 11;
    private static final int TYPE_HANDLE_OF_CHECK_BOX = 12;
    private static final int TYPE_HANDLE_OF_RADIO_BUTTON = 13;
    private static final int TYPE_HANDLE_OF_LIST_BOX = 14;
    private static final int TYPE_HANDLE_OF_COMBO_BOX = 15;
    private static final int TYPE_HANDLE_OF_FRAME = 16;
    private static final int TYPE_HANDLE_OF_SCROLL_BAR = 17;
    private static final int TYPE_HANDLE_OF_TAB_CONTROL = 18;
    private static final int TYPE_HANDLE_OF_BAR = 19;
    private static final int TYPE_HANDLE_OF_GRID = 20;
    private static final int TYPE_HANDLE_OF_BITMAP = 21;
    private static final int TYPE_HANDLE_OF_TREE_VIEW = 22;
    private static final int TYPE_HANDLE_OF_WEB_BROWSER = 23;
    private static final int TYPE_HANDLE_OF_DATE_ENTRY = 24;
    private static final int TYPE_HANDLE_OF_SLIDER = 25;
    private static final int TYPE_HANDLE_OF_JAVA_BEAN = 26;
    private static final int TYPE_HANDLE = 27;
    private static final String[] varTypes = new String[]{"All", "Constant", "Object Reference", "Handle of Window", "Handle of Font", "Handle of Menu", "Handle of Status-Bar", "Handle of Layout-Manager", "Handle of Thread", "Handle of Label", "Handle of Entry-Field", "Handle of Push-Button", "Handle of Check-Box", "Handle of Radio-Button", "Handle of List-Box", "Handle of Combo-Box", "Handle of Frame", "Handle of Scroll-Bar", "Handle of Tab-Control", "Handle of Bar", "Handle of Grid", "Handle of Bitmap", "Handle of Tree-View", "Handle of Web-Browser", "Handle of Date-Entry", "Handle of Slider", "Handle of Java-Bean", "Handle"};
    private CCombo categoryCmb;
    private CCombo typeCmb;
    private Tree[] varTree;
    private Composite treePanel;
    private StackLayout stackLayout;
    private Text varTxt;
    private String defaultName;
    private String picture;
    private int deftype;
    private int handleUsage;
    private ScreenProgram screenProgram;
    private ScreenFD_SL[] usedDataLayouts;
    private VariableName selectedVariable;
    private ModifyListener listener = new /* Unavailable Anonymous Inner Class!! */;

    public AddVariableDialog(Shell shell, ScreenProgram screenProgram, VariableName variableName, String string, int n, int n2, String string2) {
        super(shell);
        this.defaultName = string;
        this.deftype = n;
        this.handleUsage = n2;
        this.picture = string2;
        this.screenProgram = screenProgram;
        this.selectedVariable = variableName;
        this.usedDataLayouts = PluginUtilities.getUsedDataLayouts((IProject)screenProgram.getProject(), (DataSet[])screenProgram.getFileSection().getDataSets());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select variable");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Category");
        this.categoryCmb = new CCombo(composite2, 2056);
        GridData gridData = new GridData(768);
        this.categoryCmb.setLayoutData((Object)gridData);
        this.treePanel = new Composite(composite2, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 350;
        this.treePanel.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.treePanel.setLayout((Layout)this.stackLayout);
        label = new Label(composite2, 0);
        label.setText("Type");
        this.typeCmb = new CCombo(composite2, 2056);
        gridData = new GridData(768);
        this.typeCmb.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Variable");
        this.varTxt = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.varTxt.setLayoutData((Object)gridData);
        this.initData();
        this.categoryCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.typeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.varTxt.addModifyListener(this.listener);
        return composite2;
    }

    private void rearrangeVariables() {
        for (int i = 0; i < this.varTree.length; ++i) {
            Tree tree = this.varTree[i];
            tree.removeAll();
            List list = (List)tree.getData();
            for (int j = 0; j < list.size(); ++j) {
                VariableType variableType = (VariableType)list.get(j);
                this.addVariable(variableType, tree, null);
            }
        }
    }

    private boolean accept(VariableType variableType) {
        if (variableType.getLevelAsInt() == 88) {
            return false;
        }
        switch (this.typeCmb.getSelectionIndex()) {
            default: {
                return true;
            }
            case 1: {
                return variableType.getLevelAsInt() == 78;
            }
            case 2: {
                return variableType.getUsage().getValue() == 31;
            }
            case 27: {
                return variableType.isHandle();
            }
            case 19: {
                return variableType.getUsage().getValue() == 42;
            }
            case 21: {
                return variableType.getUsage().getValue() == 44;
            }
            case 12: {
                return variableType.getUsage().getValue() == 35;
            }
            case 15: {
                return variableType.getUsage().getValue() == 38;
            }
            case 24: {
                return variableType.getUsage().getValue() == 47;
            }
            case 10: {
                return variableType.getUsage().getValue() == 33;
            }
            case 4: {
                return variableType.getUsage().getValue() == 26;
            }
            case 16: {
                return variableType.getUsage().getValue() == 39;
            }
            case 20: {
                return variableType.getUsage().getValue() == 43;
            }
            case 26: {
                return variableType.getUsage().getValue() == 49;
            }
            case 9: {
                return variableType.getUsage().getValue() == 32;
            }
            case 7: {
                return variableType.getUsage().getValue() == 29;
            }
            case 14: {
                return variableType.getUsage().getValue() == 37;
            }
            case 5: {
                return variableType.getUsage().getValue() == 27;
            }
            case 11: {
                return variableType.getUsage().getValue() == 34;
            }
            case 13: {
                return variableType.getUsage().getValue() == 36;
            }
            case 17: {
                return variableType.getUsage().getValue() == 40;
            }
            case 25: {
                return variableType.getUsage().getValue() == 48;
            }
            case 6: {
                return variableType.getUsage().getValue() == 28;
            }
            case 18: {
                return variableType.getUsage().getValue() == 41;
            }
            case 8: {
                return variableType.getUsage().getValue() == 30;
            }
            case 22: {
                return variableType.getUsage().getValue() == 45;
            }
            case 23: {
                return variableType.getUsage().getValue() == 46;
            }
            case 3: 
        }
        return variableType.getUsage().getValue() == 25;
    }

    private void initData() {
        VariableType variableType;
        int n;
        int n2;
        for (int i = 0; i < varTypes.length; ++i) {
            this.typeCmb.add(varTypes[i]);
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        VariableTypeList variableTypeList = this.screenProgram.getAcuForwardVariables();
        if (variableTypeList.getSettingCount() > 0) {
            this.addCategories(new VariableTypeList[]{variableTypeList}, new String[]{"Acubench forward variables"}, arrayList);
        }
        FileEntry[] fileEntryArray = this.screenProgram.getFileSection().getFDEntries();
        VariableTypeList[] variableTypeListArray = this.screenProgram.getFileSection().getFDEntryVariables(this.screenProgram.getProject());
        String[] stringArray = new String[variableTypeListArray.length];
        for (n2 = 0; n2 < variableTypeListArray.length; ++n2) {
            stringArray[n2] = new File(fileEntryArray[n2].getFilename()).getName();
            stringArray[n2] = stringArray[n2].substring(0, stringArray[n2].length() - 3);
        }
        this.addCategories(variableTypeListArray, stringArray, arrayList);
        variableTypeListArray = this.screenProgram.getTaggedAreaFDs();
        stringArray = new String[variableTypeListArray.length];
        for (n2 = 0; n2 < variableTypeListArray.length; ++n2) {
            stringArray[n2] = variableTypeListArray[n2].getFdName();
        }
        this.addCategories(variableTypeListArray, stringArray, arrayList);
        variableTypeListArray = new VariableTypeList[this.usedDataLayouts.length];
        stringArray = new String[this.usedDataLayouts.length];
        for (n2 = 0; n2 < this.usedDataLayouts.length; ++n2) {
            variableTypeListArray[n2] = this.usedDataLayouts[n2].getFdItems();
            stringArray[n2] = this.usedDataLayouts[n2].getFdName();
        }
        this.addCategories(variableTypeListArray, stringArray, arrayList);
        ArrayList<VariableType> arrayList2 = new ArrayList<VariableType>();
        ArrayList<VariableType> arrayList3 = new ArrayList<VariableType>();
        VariableTypeList variableTypeList2 = this.screenProgram.getResourceRegistry().getVariableTypeList();
        for (n = 0; n < variableTypeList2.getSettingCount(); ++n) {
            variableType = (VariableType)variableTypeList2.getSettingAt(n);
            if (variableType.isInLinkage()) {
                arrayList3.add(variableType);
                continue;
            }
            arrayList2.add(variableType);
        }
        n = arrayList.size();
        this.categoryCmb.add("Working Storage");
        Tree tree = this.createTree(this.treePanel);
        arrayList.add(tree);
        tree.setData(arrayList2);
        this.categoryCmb.add("Linkage Section");
        Tree tree2 = this.createTree(this.treePanel);
        arrayList.add(tree2);
        tree2.setData(arrayList3);
        this.addCategories(this.screenProgram.getDefVariables(), IscobolScreenPainterPlugin.DEF_FILES, arrayList);
        this.addCategories(this.screenProgram.getExternalWorkingVariables(), this.screenProgram.getExternalWorkingCopyFiles(), arrayList);
        for (VariableTypeList variableTypeList3 : this.screenProgram.getTaggedAreaVariables()) {
            List list = variableTypeList3.getName().equals("linkage") ? (List)tree2.getData() : (variableTypeList3.getName().equals("working") ? (List)tree.getData() : null);
            if (list == null) continue;
            for (int i = 0; i < variableTypeList3.getSettingCount(); ++i) {
                variableType = (VariableType)variableTypeList3.getSettingAt(i);
                list.add(variableType);
            }
        }
        if (this.selectedVariable != null) {
            this.varTxt.setText(this.selectedVariable.getFullString());
        } else if (this.defaultName != null) {
            this.varTxt.setText(this.defaultName);
        }
        this.varTree = arrayList.toArray(new Tree[arrayList.size()]);
        this.stackLayout.topControl = this.varTree[n];
        this.categoryCmb.select(n);
        this.typeCmb.select(0);
        this.rearrangeVariables();
    }

    private void addCategories(VariableTypeList[] variableTypeListArray, String[] stringArray, List<Tree> list) {
        Tree[] treeArray = new Tree[variableTypeListArray.length];
        for (int i = 0; i < variableTypeListArray.length; ++i) {
            this.categoryCmb.add(stringArray[i]);
            treeArray[i] = this.createTree(this.treePanel);
            list.add(treeArray[i]);
            ArrayList<VariableType> arrayList = new ArrayList<VariableType>();
            VariableTypeList variableTypeList = variableTypeListArray[i];
            for (int j = 0; j < variableTypeList.getSettingCount(); ++j) {
                VariableType variableType = (VariableType)variableTypeList.getSettingAt(j);
                arrayList.add(variableType);
            }
            treeArray[i].setData(arrayList);
        }
    }

    private void addVariable(VariableType variableType, Tree tree, TreeItem treeItem) {
        if (!this.accept(variableType)) {
            return;
        }
        TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(tree, 0);
        treeItem2.setText(variableType.toString());
        treeItem2.setData((Object)variableType);
        for (int i = 0; i < variableType.getChildCount(); ++i) {
            VariableType variableType2 = (VariableType)variableType.getChildAt(i);
            this.addVariable(variableType2, null, treeItem2);
        }
    }

    private Tree createTree(Composite composite) {
        Tree tree = new Tree(composite, 2820);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(500);
        treeColumn.setText("Field Name");
        tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return tree;
    }

    public VariableName openDialog() {
        if (this.open() == 0) {
            return this.selectedVariable;
        }
        return null;
    }

    private void setSelectedVariable(String string, TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length && this.selectedVariable == null; ++i) {
            VariableType variableType = (VariableType)treeItemArray[i].getData();
            if (variableType.getName().equalsIgnoreCase(string) && variableType.getOccurs().isOccurs()) {
                this.selectedVariable = new VariableName((VariableType)treeItemArray[i].getData(), this.varTxt.getText());
                continue;
            }
            if (treeItemArray[i].getItemCount() <= 0) continue;
            this.setSelectedVariable(string, treeItemArray[i].getItems());
        }
    }

    protected void okPressed() {
        if (this.selectedVariable == null) {
            String string = this.varTxt.getText();
            int n = string.indexOf(40);
            if (n >= 0) {
                string = string.substring(0, n).trim();
                Tree tree = (Tree)this.stackLayout.topControl;
                TreeItem[] treeItemArray = tree.getItems();
                this.setSelectedVariable(string, treeItemArray);
                if (this.selectedVariable == null) {
                    this.error("'" + string + "' " + ISPBundle.getString((String)"invalid_identifier_msg"));
                    return;
                }
            } else {
                if (!PluginUtilities.isValidIdentifier((String)string)) {
                    this.error("'" + string + "' " + ISPBundle.getString((String)"invalid_identifier_msg"));
                    return;
                }
                this.selectedVariable = VariableType.getVariableName((String)string, (String)this.picture, (int)this.handleUsage, (int)this.deftype);
            }
        }
        super.okPressed();
    }

    public VariableName createNewVariable(String string) {
        return VariableType.getVariableName((String)string, (String)this.picture, (int)this.handleUsage, (int)this.deftype);
    }

    private void error(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText(this.getShell().getText());
        messageBox.setMessage(string);
        messageBox.open();
    }

    static /* synthetic */ Text access$000(AddVariableDialog addVariableDialog) {
        return addVariableDialog.varTxt;
    }

    static /* synthetic */ Tree[] access$100(AddVariableDialog addVariableDialog) {
        return addVariableDialog.varTree;
    }

    static /* synthetic */ VariableName access$202(AddVariableDialog addVariableDialog, VariableName variableName) {
        addVariableDialog.selectedVariable = variableName;
        return addVariableDialog.selectedVariable;
    }

    static /* synthetic */ StackLayout access$300(AddVariableDialog addVariableDialog) {
        return addVariableDialog.stackLayout;
    }

    static /* synthetic */ CCombo access$400(AddVariableDialog addVariableDialog) {
        return addVariableDialog.categoryCmb;
    }

    static /* synthetic */ Composite access$500(AddVariableDialog addVariableDialog) {
        return addVariableDialog.treePanel;
    }

    static /* synthetic */ void access$600(AddVariableDialog addVariableDialog) {
        addVariableDialog.rearrangeVariables();
    }

    static /* synthetic */ ModifyListener access$700(AddVariableDialog addVariableDialog) {
        return addVariableDialog.listener;
    }
}

