/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.beans.types.Alphabet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AlphabetDialog
extends Dialog {
    private ArrayList<Alphabet.Entry> entries = new ArrayList();
    private String name;
    private String predefinedType;
    private boolean readOnly;
    private Map<Character, Integer> characterPositions = new HashMap();
    private Text nameTxt;
    private Combo predefNameCmb;
    private List definitionList;
    private Button isBtn;
    private Button alsoBtn;
    private Button throughBtn;
    private Text isTxt;
    private Text also1Txt;
    private Text also2Txt;
    private Text through1Txt;
    private Text through2Txt;
    private Button addBtn;
    private Button editBtn;
    private Button removeBtn;
    private Label throughLbl;
    private Label nameLbl;
    private Label predefNameLbl;
    private Group defCmp;
    private Group newDefCmp;
    private Label alsoLbl;

    public AlphabetDialog(Shell shell, Alphabet alphabet, boolean bl) {
        super(shell);
        if (alphabet != null) {
            this.name = alphabet.getName();
            this.predefinedType = alphabet.getPredefinedType();
            this.entries.addAll(Arrays.asList(alphabet.getEntries()));
        }
        this.readOnly = bl;
    }

    private void addChar(char c, int n) throws Exception {
        Character c2 = Character.valueOf(c);
        if (this.characterPositions.containsKey(c2)) {
            throw new Exception(String.valueOf(c));
        }
        this.characterPositions.put(c2, n);
    }

    private void updateChars() throws Exception {
        this.characterPositions.clear();
        int n = 0;
        block5: for (Alphabet.Entry entry : this.entries) {
            switch (entry.getType()) {
                case 0: {
                    int n2;
                    String string = entry.getStrings()[0];
                    if (string.startsWith("'") || string.startsWith("\"")) {
                        string = string.substring(1, string.length() - 1);
                        char[] cArray = string.toCharArray();
                        for (n2 = 0; n2 < cArray.length; ++n2) {
                            this.addChar(cArray[n2], n);
                        }
                        continue block5;
                    }
                    char c = (char)(Integer.parseInt(string) - 1);
                    this.addChar(c, n);
                    break;
                }
                case 1: {
                    String[] stringArray;
                    char c;
                    String[] stringArray2 = stringArray = entry.getStrings();
                    int n2 = stringArray2.length;
                    for (int i = 0; i < n2; ++i) {
                        String string = stringArray2[i];
                        c = string.startsWith("'") || string.startsWith("\"") ? string.charAt(1) : (char)(Integer.parseInt(string) - 1);
                        this.addChar(c, n);
                    }
                    n += stringArray.length;
                    break;
                }
                case 2: {
                    char c;
                    String string = entry.getStrings()[0];
                    String string2 = entry.getStrings()[1];
                    char c2 = string2.startsWith("'") || string2.startsWith("\"") ? string2.charAt(1) : (char)(Integer.parseInt(string2) - 1);
                    if (c > c2) {
                        for (c = string.startsWith("'") || string.startsWith("\"") ? string.charAt(1) : (char)(Integer.parseInt(string) - 1); c >= c2; c = (char)(c - '\u0001')) {
                            this.addChar(c, n);
                        }
                        continue block5;
                    }
                    while (c <= c2) {
                        this.addChar(c, n);
                        c = (char)(c + '\u0001');
                    }
                    continue block5;
                }
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Alphabet");
    }

    private void setEnabledAll(boolean bl) {
        this.isBtn.setEnabled(bl);
        this.alsoBtn.setEnabled(bl);
        this.throughBtn.setEnabled(bl);
        this.isTxt.setEnabled(bl);
        this.also1Txt.setEnabled(bl);
        this.also2Txt.setEnabled(bl);
        this.through1Txt.setEnabled(bl);
        this.through2Txt.setEnabled(bl);
        this.addBtn.setEnabled(bl);
        this.editBtn.setEnabled(bl);
        this.removeBtn.setEnabled(bl);
        this.throughLbl.setEnabled(bl);
        this.newDefCmp.setEnabled(bl);
        this.alsoLbl.setEnabled(bl);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        this.nameLbl = new Label(composite3, 0);
        this.nameLbl.setText("Name:");
        this.nameTxt = new Text(composite3, 2048);
        gridData = new GridData(768);
        this.nameTxt.setLayoutData((Object)gridData);
        this.predefNameLbl = new Label(composite3, 0);
        this.predefNameLbl.setText("Predefined type:");
        this.predefNameCmb = new Combo(composite3, 2056);
        gridData = new GridData(768);
        this.predefNameCmb.setLayoutData((Object)gridData);
        this.predefNameCmb.add("");
        for (String string : Alphabet.STANDARD_ALPHABETS) {
            this.predefNameCmb.add(string);
        }
        this.predefNameCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        new Label(composite2, 0);
        this.defCmp = new Group(composite2, 0);
        gridLayout = new GridLayout();
        this.defCmp.setLayout((Layout)gridLayout);
        this.defCmp.setText("Definitions");
        gridData = new GridData();
        gridData.verticalSpan = 4;
        this.defCmp.setLayoutData((Object)gridData);
        this.definitionList = new List((Composite)this.defCmp, 2560);
        gridData = new GridData();
        gridData.widthHint = 300;
        gridData.heightHint = 250;
        this.definitionList.setLayoutData((Object)gridData);
        this.newDefCmp = new Group(composite2, 0);
        this.newDefCmp.setText("New definition");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.newDefCmp.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.newDefCmp.setLayoutData((Object)gridData);
        this.isBtn = new Button((Composite)this.newDefCmp, 16);
        this.isTxt = new Text((Composite)this.newDefCmp, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 25;
        this.isTxt.setLayoutData((Object)gridData);
        this.alsoBtn = new Button((Composite)this.newDefCmp, 16);
        this.also1Txt = new Text((Composite)this.newDefCmp, 2048);
        gridData = new GridData();
        gridData.widthHint = 25;
        this.also1Txt.setLayoutData((Object)gridData);
        this.alsoLbl = new Label((Composite)this.newDefCmp, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        this.alsoLbl.setText("also");
        this.alsoLbl.setLayoutData((Object)gridData);
        this.also2Txt = new Text((Composite)this.newDefCmp, 2048);
        gridData = new GridData();
        gridData.widthHint = 130;
        this.also2Txt.setLayoutData((Object)gridData);
        this.throughBtn = new Button((Composite)this.newDefCmp, 16);
        this.through1Txt = new Text((Composite)this.newDefCmp, 2048);
        gridData = new GridData();
        gridData.widthHint = 25;
        this.through1Txt.setLayoutData((Object)gridData);
        this.throughLbl = new Label((Composite)this.newDefCmp, 0);
        this.throughLbl.setText("through");
        this.through2Txt = new Text((Composite)this.newDefCmp, 2048);
        gridData = new GridData();
        gridData.widthHint = 25;
        this.through2Txt.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 150;
        gridData2.verticalAlignment = 128;
        this.addBtn = new Button(composite2, 8);
        this.addBtn.setText("Add new definition");
        this.addBtn.setLayoutData((Object)gridData2);
        this.editBtn = new Button(composite2, 8);
        this.editBtn.setText("Edit definition");
        this.editBtn.setLayoutData((Object)gridData2);
        this.editBtn.setEnabled(false);
        this.removeBtn = new Button(composite2, 8);
        this.removeBtn.setText("Remove definition");
        this.removeBtn.setLayoutData((Object)gridData2);
        this.setDefinitionType(0);
        if (this.name != null) {
            this.nameTxt.setText(this.name);
        }
        if (this.predefinedType != null) {
            this.predefNameCmb.setText(this.predefinedType);
            this.setEnabledAll(false);
        }
        for (Alphabet.Entry entry : this.entries) {
            this.definitionList.add(entry.toString());
        }
        if (this.readOnly) {
            this.nameLbl.setEnabled(false);
            this.nameTxt.setEnabled(false);
            this.predefNameLbl.setEnabled(false);
            this.predefNameCmb.setEnabled(false);
            this.setEnabledAll(false);
        }
        this.definitionList.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.isBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.alsoBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.throughBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void removeDefinition() {
        if (this.definitionList.getSelectionCount() > 0) {
            Alphabet.Entry entry = (Alphabet.Entry)this.entries.get(this.definitionList.getSelectionIndex());
            this.entries.remove(entry);
            try {
                this.updateChars();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.definitionList.remove(this.definitionList.getSelectionIndex());
        }
    }

    private String checkStringValue(String string, boolean bl) {
        if (string.length() == 0) {
            return "empty value not allowed";
        }
        if (string.startsWith("'")) {
            if (!string.endsWith("'")) {
                return "is not a valid string literal";
            }
            if (bl && string.length() > 3) {
                return "'the string literal must have a size of one character";
            }
        } else if (string.startsWith("\"")) {
            if (!string.endsWith("\"")) {
                return "is not a valid string literal";
            }
            if (bl && string.length() > 3) {
                return "'the string literal must have a size of one character";
            }
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 1 || n > 256) {
                    return "is not in the range of 1 through 256";
                }
            }
            catch (NumberFormatException numberFormatException) {
                return "is not a valid string literal";
            }
        }
        return null;
    }

    private void addDefinition(boolean bl) {
        String string = null;
        Alphabet.Entry entry = null;
        if (this.isBtn.getSelection()) {
            String string2 = this.isTxt.getText();
            string = this.checkStringValue(string2, false);
            if (string == null) {
                entry = Alphabet.createSingleItemEntry((String)string2);
            } else {
                string = "Invalid value '" + string2 + "': " + string;
            }
            this.addEntry(entry, bl, string);
        } else if (this.alsoBtn.getSelection()) {
            String string3 = this.also1Txt.getText();
            String string4 = this.also2Txt.getText();
            string = this.checkStringValue(string3, true);
            if (string == null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (string5.equals("'")) {
                        stringTokenizer.nextToken();
                        string5 = ",";
                    }
                    if ((string = this.checkStringValue(string5, true)) != null) break;
                    arrayList.add(string5);
                }
                if (string == null) {
                    entry = Alphabet.createAlsoItemEntry((String[])arrayList.toArray(new String[arrayList.size()]));
                } else {
                    string = "Invalid value '" + string4 + "': " + string;
                }
            } else {
                string = "Invalid value '" + string3 + "': " + string;
            }
            this.addEntry(entry, bl, string);
        } else {
            String string6 = this.through1Txt.getText();
            String string7 = this.through2Txt.getText();
            string = this.checkStringValue(string6, true);
            if (string == null) {
                string = this.checkStringValue(string7, true);
                if (string == null) {
                    entry = Alphabet.createThroughItemEntry((String)string6, (String)string7);
                } else {
                    string = "Invalid value '" + string7 + "': " + string;
                }
            } else {
                string = "Invalid value '" + string6 + "': " + string;
            }
            this.addEntry(entry, bl, string);
        }
    }

    private void addEntry(Alphabet.Entry entry, boolean bl, String string) {
        MessageBox messageBox;
        if (entry != null) {
            messageBox = null;
            int n = -1;
            if (bl) {
                n = this.definitionList.getSelectionIndex();
                messageBox = (Alphabet.Entry)this.entries.get(n);
                this.entries.set(n, entry);
            } else {
                this.entries.add(entry);
            }
            try {
                this.updateChars();
                if (bl) {
                    this.definitionList.setItem(n, entry.toString());
                } else {
                    this.definitionList.add(entry.toString());
                }
                this.isTxt.setText("");
                this.also1Txt.setText("");
                this.also2Txt.setText("");
                this.through1Txt.setText("");
                this.through2Txt.setText("");
            }
            catch (Exception exception) {
                string = "Native character specified twice: '" + exception.getMessage() + "'";
                if (bl) {
                    this.entries.set(n, messageBox);
                } else {
                    this.entries.remove(entry);
                }
                try {
                    this.updateChars();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (string != null) {
            messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setText("ERROR");
            messageBox.setMessage(string);
            messageBox.open();
        }
    }

    public void okPressed() {
        if (this.nameTxt.getText().length() == 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setText("ERROR");
            messageBox.setMessage("You must specify a name for this alphabet");
            messageBox.open();
            return;
        }
        if (this.definitionList.getItemCount() == 0 && this.predefNameCmb.getSelectionIndex() == 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setText("ERROR");
            messageBox.setMessage("You must specify at least a definition for this alphabet");
            messageBox.open();
            return;
        }
        this.name = this.nameTxt.getText();
        this.predefinedType = this.predefNameCmb.getText();
        super.okPressed();
    }

    public Alphabet openDialog() {
        Alphabet alphabet;
        if (this.open() == 0 && !this.readOnly) {
            alphabet = new Alphabet();
            alphabet.setName(this.name);
            if (this.predefinedType != null && this.predefinedType.length() > 0) {
                alphabet.setPredefinedType(this.predefinedType);
                this.entries.clear();
            } else {
                alphabet.setPredefinedType(null);
            }
            alphabet.setEntries(this.entries.toArray(new Alphabet.Entry[this.entries.size()]));
        } else {
            alphabet = null;
        }
        return alphabet;
    }

    private void setDefinitionType(int n) {
        switch (n) {
            case 0: {
                this.isBtn.setSelection(true);
                this.alsoBtn.setSelection(false);
                this.throughBtn.setSelection(false);
                this.isTxt.setEnabled(true);
                this.also1Txt.setEnabled(false);
                this.also2Txt.setEnabled(false);
                this.through1Txt.setEnabled(false);
                this.through2Txt.setEnabled(false);
                break;
            }
            case 1: {
                this.isBtn.setSelection(false);
                this.alsoBtn.setSelection(true);
                this.throughBtn.setSelection(false);
                this.isTxt.setEnabled(false);
                this.also1Txt.setEnabled(true);
                this.also2Txt.setEnabled(true);
                this.through1Txt.setEnabled(false);
                this.through2Txt.setEnabled(false);
                break;
            }
            case 2: {
                this.isBtn.setSelection(false);
                this.alsoBtn.setSelection(false);
                this.throughBtn.setSelection(true);
                this.isTxt.setEnabled(false);
                this.also1Txt.setEnabled(false);
                this.also2Txt.setEnabled(false);
                this.through1Txt.setEnabled(true);
                this.through2Txt.setEnabled(true);
            }
        }
    }

    static /* synthetic */ Combo access$000(AlphabetDialog alphabetDialog) {
        return alphabetDialog.predefNameCmb;
    }

    static /* synthetic */ void access$100(AlphabetDialog alphabetDialog, boolean bl) {
        alphabetDialog.setEnabledAll(bl);
    }

    static /* synthetic */ boolean access$200(AlphabetDialog alphabetDialog) {
        return alphabetDialog.readOnly;
    }

    static /* synthetic */ List access$300(AlphabetDialog alphabetDialog) {
        return alphabetDialog.definitionList;
    }

    static /* synthetic */ Button access$400(AlphabetDialog alphabetDialog) {
        return alphabetDialog.editBtn;
    }

    static /* synthetic */ ArrayList access$500(AlphabetDialog alphabetDialog) {
        return alphabetDialog.entries;
    }

    static /* synthetic */ void access$600(AlphabetDialog alphabetDialog, int n) {
        alphabetDialog.setDefinitionType(n);
    }

    static /* synthetic */ Text access$700(AlphabetDialog alphabetDialog) {
        return alphabetDialog.isTxt;
    }

    static /* synthetic */ Text access$800(AlphabetDialog alphabetDialog) {
        return alphabetDialog.also1Txt;
    }

    static /* synthetic */ Text access$900(AlphabetDialog alphabetDialog) {
        return alphabetDialog.also2Txt;
    }

    static /* synthetic */ Text access$1000(AlphabetDialog alphabetDialog) {
        return alphabetDialog.through1Txt;
    }

    static /* synthetic */ Text access$1100(AlphabetDialog alphabetDialog) {
        return alphabetDialog.through2Txt;
    }

    static /* synthetic */ void access$1200(AlphabetDialog alphabetDialog, boolean bl) {
        alphabetDialog.addDefinition(bl);
    }

    static /* synthetic */ void access$1300(AlphabetDialog alphabetDialog) {
        alphabetDialog.removeDefinition();
    }
}

