/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangePrefixDialog
extends Dialog {
    private String title;
    private String changeOnlyTitle;
    private String oldPrefix;
    private String newPrefix;
    private boolean changePrefixOnly;
    private Text oldPrefixTxt;
    private Text newPrefixTxt;
    private Button changePrefixOnlyBtn;

    public ChangePrefixDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.title = string;
        this.changeOnlyTitle = string2;
        this.oldPrefix = string3;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.changePrefixOnlyBtn = new Button(composite2, 32);
        this.changePrefixOnlyBtn.setText(this.changeOnlyTitle);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.changePrefixOnlyBtn.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText("Old Prefix:");
        this.oldPrefixTxt = new Text(composite2, 2048);
        if (this.oldPrefix != null) {
            this.oldPrefixTxt.setText(this.oldPrefix);
        }
        gridData = new GridData();
        gridData.widthHint = 100;
        this.oldPrefixTxt.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("New Prefix:");
        this.newPrefixTxt = new Text(composite2, 2048);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.newPrefixTxt.setLayoutData((Object)gridData);
        return composite2;
    }

    public void okPressed() {
        if (this.oldPrefixTxt.getText().length() == 0) {
            PluginUtilities.logError((String)"Set the 'Old Prefix'");
            return;
        }
        if (!this.oldPrefixTxt.getText().matches("[a-zA-Z0-9\\-\\_]+")) {
            PluginUtilities.logError((String)"Invalid value for 'Old Prefix'");
            return;
        }
        if (this.newPrefixTxt.getText().length() == 0) {
            PluginUtilities.logError((String)"Set the 'New Prefix'");
            return;
        }
        if (!this.newPrefixTxt.getText().matches("[a-zA-Z0-9\\-\\_]+")) {
            PluginUtilities.logError((String)"Invalid value for 'New Prefix'");
            return;
        }
        this.oldPrefix = this.oldPrefixTxt.getText();
        this.newPrefix = this.newPrefixTxt.getText();
        this.changePrefixOnly = this.changePrefixOnlyBtn.getSelection();
        super.okPressed();
    }

    public String getOldPrefix() {
        return this.oldPrefix;
    }

    public String getNewPrefix() {
        return this.newPrefix;
    }

    public boolean getChangePrefixOnly() {
        return this.changePrefixOnly;
    }
}

