/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.plugins.editor.dialogs.ElementSelectorComposite;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CobolEventListDialog
extends Dialog {
    private ElementSelectorComposite selector;
    private String value;
    private Class targetClass;

    public CobolEventListDialog(Shell shell, String string, Class clazz) {
        super(shell);
        this.value = string;
        this.targetClass = clazz;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Event List Setting");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(this.targetClass).getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().endsWith(" event") || propertyDescriptor.getName().equals("other event")) continue;
                String string = propertyDescriptor.getName().substring(0, propertyDescriptor.getName().length() - " event".length());
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selector = new ElementSelectorComposite(composite2, "Available Events", "Event List", false, arrayList.toArray(new String[arrayList.size()]), this.value);
        return composite2;
    }

    public void okPressed() {
        this.value = this.selector.getValue();
        super.okPressed();
    }

    public String openDialog() {
        return this.open() == 0 ? this.value : null;
    }
}

