/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.beans.ReportLine;
import com.iscobol.reportdesigner.beans.types.TableSetting;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.BackgroundColorType;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.dialogs.ColorDialog;
import com.iscobol.screenpainter.dialogs.RGBColorDialog;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JLabel;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/*
 * Exception performing whole class analysis ignored.
 */
public class ColorDialog
extends Dialog {
    public static final String[] normalColorNames = new String[]{" 0 Disabled", " 1 Black", " 2 Dark blue", " 3 Dark green", " 4 Dark cyan", " 5 Dark red", " 6 Dark magenta", " 7 Dark brown", " 8 Gray", " 9 Dark gray", "10 Blue", "11 Green", "12 Cyan", "13 Red", "14 Magenta", "15 Yellow", "16 White"};
    public static final String[] backforeColorNames = new String[]{" Disabled", " 0 Black", " 1 Dark blue", " 2 Dark green", " 3 Dark cyan", " 4 Dark red", " 5 Dark magenta", " 6 Dark brown", " 7 Gray", " 8 Dark gray", " 9 Blue", "10 Green", "11 Cyan", "12 Red", "13 Magenta", "14 Yellow", "15 White"};
    private static final int IMAGE_WIDTH = 100;
    private static final int IMAGE_HEIGHT = 20;
    private static final int RGB_INDEX = normalColorNames.length;
    private Button reverse;
    private Button underline;
    private Button blink;
    private Button _protected;
    private Button backHigh;
    private Button backLow;
    private Button backNone;
    private Button foreHigh;
    private Button foreLow;
    private Button foreNone;
    private Button isRgb;
    private Button foreRgb;
    private Button backRgb;
    private JLabel preview;
    private MyLabel backLabel;
    private MyLabel foreLabel;
    private Button backButton;
    private Button foreButton;
    private Menu popupMenu;
    private ColorType initValue;
    private boolean isReportElement;
    private boolean isReportLine;
    private int backIntensity;
    private int foreIntensity;
    private boolean isReverse;
    private boolean isUnderline;
    private boolean isBlink;
    private boolean isProtected;
    private boolean onlyFg;
    private boolean onlyBg;
    private boolean rgb;
    private final Image[] colorImages = new Image[normalColorNames.length];
    private Image rgbBackImage;
    private Image rgbForeImage;
    private String foreColorRgb = "#000000";
    private String backColorRgb = "#FFFFFF";
    private int backColor;
    private int foreColor;
    private boolean allowRgb;
    private boolean partOfColorProp;
    private ColorPalette palette;

    public ColorDialog(Shell shell, ColorType colorType, boolean bl, boolean bl2, Class clazz, ColorPalette colorPalette) {
        super(shell);
        this.initValue = colorType;
        this.allowRgb = bl;
        this.palette = colorPalette;
        this.partOfColorProp = bl2;
        this.isReportElement = ReportElement.class.isAssignableFrom(clazz) || TableSetting.class.isAssignableFrom(clazz);
        this.isReportLine = ReportLine.class.isAssignableFrom(clazz);
    }

    private static String[] getColorNames(boolean bl) {
        return bl ? backforeColorNames : normalColorNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ISPBundle.getString((String)"choose_color_title"));
    }

    private void createImagesAndMenu(Display display) {
        String[] stringArray = ColorDialog.getColorNames((boolean)this.partOfColorProp);
        for (int i = 0; i < stringArray.length; ++i) {
            this.colorImages[i] = i == 0 ? this.createDisabledColorImage(display) : ColorDialog.createImage((Display)display, (java.awt.Color)this.getColor(i - 1));
            this.createMenuItem(i, stringArray[i], this.colorImages[i]);
        }
    }

    private java.awt.Color getColor(int n) {
        return this.palette != null ? this.palette.getColor(n) : ColorType.getDefaultColor((int)n, (boolean)this.isReportElement);
    }

    public static Image createImage(Display display, java.awt.Color color) {
        Image image = new Image((Device)display, 100, 20);
        GC gC = new GC((Drawable)image);
        Color color2 = new Color((Device)display, new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        gC.setBackground(color2);
        gC.fillRectangle(image.getBounds());
        color2.dispose();
        gC.setForeground(display.getSystemColor(2));
        gC.drawRectangle(0, 0, 99, 19);
        gC.dispose();
        return image;
    }

    private Image createDisabledColorImage(Display display) {
        int n;
        Image image = new Image((Device)display, 100, 20);
        GC gC = new GC((Drawable)image);
        for (n = 5; n < 100; n += 5) {
            gC.drawLine(n, 0, n, 20);
        }
        for (n = 5; n < 20; n += 5) {
            gC.drawLine(0, n, 100, n);
        }
        gC.setForeground(display.getSystemColor(2));
        gC.drawRectangle(0, 0, 99, 19);
        gC.dispose();
        return image;
    }

    private MenuItem createMenuItem(int n, String string, Image image) {
        MenuItem menuItem = new MenuItem(this.popupMenu, 8);
        menuItem.setText(string);
        menuItem.setImage(image);
        menuItem.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        return menuItem;
    }

    private void select(MyLabel myLabel, int n) {
        myLabel.setText(ColorDialog.getColorNames((boolean)this.partOfColorProp)[n]);
        myLabel.setImage(this.colorImages[n]);
        myLabel.setData((Object)new Integer(n));
    }

    public void dispose() {
    }

    protected Control createDialogArea(Composite composite) {
        Group group;
        Frame frame;
        Group group2;
        GridData gridData;
        Composite composite2;
        Object object;
        if (this.initValue != null) {
            this.onlyFg = this.initValue instanceof ForegroundColorType;
            this.onlyBg = this.initValue instanceof BackgroundColorType;
            this.rgb = this.initValue.isRgb();
        }
        Menu menu = new Menu((Decorations)this.getShell(), 2);
        Shell shell = this.getShell();
        shell.setMenuBar(menu);
        Menu menu2 = new Menu((Decorations)shell, 2);
        shell.setMenuBar(menu2);
        MenuItem menuItem = new MenuItem(menu2, 64);
        menuItem.setText("&Copy");
        Menu menu3 = new Menu((Decorations)shell, 4);
        menuItem.setMenu(menu3);
        MenuItem menuItem2 = new MenuItem(menu2, 64);
        menuItem2.setText("&Paste");
        Menu menu4 = new Menu((Decorations)shell, 4);
        menuItem2.setMenu(menu4);
        if (this.hasBackground()) {
            object = new MenuItem(menu4, 8);
            object.setText(this.hasForeground() ? "&Background\tShift+V" : "&Background\tCtrl+V");
            object.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            object.setAccelerator((this.hasForeground() ? SWT.MOD2 : SWT.MOD1) + 86);
        }
        if (this.hasForeground()) {
            object = new MenuItem(menu4, 8);
            object.setText(this.hasBackground() ? "&Foreground\tAlt+V" : "&Foreground\tCtrl+V");
            object.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            object.setAccelerator((this.hasBackground() ? SWT.MOD3 : SWT.MOD1) + 86);
        }
        if (this.hasBackground() && this.hasForeground()) {
            object = new MenuItem(menu4, 8);
            object.setText("&Color\tCtrl+V");
            object.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            object.setAccelerator(SWT.MOD1 + 86);
        }
        object = Clipboard.getDefault().getContents();
        menuItem2.setEnabled(object instanceof ColorType);
        MenuItem menuItem3 = new MenuItem(menu3, 8);
        if (this.hasBackground() && this.hasForeground()) {
            menuItem3.setText("&Color\tCtrl+C");
        } else if (this.hasBackground()) {
            menuItem3.setText("&Background\tCtrl+C");
        } else {
            menuItem3.setText("&Foreground\tCtrl+C");
        }
        menuItem3.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menuItem3.setAccelerator(SWT.MOD1 + 67);
        Composite composite3 = (Composite)super.createDialogArea(composite);
        this.popupMenu = new Menu((Decorations)this.getShell(), 8);
        this.createImagesAndMenu(this.getShell().getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.isRgb = new Button(composite3, 32);
        this.isRgb.setText(ISPBundle.getString((String)"set_rgb_lbl"));
        this.isRgb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.isRgb.setEnabled(this.allowRgb);
        if (this.hasForeground()) {
            composite2 = new Composite(composite3, 2048);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            composite2.setLayoutData((Object)gridData);
            group2 = new Group(composite2, 2048);
            group2.setText("Foreground");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            group2.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            group2.setLayoutData((Object)gridData);
            frame = new Composite((Composite)group2, 0);
            gridData = new GridData(768);
            frame.setLayoutData(gridData);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.horizontalSpacing = 0;
            frame.setLayout((Layout)gridLayout);
            this.foreLabel = new MyLabel((Composite)frame);
            gridData = new GridData();
            gridData.widthHint = 220;
            gridData.heightHint = 25;
            this.foreLabel.setLayoutData((Object)gridData);
            this.foreButton = new Button((Composite)frame, 1028);
            this.foreButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            gridData = new GridData();
            gridData.widthHint = 20;
            gridData.heightHint = 27;
            this.foreButton.setLayoutData((Object)gridData);
            this.foreRgb = new Button((Composite)group2, 8);
            this.foreRgb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.foreRgb.setText("RGB");
            gridData = new GridData();
            gridData.widthHint = 50;
            gridData.heightHint = 30;
            this.foreRgb.setLayoutData((Object)gridData);
            group = new Group(composite2, 2048);
            group.setText("Foreground intensity");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            group.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            group.setLayoutData((Object)gridData);
            this.foreLow = new Button((Composite)group, 16);
            this.foreLow.setText("Low");
            this.foreLow.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.foreNone = new Button((Composite)group, 16);
            this.foreNone.setText("None");
            this.foreNone.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.foreHigh = new Button((Composite)group, 16);
            this.foreHigh.setText("High");
            this.foreHigh.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            if (!this.hasEffects()) {
                group.setVisible(false);
            }
        }
        if (this.hasBackground()) {
            composite2 = new Composite(composite3, 2048);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            composite2.setLayoutData((Object)gridData);
            group2 = new Group(composite2, 2048);
            group2.setText("Background");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            group2.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            group2.setLayoutData((Object)gridData);
            frame = new Composite((Composite)group2, 0);
            gridData = new GridData(768);
            frame.setLayoutData(gridData);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.horizontalSpacing = 0;
            frame.setLayout((Layout)gridLayout);
            this.backLabel = new MyLabel((Composite)frame);
            gridData = new GridData();
            gridData.widthHint = 220;
            gridData.heightHint = 25;
            this.backLabel.setLayoutData((Object)gridData);
            this.backButton = new Button((Composite)frame, 1028);
            this.backButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            gridData = new GridData();
            gridData.widthHint = 20;
            gridData.heightHint = 27;
            this.backButton.setLayoutData((Object)gridData);
            this.backRgb = new Button((Composite)group2, 8);
            this.backRgb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.backRgb.setText("RGB");
            gridData = new GridData();
            gridData.widthHint = 50;
            gridData.heightHint = 30;
            this.backRgb.setLayoutData((Object)gridData);
            group = new Group(composite2, 2048);
            group.setText("Background intensity");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            group.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            group.setLayoutData((Object)gridData);
            this.backLow = new Button((Composite)group, 16);
            this.backLow.setText("Low");
            this.backLow.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.backNone = new Button((Composite)group, 16);
            this.backNone.setText("None");
            this.backNone.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.backHigh = new Button((Composite)group, 16);
            this.backHigh.setText("High");
            this.backHigh.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            if (!this.hasEffects()) {
                group.setVisible(false);
            }
        }
        if (this.hasEffects()) {
            composite2 = new Group(composite3, 2048);
            composite2.setText("Effects");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            composite2.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            composite2.setLayoutData((Object)gridData);
            this.reverse = new Button(composite2, 32);
            this.reverse.setText("Reverse");
            this.reverse.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.underline = new Button(composite2, 32);
            this.underline.setText("Underline");
            this.underline.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.blink = new Button(composite2, 32);
            this.blink.setText("Blink");
            this.blink.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this._protected = new Button(composite2, 32);
            this._protected.setText("Protected");
            this._protected.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        composite2 = new Group(composite3, 2048);
        composite2.setText("Preview");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        group2 = new Composite(composite2, 0x1000800);
        frame = SWT_AWT.new_Frame((Composite)group2);
        frame.setLayout(new java.awt.GridLayout(1, 0));
        this.preview = new JLabel("Sample");
        this.preview.setHorizontalAlignment(0);
        this.preview.setOpaque(true);
        this.preview.setBackground(java.awt.Color.white);
        this.preview.setFont(new Font("dialog", 0, 20));
        frame.add(this.preview);
        gridData = new GridData(768);
        gridData.heightHint = 40;
        group2.setLayoutData((Object)gridData);
        if (this.initValue != null) {
            this.setColor(this.initValue);
        } else {
            this.select(this.backLabel, this.backColor);
            this.select(this.foreLabel, this.foreColor);
            this.setRGB(false);
        }
        this.updatePreview();
        return composite3;
    }

    private void copyColor() {
        ColorType colorType = this.getColor();
        Clipboard.getDefault().setContents((Object)colorType);
    }

    private void setColor(ColorType colorType) {
        this.setColor(colorType, true, true, true);
    }

    private void setColor(ColorType colorType, boolean bl, boolean bl2, boolean bl3) {
        if (colorType.isRgb()) {
            if (this.hasBackground() && bl) {
                this.backColorRgb = ColorDialog.getRgbString((int)colorType.getRgbBackground());
                this.backLabel.setText(this.backColorRgb);
                this.rgbBackImage = ColorDialog.createImage((Display)this.getShell().getDisplay(), (java.awt.Color)colorType.getBackgroundColor(this.palette));
                this.backLabel.setImage(this.rgbBackImage);
                this.backLabel.setData((Object)new Integer(RGB_INDEX));
            }
            if (this.hasForeground() && bl2) {
                this.foreColorRgb = ColorDialog.getRgbString((int)colorType.getRgbForeground());
                this.foreLabel.setText(this.foreColorRgb);
                this.rgbForeImage = ColorDialog.createImage((Display)this.getShell().getDisplay(), (java.awt.Color)colorType.getForegroundColor(this.palette));
                this.foreLabel.setImage(this.rgbForeImage);
                this.foreLabel.setData((Object)new Integer(RGB_INDEX));
            }
        } else {
            if (this.hasBackground() && bl) {
                this.backColor = colorType.getBackground();
                this.select(this.backLabel, this.backColor);
            }
            if (this.hasForeground() && bl2) {
                this.foreColor = colorType.getForeground();
                this.select(this.foreLabel, this.foreColor);
            }
            if (this.hasEffects()) {
                if (this.hasBackground() && bl) {
                    if (colorType.isBackHigh()) {
                        this.backIntensity = 1;
                        this.backHigh.setSelection(true);
                        this.backLow.setSelection(false);
                        this.backNone.setSelection(false);
                    } else if (colorType.isBackLow()) {
                        this.backIntensity = -1;
                        this.backHigh.setSelection(false);
                        this.backLow.setSelection(true);
                        this.backNone.setSelection(false);
                    } else {
                        this.backHigh.setSelection(false);
                        this.backLow.setSelection(false);
                        this.backNone.setSelection(true);
                    }
                }
                if (this.hasForeground() && bl2) {
                    if (colorType.isForeHigh()) {
                        this.foreIntensity = 1;
                        this.foreHigh.setSelection(true);
                        this.foreLow.setSelection(false);
                        this.foreNone.setSelection(false);
                    } else if (colorType.isForeLow()) {
                        this.foreIntensity = -1;
                        this.foreHigh.setSelection(false);
                        this.foreLow.setSelection(true);
                        this.foreNone.setSelection(false);
                    } else {
                        this.foreHigh.setSelection(false);
                        this.foreLow.setSelection(false);
                        this.foreNone.setSelection(true);
                    }
                }
                if (bl3) {
                    this.underline.setSelection(colorType.isUnderline());
                    this.blink.setSelection(colorType.isBlink());
                    this.isReverse = colorType.isReverse();
                    this.reverse.setSelection(this.isReverse);
                    this._protected.setSelection(colorType.isProtected());
                }
            }
        }
        this.setRGB(colorType.isRgb(), bl, bl2);
    }

    private static String getRgbString(int n) {
        return IscobolBeanConstants.getRgbString((int)n).toUpperCase();
    }

    private void chooseRgb(boolean bl) {
        java.awt.Color color = new java.awt.Color(this.getRgb(bl));
        RGBColorDialog rGBColorDialog = new RGBColorDialog(this.getShell(), new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        RGB rGB = rGBColorDialog.openDialog();
        if (rGB != null) {
            int n = new java.awt.Color(rGB.red, rGB.green, rGB.blue).getRGB();
            if (bl) {
                this.foreColorRgb = ColorDialog.getRgbString((int)n);
                this.foreLabel.setText(this.foreColorRgb);
                if (this.rgbForeImage != null) {
                    this.rgbForeImage.dispose();
                }
                this.rgbForeImage = ColorDialog.createImage((Display)this.getShell().getDisplay(), (java.awt.Color)new java.awt.Color(this.getRgb(true)));
                this.foreLabel.setImage(this.rgbForeImage);
                this.foreLabel.setData((Object)new Integer(RGB_INDEX));
            } else {
                this.backColorRgb = ColorDialog.getRgbString((int)n);
                this.backLabel.setText(this.backColorRgb);
                if (this.rgbBackImage != null) {
                    this.rgbBackImage.dispose();
                }
                this.rgbBackImage = ColorDialog.createImage((Display)this.getShell().getDisplay(), (java.awt.Color)new java.awt.Color(this.getRgb(false)));
                this.backLabel.setImage(this.rgbBackImage);
                this.backLabel.setData((Object)new Integer(RGB_INDEX));
            }
            this.updatePreview();
        }
    }

    private void setRGB(boolean bl) {
        this.setRGB(bl, true, true);
    }

    private void setRGB(boolean bl, boolean bl2, boolean bl3) {
        this.rgb = bl;
        this.isRgb.setSelection(bl);
        if (this.hasEffects()) {
            this.reverse.setEnabled(!bl);
            this.underline.setEnabled(!bl);
            this._protected.setEnabled(!bl);
            this.blink.setEnabled(!bl);
            this.backLow.setEnabled(!bl);
            this.backHigh.setEnabled(!bl);
            this.backNone.setEnabled(!bl);
            this.foreLow.setEnabled(!bl);
            this.foreHigh.setEnabled(!bl);
            this.foreNone.setEnabled(!bl);
        }
        if (this.hasForeground()) {
            this.foreButton.setEnabled(!bl);
        }
        if (this.hasBackground()) {
            this.backButton.setEnabled(!bl);
        }
        if (bl) {
            if (this.hasForeground() && bl3) {
                this.foreLabel.setText(this.foreColorRgb);
                if (this.rgbForeImage != null) {
                    this.rgbForeImage.dispose();
                }
                this.rgbForeImage = ColorDialog.createImage((Display)this.getShell().getDisplay(), (java.awt.Color)new java.awt.Color(this.getRgb(true)));
                this.foreLabel.setImage(this.rgbForeImage);
                this.foreLabel.setData((Object)new Integer(RGB_INDEX));
            }
            if (this.hasBackground() && bl2) {
                this.backLabel.setText(this.backColorRgb);
                if (this.rgbBackImage != null) {
                    this.rgbBackImage.dispose();
                }
                this.rgbBackImage = ColorDialog.createImage((Display)this.getShell().getDisplay(), (java.awt.Color)new java.awt.Color(this.getRgb(false)));
                this.backLabel.setImage(this.rgbBackImage);
                this.backLabel.setData((Object)new Integer(RGB_INDEX));
            }
        } else {
            if (this.hasForeground() && bl3) {
                this.select(this.foreLabel, this.foreColor);
            }
            if (this.hasBackground() && bl2) {
                this.select(this.backLabel, this.backColor);
            }
        }
        if (this.hasForeground()) {
            this.foreRgb.setEnabled(bl);
        }
        if (this.hasBackground()) {
            this.backRgb.setEnabled(bl);
        }
    }

    private void updatePreview() {
        java.awt.Color color = null;
        if (this.hasBackground()) {
            int n = (Integer)this.backLabel.getData();
            if (n == RGB_INDEX) {
                color = new java.awt.Color(this.getRgb(false));
            } else if (n > 0) {
                if (this.backIntensity > 0 && n <= 8) {
                    n += 8;
                }
                color = this.getColor(n - 1);
            } else {
                color = java.awt.Color.white;
            }
        }
        java.awt.Color color2 = null;
        if (this.hasForeground()) {
            int n = (Integer)this.foreLabel.getData();
            if (n == RGB_INDEX) {
                color2 = new java.awt.Color(this.getRgb(true));
            } else if (n > 0) {
                if (this.foreIntensity > 0 && n <= 8) {
                    n += 8;
                }
                color2 = this.getColor(n - 1);
            } else {
                color2 = java.awt.Color.black;
            }
        }
        if (color != null) {
            if (this.isReverse) {
                this.preview.setForeground(color);
            } else {
                this.preview.setBackground(color);
            }
        } else {
            this.preview.setBackground(color2);
        }
        if (color2 != null) {
            if (this.isReverse) {
                this.preview.setBackground(color2);
            } else {
                this.preview.setForeground(color2);
            }
        } else {
            this.preview.setForeground(color);
        }
    }

    public ColorType openDialog() {
        int n = this.open();
        for (int i = 0; i < this.colorImages.length; ++i) {
            this.colorImages[i].dispose();
        }
        if (this.rgbBackImage != null) {
            this.rgbBackImage.dispose();
        }
        if (this.rgbForeImage != null) {
            this.rgbForeImage.dispose();
        }
        if (n != 0) {
            return null;
        }
        return this.getColor();
    }

    private ColorType getColor() {
        if (this.rgb) {
            int n = this.getRgb(false);
            int n2 = this.getRgb(true);
            if (this.onlyBg) {
                return BackgroundColorType.getRgbBackgroundColorType((int)n);
            }
            if (this.onlyFg) {
                return ForegroundColorType.getRgbForegroundColorType((int)n2);
            }
            return new ColorType(n, n2);
        }
        if (this.onlyBg) {
            return new BackgroundColorType(this.backColor, false, false, this.partOfColorProp);
        }
        if (this.onlyFg) {
            return new ForegroundColorType(this.foreColor, false, false, this.partOfColorProp);
        }
        return new ColorType(this.backColor, this.foreColor, this.backIntensity > 0, this.backIntensity < 0, this.foreIntensity > 0, this.foreIntensity < 0, this.isReverse, this.isProtected, this.isBlink, this.isUnderline);
    }

    private int getRgb(boolean bl) {
        String string = bl ? this.foreColorRgb : this.backColorRgb;
        return Integer.parseInt(string.substring(1), 16);
    }

    private boolean hasForeground() {
        return !this.onlyBg;
    }

    private boolean hasBackground() {
        return !this.onlyFg && !this.isReportLine;
    }

    private boolean hasEffects() {
        return !this.isReportElement && this.hasBackground() && this.hasForeground();
    }

    static /* synthetic */ Menu access$000(ColorDialog colorDialog) {
        return colorDialog.popupMenu;
    }

    static /* synthetic */ Button access$100(ColorDialog colorDialog) {
        return colorDialog.backButton;
    }

    static /* synthetic */ MyLabel access$200(ColorDialog colorDialog) {
        return colorDialog.backLabel;
    }

    static /* synthetic */ int access$300() {
        return RGB_INDEX;
    }

    static /* synthetic */ int access$402(ColorDialog colorDialog, int n) {
        colorDialog.backColor = n;
        return colorDialog.backColor;
    }

    static /* synthetic */ MyLabel access$500(ColorDialog colorDialog) {
        return colorDialog.foreLabel;
    }

    static /* synthetic */ int access$602(ColorDialog colorDialog, int n) {
        colorDialog.foreColor = n;
        return colorDialog.foreColor;
    }

    static /* synthetic */ void access$700(ColorDialog colorDialog) {
        colorDialog.updatePreview();
    }

    static /* synthetic */ void access$800(ColorDialog colorDialog, ColorType colorType, boolean bl, boolean bl2, boolean bl3) {
        colorDialog.setColor(colorType, bl, bl2, bl3);
    }

    static /* synthetic */ void access$900(ColorDialog colorDialog) {
        colorDialog.copyColor();
    }

    static /* synthetic */ Button access$1000(ColorDialog colorDialog) {
        return colorDialog.isRgb;
    }

    static /* synthetic */ void access$1100(ColorDialog colorDialog, boolean bl) {
        colorDialog.setRGB(bl);
    }

    static /* synthetic */ Button access$1200(ColorDialog colorDialog) {
        return colorDialog.foreButton;
    }

    static /* synthetic */ void access$1300(ColorDialog colorDialog, boolean bl) {
        colorDialog.chooseRgb(bl);
    }

    static /* synthetic */ int access$1402(ColorDialog colorDialog, int n) {
        colorDialog.foreIntensity = n;
        return colorDialog.foreIntensity;
    }

    static /* synthetic */ int access$1502(ColorDialog colorDialog, int n) {
        colorDialog.backIntensity = n;
        return colorDialog.backIntensity;
    }

    static /* synthetic */ boolean access$1602(ColorDialog colorDialog, boolean bl) {
        colorDialog.isReverse = bl;
        return colorDialog.isReverse;
    }

    static /* synthetic */ Button access$1700(ColorDialog colorDialog) {
        return colorDialog.reverse;
    }

    static /* synthetic */ boolean access$1802(ColorDialog colorDialog, boolean bl) {
        colorDialog.isUnderline = bl;
        return colorDialog.isUnderline;
    }

    static /* synthetic */ Button access$1900(ColorDialog colorDialog) {
        return colorDialog.underline;
    }

    static /* synthetic */ boolean access$2002(ColorDialog colorDialog, boolean bl) {
        colorDialog.isBlink = bl;
        return colorDialog.isBlink;
    }

    static /* synthetic */ Button access$2100(ColorDialog colorDialog) {
        return colorDialog.blink;
    }

    static /* synthetic */ boolean access$2202(ColorDialog colorDialog, boolean bl) {
        colorDialog.isProtected = bl;
        return colorDialog.isProtected;
    }

    static /* synthetic */ Button access$2300(ColorDialog colorDialog) {
        return colorDialog._protected;
    }
}

