/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.dialogs.ColorDialog;
import com.iscobol.screenpainter.util.ColorPalette;
import java.awt.Color;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ColorPaletteDialog
extends Dialog {
    private Table colorTable;
    private Button modifyBtn;
    private Button resetBtn;
    private Button resetAllBtn;
    private ScreenProgram screenProgram;
    private boolean isScreenPalette;
    private Image[] colorImages = new Image[16];
    private ColorPalette palette;

    public ColorPaletteDialog(Shell shell, ScreenProgram screenProgram, boolean bl) {
        super(shell);
        this.screenProgram = screenProgram;
        this.isScreenPalette = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Color Palette");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Colors");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.colorTable = new Table((Composite)group, 67584);
        this.palette = new ColorPalette(this.isScreenPalette ? this.screenProgram.getScreenPalette() : this.screenProgram.getReportPalette());
        for (int i = 0; i < 16; ++i) {
            TableItem tableItem = new TableItem(this.colorTable, 0);
            this.colorImages[i] = ColorDialog.createImage((Display)this.getShell().getDisplay(), (Color)this.palette.getColor(i));
            tableItem.setImage(this.colorImages[i]);
            tableItem.setText(ColorDialog.normalColorNames[i + 1]);
        }
        GridData gridData = new GridData();
        gridData.verticalSpan = 3;
        gridData.widthHint = 220;
        gridData.heightHint = 370;
        this.colorTable.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.widthHint = 80;
        this.modifyBtn = new Button((Composite)group, 8);
        this.modifyBtn.setText("Modify");
        this.modifyBtn.setLayoutData((Object)gridData);
        this.resetBtn = new Button((Composite)group, 8);
        this.resetBtn.setText("Reset");
        this.resetBtn.setLayoutData((Object)gridData);
        this.resetAllBtn = new Button((Composite)group, 8);
        this.resetAllBtn.setText("Reset All");
        this.resetAllBtn.setLayoutData((Object)gridData);
        this.modifyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resetBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resetAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void changeImage(int n) {
        Image image = this.colorImages[n];
        this.colorImages[n] = ColorDialog.createImage((Display)this.getShell().getDisplay(), (Color)this.palette.getColor(n));
        this.colorTable.getItem(n).setImage(this.colorImages[n]);
        image.dispose();
    }

    public ColorPalette openDialog() {
        int n = super.open();
        for (int i = 0; i < this.colorImages.length; ++i) {
            this.colorImages[i].dispose();
        }
        return n == 0 ? this.palette : null;
    }

    static /* synthetic */ Table access$000(ColorPaletteDialog colorPaletteDialog) {
        return colorPaletteDialog.colorTable;
    }

    static /* synthetic */ ColorPalette access$100(ColorPaletteDialog colorPaletteDialog) {
        return colorPaletteDialog.palette;
    }

    static /* synthetic */ void access$200(ColorPaletteDialog colorPaletteDialog, int n) {
        colorPaletteDialog.changeImage(n);
    }
}

