/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ColumnHeadingLayoutDialog
extends Dialog {
    private Button enabledBtn;
    private Button[] buttons = new Button[10];
    private int value;

    public ColumnHeadingLayoutDialog(Shell shell, String string) {
        super(shell);
        try {
            this.value = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Column heading layout");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.enabledBtn = new Button(composite2, 32);
        this.enabledBtn.setText("Enabled");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.enabledBtn.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        group.setText("Orientation");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        group.setLayoutData((Object)gridData);
        this.buttons[0] = new Button((Composite)group, 16);
        this.buttons[0].setText("Horizontal");
        this.buttons[0].setData((Object)0);
        this.buttons[1] = new Button((Composite)group, 16);
        this.buttons[1].setText("Vertical Left");
        this.buttons[1].setData((Object)1);
        this.buttons[2] = new Button((Composite)group, 16);
        this.buttons[2].setText("Vertical Right");
        this.buttons[2].setData((Object)2);
        Group group2 = new Group(composite2, 0);
        gridLayout = new GridLayout();
        group2.setLayout((Layout)gridLayout);
        group2.setText("Horizontal Alignment");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        group2.setLayoutData((Object)gridData);
        this.buttons[3] = new Button((Composite)group2, 16);
        this.buttons[3].setText("None");
        this.buttons[3].setData((Object)0);
        this.buttons[4] = new Button((Composite)group2, 16);
        this.buttons[4].setText("Left");
        this.buttons[4].setData((Object)8);
        this.buttons[5] = new Button((Composite)group2, 16);
        this.buttons[5].setText("Center");
        this.buttons[5].setData((Object)4);
        this.buttons[6] = new Button((Composite)group2, 16);
        this.buttons[6].setText("Right");
        this.buttons[6].setData((Object)16);
        Group group3 = new Group(composite2, 0);
        gridLayout = new GridLayout();
        group3.setLayout((Layout)gridLayout);
        group3.setText("Vertical Alignment");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        group3.setLayoutData((Object)gridData);
        this.buttons[7] = new Button((Composite)group3, 16);
        this.buttons[7].setText("None");
        this.buttons[7].setData((Object)0);
        this.buttons[8] = new Button((Composite)group3, 16);
        this.buttons[8].setText("Top");
        this.buttons[8].setData((Object)32);
        this.buttons[9] = new Button((Composite)group3, 16);
        this.buttons[9].setText("Bottom");
        this.buttons[9].setData((Object)64);
        this.intSetEnabled(this.value > 0);
        if ((this.value & 1) == 1) {
            this.buttons[1].setSelection(true);
        } else if ((this.value & 2) == 2) {
            this.buttons[2].setSelection(true);
        } else {
            this.buttons[0].setSelection(true);
        }
        if ((this.value & 8) == 8) {
            this.buttons[4].setSelection(true);
        } else if ((this.value & 4) == 4) {
            this.buttons[5].setSelection(true);
        } else if ((this.value & 0x10) == 16) {
            this.buttons[6].setSelection(true);
        } else {
            this.buttons[3].setSelection(true);
        }
        if ((this.value & 0x20) == 32) {
            this.buttons[8].setSelection(true);
        } else if ((this.value & 0x40) == 64) {
            this.buttons[9].setSelection(true);
        } else {
            this.buttons[7].setSelection(true);
        }
        this.enabledBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void intSetEnabled(boolean bl) {
        this.enabledBtn.setSelection(bl);
        for (Button button : this.buttons) {
            button.setEnabled(bl);
        }
    }

    public void okPressed() {
        this.value = 0;
        if (this.enabledBtn.getSelection()) {
            for (Button button : this.buttons) {
                if (!button.getSelection()) continue;
                this.value += ((Integer)button.getData()).intValue();
            }
        }
        super.okPressed();
    }

    public String openDialog() {
        if (this.open() != 0) {
            return null;
        }
        return Integer.toString(this.value);
    }

    static /* synthetic */ Button access$000(ColumnHeadingLayoutDialog columnHeadingLayoutDialog) {
        return columnHeadingLayoutDialog.enabledBtn;
    }

    static /* synthetic */ void access$100(ColumnHeadingLayoutDialog columnHeadingLayoutDialog, boolean bl) {
        columnHeadingLayoutDialog.intSetEnabled(bl);
    }
}

