/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingBitmap;
import com.iscobol.screenpainter.beans.swing.SwingCheckBox;
import com.iscobol.screenpainter.beans.swing.SwingCheckListBox;
import com.iscobol.screenpainter.beans.swing.SwingComboBox;
import com.iscobol.screenpainter.beans.swing.SwingDateEntry;
import com.iscobol.screenpainter.beans.swing.SwingEntryField;
import com.iscobol.screenpainter.beans.swing.SwingLabel;
import com.iscobol.screenpainter.beans.swing.SwingListBox;
import com.iscobol.screenpainter.beans.swing.SwingPushButton;
import com.iscobol.screenpainter.beans.swing.SwingRadioButton;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.dialogs.SettingsDialog;
import com.iscobol.screenpainter.propertysheet.PropertySheetContainer;
import com.iscobol.screenpainter.propertysheet.PropertySheetTable;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComponentDialog
extends Dialog
implements PropertySheetContainer {
    private AbstractBeanControl initValue;
    private AbstractBeanControl newValue;
    private ScreenProgram screenProgram;
    private PropertySheetTable propertySheet;
    private CCombo typeCmb;
    private Label statusBar;
    protected SettingsDialog parentDialog;
    private static final AbstractBeanControl NULL = new /* Unavailable Anonymous Inner Class!! */;
    private int[] types = new int[]{106, 104, 108, 119, 101, 105, 107, 120, 102, 103};
    private AbstractBeanControl[] controls = new AbstractBeanControl[this.types.length];

    public ComponentDialog(Shell shell, ScreenProgram screenProgram, SettingsDialog settingsDialog, AbstractBeanControl abstractBeanControl) {
        super(shell);
        this.initValue = abstractBeanControl;
        this.screenProgram = screenProgram;
        this.parentDialog = settingsDialog;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Grid Editor Settings");
    }

    protected Control createDialogArea(Composite composite) {
        int n;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        label.setText("Type:");
        this.typeCmb = new CCombo(composite3, 2056);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.typeCmb.setLayoutData((Object)gridData);
        IProject iProject = this.screenProgram != null ? this.screenProgram.getProject() : null;
        this.propertySheet = new PropertySheetTable(composite2, 0, (PropertySheetContainer)this, this.screenProgram, iProject, false, 200, 250);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 700;
        gridData.heightHint = 600;
        this.propertySheet.setLayoutData((Object)gridData);
        this.statusBar = new Label(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.statusBar.setLayoutData((Object)gridData);
        this.statusBar.setForeground(composite.getDisplay().getSystemColor(3));
        this.typeCmb.add("None");
        for (n = 0; n < this.types.length; ++n) {
            this.typeCmb.add(IscobolBeanConstants.getTypeName((int)this.types[n]));
        }
        if (this.initValue != null) {
            n = this.initValue.getType();
            for (int i = 0; i < this.types.length; ++i) {
                if (n != this.types[i]) continue;
                this.controls[i] = this.initValue;
                this.typeCmb.select(i + 1);
                break;
            }
        } else {
            this.typeCmb.select(5);
        }
        this.loadComponent();
        this.typeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void loadComponent() {
        int n = this.typeCmb.getSelectionIndex();
        if (n > 0) {
            this.newValue = this.controls[--n];
            if (this.newValue == null) {
                switch (this.types[n]) {
                    case 106: {
                        this.newValue = new SwingBitmap();
                        break;
                    }
                    case 104: {
                        this.newValue = new SwingCheckBox();
                        break;
                    }
                    case 108: {
                        this.newValue = new SwingComboBox();
                        break;
                    }
                    case 119: {
                        this.newValue = new SwingDateEntry();
                        break;
                    }
                    case 101: {
                        this.newValue = new SwingEntryField();
                        break;
                    }
                    case 105: {
                        this.newValue = new SwingLabel();
                        break;
                    }
                    case 107: {
                        this.newValue = new SwingListBox();
                        break;
                    }
                    case 120: {
                        this.newValue = new SwingCheckListBox();
                        break;
                    }
                    case 103: {
                        this.newValue = new SwingRadioButton();
                        break;
                    }
                    case 102: {
                        this.newValue = new SwingPushButton();
                    }
                }
            }
            this.newValue.setName(IscobolBeanConstants.getTypeName((int)this.newValue.getType()).toLowerCase());
            this.controls[n] = this.newValue;
            this.propertySheet.setVisible(true);
            this.propertySheet.loadTable(new Object[]{this.newValue});
        } else {
            this.newValue = null;
            this.propertySheet.setVisible(false);
        }
    }

    public AbstractBeanControl openDialog() {
        if (super.open() == 0) {
            return this.newValue != null ? this.newValue : NULL;
        }
        return null;
    }

    public boolean isDirty() {
        return false;
    }

    public void paragraphValueChanged(Object object, int n, String string, ParagraphType paragraphType, ParagraphType paragraphType2, boolean bl) {
        if (paragraphType2 != null && n == 0 && bl) {
            this.okPressed();
            if (this.parentDialog != null) {
                this.parentDialog.okPressed();
            }
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
            screenProgramEditor.activateEventParagraphsEditor();
            eventParagraphsEditor.setFocus();
            eventParagraphsEditor.addAndSelectParagraph(this.screenProgram.getEventParagraphs(), paragraphType2.getName(), paragraphType2.isUserParagraph());
        }
    }

    public void setDirty(boolean bl) {
    }

    public void setErrorMessage(String string) {
        if (this.statusBar.isDisposed()) {
            return;
        }
        if (string != null) {
            this.statusBar.setText(string);
        } else {
            this.statusBar.setText("");
        }
    }

    public void valueChanged(Object object, int n, String string, Object object2, Object object3) {
    }

    public CommandStack getCommandStack() {
        return null;
    }

    static /* synthetic */ void access$000(ComponentDialog componentDialog) {
        componentDialog.loadComponent();
    }
}

