/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class CopyFileSelectionDialog
extends Dialog {
    private Tree resTree;
    private Button importBtn;
    private final IFolder[] copyFolders;
    String selectedFileName;
    String selectedFilePath;
    String selectedProjectRelativeFilePath;
    final String[] copyExtensions;
    final IProject project;

    CopyFileSelectionDialog(Shell shell, IFolder[] iFolderArray, String[] stringArray, IProject iProject) {
        super(shell);
        this.copyFolders = iFolderArray;
        this.copyExtensions = stringArray;
        this.project = iProject;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select Copy File");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.resTree = new Tree(composite2, 268437508);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 500;
        this.resTree.setLayoutData((Object)gridData);
        for (int i = 0; i < this.copyFolders.length; ++i) {
            this.loadTree(this.copyFolders[i], null);
        }
        this.resTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.importBtn = new Button(composite2, 8);
        this.importBtn.setText("Add Copy File");
        this.importBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        this.importBtn.setLayoutData((Object)gridData);
        return composite2;
    }

    private void loadTree(IFolder iFolder, TreeItem treeItem) {
        IResource[] iResourceArray;
        TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.resTree, 0);
        treeItem2.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/copyfolder.gif"));
        if (treeItem != null) {
            treeItem2.setText(iFolder.getName());
        } else if (iFolder.getProject() == this.project) {
            treeItem2.setText(iFolder.getProjectRelativePath().toString());
        } else {
            treeItem2.setText(iFolder.getFullPath().toString());
        }
        treeItem2.setData((Object)iFolder);
        try {
            iResourceArray = iFolder.members();
        }
        catch (CoreException coreException) {
            iResourceArray = new IResource[]{};
        }
        Arrays.sort(iResourceArray, new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < iResourceArray.length; ++i) {
            IFile iFile;
            String string;
            if (iResourceArray[i] instanceof IFolder) {
                this.loadTree((IFolder)iResourceArray[i], treeItem2);
                continue;
            }
            if (!(iResourceArray[i] instanceof IFile) || !this.isValidCopyFileExtension(string = (iFile = (IFile)iResourceArray[i]).getFileExtension())) continue;
            TreeItem treeItem3 = new TreeItem(treeItem2, 0);
            treeItem3.setText(iFile.getName());
            treeItem3.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/copy.gif"));
            treeItem3.setData((Object)iFile);
        }
    }

    private boolean isValidCopyFileExtension(String string) {
        for (int i = 0; i < this.copyExtensions.length; ++i) {
            if (!"*".equals(this.copyExtensions[i]) && (string == null || !this.copyExtensions[i].equalsIgnoreCase(string))) continue;
            return true;
        }
        return false;
    }

    public void okPressed() {
        if (this.selectedFileName == null) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setText(this.getShell().getText());
            messageBox.setMessage("Please select a Copy File");
            messageBox.open();
        } else {
            super.okPressed();
        }
    }

    static /* synthetic */ Tree access$000(CopyFileSelectionDialog copyFileSelectionDialog) {
        return copyFileSelectionDialog.resTree;
    }

    static /* synthetic */ IFolder[] access$100(CopyFileSelectionDialog copyFileSelectionDialog) {
        return copyFileSelectionDialog.copyFolders;
    }
}

