/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.screenpainter.DataPool;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DataPoolDialog
extends Dialog {
    private CCombo typeCmb;
    private Tree dataItemTree;
    private final Font font;
    private ScreenProgramEditor editor;
    private DataPool dataPool;

    public DataPoolDialog(ScreenProgramEditor screenProgramEditor) {
        super(screenProgramEditor.getSite().getShell());
        this.setShellStyle(112);
        this.editor = screenProgramEditor;
        this.dataPool = screenProgramEditor.getDataPool();
        this.font = new Font((Device)screenProgramEditor.getSite().getShell().getDisplay(), new FontData("dialog", 8, 0));
    }

    public boolean close() {
        this.font.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Data Pool - " + this.editor.getScreenProgram().getProgramName());
    }

    protected Control createDialogArea(Composite composite) {
        VariableType variableType;
        int n;
        Object object;
        ScreenProgram screenProgram = this.editor.getScreenProgram();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Control Type:");
        label.setFont(this.font);
        this.typeCmb = new CCombo(composite2, 2056);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.typeCmb.setLayoutData((Object)gridData);
        this.typeCmb.setFont(this.font);
        this.dataItemTree = new Tree(composite2, 2050);
        this.dataItemTree.setHeaderVisible(true);
        this.dataItemTree.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.horizontalSpan = 2;
        this.dataItemTree.setLayoutData((Object)gridData);
        this.dataItemTree.setFont(this.font);
        this.dataItemTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        TreeColumn treeColumn = new TreeColumn(this.dataItemTree, 0);
        treeColumn.setText("Field");
        treeColumn.setWidth(400);
        DragSource dragSource = new DragSource((Control)this.dataItemTree, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new /* Unavailable Anonymous Inner Class!! */);
        int[] nArray = this.dataPool.getTypes();
        int n2 = this.dataPool.getDefaultType();
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            this.typeCmb.add(this.dataPool.getTypeName(nArray[i]));
            if (nArray[i] != n2) continue;
            n3 = i;
        }
        this.typeCmb.select(n3);
        FileEntry[] fileEntryArray = screenProgram.getFileSection().getFDEntries();
        VariableTypeList[] variableTypeListArray = screenProgram.getFileSection().getFDEntryVariables(screenProgram.getProject());
        for (int i = 0; i < fileEntryArray.length; ++i) {
            ArrayList<VariableType> arrayList = new ArrayList<VariableType>();
            object = variableTypeListArray[i];
            for (n = 0; n < object.getSettingCount(); ++n) {
                variableType = (VariableType)object.getSettingAt(n);
                int n4 = variableType.getLevelAsInt();
                if ((n4 < 1 || n4 > 49) && n4 != 77) continue;
                arrayList.add(variableType);
            }
            if (arrayList.size() <= 0) continue;
            TreeItem treeItem = new TreeItem(this.dataItemTree, 0);
            treeItem.setGrayed(true);
            String string = fileEntryArray[i].getFilename();
            treeItem.setText(string.substring(0, string.length() - 3));
            this.addVariables(arrayList.toArray(new VariableType[arrayList.size()]), treeItem);
        }
        ScreenFD_SL[] screenFD_SLArray = PluginUtilities.getUsedDataLayouts((IProject)screenProgram.getProject(), (DataSet[])screenProgram.getFileSection().getDataSets());
        for (int i = 0; i < screenFD_SLArray.length; ++i) {
            object = new ArrayList();
            variableType = screenFD_SLArray[i].getFdItems();
            for (int j = 0; j < variableType.getSettingCount(); ++j) {
                VariableType variableType2 = (VariableType)variableType.getSettingAt(j);
                n = variableType2.getLevelAsInt();
                if ((n < 1 || n > 49) && n != 77) continue;
                ((ArrayList)object).add(variableType2);
            }
            if (((ArrayList)object).size() <= 0) continue;
            TreeItem treeItem = new TreeItem(this.dataItemTree, 0);
            treeItem.setGrayed(true);
            treeItem.setText(screenFD_SLArray[i].getFdName());
            this.addVariables(((ArrayList)object).toArray(new VariableType[((ArrayList)object).size()]), treeItem);
        }
        ArrayList<VariableType> arrayList = new ArrayList<VariableType>();
        object = new ArrayList();
        variableType = screenProgram.getResourceRegistry().getVariableTypeList();
        for (int i = 0; i < variableType.getSettingCount(); ++i) {
            VariableType variableType3 = (VariableType)variableType.getSettingAt(i);
            n = variableType3.getLevelAsInt();
            if ((n < 1 || n > 49) && n != 77) continue;
            if (variableType3.isInLinkage()) {
                ((ArrayList)object).add(variableType3);
                continue;
            }
            arrayList.add(variableType3);
        }
        if (arrayList.size() > 0) {
            TreeItem treeItem = new TreeItem(this.dataItemTree, 0);
            treeItem.setGrayed(true);
            treeItem.setText("Working Storage");
            this.addVariables(arrayList.toArray(new VariableType[arrayList.size()]), treeItem);
        }
        if (((ArrayList)object).size() > 0) {
            TreeItem treeItem = new TreeItem(this.dataItemTree, 0);
            treeItem.setGrayed(true);
            treeItem.setText("Linkage Section");
            this.addVariables(((ArrayList)object).toArray(new VariableType[((ArrayList)object).size()]), treeItem);
        }
        return composite2;
    }

    private void addVariables(VariableType[] variableTypeArray, TreeItem treeItem) {
        for (int i = 0; i < variableTypeArray.length; ++i) {
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setText(variableTypeArray[i].toString(this.dataPool.getApplyEFDNames()));
            treeItem2.setData((Object)variableTypeArray[i]);
            ArrayList<VariableType> arrayList = new ArrayList<VariableType>();
            for (int j = 0; j < variableTypeArray[i].getChildCount(); ++j) {
                VariableType variableType = (VariableType)variableTypeArray[i].getChildAt(j);
                int n = variableType.getLevelAsInt();
                if ((n < 1 || n > 49) && n != 77) continue;
                arrayList.add(variableType);
            }
            if (arrayList.size() <= 0) continue;
            this.addVariables(arrayList.toArray(new VariableType[arrayList.size()]), treeItem2);
        }
    }

    public VariableType[] getSelection() {
        VariableType[] variableTypeArray = new VariableType[this.dataItemTree.getSelectionCount()];
        TreeItem[] treeItemArray = this.dataItemTree.getSelection();
        for (int i = 0; i < variableTypeArray.length; ++i) {
            variableTypeArray[i] = (VariableType)treeItemArray[i].getData();
        }
        return variableTypeArray;
    }

    public int getControlType() {
        return this.dataPool.getTypes()[this.typeCmb.getSelectionIndex()];
    }

    public ScreenProgramEditor getEditor() {
        return this.editor;
    }

    static /* synthetic */ Tree access$000(DataPoolDialog dataPoolDialog) {
        return dataPoolDialog.dataItemTree;
    }
}

