/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.CellEditorValidators;
import com.iscobol.screenpainter.propertysheet.TextEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DataPoolMakeRadioButtonDialog
extends Dialog {
    private CCombo varCmb;
    private Table radioButtonTable;
    private TableEditor tableEditor;
    private VariableType[] variables;
    private int previousSelection;
    private String[] labels;

    public DataPoolMakeRadioButtonDialog(Shell shell, VariableType[] variableTypeArray) {
        super(shell);
        this.variables = variableTypeArray;
        this.labels = new String[variableTypeArray.length];
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Make Radio Button");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Variable:");
        this.varCmb = new CCombo(composite2, 2056);
        this.varCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gridData = new GridData(768);
        this.varCmb.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout());
        Composite composite3 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        label = new Label(composite3, 0);
        label.setText("Group Label");
        label.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite3, 8);
        button.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/add_item.gif"));
        button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button button2 = new Button(composite3, 8);
        button2.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/remove_item.gif"));
        button2.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.radioButtonTable = new Table((Composite)group, 2052);
        this.radioButtonTable.setHeaderVisible(true);
        this.radioButtonTable.setLinesVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.radioButtonTable.setLayoutData((Object)gridData);
        this.tableEditor = new TableEditor(this.radioButtonTable);
        this.tableEditor.grabHorizontal = true;
        TableColumn tableColumn = new TableColumn(this.radioButtonTable, 0);
        tableColumn.setWidth(250);
        tableColumn.setText("Prompt");
        this.radioButtonTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < this.variables.length; ++i) {
            this.varCmb.add(this.variables[i].getName());
        }
        this.varCmb.select(0);
        this.previousSelection = 0;
        return composite2;
    }

    private void updateLabels() {
        StringBuilder stringBuilder = new StringBuilder();
        TableItem[] tableItemArray = this.radioButtonTable.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            stringBuilder.append(tableItemArray[i].getText());
            if (i >= tableItemArray.length - 1) continue;
            stringBuilder.append(",");
        }
        this.labels[this.previousSelection] = stringBuilder.toString();
    }

    private void handleMouseDownEvent(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.radioButtonTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        TextEditor textEditor = new TextEditor();
        TableItem tableItem = this.radioButtonTable.getItem(nArray[0]);
        textEditor.setValidator(CellEditorValidators.varnameValidator);
        textEditor.createEditor((Composite)this.radioButtonTable);
        textEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tableEditor.setEditor(textEditor.getEditor(), tableItem, 0);
        textEditor.setValue((Object)tableItem.getText(0));
        textEditor.selectAll();
        textEditor.setFocus();
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void comboSelchanged(int n) {
        this.radioButtonTable.removeAll();
        if (this.labels[n] != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.labels[n], ",");
            while (stringTokenizer.hasMoreTokens()) {
                TableItem tableItem = new TableItem(this.radioButtonTable, 0);
                tableItem.setText(stringTokenizer.nextToken());
            }
        }
        this.previousSelection = n;
    }

    public void okPressed() {
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] != null && this.labels[i].length() != 0) continue;
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setText("Error");
            messageBox.setMessage("Must have at least one prompt");
            messageBox.open();
            this.varCmb.select(i);
            this.comboSelchanged(i);
            return;
        }
        super.okPressed();
    }

    public String[] openDialog() {
        if (this.open() == 0) {
            return this.labels;
        }
        return null;
    }

    static /* synthetic */ CCombo access$000(DataPoolMakeRadioButtonDialog dataPoolMakeRadioButtonDialog) {
        return dataPoolMakeRadioButtonDialog.varCmb;
    }

    static /* synthetic */ void access$100(DataPoolMakeRadioButtonDialog dataPoolMakeRadioButtonDialog, int n) {
        dataPoolMakeRadioButtonDialog.comboSelchanged(n);
    }

    static /* synthetic */ Table access$200(DataPoolMakeRadioButtonDialog dataPoolMakeRadioButtonDialog) {
        return dataPoolMakeRadioButtonDialog.radioButtonTable;
    }

    static /* synthetic */ void access$300(DataPoolMakeRadioButtonDialog dataPoolMakeRadioButtonDialog) {
        dataPoolMakeRadioButtonDialog.updateLabels();
    }

    static /* synthetic */ void access$400(DataPoolMakeRadioButtonDialog dataPoolMakeRadioButtonDialog, MouseEvent mouseEvent) {
        dataPoolMakeRadioButtonDialog.handleMouseDownEvent(mouseEvent);
    }
}

