/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.plugins.editor.dialogs.ElementSelectorComposite;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractJavaBean;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EventListDialog
extends Dialog {
    private String value;
    private String clsid;
    private ElementSelectorComposite selector;
    private Class zkBaseComponentClass;
    private ClassLoader loader;

    public EventListDialog(Shell shell, String string, String string2) {
        super(shell);
        this.value = string;
        this.clsid = string2;
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        if (screenProgram != null) {
            this.loader = PluginUtilities.getClassLoader((IProject)screenProgram.getProject(), (String)PluginUtilities.getCurrentSettingMode((IResource)screenProgram.getProject()));
        }
        if (this.loader == null) {
            this.loader = this.getClass().getClassLoader();
        }
        try {
            this.zkBaseComponentClass = PluginUtilities.classForName((String)"org.zkoss.zk.ui.HtmlBasedComponent", (ClassLoader)this.loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Event List Setting");
    }

    private String[] getZKEvents(Class clazz) {
        if (this.zkBaseComponentClass != null && this.zkBaseComponentClass.isAssignableFrom(clazz)) {
            try {
                Logger.getLogger("org.zkoss").setLevel(Level.OFF);
                Object t = clazz.newInstance();
                Map map = (Map)clazz.getMethod("getClientEvents", new Class[0]).invoke(t, new Object[0]);
                Object[] objectArray = map.keySet().toArray(new String[map.size()]);
                Arrays.sort(objectArray);
                return objectArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.clsid != null && this.clsid.length() > 0) {
            try {
                Class clazz;
                String[] stringArray;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (this.loader != null) {
                    Thread.currentThread().setContextClassLoader(this.loader);
                }
                if ((stringArray = this.getZKEvents(clazz = PluginUtilities.classForName((String)this.clsid, (ClassLoader)this.loader))) != null) {
                    for (String object : stringArray) {
                        arrayList.add(object);
                    }
                } else {
                    for (EventSetDescriptor eventSetDescriptor : Introspector.getBeanInfo(clazz).getEventSetDescriptors()) {
                        arrayList.add(eventSetDescriptor.getName());
                    }
                }
                Thread.currentThread().setContextClassLoader(classLoader);
                for (String string : AbstractJavaBean.JAVA_BEAN_EVENTS) {
                    arrayList.add(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.selector = new ElementSelectorComposite(composite2, "Available Events", "Event List", false, arrayList.toArray(new String[arrayList.size()]), this.value);
        return composite2;
    }

    public void okPressed() {
        this.value = this.selector.getValue();
        super.okPressed();
    }

    public String openDialog() {
        return this.open() == 0 ? this.value : null;
    }
}

