/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.findinobject.FindInObjectQuery;
import com.iscobol.screenpainter.findinobject.FindInObjectUtilities;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FindInObjectDialog
extends Dialog {
    private Combo searchCmb;
    private StyledText targetObjectTxt;
    private Button matchCaseBtn;
    private Button wholeWordBtn;
    private Button searchPropNameBtn;
    private FindInObjectQuery query = new FindInObjectQuery();
    private Object targetObj;
    private static boolean lastMatchCase = false;
    private static boolean lastWholeWord = false;
    private static boolean lastSearchPropName = false;
    private static LinkedList searchList = new LinkedList();
    private static final int MAX_SIZE = 15;

    public FindInObjectDialog(Shell shell, Object object) {
        super(shell);
        this.targetObj = object;
        this.query.setSearchTarget(object);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Find in objects");
    }

    protected Control createDialogArea(Composite composite) {
        StyleRange styleRange;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Search text:");
        this.searchCmb = new Combo(composite2, 2048);
        GridData gridData = new GridData(768);
        this.searchCmb.setLayoutData((Object)gridData);
        Image image = searchList.listIterator();
        while (image.hasNext()) {
            this.searchCmb.add(image.next().toString());
        }
        this.searchCmb.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.searchCmb.getItemCount() > 0) {
            this.searchCmb.select(0);
            this.query.setSearchText(this.searchCmb.getItem(0));
        }
        label = new Label(composite2, 0);
        label.setText("Target Object");
        this.targetObjectTxt = new StyledText(composite2, 2048);
        gridData = new GridData(768);
        this.targetObjectTxt.setLayoutData((Object)gridData);
        this.targetObjectTxt.setText("  " + FindInObjectUtilities.getLabelFor((Object)this.targetObj));
        image = FindInObjectUtilities.getImageFor((Object)this.targetObj);
        if (image != null) {
            this.targetObjectTxt.setData((Object)image);
            styleRange = new StyleRange();
            styleRange.start = 0;
            styleRange.length = 1;
            Rectangle rectangle = image.getBounds();
            styleRange.metrics = new GlyphMetrics(rectangle.height, 0, rectangle.width);
            this.targetObjectTxt.setStyleRange(styleRange);
        }
        this.targetObjectTxt.addPaintObjectListener((PaintObjectListener)new /* Unavailable Anonymous Inner Class!! */);
        this.targetObjectTxt.setEnabled(false);
        styleRange = new Composite(composite2, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        styleRange.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        styleRange.setLayout((Layout)gridLayout);
        this.matchCaseBtn = new Button((Composite)styleRange, 32);
        this.matchCaseBtn.setText("Match case");
        this.matchCaseBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.matchCaseBtn.setSelection(lastMatchCase);
        this.query.setMatchCase(lastMatchCase);
        this.wholeWordBtn = new Button((Composite)styleRange, 32);
        this.wholeWordBtn.setText("Whole word");
        this.wholeWordBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wholeWordBtn.setSelection(lastWholeWord);
        this.query.setWholeWord(lastWholeWord);
        this.searchPropNameBtn = new Button((Composite)styleRange, 32);
        this.searchPropNameBtn.setText("Search property name");
        this.searchPropNameBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchPropNameBtn.setSelection(lastSearchPropName);
        this.query.setFindPropertyName(lastSearchPropName);
        return composite2;
    }

    protected void okPressed() {
        if (this.searchCmb.getText().length() == 0) {
            MessageBox messageBox = new MessageBox(this.getShell(), 33);
            messageBox.setText(this.getShell().getText());
            messageBox.setMessage("Search text cannot be empty");
            messageBox.open();
        } else {
            if (!searchList.contains(this.searchCmb.getText())) {
                searchList.addFirst(this.searchCmb.getText());
                if (searchList.size() > 15) {
                    searchList.removeLast();
                }
            }
            lastMatchCase = this.query.isMatchCase();
            lastWholeWord = this.query.isWholeWord();
            lastSearchPropName = this.query.isFindPropertyName();
            super.okPressed();
        }
    }

    public FindInObjectQuery openDialog() {
        if (this.open() != 0) {
            return null;
        }
        return this.query;
    }

    static /* synthetic */ Combo access$000(FindInObjectDialog findInObjectDialog) {
        return findInObjectDialog.searchCmb;
    }

    static /* synthetic */ FindInObjectQuery access$100(FindInObjectDialog findInObjectDialog) {
        return findInObjectDialog.query;
    }

    static /* synthetic */ StyledText access$200(FindInObjectDialog findInObjectDialog) {
        return findInObjectDialog.targetObjectTxt;
    }

    static /* synthetic */ Button access$300(FindInObjectDialog findInObjectDialog) {
        return findInObjectDialog.matchCaseBtn;
    }

    static /* synthetic */ Button access$400(FindInObjectDialog findInObjectDialog) {
        return findInObjectDialog.wholeWordBtn;
    }

    static /* synthetic */ Button access$500(FindInObjectDialog findInObjectDialog) {
        return findInObjectDialog.searchPropNameBtn;
    }
}

