/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.UIFontManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JLabel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FontDialog
extends Dialog {
    private static String[] fontNames;
    private static String[] fontSizes;
    private Text fontSizeTxt;
    private List fontName;
    private List fontSize;
    private Button bold;
    private Button italic;
    private Button underline;
    private Button strikethrough;
    private JLabel preview;
    private FontType initValue = FontType.getStandardFont((String)"Default-Font");
    private String name;
    private float size;
    private boolean isBold;
    private boolean isUnderline;
    private boolean isStrikethrough;
    private boolean isItalic;
    private boolean isOnPreferencePage;

    public FontDialog(Shell shell, FontType fontType, boolean bl) {
        super(shell);
        this.initValue = fontType;
        this.isOnPreferencePage = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ISPBundle.getString((String)"choose_font_title"));
        shell.setSize(500, 470);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Font");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        this.fontName = new List((Composite)group, 2560);
        gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 350;
        this.fontName.setLayoutData((Object)gridData);
        if (fontNames == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fontNames = graphicsEnvironment.getAvailableFontFamilyNames();
        }
        for (int i = 0; i < fontNames.length; ++i) {
            this.fontName.add(fontNames[i]);
        }
        this.fontName.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite composite3 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 1;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.heightHint = 150;
        composite3.setLayoutData((Object)gridData);
        this.fontSizeTxt = new Text(composite3, 133120);
        gridData = new GridData(768);
        this.fontSizeTxt.setLayoutData((Object)gridData);
        this.fontSizeTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fontSize = new List(composite3, 133632);
        gridData = new GridData(1808);
        this.fontSize.setLayoutData((Object)gridData);
        if (fontSizes == null) {
            fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        }
        for (int i = 0; i < fontSizes.length; ++i) {
            this.fontSize.add(fontSizes[i]);
        }
        this.fontSize.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group group2 = new Group(composite2, 0);
        group2.setText("Effects");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group2.setLayoutData((Object)gridData);
        this.bold = new Button((Composite)group2, 32);
        this.bold.setText("Bold");
        this.bold.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.italic = new Button((Composite)group2, 32);
        this.italic.setText("Italic");
        this.italic.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.underline = new Button((Composite)group2, 32);
        this.underline.setText("Underline");
        this.underline.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.strikethrough = new Button((Composite)group2, 32);
        this.strikethrough.setText("Strikethrough");
        this.strikethrough.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group group3 = new Group(composite2, 0);
        group3.setText("Preview");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group3.setLayoutData((Object)gridData);
        Composite composite4 = new Composite((Composite)group3, 0x1000800);
        Frame frame = SWT_AWT.new_Frame((Composite)composite4);
        frame.setLayout(new java.awt.GridLayout(1, 0));
        this.preview = new JLabel("Preview Font");
        this.preview.setHorizontalAlignment(0);
        this.preview.setOpaque(true);
        this.preview.setBackground(Color.white);
        frame.add(this.preview);
        gridData = new GridData(768);
        gridData.heightHint = 70;
        composite4.setLayoutData((Object)gridData);
        if (this.initValue != null) {
            String[] stringArray = this.fontName.getItems();
            this.name = this.initValue.getFont().getName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(this.name)) continue;
                this.fontName.select(i);
                this.fontName.showSelection();
                break;
            }
            this.size = this.initValue.getSize();
            String string = Integer.toString((int)this.size);
            this.fontSizeTxt.setText(string);
            stringArray = this.fontSize.getItems();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.fontSize.select(i);
                this.fontSize.showSelection();
                break;
            }
            this.isBold = this.initValue.isBold();
            this.bold.setSelection(this.isBold);
            this.isItalic = this.initValue.isItalic();
            this.italic.setSelection(this.isItalic);
            this.isUnderline = this.initValue.isUnderline();
            this.underline.setSelection(this.isUnderline);
            this.isStrikethrough = this.initValue.isStrikethrough();
            this.strikethrough.setSelection(this.isStrikethrough);
        } else {
            this.fontName.select(0);
            this.fontSize.select(0);
        }
        return composite2;
    }

    private void updatePreview() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        if (this.name != null && this.name.length() > 0) {
            hashMap.put(TextAttribute.FAMILY, this.name);
        }
        if (this.size > 0.0f) {
            hashMap.put(TextAttribute.SIZE, new Float(this.size * (float)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0f));
        }
        if (this.isBold) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.isItalic) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (this.isUnderline) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.isStrikethrough) {
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        this.preview.setFont(new Font(hashMap));
    }

    public FontType openDialog() {
        if (this.open() != 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append(this.name.replace(' ', '-'));
        }
        stringBuilder.append("-");
        stringBuilder.append(Float.toString(this.size).replace('.', 'v'));
        if (this.isBold) {
            stringBuilder.append("-b");
        }
        if (this.isItalic) {
            stringBuilder.append("-i");
        }
        if (this.isUnderline) {
            stringBuilder.append("-u");
        }
        if (this.isStrikethrough) {
            stringBuilder.append("-s");
        }
        int n = 0;
        if (this.isBold) {
            n += 2;
        }
        if (this.isUnderline) {
            n += 8;
        }
        if (this.isItalic) {
            n += 4;
        }
        if (this.isStrikethrough) {
            n += 16;
        }
        FontType fontType = new FontType(stringBuilder.toString(), this.name, this.size, n, null);
        if (this.isOnPreferencePage) {
            UIFontManager.getInstance().addFont(fontType);
        } else {
            ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
            VariableType variableType = screenProgram.createHandleVariable(fontType.getDefaultHandleName(), 26);
            fontType.setHandle(variableType);
        }
        return fontType;
    }

    static /* synthetic */ String access$002(FontDialog fontDialog, String string) {
        fontDialog.name = string;
        return fontDialog.name;
    }

    static /* synthetic */ List access$100(FontDialog fontDialog) {
        return fontDialog.fontName;
    }

    static /* synthetic */ void access$200(FontDialog fontDialog) {
        fontDialog.updatePreview();
    }

    static /* synthetic */ Text access$300(FontDialog fontDialog) {
        return fontDialog.fontSizeTxt;
    }

    static /* synthetic */ float access$402(FontDialog fontDialog, float f) {
        fontDialog.size = f;
        return fontDialog.size;
    }

    static /* synthetic */ List access$500(FontDialog fontDialog) {
        return fontDialog.fontSize;
    }

    static /* synthetic */ boolean access$602(FontDialog fontDialog, boolean bl) {
        fontDialog.isBold = bl;
        return fontDialog.isBold;
    }

    static /* synthetic */ Button access$700(FontDialog fontDialog) {
        return fontDialog.bold;
    }

    static /* synthetic */ boolean access$802(FontDialog fontDialog, boolean bl) {
        fontDialog.isItalic = bl;
        return fontDialog.isItalic;
    }

    static /* synthetic */ Button access$900(FontDialog fontDialog) {
        return fontDialog.italic;
    }

    static /* synthetic */ boolean access$1002(FontDialog fontDialog, boolean bl) {
        fontDialog.isUnderline = bl;
        return fontDialog.isUnderline;
    }

    static /* synthetic */ Button access$1100(FontDialog fontDialog) {
        return fontDialog.underline;
    }

    static /* synthetic */ boolean access$1202(FontDialog fontDialog, boolean bl) {
        fontDialog.isStrikethrough = bl;
        return fontDialog.isStrikethrough;
    }

    static /* synthetic */ Button access$1300(FontDialog fontDialog) {
        return fontDialog.strikethrough;
    }
}

