/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.plugins.editor.util.TreeStructuredData;
import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.types.Choice;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.dialogs.GroupItemDesignerDialog;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ContainerModel;
import com.iscobol.screenpainter.propertysheet.CellEditor;
import com.iscobol.screenpainter.propertysheet.CellEditorValidators;
import com.iscobol.screenpainter.propertysheet.ColorEditor;
import com.iscobol.screenpainter.propertysheet.ComboEditor;
import com.iscobol.screenpainter.propertysheet.ParagraphEditor;
import com.iscobol.screenpainter.propertysheet.ProcedureEditor;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.PropertySheetTable;
import com.iscobol.screenpainter.propertysheet.TextEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import com.iscobol.screenpainter.propertysheet.VariableEditor;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * Exception performing whole class analysis ignored.
 */
public class GroupItemDesignerDialog
extends Dialog {
    private Tree tree;
    private SashForm splitPane;
    private Label statusBar;
    private ToolBar toolBar;
    private Tree propertySheet;
    private TreeEditor propertySheetEditor;
    private ToolItem addBtn;
    private ToolItem removeBtn;
    private ToolItem removeAllBtn;
    private ToolItem upBtn;
    private ToolItem downBtn;
    private ToolItem leftBtn;
    private ToolItem rightBtn;
    protected TreeItem currentItem;
    private ComponentsContainer container;
    private ContainerModel cntModel;
    private ScreenProgram screenProgram;
    private TreeStructuredData<ElementData> elementTree;

    public GroupItemDesignerDialog(Shell shell, ComponentsContainer componentsContainer, ContainerModel containerModel, ScreenProgram screenProgram) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.container = componentsContainer;
        this.cntModel = containerModel;
        this.screenProgram = screenProgram;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Group Item Designer");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 500;
        gridData.widthHint = 800;
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        composite3.setLayout((Layout)gridLayout);
        this.toolBar = new ToolBar(composite3, 8519936);
        gridData = new GridData(768);
        this.toolBar.setLayoutData((Object)gridData);
        this.addBtn = new ToolItem(this.toolBar, 8);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.setImage(this.mygetImage("/add_item.gif"));
        this.addBtn.setToolTipText(ISPBundle.getString((String)"add_item_lbl"));
        this.removeBtn = new ToolItem(this.toolBar, 8);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.setImage(this.mygetImage("/remove_item.gif"));
        this.removeBtn.setToolTipText(ISPBundle.getString((String)"remove_item_lbl"));
        this.removeAllBtn = new ToolItem(this.toolBar, 8);
        this.removeAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllBtn.setImage(this.mygetImage("/removeall.gif"));
        this.removeAllBtn.setToolTipText(ISPBundle.getString((String)"remove_all_lbl"));
        this.leftBtn = new ToolItem(this.toolBar, 8);
        this.leftBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.leftBtn.setImage(this.mygetImage("/move_left.png"));
        this.leftBtn.setToolTipText(ISPBundle.getString((String)"move_left_lbl"));
        this.rightBtn = new ToolItem(this.toolBar, 8);
        this.rightBtn.setToolTipText(ISPBundle.getString((String)"move_right_lbl"));
        this.rightBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.rightBtn.setImage(this.mygetImage("/move_right.png"));
        this.upBtn = new ToolItem(this.toolBar, 8);
        this.upBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upBtn.setImage(this.mygetImage("/move_up.png"));
        this.upBtn.setToolTipText(ISPBundle.getString((String)"move_up_lbl"));
        this.downBtn = new ToolItem(this.toolBar, 8);
        this.downBtn.setToolTipText(ISPBundle.getString((String)"move_down_lbl"));
        this.downBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downBtn.setImage(this.mygetImage("/move_down.png"));
        this.splitPane = new SashForm(composite3, 65792);
        this.splitPane.SASH_WIDTH = 5;
        gridData = new GridData(1808);
        this.splitPane.setLayoutData((Object)gridData);
        this.tree = new Tree((Composite)this.splitPane, 2050);
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.propertySheet = new Tree((Composite)this.splitPane, 67588);
        this.propertySheet.setLinesVisible(true);
        this.propertySheet.setHeaderVisible(true);
        TreeColumn treeColumn = new TreeColumn(this.propertySheet, 0);
        treeColumn.setWidth(150);
        treeColumn.setText("Property");
        treeColumn = new TreeColumn(this.propertySheet, 0);
        treeColumn.setWidth(150);
        treeColumn.setText("Value");
        this.propertySheetEditor = new TreeEditor(this.propertySheet);
        this.propertySheetEditor.grabHorizontal = true;
        this.propertySheet.addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.splitPane.setWeights(new int[]{50, 50});
        this.statusBar = new Label(composite3, 0);
        gridData = new GridData(768);
        this.statusBar.setLayoutData((Object)gridData);
        this.statusBar.setForeground(IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(new RGB(255, 0, 0)));
        this.tree.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    protected void handlePropertySheetSelectionEvent() {
        GroupBeanControl groupBeanControl;
        ElementData elementData;
        ScreenElement screenElement;
        PropertyDescriptor propertyDescriptor;
        if (this.tree.getSelectionCount() == 0) {
            return;
        }
        TreeItem treeItem = this.propertySheet.getSelection()[0];
        TextEditor textEditor = null;
        TreeStructuredData treeStructuredData = (TreeStructuredData)this.currentItem.getData();
        String string = (String)treeItem.getData();
        if (string == null) {
            string = treeItem.getText(0);
        }
        Class clazz = (propertyDescriptor = PropertyDescriptorRegistry.getJPropertyDescriptor((screenElement = (elementData = (ElementData)treeStructuredData.getData()).getTarget()).getClass(), (String)string)) != null ? propertyDescriptor.getPropertyType() : Object.class;
        Object object = ElementData.access$700((ElementData)elementData, clazz, (String)string);
        if (string.equals("screen-level") && this.currentItem.getParentItem() != null) {
            textEditor = new TextEditor();
            treeItem.setText(1, textEditor.valueToString(object));
            textEditor.setValidator((ICellEditorValidator)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            switch (ElementData.access$900((ElementData)elementData)) {
                case 2: 
                case 3: {
                    if (!ColorType.class.isAssignableFrom(clazz)) break;
                    textEditor = new ColorEditor(false, IscobolBeanConstants.isPartOfColorProperty((String)string), screenElement.getClass(), this.screenProgram.getScreenPalette());
                    treeItem.setText(1, textEditor.valueToString(object));
                    break;
                }
                case 5: {
                    groupBeanControl = (GroupBeanControl)screenElement;
                    if (clazz == Boolean.TYPE) {
                        textEditor = new ComboEditor();
                        ((ComboEditor)textEditor).setItems(new String[]{"false", "true"});
                        int n = (Integer)object;
                        treeItem.setText(1, n == 1 ? "true" : "false");
                        break;
                    }
                    if (Choice.class.isAssignableFrom(clazz)) {
                        Choice choice = null;
                        try {
                            choice = (Choice)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        textEditor = new ComboEditor();
                        ((ComboEditor)textEditor).setItems(choice.getNames());
                        int n = (Integer)object;
                        choice.setSelection(n);
                        treeItem.setText(1, choice.toString());
                        break;
                    }
                    if (clazz == Integer.TYPE) {
                        textEditor = new TextEditor(true);
                        treeItem.setText(1, textEditor.valueToString(object));
                        if (IscobolBeanConstants.isPositiveNumericProperty((String)string)) {
                            textEditor.setValidator(CellEditorValidators.positiveValidator);
                            break;
                        }
                        if (IscobolBeanConstants.isNotNegativeNumericProperty((String)string)) {
                            textEditor.setValidator(CellEditorValidators.notNegativeValidator);
                            break;
                        }
                        textEditor.setValidator(CellEditorValidators.numericValidator);
                        break;
                    }
                    if (clazz == Float.TYPE) {
                        textEditor = new TextEditor(true);
                        treeItem.setText(1, textEditor.valueToString(object));
                        if (IscobolBeanConstants.isPositiveNumericProperty((String)string)) {
                            textEditor.setValidator(CellEditorValidators.positiveValidator);
                            break;
                        }
                        if (IscobolBeanConstants.isNotNegativeNumericProperty((String)string)) {
                            textEditor.setValidator(CellEditorValidators.notNegativeValidator);
                            break;
                        }
                        textEditor.setValidator(CellEditorValidators.numericValidator);
                        break;
                    }
                    if (ColorType.class.isAssignableFrom(clazz)) {
                        textEditor = new ColorEditor(false, IscobolBeanConstants.isPartOfColorProperty((String)string), screenElement.getClass(), this.screenProgram.getScreenPalette());
                        treeItem.setText(1, textEditor.valueToString(object));
                        break;
                    }
                    if (IscobolBeanConstants.isVariableProperty((String)string) || IscobolBeanConstants.isHandleProperty((String)string)) {
                        int n = PropertyDescriptorRegistry.getVarType(screenElement.getClass(), (String)string);
                        textEditor = new VariableEditor(n, -1, string, PropertySheetTable.getPictureProp((String)string, (Object)groupBeanControl), (AbstractBeanControl)groupBeanControl);
                        treeItem.setText(1, textEditor.valueToString(object));
                        break;
                    }
                    if (IscobolBeanConstants.isParagraphProperty((String)string)) {
                        textEditor = new ParagraphEditor(string, null, (AbstractBeanControl)groupBeanControl);
                        treeItem.setText(1, textEditor.valueToString(object));
                        if (object == null) break;
                        String string2 = object.toString();
                        object = this.screenProgram.getResourceRegistry().getParagraph(string2);
                        if (object != null) break;
                        object = new ParagraphType(string2);
                        break;
                    }
                    if ("Exception procedure".equals(string) || "Event procedure".equals(string)) {
                        textEditor = new ProcedureEditor((AbstractBeanControl)groupBeanControl);
                        treeItem.setText(1, textEditor.valueToString(object));
                        break;
                    }
                    textEditor = new TextEditor();
                    treeItem.setText(1, textEditor.valueToString(object));
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    AbstractBeanControl abstractBeanControl = (AbstractBeanControl)screenElement;
                    if (string.equals("line")) {
                        textEditor = new TextEditor();
                        treeItem.setText(1, textEditor.valueToString((Object)abstractBeanControl.getLine()));
                        textEditor.setValidator(PropertyDescriptorRegistry.coordinateValidator);
                        break;
                    }
                    if (string.equals("column")) {
                        textEditor = new TextEditor();
                        treeItem.setText(1, textEditor.valueToString((Object)abstractBeanControl.getColumn()));
                        textEditor.setValidator(PropertyDescriptorRegistry.coordinateValidator);
                        break;
                    }
                    if (string.equals("screen-occurs")) {
                        textEditor = new TextEditor(true);
                        treeItem.setText(1, textEditor.valueToString((Object)Integer.toString(abstractBeanControl.getOccurs())));
                        textEditor.setValidator(PropertyDescriptorRegistry.notNegativeValidator);
                        break;
                    }
                    if (ColorType.class.isAssignableFrom(clazz)) {
                        textEditor = new ColorEditor(false, IscobolBeanConstants.isPartOfColorProperty((String)string), screenElement.getClass(), this.screenProgram.getScreenPalette());
                        treeItem.setText(1, textEditor.valueToString(object));
                        break;
                    }
                    textEditor = new TextEditor();
                    textEditor.setEditable(false);
                    treeItem.setText(1, textEditor.valueToString(object));
                }
            }
        }
        if (textEditor != null) {
            textEditor.createEditor((Composite)this.propertySheet);
            groupBeanControl = textEditor;
            Object object2 = object;
            textEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
            this.propertySheetEditor.setEditor(textEditor.getEditor(), treeItem, 1);
            textEditor.setValue(object);
            textEditor.selectAll();
            textEditor.setFocus();
        }
    }

    private boolean validateLevel(int n) {
        TreeStructuredData treeStructuredData = (TreeStructuredData)this.currentItem.getData();
        ElementData elementData = (ElementData)treeStructuredData.getData();
        switch (ElementData.access$900((ElementData)elementData)) {
            default: {
                return false;
            }
            case 1: 
            case 5: 
        }
        int n2 = elementData.getLevel();
        if (n == n2) {
            return true;
        }
        if (n > n2) {
            // empty if block
        }
        return true;
    }

    private boolean equals(String string, String string2) {
        if (string != null) {
            if (string2 != null) {
                return string.equalsIgnoreCase(string2);
            }
            return false;
        }
        return string2 == null;
    }

    private TreeItem[] getItemsAbove(TreeItem treeItem) {
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        TreeItem treeItem2 = this.getPrevious(treeItem);
        if (treeItem2 != null) {
            while (treeItem2.getParentItem() != null) {
                arrayList.add(treeItem2);
                treeItem2 = treeItem2.getParentItem();
            }
        }
        return arrayList.toArray(new TreeItem[arrayList.size()]);
    }

    private ArrayList<TreeItem>[] getItemsBelow(TreeItem treeItem) {
        ArrayList arrayList = new ArrayList();
        TreeItem treeItem2 = treeItem;
        TreeItem treeItem3 = treeItem2.getParentItem();
        while (treeItem3 != null) {
            int n = treeItem3.indexOf(treeItem2);
            ArrayList<TreeItem> arrayList2 = new ArrayList<TreeItem>();
            TreeItem[] treeItemArray = treeItem3.getItems();
            for (int i = n + 1; i < treeItemArray.length; ++i) {
                arrayList2.add(treeItemArray[i]);
            }
            arrayList.add(0, arrayList2);
            treeItem2 = treeItem3;
            treeItem3 = treeItem2.getParentItem();
        }
        return arrayList.toArray(new ArrayList[arrayList.size()]);
    }

    private int changeLevel(TreeStructuredData<ElementData> treeStructuredData, TreeItem treeItem, int n, int n2) {
        TreeStructuredData treeStructuredData2;
        TreeStructuredData treeStructuredData3;
        TreeItem treeItem2;
        TreeItem treeItem3;
        if (n < n2) {
            TreeItem treeItem4;
            int n3;
            TreeItem treeItem5;
            treeItem3 = (TreeItem)this.tree.getItem(0).getData();
            n = Math.max(n, ((ElementData)treeItem3.getData()).getLevel() + 1);
            treeItem2 = this.currentItem.getParentItem();
            treeStructuredData3 = (TreeStructuredData)treeItem2.getData();
            int n4 = treeItem2.indexOf(this.currentItem);
            while (treeItem2.getParentItem() != null && ((ElementData)treeStructuredData3.getData()).getLevel() >= n) {
                treeItem5 = treeItem2;
                treeItem2 = treeItem5.getParentItem();
                treeStructuredData3 = (TreeStructuredData)treeItem2.getData();
                n4 = treeItem2.indexOf(treeItem5);
            }
            treeItem5 = new ArrayList();
            ArrayList[] arrayListArray = this.getItemsBelow(this.currentItem);
            for (n3 = 0; n3 < arrayListArray.length; ++n3) {
                for (int i = 0; i < arrayListArray[n3].size(); ++i) {
                    treeItem4 = (TreeItem)arrayListArray[n3].get(i);
                    treeStructuredData2 = (TreeStructuredData)treeItem4.getData();
                    if (((ElementData)treeStructuredData2.getData()).getLevel() <= n) continue;
                    treeItem5.add(treeItem4);
                }
                if (treeItem5.size() > 0) break;
            }
            if (treeItem2 != this.currentItem.getParentItem()) {
                treeStructuredData.getParentItem().removeItem(treeStructuredData);
                this.currentItem.dispose();
                treeStructuredData3.addItem(n4 + 1, treeStructuredData);
                this.currentItem = new TreeItem(treeItem2, 0, n4 + 1);
                this.currentItem.setData(treeStructuredData);
                this.currentItem.setText(this.toString((ElementData)treeStructuredData.getData()));
                this.currentItem.setImage(this.mygetImage(IscobolBeanConstants.getImageName((int)((ElementData)treeStructuredData.getData()).getTarget().getType())));
                if (treeStructuredData.getItemCount() > 0) {
                    this.addItems(this.currentItem, treeStructuredData, treeStructuredData.getItems(), 0, -1, true);
                }
                this.refresh(treeItem2, true);
            }
            for (n3 = 0; n3 < treeItem5.size(); ++n3) {
                TreeItem treeItem6 = (TreeItem)treeItem5.get(n3);
                treeItem4 = (TreeStructuredData)treeItem6.getData();
                treeItem4.getParentItem().removeItem((TreeStructuredData)treeItem4);
                treeItem6.dispose();
                treeStructuredData.addItem((TreeStructuredData)treeItem4);
                treeItem6 = new TreeItem(this.currentItem, 0);
                treeItem6.setData((Object)treeItem4);
                treeItem6.setText(this.toString((ElementData)treeItem4.getData()));
                treeItem6.setImage(this.mygetImage(IscobolBeanConstants.getImageName((int)((ElementData)treeItem4.getData()).getTarget().getType())));
                if (treeItem4.getItemCount() > 0) {
                    this.addItems(treeItem6, (TreeStructuredData)treeItem4, treeItem4.getItems(), 0, -1, true);
                }
                this.refresh(this.currentItem, true);
            }
        } else if (n > n2) {
            int n5;
            TreeItem[] treeItemArray;
            treeItem3 = this.getItemsAbove(this.currentItem);
            treeItem2 = null;
            for (int i = 0; i < ((TreeItem[])treeItem3).length && treeItem2 == null; ++i) {
                treeItemArray = (TreeItem[])treeItem3[i].getData();
                if (((ElementData)treeItemArray.getData()).getLevel() >= n) continue;
                treeItem2 = treeItem3[i];
            }
            treeStructuredData3 = new ArrayList();
            treeItemArray = this.currentItem.getItems();
            for (n5 = 0; n5 < treeItemArray.length; ++n5) {
                TreeStructuredData treeStructuredData4 = (TreeStructuredData)treeItemArray[n5].getData();
                if (((ElementData)treeStructuredData4.getData()).getLevel() > n) continue;
                treeStructuredData3.add(treeItemArray[n5]);
            }
            n5 = -1;
            for (int i = 0; i < treeStructuredData3.size(); ++i) {
                TreeItem treeItem7 = (TreeItem)treeStructuredData3.get(i);
                TreeStructuredData treeStructuredData5 = (TreeStructuredData)treeItem7.getData();
                int n6 = ((ElementData)treeStructuredData5.getData()).getLevel();
                treeStructuredData2 = null;
                for (int j = 0; j < ((TreeItem)treeItem3).length && treeStructuredData2 == null; ++j) {
                    TreeStructuredData treeStructuredData6 = (TreeStructuredData)treeItem3[j].getData();
                    if (((ElementData)treeStructuredData6.getData()).getLevel() >= n6) continue;
                    treeStructuredData2 = treeItem3[j];
                }
                if (treeStructuredData2 == null) continue;
                if (treeItem2 == treeStructuredData2 && n5 == -1) {
                    n5 = treeStructuredData2.getItemCount();
                }
                treeStructuredData5.getParentItem().removeItem(treeStructuredData5);
                treeItem7.dispose();
                TreeStructuredData treeStructuredData7 = (TreeStructuredData)treeStructuredData2.getData();
                treeStructuredData7.addItem(treeStructuredData5);
                treeItem7 = new TreeItem((TreeItem)treeStructuredData2, 0);
                treeItem7.setData((Object)treeStructuredData5);
                treeItem7.setText(this.toString((ElementData)treeStructuredData5.getData()));
                treeItem7.setImage(this.mygetImage(IscobolBeanConstants.getImageName((int)((ElementData)treeStructuredData5.getData()).getTarget().getType())));
                if (treeStructuredData5.getItemCount() > 0) {
                    this.addItems(treeItem7, treeStructuredData5, treeStructuredData5.getItems(), 0, -1, true);
                }
                this.refresh((TreeItem)treeStructuredData2, true);
            }
            if (treeItem2 != null && treeItem2 != this.currentItem.getParentItem()) {
                treeStructuredData.getParentItem().removeItem(treeStructuredData);
                this.currentItem.dispose();
                TreeStructuredData treeStructuredData8 = (TreeStructuredData)treeItem2.getData();
                treeStructuredData8.addItem(n5, treeStructuredData);
                this.currentItem = n5 >= 0 ? new TreeItem(treeItem2, 0, n5) : new TreeItem(treeItem2, 0);
                this.currentItem.setData(treeStructuredData);
                this.currentItem.setText(this.toString((ElementData)treeStructuredData.getData()));
                this.currentItem.setImage(this.mygetImage(IscobolBeanConstants.getImageName((int)((ElementData)treeStructuredData.getData()).getTarget().getType())));
                if (treeStructuredData.getItemCount() > 0) {
                    this.addItems(this.currentItem, treeStructuredData, treeStructuredData.getItems(), 0, -1, true);
                }
                this.refresh(treeItem2, true);
            }
        }
        for (treeItem3 = this.currentItem.getParentItem(); treeItem3 != null; treeItem3 = treeItem3.getParentItem()) {
            treeItem3.setExpanded(true);
        }
        this.expandAll(this.currentItem);
        this.tree.select(this.currentItem);
        this.updateButtonsEnabledState(new TreeItem[]{this.currentItem});
        return n;
    }

    protected final void refresh(TreeItem treeItem, boolean bl) {
        TreeStructuredData treeStructuredData;
        if (!treeItem.isDisposed() && (treeStructuredData = (TreeStructuredData)treeItem.getData()) != null) {
            treeItem.setText(this.toString((ElementData)treeStructuredData.getData()));
            treeItem.setImage(this.mygetImage(IscobolBeanConstants.getImageName((int)((ElementData)treeStructuredData.getData()).getTarget().getType())));
        }
        if (bl) {
            TreeItem[] treeItemArray = treeItem.getItems();
            for (int i = 0; i < treeItemArray.length; ++i) {
                this.refresh(treeItemArray[i], bl);
            }
        }
    }

    private Object cellEditorValueChanged(TreeStructuredData<ElementData> treeStructuredData, CellEditor cellEditor, PropertyDescriptor propertyDescriptor, TreeItem treeItem, Object object, Object object2) {
        ElementData elementData = (ElementData)treeStructuredData.getData();
        if (cellEditor.isValueValid()) {
            if (!treeItem.isDisposed()) {
                treeItem.setText(1, cellEditor.valueToString(object));
            }
            if (cellEditor instanceof VariableEditor) {
                VariableType variableType = null;
                variableType = object instanceof VariableName ? ((VariableName)object).getVariable() : (VariableType)object;
                ElementData.access$1100((ElementData)elementData, (String)propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), (Object)variableType);
                this.containerValueChanged(elementData, propertyDescriptor.getName(), object, object2);
            } else if (cellEditor instanceof ParagraphEditor) {
                ParagraphType paragraphType = (ParagraphType)object;
                ElementData.access$1100((ElementData)elementData, (String)propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), (Object)paragraphType);
                this.containerParagraphValueChanged((GroupBeanControl)elementData.getTarget(), propertyDescriptor.getName(), paragraphType, ((ParagraphEditor)cellEditor).shouldOpenEventEditor());
            } else if (propertyDescriptor.getName().equals("screen-level")) {
                object = new Integer(this.changeLevel(treeStructuredData, treeItem, Integer.parseInt(object.toString()), Integer.parseInt(object2.toString())));
                ElementData.access$1100((ElementData)elementData, (String)propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), (Object)object);
                this.containerValueChanged(elementData, propertyDescriptor.getName(), object, object2);
            } else {
                ElementData.access$1100((ElementData)elementData, (String)propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), (Object)object);
                this.containerValueChanged(elementData, propertyDescriptor.getName(), object, object2);
            }
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(cellEditor.getErrorMessage());
        }
        return object;
    }

    public void setErrorMessage(String string) {
        if (!this.statusBar.isDisposed()) {
            this.statusBar.setText(string != null ? string : "");
        }
    }

    private void containerParagraphValueChanged(GroupBeanControl groupBeanControl, String string, ParagraphType paragraphType, boolean bl) {
        if (paragraphType != null && bl) {
            this.okPressed();
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
            screenProgramEditor.activateEventParagraphsEditor();
            eventParagraphsEditor.setFocus();
            eventParagraphsEditor.addAndSelectParagraph(this.screenProgram.getEventParagraphs(), paragraphType.getName(), paragraphType.isUserParagraph());
        }
    }

    private void containerValueChanged(ElementData elementData, String string, Object object, Object object2) {
        if (this.currentItem != null && !this.currentItem.isDisposed()) {
            this.currentItem.setText(this.toString(elementData));
        }
    }

    private String toString(ElementData elementData) {
        String string = "";
        int n = elementData.getLevel();
        if (n < 10) {
            string = string + "0";
        }
        string = string + n;
        string = string + " " + elementData.getTarget().getName() + " (" + IscobolBeanConstants.getTypeName((int)elementData.getTarget().getType()) + ")";
        return string;
    }

    private void addItems(TreeItem treeItem, TreeStructuredData<ElementData> treeStructuredData, ComponentsContainer componentsContainer) {
        AbstractBeanControl[] abstractBeanControlArray = componentsContainer.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            ElementData elementData = abstractBeanControlArray[i] instanceof GroupBeanControl ? new ElementData(this, (GroupBeanControl)abstractBeanControlArray[i]) : new ElementData(this, abstractBeanControlArray[i]);
            TreeStructuredData treeStructuredData2 = new TreeStructuredData((Object)elementData);
            treeStructuredData.addItem(treeStructuredData2);
            treeItem2.setData((Object)treeStructuredData2);
            String string = this.toString(elementData);
            treeItem2.setText(string);
            String string2 = IscobolBeanConstants.getImageName((int)abstractBeanControlArray[i].getType());
            if (string2 != null) {
                treeItem2.setImage(this.mygetImage(string2));
            }
            if (!(abstractBeanControlArray[i] instanceof GroupBeanControl)) continue;
            this.addItems(treeItem2, treeStructuredData2, (ComponentsContainer)((GroupBeanControl)abstractBeanControlArray[i]));
        }
    }

    private TreeItem[] addItems(TreeItem treeItem, TreeStructuredData<ElementData> treeStructuredData, TreeStructuredData<ElementData>[] treeStructuredDataArray, int n, int n2) {
        return this.addItems(treeItem, treeStructuredData, treeStructuredDataArray, n, n2, true);
    }

    private TreeItem[] addItems(TreeItem treeItem, TreeStructuredData<ElementData> treeStructuredData, TreeStructuredData<ElementData>[] treeStructuredDataArray, int n, int n2, boolean bl) {
        TreeItem[] treeItemArray = new TreeItem[treeStructuredDataArray.length];
        for (int i = 0; i < treeStructuredDataArray.length; ++i) {
            TreeItem treeItem2 = treeItem != null ? (n2 >= 0 ? new TreeItem(treeItem, 0, i + n2) : new TreeItem(treeItem, 0)) : (n2 >= 0 ? new TreeItem(this.tree, 0, i + n2) : new TreeItem(this.tree, 0));
            treeItemArray[i] = treeItem2;
            int n3 = ((ElementData)treeStructuredDataArray[i].getData()).getLevel();
            ((ElementData)treeStructuredDataArray[i].getData()).setLevel(n3 + n);
            this.setItemData(treeItem2, treeStructuredDataArray[i]);
            if (bl) {
                if (treeStructuredData != null) {
                    if (n2 >= 0) {
                        treeStructuredData.addItem(i + n2, treeStructuredDataArray[i]);
                    } else {
                        treeStructuredData.addItem(treeStructuredDataArray[i]);
                    }
                } else if (n2 >= 0) {
                    this.elementTree.addItem(i + n2, treeStructuredDataArray[i]);
                } else {
                    this.elementTree.addItem(treeStructuredDataArray[i]);
                }
            }
            this.addItems(treeItem2, null, treeStructuredDataArray[i].getItems(), n, -1, false);
        }
        return treeItemArray;
    }

    private TreeItem addContainerItem() {
        String string;
        String string2;
        ElementData elementData;
        TreeItem treeItem = new TreeItem(this.tree, 0);
        if (this.container instanceof AbstractBeanWindow) {
            AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.container;
            elementData = new ElementData(this, abstractBeanWindow);
            string2 = this.toString(elementData);
            string = IscobolBeanConstants.getImageName((int)abstractBeanWindow.getType());
        } else if (this.container instanceof AbstractBeanToolbar) {
            AbstractBeanToolbar abstractBeanToolbar = (AbstractBeanToolbar)this.container;
            elementData = new ElementData(this, abstractBeanToolbar);
            string2 = this.toString(elementData);
            string = IscobolBeanConstants.getImageName((int)abstractBeanToolbar.getType());
        } else {
            ScreenElement screenElement = (ScreenElement)this.container;
            elementData = new ElementData(this, this.container);
            string2 = this.toString(elementData);
            string = IscobolBeanConstants.getImageName((int)screenElement.getType());
        }
        treeItem.setText(string2);
        if (string != null) {
            treeItem.setImage(this.mygetImage(string));
        }
        this.elementTree = new TreeStructuredData((Object)elementData);
        treeItem.setData((Object)this.elementTree);
        return treeItem;
    }

    public void okPressed() {
        TreeItem treeItem = this.check(this.tree.getItem(0));
        if (treeItem != null) {
            this.setErrorMessage("Illegal Level Number: " + treeItem.getText());
            this.tree.setSelection(treeItem);
            this.updateButtonsEnabledState(new TreeItem[]{treeItem});
        } else {
            super.okPressed();
        }
    }

    private TreeItem check(TreeItem treeItem) {
        TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
        ElementData elementData = (ElementData)treeStructuredData.getData();
        if (ElementData.access$900((ElementData)elementData) == 1 && treeStructuredData.getItemCount() > 0) {
            return treeItem;
        }
        for (int i = 0; i < treeStructuredData.getItemCount(); ++i) {
            TreeItem treeItem2 = this.check(treeItem.getItem(i));
            if (treeItem2 == null) continue;
            return treeItem2;
        }
        return null;
    }

    public boolean openDialog() {
        if (this.open() == 0) {
            this.updateProperties((ElementData)this.elementTree.getData());
            ComponentModel[] componentModelArray = new ComponentModel[this.cntModel.getComponentCount()];
            this.cntModel.getComponents(componentModelArray);
            this.updateChildren(this.elementTree.getItems(), this.container, new int[1]);
            this.cntModel.updateStructure();
            return true;
        }
        return false;
    }

    private void updateChildren(TreeStructuredData<ElementData>[] treeStructuredDataArray, ComponentsContainer componentsContainer, int[] nArray) {
        componentsContainer.removeAllComponents();
        for (int i = 0; i < treeStructuredDataArray.length; ++i) {
            GroupBeanControl groupBeanControl;
            ElementData elementData = (ElementData)treeStructuredDataArray[i].getData();
            this.updateProperties(elementData);
            ScreenElement screenElement = elementData.getTarget();
            if (screenElement instanceof GroupBeanControl) {
                groupBeanControl = (GroupBeanControl)screenElement;
                componentsContainer.addComponent((AbstractBeanControl)groupBeanControl);
                this.updateChildren(treeStructuredDataArray[i].getItems(), (ComponentsContainer)groupBeanControl, nArray);
                continue;
            }
            groupBeanControl = (AbstractBeanControl)screenElement;
            nArray[0] = nArray[0] + 1;
            groupBeanControl.setTabOrder(nArray[0], false);
            componentsContainer.addComponent((AbstractBeanControl)groupBeanControl);
        }
    }

    private void updateProperties(ElementData elementData) {
        ScreenElement screenElement = elementData.getTarget();
        for (String string : ElementData.access$1200((ElementData)elementData).keySet()) {
            Object object;
            Object object2;
            String string2;
            PropertyDescriptor propertyDescriptor = PropertyDescriptorRegistry.getJPropertyDescriptor(screenElement.getClass(), (String)string);
            Object object3 = ElementData.access$1200((ElementData)elementData).get(string);
            VariableType variableType = null;
            if (propertyDescriptor == null) continue;
            if (IscobolBeanConstants.isVariableProperty((String)string)) {
                string2 = null;
                object2 = (String)PropertyDescriptorRegistry.getProperty((Object)elementData.getTarget(), (String)string);
                if (object2 != null) {
                    string2 = this.screenProgram.getProgramVariable((String)object2);
                }
                String string3 = object3 = (object = (variableType = (VariableType)ElementData.access$700((ElementData)elementData, String.class, (String)string))) != null ? object.getQName() : null;
                if (string2 != object) {
                    if (string2 != null) {
                        this.screenProgram.getResourceRegistry().unregisterVariable((VariableType)string2, (Object)elementData.getTarget(), string);
                    }
                    if (object != null) {
                        this.screenProgram.getResourceRegistry().registerVariable(object, (Object)elementData.getTarget(), string);
                    }
                }
            } else if ("Event procedure".equals(propertyDescriptor.getName()) || "Exception procedure".equals(propertyDescriptor.getName())) {
                string2 = (String)PropertyDescriptorRegistry.getProperty((Object)elementData.getTarget(), (String)string);
                if (!this.equals(string2, (String)(object2 = (String)ElementData.access$700((ElementData)elementData, String.class, (String)string)))) {
                    if (string2 != null) {
                        this.screenProgram.unregisterProcedure(string2, (Object)elementData.getTarget());
                    }
                    if (object2 != null) {
                        this.screenProgram.registerProcedure((String)object2, (Object)elementData.getTarget());
                    }
                }
            } else if (IscobolBeanConstants.isParagraphProperty((String)string)) {
                string2 = (String)PropertyDescriptorRegistry.getProperty((Object)elementData.getTarget(), (String)string);
                object2 = (ParagraphType)ElementData.access$700((ElementData)elementData, String.class, (String)string);
                object = object2 != null ? object2.getName() : null;
                object3 = object;
                if (!this.equals(string2, (String)object)) {
                    if (string2 != null) {
                        this.screenProgram.getResourceRegistry().unregisterParagraph(string2, (Object)elementData.getTarget(), string);
                    }
                    if (object != null) {
                        this.screenProgram.getResourceRegistry().registerParagraph((String)object, (Object)elementData.getTarget(), string);
                    }
                }
            }
            if (propertyDescriptor.getWriteMethod() != null) {
                try {
                    propertyDescriptor.getWriteMethod().invoke((Object)screenElement, object3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (variableType != null) {
                PropertyDescriptorRegistry.changeVariableValue((Object)screenElement, (String)string, (VariableType)variableType, (boolean)this.screenProgram.getAddQuotesToString());
                continue;
            }
            string2 = string + " variable";
            object2 = PropertyDescriptorRegistry.getJPropertyDescriptor(screenElement.getClass(), (String)string2);
            if (object2 == null) continue;
            String string4 = null;
            try {
                string4 = (String)((PropertyDescriptor)object2).getReadMethod().invoke((Object)screenElement, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string4 == null || string4.length() <= 0 || (object = this.screenProgram.getProgramVariable(string4)) == null) continue;
            PropertyDescriptorRegistry.setVariableValue((VariableType)object, propertyDescriptor.getPropertyType(), object3, (boolean)this.screenProgram.getAddQuotesToString(), (String)string2);
        }
    }

    protected void expandAll() {
        TreeItem[] treeItemArray = this.tree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItemArray[i].setExpanded(true);
            this.expandAll(treeItemArray[i]);
        }
    }

    protected void expandAll(TreeItem treeItem) {
        TreeItem[] treeItemArray = treeItem.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            treeItem.setExpanded(true);
            this.expandAll(treeItemArray[i]);
        }
    }

    protected void addItem(TreeItem[] treeItemArray) {
        TreeItem treeItem;
        TreeStructuredData treeStructuredData;
        if (treeItemArray.length == 0) {
            return;
        }
        TreeItem treeItem2 = treeItemArray[0];
        TreeItem treeItem3 = treeItem2.getParentItem();
        TreeStructuredData treeStructuredData2 = (TreeStructuredData)treeItem2.getData();
        GroupBeanControl groupBeanControl = new GroupBeanControl();
        groupBeanControl.setName("filler");
        if (treeItem3 != null) {
            TreeStructuredData treeStructuredData3 = (TreeStructuredData)treeItem3.getData();
            int n = ((ElementData)treeStructuredData2.getData()).getLevel();
            ElementData elementData = new ElementData(this, groupBeanControl);
            elementData.setLevel(n);
            treeStructuredData = new TreeStructuredData((Object)elementData);
            int n2 = treeItem3.indexOf(treeItem2) + 1;
            treeItem = n2 < treeItem3.getItemCount() ? new TreeItem(treeItem3, 0, n2) : new TreeItem(treeItem3, 0);
            treeStructuredData3.addItem(n2, treeStructuredData);
        } else {
            int n = treeStructuredData2.getItemCount() > 0 ? ((ElementData)treeStructuredData2.getItem(treeStructuredData2.getItemCount() - 1).getData()).getLevel() : ((ElementData)treeStructuredData2.getData()).getLevel() + 2;
            ElementData elementData = new ElementData(this, groupBeanControl);
            elementData.setLevel(n);
            treeStructuredData = new TreeStructuredData((Object)elementData);
            treeItem = new TreeItem(treeItem2, 0);
            this.elementTree.addItem(treeStructuredData);
        }
        this.setItemData(treeItem, treeStructuredData);
    }

    private Image mygetImage(String string) {
        return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage(string);
    }

    protected void removeGroupItems(TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            this.removeGroupItems(treeItemArray[i].getItems());
            TreeStructuredData treeStructuredData = (TreeStructuredData)treeItemArray[i].getData();
            if (ElementData.access$900((ElementData)((ElementData)treeStructuredData.getData())) != 5) continue;
            this.removeItem(treeItemArray[i]);
        }
    }

    protected void removeItem(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        int n = treeItem2.indexOf(treeItem);
        TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
        TreeStructuredData treeStructuredData2 = treeStructuredData.getParentItem();
        TreeStructuredData[] treeStructuredDataArray = treeStructuredData.getItems();
        treeItem.dispose();
        treeStructuredData2.removeItem(treeStructuredData);
        this.addItems(treeItem2, treeStructuredData2, treeStructuredDataArray, -2, n);
    }

    protected void moveRight(TreeItem treeItem) {
        if (treeItem.isDisposed()) {
            return;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
        TreeStructuredData treeStructuredData2 = treeStructuredData.getParentItem();
        int n = treeItem2.indexOf(treeItem);
        TreeItem treeItem3 = treeItem2.getItem(n - 1);
        TreeStructuredData treeStructuredData3 = (TreeStructuredData)treeItem3.getData();
        treeItem.dispose();
        treeStructuredData2.removeItem(treeStructuredData);
        TreeItem[] treeItemArray = this.addItems(treeItem3, treeStructuredData3, new TreeStructuredData[]{treeStructuredData}, 2, -1);
        this.expandAll();
        this.tree.setSelection(treeItemArray[0]);
        this.updateButtonsEnabledState(treeItemArray);
        this.setErrorMessage(null);
    }

    protected void moveLeft(TreeItem treeItem) {
        int n;
        if (treeItem.isDisposed()) {
            return;
        }
        TreeItem treeItem2 = treeItem.getParentItem();
        TreeItem treeItem3 = treeItem2.getParentItem();
        TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
        TreeStructuredData treeStructuredData2 = treeStructuredData.getParentItem();
        TreeStructuredData treeStructuredData3 = treeStructuredData2.getParentItem();
        int n2 = treeItem2.indexOf(treeItem);
        TreeItem[] treeItemArray = new TreeItem[treeItem2.getItemCount() - n2 - 1];
        TreeStructuredData[] treeStructuredDataArray = new TreeStructuredData[treeItemArray.length];
        for (n = 0; n < treeItemArray.length; ++n) {
            treeItemArray[n] = treeItem2.getItem(n + n2 + 1);
            treeStructuredDataArray[n] = (TreeStructuredData)treeItemArray[n].getData();
        }
        for (n = 0; n < treeItemArray.length; ++n) {
            treeItemArray[n].dispose();
            treeStructuredData2.removeItem(treeStructuredDataArray[n]);
        }
        treeItem.dispose();
        treeStructuredData2.removeItem(treeStructuredData);
        if (treeItem3 != null) {
            n2 = treeItem3.indexOf(treeItem2);
            treeItem = this.addItems(treeItem3, treeStructuredData3, new TreeStructuredData[]{treeStructuredData}, -2, n2 + 1)[0];
        } else {
            n2 = this.tree.indexOf(treeItem2);
            treeItem = this.addItems(null, null, new TreeStructuredData[]{treeStructuredData}, -2, n2 + 1)[0];
        }
        this.addItems(treeItem, treeStructuredData, treeStructuredDataArray, 0, -1);
        this.expandAll();
        this.tree.setSelection(treeItem);
        this.updateButtonsEnabledState(new TreeItem[]{treeItem});
        this.setErrorMessage(null);
    }

    protected void moveDown(TreeItem treeItem) {
        if (treeItem.isDisposed()) {
            return;
        }
        TreeItem treeItem2 = this.getNext(treeItem);
        this.swap(treeItem, treeItem2);
        this.tree.setSelection(treeItem2);
        this.updateButtonsEnabledState(new TreeItem[]{treeItem2});
        this.setErrorMessage(null);
    }

    private void setItemData(TreeItem treeItem, TreeStructuredData<ElementData> treeStructuredData) {
        ElementData elementData = (ElementData)treeStructuredData.getData();
        treeItem.setText(this.toString(elementData));
        treeItem.setImage(this.mygetImage(IscobolBeanConstants.getImageName((int)elementData.getTarget().getType())));
        treeItem.setData(treeStructuredData);
    }

    private void swap(TreeItem treeItem, TreeItem treeItem2) {
        TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
        TreeStructuredData treeStructuredData2 = (TreeStructuredData)treeItem2.getData();
        ElementData elementData = (ElementData)treeStructuredData.getData();
        ElementData elementData2 = (ElementData)treeStructuredData2.getData();
        int n = elementData.getLevel();
        elementData.setLevel(elementData2.getLevel());
        elementData2.setLevel(n);
        treeStructuredData.setData((Object)elementData2);
        treeStructuredData2.setData((Object)elementData);
        this.setItemData(treeItem, treeStructuredData);
        this.setItemData(treeItem2, treeStructuredData2);
    }

    protected void moveUp(TreeItem treeItem) {
        if (treeItem.isDisposed()) {
            return;
        }
        TreeItem treeItem2 = this.getPrevious(treeItem);
        this.swap(treeItem, treeItem2);
        this.tree.setSelection(treeItem2);
        this.updateButtonsEnabledState(new TreeItem[]{treeItem2});
        this.setErrorMessage(null);
    }

    protected void treeSelectionChanged(TreeItem[] treeItemArray) {
        if (treeItemArray.length > 0) {
            this.currentItem = treeItemArray[0];
            this.loadPropertySheet();
        }
        this.updateButtonsEnabledState(treeItemArray);
        this.setErrorMessage(null);
    }

    private void updateButtonsEnabledState(TreeItem[] treeItemArray) {
        this.addBtn.setEnabled(treeItemArray.length == 1);
        this.removeBtn.setEnabled(treeItemArray.length >= 1 && this.canRemove(treeItemArray));
        this.upBtn.setEnabled(treeItemArray.length == 1 && this.canMoveUp(treeItemArray[0]));
        this.downBtn.setEnabled(treeItemArray.length == 1 && this.canMoveDown(treeItemArray[0]));
        this.rightBtn.setEnabled(treeItemArray.length >= 1 && this.canMoveRight(treeItemArray));
        this.leftBtn.setEnabled(treeItemArray.length >= 1 && this.canMoveLeft(treeItemArray));
    }

    protected boolean canRemove(TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (this.canRemove(treeItemArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean canRemove(TreeItem treeItem) {
        ElementData elementData = (ElementData)((TreeStructuredData)treeItem.getData()).getData();
        return elementData.getTarget() instanceof GroupBeanControl;
    }

    protected boolean canMoveUp(TreeItem treeItem) {
        TreeItem treeItem2 = this.getPrevious(treeItem);
        return treeItem2 != null && treeItem2.getParentItem() != null;
    }

    protected boolean canMoveDown(TreeItem treeItem) {
        if (treeItem.getParentItem() == null) {
            return false;
        }
        TreeItem treeItem2 = this.getNext(treeItem);
        return treeItem2 != null;
    }

    protected boolean canMoveRight(TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (this.canMoveRight(treeItemArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean canMoveRight(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        if (treeItem2 == null) {
            return false;
        }
        int n = treeItem2.indexOf(treeItem);
        return n != 0;
    }

    protected boolean canMoveLeft(TreeItem[] treeItemArray) {
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (this.canMoveLeft(treeItemArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean canMoveLeft(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        return treeItem2 != null && treeItem2.getParentItem() != null;
    }

    protected TreeItem getPrevious(TreeItem treeItem) {
        if (treeItem.getParentItem() != null) {
            int n = treeItem.getParentItem().indexOf(treeItem);
            if (n > 0) {
                return this.getLast(treeItem.getParentItem().getItem(n - 1));
            }
            return treeItem.getParentItem();
        }
        int n = this.tree.indexOf(treeItem);
        if (n > 0) {
            return this.getLast(this.tree.getItem(n - 1));
        }
        return null;
    }

    protected TreeItem getLast(TreeItem treeItem) {
        if (treeItem.getItemCount() == 0) {
            return treeItem;
        }
        return this.getLast(treeItem.getItem(treeItem.getItemCount() - 1));
    }

    protected TreeItem getNext(TreeItem treeItem) {
        return this.getNext(treeItem, false);
    }

    protected TreeItem getNext(TreeItem treeItem, boolean bl) {
        if (treeItem.getItemCount() > 0 && !bl) {
            return treeItem.getItem(0);
        }
        if (treeItem.getParentItem() != null) {
            int n = treeItem.getParentItem().indexOf(treeItem);
            if (n < treeItem.getParentItem().getItemCount() - 1) {
                return treeItem.getParentItem().getItem(n + 1);
            }
            return this.getNext(treeItem.getParentItem(), true);
        }
        int n = this.tree.indexOf(treeItem);
        if (n < this.tree.getItemCount() - 1) {
            return this.tree.getItem(n + 1);
        }
        return null;
    }

    private void loadPropertySheet() {
        this.propertySheet.removeAll();
        ElementData elementData = (ElementData)((TreeStructuredData)this.currentItem.getData()).getData();
        TreeItem treeItem = new TreeItem(this.propertySheet, 0);
        treeItem.setText(0, "screen-level");
        int n = elementData.getLevel();
        treeItem.setText(1, "" + n);
        switch (ElementData.access$900((ElementData)elementData)) {
            case 2: 
            case 3: {
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "color");
                Object object = ElementData.access$700((ElementData)elementData, ColorType.class, (String)"color");
                if (object != null) {
                    treeItem.setText(1, object.toString());
                }
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "background-color");
                object = ElementData.access$700((ElementData)elementData, ColorType.class, (String)"background-color");
                if (object != null) {
                    treeItem.setText(1, object.toString());
                }
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "foreground-color");
                object = ElementData.access$700((ElementData)elementData, ColorType.class, (String)"foreground-color");
                if (object == null) break;
                treeItem.setText(1, object.toString());
                break;
            }
            case 5: {
                PropertyDescriptor[] propertyDescriptorArray = PropertyDescriptorRegistry.getJPropertyDescriptors(GroupBeanControl.class);
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    int n2;
                    if (IscobolBeanConstants.isHiddenProperty((String)propertyDescriptorArray[i].getName())) continue;
                    treeItem = new TreeItem(this.propertySheet, 0);
                    treeItem.setText(0, propertyDescriptorArray[i].getDisplayName());
                    treeItem.setData((Object)propertyDescriptorArray[i].getName());
                    Object object = ElementData.access$700((ElementData)elementData, propertyDescriptorArray[i].getPropertyType(), (String)propertyDescriptorArray[i].getName());
                    if (propertyDescriptorArray[i].getPropertyType() == Boolean.TYPE) {
                        n2 = (Integer)object;
                        treeItem.setText(1, n2 == 1 ? "true" : "false");
                        continue;
                    }
                    if (Choice.class.isAssignableFrom(propertyDescriptorArray[i].getPropertyType())) {
                        n2 = (Integer)object;
                        try {
                            Choice choice = (Choice)propertyDescriptorArray[i].getPropertyType().newInstance();
                            choice.setSelection(n2);
                            treeItem.setText(1, choice.toString());
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    treeItem.setText(1, object != null ? object.toString() : "");
                }
                break;
            }
            case 4: {
                break;
            }
            default: {
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "column");
                Object object = ElementData.access$700((ElementData)elementData, String.class, (String)"column");
                treeItem.setText(1, object.toString());
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "color");
                object = ElementData.access$700((ElementData)elementData, ColorType.class, (String)"color");
                if (object != null) {
                    treeItem.setText(1, object.toString());
                }
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "background-color");
                object = ElementData.access$700((ElementData)elementData, ColorType.class, (String)"background-color");
                if (object != null) {
                    treeItem.setText(1, object.toString());
                }
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "foreground-color");
                object = ElementData.access$700((ElementData)elementData, ColorType.class, (String)"foreground-color");
                if (object != null) {
                    treeItem.setText(1, object.toString());
                }
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "line");
                object = ElementData.access$700((ElementData)elementData, String.class, (String)"line");
                treeItem.setText(1, object.toString());
                treeItem = new TreeItem(this.propertySheet, 0);
                treeItem.setText(0, "occurs");
                object = ElementData.access$700((ElementData)elementData, Integer.TYPE, (String)"screen-occurs");
                treeItem.setText(1, object.toString());
                treeItem.setData((Object)"screen-occurs");
            }
        }
    }

    static /* synthetic */ ScreenProgram access$000(GroupItemDesignerDialog groupItemDesignerDialog) {
        return groupItemDesignerDialog.screenProgram;
    }

    static /* synthetic */ Tree access$100(GroupItemDesignerDialog groupItemDesignerDialog) {
        return groupItemDesignerDialog.tree;
    }

    static /* synthetic */ TreeItem access$200(GroupItemDesignerDialog groupItemDesignerDialog) {
        return groupItemDesignerDialog.addContainerItem();
    }

    static /* synthetic */ TreeStructuredData access$300(GroupItemDesignerDialog groupItemDesignerDialog) {
        return groupItemDesignerDialog.elementTree;
    }

    static /* synthetic */ ComponentsContainer access$400(GroupItemDesignerDialog groupItemDesignerDialog) {
        return groupItemDesignerDialog.container;
    }

    static /* synthetic */ void access$500(GroupItemDesignerDialog groupItemDesignerDialog, TreeItem treeItem, TreeStructuredData treeStructuredData, ComponentsContainer componentsContainer) {
        groupItemDesignerDialog.addItems(treeItem, treeStructuredData, componentsContainer);
    }

    static /* synthetic */ void access$600(GroupItemDesignerDialog groupItemDesignerDialog, TreeItem[] treeItemArray) {
        groupItemDesignerDialog.updateButtonsEnabledState(treeItemArray);
    }

    static /* synthetic */ boolean access$800(GroupItemDesignerDialog groupItemDesignerDialog, int n) {
        return groupItemDesignerDialog.validateLevel(n);
    }

    static /* synthetic */ Object access$1000(GroupItemDesignerDialog groupItemDesignerDialog, TreeStructuredData treeStructuredData, CellEditor cellEditor, PropertyDescriptor propertyDescriptor, TreeItem treeItem, Object object, Object object2) {
        return groupItemDesignerDialog.cellEditorValueChanged(treeStructuredData, cellEditor, propertyDescriptor, treeItem, object, object2);
    }
}

