/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HeadingMenuPopupDialog
extends Dialog {
    private List<Button> buttons = new ArrayList();
    private int value;
    private String valueStr;

    public HeadingMenuPopupDialog(Shell shell, String string) {
        super(shell);
        try {
            this.value = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Heading Menu Popup");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.createGroup(composite2, "Column Items", new String[]{"Shown by right clicking on the heading", "Shown through the button on the top right corner of the grid"}, new int[]{1, 2});
        this.createGroup(composite2, "Export Item", new String[]{"Shown by right clicking on the heading", "Shown through the button on the top right corner of the grid"}, new int[]{4, 8});
        this.createGroup(composite2, "Copy Item", new String[]{"Shown by right clicking on the heading", "Shown through the button on the top right corner of the grid"}, new int[]{16, 32});
        this.createGroup(composite2, "Find Item", new String[]{"Shown by right clicking on the heading", "Shown through the button on the top right corner of the grid"}, new int[]{64, 128});
        return composite2;
    }

    private void createGroup(Composite composite, String string, String[] stringArray, int[] nArray) {
        Group group = new Group(composite, 0);
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        for (int i = 0; i < stringArray.length; ++i) {
            Button button = new Button((Composite)group, 32);
            button.setText(stringArray[i]);
            button.setData((Object)new Integer(nArray[i]));
            button.setSelection((this.value & nArray[i]) == nArray[i]);
            this.buttons.add(button);
        }
    }

    public void okPressed() {
        int n = 0;
        for (Button button : this.buttons) {
            if (!button.getSelection()) continue;
            n += ((Integer)button.getData()).intValue();
        }
        this.valueStr = Integer.toString(n);
        super.okPressed();
    }

    public String openDialog() {
        super.open();
        return this.valueStr;
    }
}

