/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.LayoutManager;
import com.iscobol.screenpainter.beans.types.VariableName;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.VariableFieldEditor;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LayoutManagerDialog
extends Dialog {
    private Combo typeCmb;
    private Label confLbl;
    private Text confTxt;
    private LayoutManager value;
    private LayoutManager Return;
    private boolean showWrapType;
    private VariableFieldEditor handleEd;

    public LayoutManagerDialog(Shell shell, LayoutManager layoutManager, boolean bl) {
        super(shell);
        this.value = layoutManager;
        this.showWrapType = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Layout Manager settings");
    }

    protected Control createDialogArea(Composite composite) {
        VariableType variableType;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Type: ");
        this.typeCmb = new Combo(composite2, 2056);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("none");
        arrayList.add("lm-resize");
        arrayList.add("lm-scale");
        arrayList.add("lm-responsive");
        if (this.showWrapType) {
            arrayList.add("lm-wrap");
        }
        this.typeCmb.setItems(arrayList.toArray(new String[arrayList.size()]));
        this.confLbl = new Label(composite2, 0);
        this.confLbl.setText("Configuration string: ");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.confLbl.setLayoutData((Object)gridData);
        this.confTxt = new Text(composite2, 2114);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 100;
        gridData.horizontalSpan = 2;
        this.confTxt.setLayoutData((Object)gridData);
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        if (this.value != null) {
            if (this.value.getType() < this.typeCmb.getItemCount()) {
                this.typeCmb.select(this.value.getType());
            }
            if (this.value.getConfiguration() != null) {
                this.confTxt.setText(this.value.getConfiguration());
            } else if (this.value.getHandleName() != null && (variableType = screenProgram.getProgramVariable(this.value.getHandleName())) != null && variableType.getValue2() != null) {
                this.confTxt.setText(variableType.getValue2());
            }
        } else {
            this.typeCmb.select(0);
        }
        variableType = screenProgram.getProgramVariables();
        this.handleEd = new VariableFieldEditor(composite2, "Handle:", "lm", 1003, 29, null, true, (VariableType[])variableType, this.value != null ? this.value.getHandleName() : null);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.handleEd.getControl().setLayoutData((Object)gridData);
        this.setConfEnabled();
        this.typeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.confTxt.addVerifyListener((VerifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.handleEd.setSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void setConfEnabled() {
        boolean bl = this.typeCmb.getSelectionIndex() == 2 || this.typeCmb.getSelectionIndex() == 3;
        this.confTxt.setEnabled(bl);
        this.confLbl.setEnabled(bl);
    }

    public void okPressed() {
        VariableType variableType;
        String string;
        VariableName variableName;
        String string2 = null;
        if (this.confTxt.isEnabled() && this.confTxt.getText().length() > 0) {
            string2 = this.confTxt.getText();
        }
        if ((variableName = this.handleEd.getValue()) == null && string2 != null) {
            PluginUtilities.logError((String)"Set the handle");
            return;
        }
        ScreenProgram screenProgram = PropertyDescriptorRegistry.getCurrentScreenProgram();
        try {
            VariableFieldEditor.validateVariable((VariableName)variableName, (String)"handle", (ScreenProgram)screenProgram);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PluginUtilities.logError((String)illegalArgumentException.getMessage());
            return;
        }
        this.Return = new LayoutManager(this.typeCmb.getSelectionIndex(), string2);
        if (variableName != null) {
            int n = this.getHandleUsage();
            if (variableName.getVariable() == null) {
                string = variableName.getFullString();
                variableType = screenProgram.createHandleVariable(string, n);
            } else {
                variableType = variableName.getVariable();
                if (variableType.getUsage().getValue() != n) {
                    PluginUtilities.logError((String)"wrong handle usage");
                    return;
                }
            }
        } else {
            variableType = null;
        }
        try {
            String string3 = this.value != null ? this.value.getHandleName() : null;
            string = null;
            if (string3 != null && string3.length() > 0) {
                string = screenProgram.getProgramVariable(string3);
            }
            if (string != null) {
                screenProgram.getResourceRegistry().unregisterVariable((VariableType)string, (Object)this.Return, "handleName");
            }
            if (variableType != null) {
                this.Return.setHandleName(variableName.getFullString());
                if (this.Return.getType() == 3 || this.Return.getType() == 2) {
                    String string4 = this.confTxt.getText();
                    if (!string4.startsWith("\"") && !string4.startsWith("'")) {
                        string4 = "\"" + string4 + "\"";
                    }
                    variableType.setValue2(string4);
                }
                screenProgram.getResourceRegistry().registerVariable(variableType, (Object)this.Return, "handleName");
            } else {
                this.Return.setHandleName(null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.okPressed();
    }

    private int getHandleUsage() {
        int n = 29;
        switch (this.typeCmb.getSelectionIndex()) {
            case 1: {
                n = 62;
                break;
            }
            case 2: {
                n = 63;
                break;
            }
            case 3: {
                n = 64;
                break;
            }
            case 4: {
                n = 65;
            }
        }
        return n;
    }

    public LayoutManager openDialog() {
        this.open();
        return this.Return;
    }

    static /* synthetic */ void access$000(LayoutManagerDialog layoutManagerDialog) {
        layoutManagerDialog.setConfEnabled();
    }

    static /* synthetic */ int access$100(LayoutManagerDialog layoutManagerDialog) {
        return layoutManagerDialog.getHandleUsage();
    }

    static /* synthetic */ VariableFieldEditor access$200(LayoutManagerDialog layoutManagerDialog) {
        return layoutManagerDialog.handleEd;
    }

    static /* synthetic */ Text access$300(LayoutManagerDialog layoutManagerDialog) {
        return layoutManagerDialog.confTxt;
    }

    static /* synthetic */ Combo access$400(LayoutManagerDialog layoutManagerDialog) {
        return layoutManagerDialog.typeCmb;
    }
}

