/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.beans.types.OccursClause;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.propertysheet.ComboEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class OccursClauseDialog
extends Dialog {
    private VariableType vt;
    private OccursClause Return;
    private boolean enabled;
    private Text fieldNameTxt;
    private Button occursBtn;
    private Button occFixedBtn;
    private Button occVarBtn;
    private Button keysBtn;
    private Button indexBtn;
    private Button dynamicBtn;
    private Text occSizeTxt;
    private Text occMinTxt;
    private Text occMaxTxt;
    private Text occDepOnTxt;
    private Table fieldsTable;
    private Table keysTable;
    private Button orderBtn;
    private Button addKeyBtn;
    private Button removeKeyBtn;
    private Button removeAllKeysBtn;
    private Text indexTxt;
    private Text capacityTxt;
    private Button addIndexBtn;
    private Button removeIndexBtn;
    private Button removeAllIndexesBtn;
    private List indexList;
    private Font tableFont;
    private Label occSizeLbl;
    private Label occMaxLbl;
    private Label occMinLbl;
    private Label occDepOnLbl;
    private Label indexNameLbl;
    private Label indexListLbl;
    private Label fieldsLbl;
    private Label keysLbl;
    private Label capacityLbl;
    private TableEditor keysEditor;
    private static final String ASC = "Asc";
    private static final String DESC = "Desc";

    public OccursClauseDialog(Shell shell, VariableType variableType, boolean bl) {
        super(shell);
        this.vt = variableType;
        this.enabled = bl;
    }

    public OccursClause openDialog() {
        if (super.open() == 0 && this.enabled) {
            return this.Return;
        }
        return null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Occurs Clause settings");
    }

    private OccursClause makeOccursClause() throws Exception {
        String[] stringArray;
        int n;
        String string;
        OccursClause occursClause = OccursClause.getOccurs();
        if (!this.occursBtn.getSelection()) {
            return occursClause;
        }
        occursClause.setOccurs(true);
        if (this.dynamicBtn.getSelection()) {
            occursClause.setDynamic(true);
            occursClause.setCapacity(this.capacityTxt.getText());
            return occursClause;
        }
        if (this.occFixedBtn.getSelection()) {
            string = this.occSizeTxt.getText();
            if (string.length() == 0) {
                throw new Exception("The 'Size' field cannot be empty");
            }
            n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The 'Size' field must contain a numeric value");
            }
            if (n <= 0) {
                throw new Exception("The 'Size' field must contain a value > 0");
            }
            occursClause.setFixed(true);
            occursClause.setTimes(n);
        } else {
            string = this.occMinTxt.getText();
            if (string.length() == 0) {
                throw new Exception("The 'Min' field cannot be empty");
            }
            n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The 'Min' field must contain a numeric value");
            }
            if (n <= 0) {
                throw new Exception("The 'Min' field must contain a value > 0");
            }
            string = this.occMaxTxt.getText();
            if (string.length() == 0) {
                throw new Exception("The 'Max' field cannot be empty");
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("The 'Max' field must contain a numeric value");
            }
            if (n2 <= n) {
                throw new Exception("The 'Max' field must contain a value > " + n);
            }
            stringArray = this.occDepOnTxt.getText();
            if (stringArray.length() == 0) {
                throw new Exception("The 'Depending On' field cannot be empty");
            }
            occursClause.setFixed(false);
            occursClause.setMin(n);
            occursClause.setMax(n2);
            occursClause.setDepOn((String)stringArray);
        }
        if (this.keysBtn.getSelection()) {
            TableItem[] tableItemArray = this.keysTable.getItems();
            boolean[] blArray = new boolean[tableItemArray.length];
            stringArray = new String[tableItemArray.length];
            for (int i = 0; i < tableItemArray.length; ++i) {
                blArray[i] = tableItemArray[i].getText(0).equals(ASC);
                stringArray[i] = tableItemArray[i].getText(1);
            }
            occursClause.setKeys(true);
            occursClause.setKeyList(blArray, stringArray);
        }
        if (this.indexBtn.getSelection()) {
            occursClause.setIndexed(true);
            occursClause.setIndexList(this.indexList.getItems());
        }
        return occursClause;
    }

    protected void okPressed() {
        try {
            this.Return = this.makeOccursClause();
            super.okPressed();
        }
        catch (Exception exception) {
            this.logError(exception.getMessage());
            this.Return = null;
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Field name:");
        this.fieldNameTxt = new Text(composite2, 2048);
        this.fieldNameTxt.setEditable(false);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        this.fieldNameTxt.setLayoutData((Object)gridData);
        this.occursBtn = new Button(composite2, 32);
        this.occursBtn.setText("Occurs");
        gridData = new GridData();
        gridData.widthHint = 100;
        gridData.horizontalAlignment = 131072;
        this.occursBtn.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 50;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group.setLayoutData((Object)gridData);
        this.dynamicBtn = new Button((Composite)group, 32);
        this.dynamicBtn.setText("Dynamic");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.dynamicBtn.setLayoutData((Object)gridData);
        this.dynamicBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite composite3 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(768));
        this.capacityLbl = new Label(composite3, 0);
        this.capacityLbl.setText("Capacity:");
        this.capacityTxt = new Text(composite3, 2048);
        gridData = new GridData(768);
        this.capacityTxt.setLayoutData((Object)gridData);
        Group group2 = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 7;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        group2.setLayoutData((Object)gridData);
        group2.setText("Occurs");
        this.occFixedBtn = new Button((Composite)group2, 16);
        this.occFixedBtn.setText("Fixed");
        this.occSizeLbl = new Label((Composite)group2, 0);
        this.occSizeLbl.setText("Size:");
        this.occSizeTxt = new Text((Composite)group2, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.widthHint = 30;
        this.occSizeTxt.setLayoutData((Object)gridData);
        this.occVarBtn = new Button((Composite)group2, 16);
        this.occVarBtn.setText("Variable");
        this.occMinLbl = new Label((Composite)group2, 0);
        this.occMinLbl.setText("Min:");
        this.occMinTxt = new Text((Composite)group2, 2048);
        gridData = new GridData();
        gridData.widthHint = 30;
        this.occMinTxt.setLayoutData((Object)gridData);
        this.occMaxLbl = new Label((Composite)group2, 0);
        this.occMaxLbl.setText("Max:");
        this.occMaxTxt = new Text((Composite)group2, 2048);
        gridData = new GridData();
        gridData.widthHint = 30;
        this.occMaxTxt.setLayoutData((Object)gridData);
        this.occDepOnLbl = new Label((Composite)group2, 0);
        this.occDepOnLbl.setText("Depending On:");
        this.occDepOnTxt = new Text((Composite)group2, 2048);
        gridData = new GridData(1808);
        this.occDepOnTxt.setLayoutData((Object)gridData);
        Group group3 = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group3.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group3.setLayoutData((Object)gridData);
        this.keysBtn = new Button((Composite)group3, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.keysBtn.setLayoutData((Object)gridData);
        this.keysBtn.setText("Key");
        Composite composite4 = new Composite((Composite)group3, 0);
        gridLayout = new GridLayout();
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(1808));
        this.fieldsLbl = new Label(composite4, 0);
        this.fieldsLbl.setText("Available fields:");
        this.fieldsTable = new Table(composite4, 68354);
        this.fieldsTable.setLinesVisible(true);
        this.fieldsTable.setHeaderVisible(true);
        this.fieldsTable.setFont(this.getTableFont());
        TableColumn tableColumn = new TableColumn(this.fieldsTable, 0);
        tableColumn.setText("Level");
        tableColumn.setWidth(70);
        tableColumn = new TableColumn(this.fieldsTable, 0);
        tableColumn.setText("Field name");
        tableColumn.setWidth(175);
        gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.fieldsTable.setLayoutData((Object)gridData);
        Composite composite5 = new Composite((Composite)group3, 0);
        gridLayout = new GridLayout();
        composite5.setLayout((Layout)gridLayout);
        this.addKeyBtn = new Button(composite5, 8);
        this.addKeyBtn.setText(">");
        gridData = new GridData();
        gridData.widthHint = 40;
        this.addKeyBtn.setLayoutData((Object)gridData);
        this.removeKeyBtn = new Button(composite5, 8);
        this.removeKeyBtn.setText("<");
        this.removeKeyBtn.setLayoutData((Object)gridData);
        this.removeAllKeysBtn = new Button(composite5, 8);
        this.removeAllKeysBtn.setText("<<");
        this.removeAllKeysBtn.setLayoutData((Object)gridData);
        Composite composite6 = new Composite((Composite)group3, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite6.setLayout((Layout)gridLayout);
        composite6.setLayoutData((Object)new GridData(1808));
        this.keysLbl = new Label(composite6, 0);
        this.keysLbl.setText("Key List:");
        this.keysLbl.setLayoutData((Object)new GridData(1808));
        this.orderBtn = new Button(composite6, 8);
        this.orderBtn.setText("Order");
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.heightHint = 22;
        this.orderBtn.setLayoutData((Object)gridData);
        this.keysTable = new Table(composite6, 68354);
        this.keysTable.setLinesVisible(true);
        this.keysTable.setHeaderVisible(true);
        this.keysTable.setFont(this.getTableFont());
        tableColumn = new TableColumn(this.keysTable, 0);
        tableColumn.setText("Order");
        tableColumn.setWidth(70);
        tableColumn = new TableColumn(this.keysTable, 0);
        tableColumn.setText("Fields");
        tableColumn.setWidth(175);
        gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        gridData.horizontalSpan = 3;
        this.keysTable.setLayoutData((Object)gridData);
        this.keysEditor = new TableEditor(this.keysTable);
        this.keysEditor.grabHorizontal = true;
        Group group4 = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group4.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        group4.setLayoutData((Object)gridData);
        this.indexBtn = new Button((Composite)group4, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.indexBtn.setLayoutData((Object)gridData);
        this.indexBtn.setText("Indexed by");
        Composite composite7 = new Composite((Composite)group4, 0);
        gridLayout = new GridLayout();
        composite7.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        composite7.setLayoutData((Object)gridData);
        this.indexNameLbl = new Label(composite7, 0);
        this.indexNameLbl.setText("Index name:");
        this.indexTxt = new Text(composite7, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.indexTxt.setLayoutData((Object)gridData);
        Composite composite8 = new Composite((Composite)group4, 0);
        gridLayout = new GridLayout();
        composite8.setLayout((Layout)gridLayout);
        this.addIndexBtn = new Button(composite8, 8);
        this.addIndexBtn.setText(">");
        gridData = new GridData();
        gridData.widthHint = 40;
        this.addIndexBtn.setLayoutData((Object)gridData);
        this.removeIndexBtn = new Button(composite8, 8);
        this.removeIndexBtn.setText("<");
        this.removeIndexBtn.setLayoutData((Object)gridData);
        this.removeAllIndexesBtn = new Button(composite8, 8);
        this.removeAllIndexesBtn.setText("<<");
        this.removeAllIndexesBtn.setLayoutData((Object)gridData);
        Composite composite9 = new Composite((Composite)group4, 0);
        gridLayout = new GridLayout();
        composite9.setLayout((Layout)gridLayout);
        composite9.setLayoutData((Object)new GridData(1808));
        this.indexListLbl = new Label(composite9, 0);
        this.indexListLbl.setText("Index list:");
        this.indexList = new List(composite9, 2050);
        gridData = new GridData(1808);
        gridData.widthHint = 250;
        gridData.heightHint = 150;
        this.indexList.setLayoutData((Object)gridData);
        OccursClause occursClause = this.vt.getOccurs();
        this.fieldNameTxt.setText(this.vt.getName());
        this.occursBtn.setSelection(occursClause.isOccurs());
        this.dynamicBtn.setSelection(occursClause.isDynamic());
        if (occursClause.getCapacity() != null) {
            this.capacityTxt.setText(occursClause.getCapacity());
        }
        this.occFixedBtn.setSelection(occursClause.isFixed());
        this.occVarBtn.setSelection(!occursClause.isFixed());
        this.occSizeTxt.setText("" + occursClause.getTimes());
        this.occMinTxt.setText("" + occursClause.getMin());
        this.occMaxTxt.setText("" + occursClause.getMax());
        if (occursClause.getDepOn() != null) {
            this.occDepOnTxt.setText(occursClause.getDepOn());
        }
        this.keysBtn.setSelection(occursClause.isKeys());
        this.fillFieldsTable(this.vt);
        this.fillKeyTable(occursClause);
        this.indexBtn.setSelection(occursClause.isIndexed());
        this.fillIndexList(occursClause);
        if (this.enabled) {
            if (occursClause.isOccurs()) {
                if (occursClause.isDynamic()) {
                    this.setNotDynamicEnabled(false);
                } else {
                    if (!occursClause.isKeys()) {
                        this.setKeyGrpEnabled(false);
                    }
                    if (!occursClause.isIndexed()) {
                        this.setIndexGrpEnabled(false);
                    }
                    if (occursClause.isFixed()) {
                        this.setOccVarEnabled(false);
                    } else {
                        this.setOccFixedEnabled(false);
                    }
                }
            } else {
                this.setMaskEnabled(false);
            }
        } else {
            this.occursBtn.setEnabled(false);
            this.setMaskEnabled(false);
        }
        this.addKeyBtn.setEnabled(false);
        this.removeKeyBtn.setEnabled(false);
        this.addIndexBtn.setEnabled(false);
        this.removeIndexBtn.setEnabled(false);
        this.orderBtn.setEnabled(false);
        this.occursBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.occFixedBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.occVarBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keysBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.indexBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addKeyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeKeyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllKeysBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fieldsTable.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keysTable.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keysTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.indexTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addIndexBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeIndexBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllIndexesBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.orderBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.indexList.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void handleKeysTableMouseDown(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.keysTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null || nArray[1] != 0) {
            return;
        }
        TableItem tableItem = this.keysTable.getItem(nArray[0]);
        ComboEditor comboEditor = new ComboEditor();
        comboEditor.setItems(new String[]{ASC, DESC});
        comboEditor.createEditor((Composite)this.keysTable);
        comboEditor.setListener((ValueListener)new /* Unavailable Anonymous Inner Class!! */);
        this.keysEditor.setEditor(comboEditor.getEditor(), tableItem, 0);
        comboEditor.setValue((Object)new Integer(tableItem.getText().equals(ASC) ? 0 : 1));
        comboEditor.setFocus();
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void logError(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setMessage(string);
        messageBox.setText(this.getShell().getText());
        messageBox.open();
    }

    private boolean foundKey(String string) {
        TableItem[] tableItemArray = this.keysTable.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (!tableItemArray[i].getText(1).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void fillFieldsTable(VariableType variableType) {
        TableItem tableItem = new TableItem(this.fieldsTable, 0);
        tableItem.setText(0, variableType.getLevel());
        tableItem.setText(1, variableType.getName());
        for (int i = 0; i < variableType.getChildCount(); ++i) {
            VariableType variableType2 = (VariableType)variableType.getChildAt(i);
            if (variableType2.isFiller() || variableType2.getLevelAsInt() != 77 && (variableType2.getLevelAsInt() < 1 || variableType2.getLevelAsInt() > 49)) continue;
            this.fillFieldsTable(variableType2);
        }
    }

    private void setMaskEnabled(boolean bl) {
        this.dynamicBtn.setEnabled(bl);
        this.setNotDynamicEnabled(bl && !this.dynamicBtn.getSelection());
    }

    private void setNotDynamicEnabled(boolean bl) {
        this.capacityLbl.setEnabled(!bl && this.dynamicBtn.isEnabled());
        this.capacityTxt.setEnabled(!bl && this.dynamicBtn.isEnabled());
        this.occFixedBtn.setEnabled(bl);
        this.setOccFixedEnabled(bl && this.occFixedBtn.getSelection());
        this.occVarBtn.setEnabled(bl);
        this.setOccVarEnabled(bl && this.occVarBtn.getSelection());
        this.keysBtn.setEnabled(bl);
        this.setKeyGrpEnabled(bl && this.keysBtn.getSelection());
        this.indexBtn.setEnabled(bl);
        this.setIndexGrpEnabled(bl && this.indexBtn.getSelection());
    }

    private void setOccFixedEnabled(boolean bl) {
        this.occSizeLbl.setEnabled(bl);
        this.occSizeTxt.setEnabled(bl);
    }

    private void setOccVarEnabled(boolean bl) {
        this.occMinLbl.setEnabled(bl);
        this.occMinTxt.setEnabled(bl);
        this.occMaxLbl.setEnabled(bl);
        this.occMaxTxt.setEnabled(bl);
        this.occDepOnLbl.setEnabled(bl);
        this.occDepOnTxt.setEnabled(bl);
    }

    private void setKeyGrpEnabled(boolean bl) {
        this.keysLbl.setEnabled(bl);
        this.keysTable.setEnabled(bl);
        this.fieldsLbl.setEnabled(bl);
        this.fieldsTable.setEnabled(bl);
        this.keysTable.setEnabled(bl);
        this.addKeyBtn.setEnabled(bl && this.fieldsTable.getSelectionCount() > 0);
        this.removeKeyBtn.setEnabled(bl && this.keysTable.getSelectionCount() > 0);
        this.removeAllKeysBtn.setEnabled(bl);
        this.orderBtn.setEnabled(bl && this.keysTable.getSelectionCount() > 0);
    }

    private void setIndexGrpEnabled(boolean bl) {
        this.indexNameLbl.setEnabled(bl);
        this.indexListLbl.setEnabled(bl);
        this.indexTxt.setEnabled(bl);
        this.indexList.setEnabled(bl);
        this.addIndexBtn.setEnabled(bl && this.indexTxt.getText().length() > 0);
        this.removeIndexBtn.setEnabled(bl && this.indexList.getSelectionCount() > 0);
        this.removeAllIndexesBtn.setEnabled(bl);
    }

    private void fillKeyTable(OccursClause occursClause) {
        OccursClause.KeyList keyList = new OccursClause.KeyList();
        occursClause.getKeyList(keyList);
        for (int i = 0; i < keyList.keys.length; ++i) {
            TableItem tableItem = new TableItem(this.keysTable, 0);
            tableItem.setText(0, keyList.ascending[i] ? ASC : DESC);
            tableItem.setText(1, keyList.keys[i]);
        }
    }

    private void fillIndexList(OccursClause occursClause) {
        String string = occursClause.getIndexes();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.indexList.add(stringTokenizer.nextToken());
        }
    }

    public boolean close() {
        if (this.tableFont != null) {
            this.tableFont.dispose();
        }
        return super.close();
    }

    private Font getTableFont() {
        if (this.tableFont == null) {
            this.tableFont = new Font((Device)this.getShell().getDisplay(), new FontData("Courier New", 8, 0));
        }
        return this.tableFont;
    }

    static /* synthetic */ Button access$000(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.dynamicBtn;
    }

    static /* synthetic */ void access$100(OccursClauseDialog occursClauseDialog, boolean bl) {
        occursClauseDialog.setNotDynamicEnabled(bl);
    }

    static /* synthetic */ Button access$200(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.occursBtn;
    }

    static /* synthetic */ void access$300(OccursClauseDialog occursClauseDialog, boolean bl) {
        occursClauseDialog.setMaskEnabled(bl);
    }

    static /* synthetic */ Button access$400(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.occFixedBtn;
    }

    static /* synthetic */ void access$500(OccursClauseDialog occursClauseDialog, boolean bl) {
        occursClauseDialog.setOccFixedEnabled(bl);
    }

    static /* synthetic */ void access$600(OccursClauseDialog occursClauseDialog, boolean bl) {
        occursClauseDialog.setOccVarEnabled(bl);
    }

    static /* synthetic */ Button access$700(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.occVarBtn;
    }

    static /* synthetic */ Button access$800(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.keysBtn;
    }

    static /* synthetic */ void access$900(OccursClauseDialog occursClauseDialog, boolean bl) {
        occursClauseDialog.setKeyGrpEnabled(bl);
    }

    static /* synthetic */ Button access$1000(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.indexBtn;
    }

    static /* synthetic */ void access$1100(OccursClauseDialog occursClauseDialog, boolean bl) {
        occursClauseDialog.setIndexGrpEnabled(bl);
    }

    static /* synthetic */ Table access$1200(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.fieldsTable;
    }

    static /* synthetic */ boolean access$1300(OccursClauseDialog occursClauseDialog, String string) {
        return occursClauseDialog.foundKey(string);
    }

    static /* synthetic */ void access$1400(OccursClauseDialog occursClauseDialog, String string) {
        occursClauseDialog.logError(string);
    }

    static /* synthetic */ Table access$1500(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.keysTable;
    }

    static /* synthetic */ Button access$1600(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.removeKeyBtn;
    }

    static /* synthetic */ Button access$1700(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.addKeyBtn;
    }

    static /* synthetic */ Button access$1800(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.orderBtn;
    }

    static /* synthetic */ void access$1900(OccursClauseDialog occursClauseDialog, MouseEvent mouseEvent) {
        occursClauseDialog.handleKeysTableMouseDown(mouseEvent);
    }

    static /* synthetic */ Text access$2000(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.indexTxt;
    }

    static /* synthetic */ Button access$2100(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.addIndexBtn;
    }

    static /* synthetic */ List access$2200(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.indexList;
    }

    static /* synthetic */ Button access$2300(OccursClauseDialog occursClauseDialog) {
        return occursClauseDialog.removeIndexBtn;
    }
}

