/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.EventParagraphsEditor;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.dialogs.ProgramProceduresDialog;
import com.iscobol.screenpainter.propertysheet.PropertySheetContainer;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ProgramProceduresDialog
extends Dialog
implements PropertySheetContainer {
    private ScreenProgram screenProgram;
    private MyPropertySheetTable propertySheet;
    private Label statusBar;

    public ProgramProceduresDialog(Shell shell, ScreenProgram screenProgram) {
        super(shell);
        this.screenProgram = screenProgram;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Screen Program procedures");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        IProject iProject = this.screenProgram.getProject();
        this.propertySheet = new MyPropertySheetTable(composite2, 0, (PropertySheetContainer)this, this.screenProgram, iProject, false, 200, 250);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 500;
        gridData.heightHint = 300;
        this.propertySheet.setLayoutData((Object)gridData);
        this.statusBar = new Label(composite2, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.statusBar.setLayoutData((Object)gridData);
        this.statusBar.setForeground(composite.getDisplay().getSystemColor(3));
        this.propertySheet.loadTable(new Object[]{new ScreenProgramWrapper(this.screenProgram)});
        return composite2;
    }

    public void paragraphValueChanged(Object object, int n, String string, ParagraphType paragraphType, ParagraphType paragraphType2, boolean bl) {
        if (paragraphType2 != null && n == 0 && bl) {
            this.okPressed();
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            EventParagraphsEditor eventParagraphsEditor = screenProgramEditor.getEventParagraphsEditor();
            screenProgramEditor.activateEventParagraphsEditor();
            eventParagraphsEditor.setFocus();
            eventParagraphsEditor.addAndSelectParagraph(this.screenProgram.getEventParagraphs(), paragraphType2.getName(), paragraphType2.isUserParagraph());
        }
    }

    public void setDirty(boolean bl) {
    }

    public void setErrorMessage(String string) {
        if (this.statusBar.isDisposed()) {
            return;
        }
        if (string != null) {
            this.statusBar.setText(string);
        } else {
            this.statusBar.setText("");
        }
    }

    public void valueChanged(Object object, int n, String string, Object object2, Object object3) {
    }

    public boolean isDirty() {
        return false;
    }

    public CommandStack getCommandStack() {
        return null;
    }
}

