/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.dialogs.RGBColorDialog;
import com.iscobol.screenpainter.util.ColorProvider;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageProducer;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

/*
 * Exception performing whole class analysis ignored.
 */
public class RGBColorDialog
extends Dialog {
    private ColorLabelCmp selectedLabel;
    private static final int PALETTE_DIMENSION = 300;
    private static final int MAX_HUE_VALUE = 359;
    private static final int MAX_SATURATION_VALUE = 100;
    private static final int MAX_BRIGHTNESS_VALUE = 100;
    private int currentMode = 0;
    private boolean isAdjusting = false;
    private Color selectedColor;
    private static final int HUE_MODE = 0;
    private static final int SATURATION_MODE = 1;
    private static final int BRIGHTNESS_MODE = 2;
    private JLabel paletteLabel;
    private JLabel scaleLabel;
    private Composite paletteContainer;
    private Composite scalePaletteContainer;
    private Scale scale;
    private boolean scaleInverted;
    private boolean updateRgb = true;
    private Button hueBtn;
    private Button saturationBtn;
    private Button brightnessBtn;
    private Spinner hueTxt;
    private Spinner saturationTxt;
    private Spinner brightnessTxt;
    private Spinner redTxt;
    private Spinner greenTxt;
    private Spinner blueTxt;
    private Point paletteSelection = new Point(0, 0);
    private HSBImage palette;
    private HSBImage scalePalette;
    private Image paletteImage;
    private Image scaleImage;
    private Composite previewContainer;
    private JLabel previewLabel;
    private Button addToCustBtn;
    private int lastCustColorIndex;
    private int customizedColorCount;
    private static final RGB[] baseRGBs = new RGB[]{new RGB(255, 128, 128), new RGB(255, 255, 128), new RGB(128, 255, 128), new RGB(0, 255, 128), new RGB(128, 255, 255), new RGB(0, 128, 255), new RGB(255, 128, 192), new RGB(255, 128, 255), new RGB(255, 0, 0), new RGB(255, 255, 0), new RGB(128, 255, 0), new RGB(0, 255, 64), new RGB(0, 255, 255), new RGB(0, 128, 192), new RGB(128, 128, 192), new RGB(255, 0, 255), new RGB(128, 64, 64), new RGB(255, 128, 64), new RGB(0, 255, 0), new RGB(0, 128, 128), new RGB(0, 64, 128), new RGB(128, 128, 255), new RGB(128, 0, 64), new RGB(255, 0, 128), new RGB(128, 0, 0), new RGB(255, 128, 0), new RGB(0, 128, 0), new RGB(0, 128, 64), new RGB(0, 0, 255), new RGB(0, 0, 160), new RGB(128, 0, 128), new RGB(128, 0, 255), new RGB(64, 0, 0), new RGB(128, 64, 0), new RGB(0, 64, 0), new RGB(0, 64, 64), new RGB(0, 0, 128), new RGB(0, 0, 64), new RGB(64, 0, 64), new RGB(64, 0, 128), new RGB(0, 0, 0), new RGB(128, 128, 0), new RGB(128, 128, 64), new RGB(128, 128, 128), new RGB(64, 128, 128), new RGB(192, 192, 192), new RGB(64, 0, 64), new RGB(255, 255, 255)};
    private RGB[] customizedRGBs = new RGB[16];
    private ColorLabelCmp[] customizedColors = new ColorLabelCmp[16];
    private ColorProvider colorProvider = new ColorProvider();

    public RGBColorDialog(Shell shell, RGB rGB) {
        super(shell);
        for (int i = 0; i < this.customizedRGBs.length; ++i) {
            this.customizedRGBs[i] = new RGB(0, 0, 0);
        }
        this.selectedColor = rGB != null ? new Color(rGB.red, rGB.green, rGB.blue) : new Color(255, 255, 255);
    }

    public boolean close() {
        this.saveCustomizedColors();
        this.colorProvider.dispose();
        return super.close();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        composite3.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        composite3.setLayoutData((Object)gridData);
        Group group = new Group(composite3, 0);
        group.setText("Base Colors");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        group.setLayout((Layout)gridLayout);
        for (int i = 0; i < baseRGBs.length; ++i) {
            new ColorLabelCmp(this, baseRGBs[i], (Composite)group);
        }
        Group group2 = new Group(composite3, 0);
        group2.setText("Customized Colors");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        group2.setLayout((Layout)gridLayout);
        for (int i = 0; i < this.customizedRGBs.length; ++i) {
            this.customizedColors[i] = new ColorLabelCmp(this, this.customizedRGBs[i], (Composite)group2);
        }
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        composite4.setLayout((Layout)gridLayout);
        Composite composite5 = new Composite(composite4, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite5.setLayout((Layout)gridLayout);
        this.createPaletteLabel(composite5);
        gridData = new GridData();
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        this.paletteContainer.setLayoutData((Object)gridData);
        this.paletteLabel.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.paletteLabel.addMouseMotionListener((MouseMotionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite composite6 = new Composite(composite5, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        composite6.setLayout((Layout)gridLayout);
        this.scale = new Scale(composite6, 512);
        this.scale.setMinimum(0);
        this.scale.setMaximum(359);
        this.scale.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.heightHint = 330;
        this.scale.setLayoutData((Object)gridData);
        this.createScalePaletteLabel(composite6);
        gridData = new GridData();
        gridData.widthHint = 30;
        gridData.heightHint = 300;
        this.scalePaletteContainer.setLayoutData((Object)gridData);
        4 var11_13 = new /* Unavailable Anonymous Inner Class!! */;
        this.scaleLabel.addMouseListener((MouseListener)var11_13);
        this.scaleLabel.addMouseMotionListener((MouseMotionListener)var11_13);
        Composite composite7 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 20;
        composite7.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite7.setLayoutData((Object)gridData);
        Group group3 = new Group(composite7, 0);
        group3.setText("Preview");
        gridLayout = new GridLayout();
        group3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        group3.setLayoutData((Object)gridData);
        this.createPreviewLabel((Composite)group3);
        gridData = new GridData(768);
        gridData.heightHint = 60;
        this.previewContainer.setLayoutData((Object)gridData);
        Group group4 = new Group(composite7, 0);
        group4.setText("HSB");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group4.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.verticalAlignment = 128;
        group4.setLayoutData((Object)gridData);
        this.hueBtn = new Button((Composite)group4, 16);
        this.hueBtn.setText("Hue");
        this.hueBtn.setSelection(true);
        this.hueTxt = new Spinner((Composite)group4, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.hueTxt.setLayoutData((Object)gridData);
        this.hueTxt.setMinimum(0);
        this.hueTxt.setMaximum(359);
        this.saturationBtn = new Button((Composite)group4, 16);
        this.saturationBtn.setText("Saturation");
        this.saturationTxt = new Spinner((Composite)group4, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.saturationTxt.setLayoutData((Object)gridData);
        this.saturationTxt.setMinimum(0);
        this.saturationTxt.setMaximum(100);
        this.brightnessBtn = new Button((Composite)group4, 16);
        this.brightnessBtn.setText("Brightness");
        this.brightnessTxt = new Spinner((Composite)group4, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.brightnessTxt.setLayoutData((Object)gridData);
        this.brightnessTxt.setMinimum(0);
        this.brightnessTxt.setMaximum(100);
        Group group5 = new Group(composite7, 0);
        group5.setText("RGB");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group5.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.verticalAlignment = 128;
        group5.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group5, 0);
        label.setText("Red:");
        this.redTxt = new Spinner((Composite)group5, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.redTxt.setLayoutData((Object)gridData);
        this.redTxt.setMinimum(0);
        this.redTxt.setMaximum(255);
        Label label2 = new Label((Composite)group5, 0);
        label2.setText("Green:");
        this.greenTxt = new Spinner((Composite)group5, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.greenTxt.setLayoutData((Object)gridData);
        this.greenTxt.setMinimum(0);
        this.greenTxt.setMaximum(255);
        Label label3 = new Label((Composite)group5, 0);
        label3.setText("Blue:");
        this.blueTxt = new Spinner((Composite)group5, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.blueTxt.setLayoutData((Object)gridData);
        this.blueTxt.setMinimum(0);
        this.blueTxt.setMaximum(255);
        this.addToCustBtn = new Button(composite7, 8);
        this.addToCustBtn.setText("Add to customized colors");
        this.addToCustBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.loadCustomizedColors();
        6 var19_21 = new /* Unavailable Anonymous Inner Class!! */;
        this.hueTxt.addSelectionListener((SelectionListener)var19_21);
        this.saturationTxt.addSelectionListener((SelectionListener)var19_21);
        this.brightnessTxt.addSelectionListener((SelectionListener)var19_21);
        this.hueBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.saturationBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.brightnessBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        10 var20_22 = new /* Unavailable Anonymous Inner Class!! */;
        this.redTxt.addSelectionListener((SelectionListener)var20_22);
        this.greenTxt.addSelectionListener((SelectionListener)var20_22);
        this.blueTxt.addSelectionListener((SelectionListener)var20_22);
        this.initializePalettesIfNecessary(composite.getDisplay());
        this.setMode(0);
        float[] fArray = this.getHSBColor(this.selectedColor);
        this.updateHSB(fArray[0], fArray[1], fArray[2]);
        return composite2;
    }

    private void setMode(int n) {
        if (this.currentMode == n) {
            return;
        }
        this.isAdjusting = true;
        this.currentMode = n;
        float[] fArray = this.getHSBColor(this.selectedColor);
        switch (this.currentMode) {
            case 0: {
                this.scaleInverted = false;
                this.scale.setMaximum(359);
                this.palette.setValues(0, fArray[0], 1.0f, 1.0f);
                this.scalePalette.setValues(3, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.scaleInverted = true;
                this.scale.setMaximum(100);
                this.palette.setValues(1, fArray[0], fArray[1], 1.0f);
                this.scalePalette.setValues(4, fArray[0], 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.scaleInverted = true;
                this.scale.setMaximum(100);
                this.palette.setValues(2, fArray[0], 1.0f, fArray[2]);
                this.scalePalette.setValues(5, fArray[0], 1.0f, 1.0f);
            }
        }
        this.isAdjusting = false;
        this.palette.nextFrame();
        this.scalePalette.nextFrame();
        if (!this.isAdjusting) {
            fArray = this.getHSBColor(this.selectedColor);
            this.updateHSB(fArray[0], fArray[1], fArray[2]);
        }
    }

    private void addCustomizedColor(RGB rGB) {
        this.customizedRGBs[this.lastCustColorIndex] = rGB;
        ColorLabelCmp.access$2100((ColorLabelCmp)this.customizedColors[this.lastCustColorIndex], (RGB)this.customizedRGBs[this.lastCustColorIndex]);
        ++this.lastCustColorIndex;
        if (this.customizedColorCount < this.customizedRGBs.length) {
            ++this.customizedColorCount;
        }
        if (this.lastCustColorIndex >= this.customizedRGBs.length) {
            this.lastCustColorIndex = 0;
        }
    }

    protected void createPreviewLabel(Composite composite) {
        this.previewContainer = new Composite(composite, 0x1000800);
        Frame frame = SWT_AWT.new_Frame((Composite)this.previewContainer);
        Panel panel = new Panel(new java.awt.GridLayout(1, 0));
        frame.add(panel);
        this.previewLabel = new JLabel();
        this.previewLabel.setOpaque(true);
        panel.add(this.previewLabel);
    }

    private void scaleValueChanged() {
        if (!this.isAdjusting) {
            int n = this.getScaleValue();
            int n2 = this.scale.getMaximum();
            float f = (float)n / (float)n2;
            float[] fArray = this.getHSBColor(this.selectedColor);
            switch (this.currentMode) {
                case 0: {
                    this.updateHSB(f, fArray[1], fArray[2]);
                    break;
                }
                case 1: {
                    this.updateHSB(fArray[0], f, fArray[2]);
                    break;
                }
                case 2: {
                    this.updateHSB(fArray[0], fArray[1], f);
                }
            }
        }
    }

    private void initializePalettesIfNecessary(Display display) {
        if (this.palette != null) {
            return;
        }
        float[] fArray = this.getHSBColor(this.selectedColor);
        switch (this.currentMode) {
            case 0: {
                this.palette = new HSBImage(0, 300, 300, fArray[0], 1.0f, 1.0f);
                this.scalePalette = new HSBImage(3, 16, 300, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.palette = new HSBImage(1, 300, 300, 1.0f, fArray[1], 1.0f);
                this.scalePalette = new HSBImage(4, 16, 300, 1.0f, 0.0f, 1.0f);
                break;
            }
            case 2: {
                this.palette = new HSBImage(2, 300, 300, 1.0f, 1.0f, fArray[2]);
                this.scalePalette = new HSBImage(5, 16, 300, 1.0f, 1.0f, 0.0f);
            }
        }
        this.paletteImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)this.palette);
        this.scaleImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)this.scalePalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.scaleLabel.setIcon(new ImageIcon(this.scaleImage));
    }

    private float[] getHSBColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        return fArray;
    }

    private int getScaleValue() {
        int n = this.scale.getSelection();
        if (this.scaleInverted) {
            n = this.scale.getMaximum() - n;
        }
        return n;
    }

    private void setScaleValue(int n) {
        if (this.scaleInverted) {
            n = this.scale.getMaximum() - n;
        }
        this.scale.setSelection(n);
    }

    private void updateHSB(float f, float f2, float f3) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            11 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
            if (this.getShell().getDisplay().getThread() != Thread.currentThread()) {
                Display.getDefault().syncExec((Runnable)var4_4);
            } else {
                var4_4.run();
            }
            this.isAdjusting = false;
            this.paletteLabel.repaint();
            this.previewLabel.setBackground(Color.getHSBColor(f, f2, f3));
        }
    }

    private void updatePalette(float f, float f2, float f3) {
        int n = 0;
        int n2 = 0;
        switch (this.currentMode) {
            case 0: {
                if (f != this.palette.hue) {
                    this.palette.hue = f;
                    this.palette.nextFrame();
                }
                n = 300 - (int)(f2 * 300.0f);
                n2 = 300 - (int)(f3 * 300.0f);
                break;
            }
            case 1: {
                if (f2 != this.palette.saturation) {
                    this.palette.saturation = f2;
                    this.palette.nextFrame();
                }
                n = (int)(f * 300.0f);
                n2 = 300 - (int)(f3 * 300.0f);
                break;
            }
            case 2: {
                if (f3 != this.palette.brightness) {
                    this.palette.brightness = f3;
                    this.palette.nextFrame();
                }
                n = (int)(f * 300.0f);
                n2 = 300 - (int)(f2 * 300.0f);
            }
        }
        this.paletteSelection.x = n;
        this.paletteSelection.y = n2;
    }

    private void updateSlider(float f, float f2, float f3) {
        if (this.currentMode != 0 && f != this.scalePalette.hue) {
            this.scalePalette.hue = f;
            this.scalePalette.nextFrame();
        }
        float f4 = 0.0f;
        switch (this.currentMode) {
            case 0: {
                f4 = f;
                break;
            }
            case 1: {
                f4 = f2;
                break;
            }
            case 2: {
                f4 = f3;
            }
        }
        this.setScaleValue(Math.round(f4 * (float)this.scale.getMaximum()));
    }

    private void updateHSBTextFields(float f, float f2, float f3) {
        int n = Math.round(f * 359.0f);
        int n2 = Math.round(f2 * 100.0f);
        int n3 = Math.round(f3 * 100.0f);
        if (this.hueTxt.getSelection() != n) {
            this.hueTxt.setSelection(n);
        }
        if (this.saturationTxt.getSelection() != n2) {
            this.saturationTxt.setSelection(n2);
        }
        if (this.brightnessTxt.getSelection() != n3) {
            this.brightnessTxt.setSelection(n3);
        }
    }

    private void updateRGBTextFields(Color color) {
        if (this.updateRgb) {
            this.redTxt.setSelection(color.getRed());
            this.greenTxt.setSelection(color.getGreen());
            this.blueTxt.setSelection(color.getBlue());
        }
    }

    protected void createPaletteLabel(Composite composite) {
        this.paletteContainer = new Composite(composite, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)this.paletteContainer);
        Panel panel = new Panel(new java.awt.GridLayout(1, 0));
        frame.add(panel);
        this.paletteLabel = new /* Unavailable Anonymous Inner Class!! */;
        this.paletteLabel.setOpaque(true);
        panel.add(this.paletteLabel);
    }

    protected void createScalePaletteLabel(Composite composite) {
        this.scalePaletteContainer = new Composite(composite, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)this.scalePaletteContainer);
        Panel panel = new Panel(new java.awt.GridLayout(1, 0));
        frame.add(panel);
        this.scaleLabel = new /* Unavailable Anonymous Inner Class!! */;
        this.scaleLabel.setOpaque(true);
        panel.add(this.scaleLabel);
    }

    public RGB openDialog() {
        if (this.open() == 0) {
            return new RGB(this.selectedColor.getRed(), this.selectedColor.getGreen(), this.selectedColor.getBlue());
        }
        return null;
    }

    private void loadCustomizedColors() {
        String string = IscobolScreenPainterPlugin.getDefault().getPreferenceStore().getString("iscobol.custcolors");
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            int n = Integer.parseInt(stringTokenizer2.nextToken());
            int n2 = Integer.parseInt(stringTokenizer2.nextToken());
            int n3 = Integer.parseInt(stringTokenizer2.nextToken());
            this.addCustomizedColor(new RGB(n, n2, n3));
        }
    }

    private void saveCustomizedColors() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.customizedColorCount; ++i) {
            stringBuilder.append(this.customizedRGBs[i].red);
            stringBuilder.append(",");
            stringBuilder.append(this.customizedRGBs[i].green);
            stringBuilder.append(",");
            stringBuilder.append(this.customizedRGBs[i].blue);
            if (i >= this.customizedColorCount - 1) continue;
            stringBuilder.append(";");
        }
        IscobolScreenPainterPlugin.getDefault().getPreferenceStore().setValue("iscobol.custcolors", stringBuilder.toString());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose Color");
    }

    static /* synthetic */ ColorProvider access$000(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.colorProvider;
    }

    static /* synthetic */ ColorLabelCmp access$100(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.selectedLabel;
    }

    static /* synthetic */ ColorLabelCmp access$102(RGBColorDialog rGBColorDialog, ColorLabelCmp colorLabelCmp) {
        rGBColorDialog.selectedLabel = colorLabelCmp;
        return rGBColorDialog.selectedLabel;
    }

    static /* synthetic */ void access$200(RGBColorDialog rGBColorDialog, float f, float f2, float f3) {
        rGBColorDialog.updateHSB(f, f2, f3);
    }

    static /* synthetic */ HSBImage access$300(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.palette;
    }

    static /* synthetic */ JLabel access$400(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.paletteLabel;
    }

    static /* synthetic */ void access$500(RGBColorDialog rGBColorDialog) {
        rGBColorDialog.scaleValueChanged();
    }

    static /* synthetic */ boolean access$600(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.scaleInverted;
    }

    static /* synthetic */ JLabel access$700(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.scaleLabel;
    }

    static /* synthetic */ Scale access$800(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.scale;
    }

    static /* synthetic */ void access$900(RGBColorDialog rGBColorDialog, int n) {
        rGBColorDialog.setScaleValue(n);
    }

    static /* synthetic */ Color access$1000(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.selectedColor;
    }

    static /* synthetic */ void access$1100(RGBColorDialog rGBColorDialog, RGB rGB) {
        rGBColorDialog.addCustomizedColor(rGB);
    }

    static /* synthetic */ Spinner access$1200(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.hueTxt;
    }

    static /* synthetic */ Spinner access$1300(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.saturationTxt;
    }

    static /* synthetic */ Spinner access$1400(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.brightnessTxt;
    }

    static /* synthetic */ void access$1500(RGBColorDialog rGBColorDialog, int n) {
        rGBColorDialog.setMode(n);
    }

    static /* synthetic */ Spinner access$1600(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.redTxt;
    }

    static /* synthetic */ Spinner access$1700(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.greenTxt;
    }

    static /* synthetic */ Spinner access$1800(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.blueTxt;
    }

    static /* synthetic */ float[] access$1900(RGBColorDialog rGBColorDialog, Color color) {
        return rGBColorDialog.getHSBColor(color);
    }

    static /* synthetic */ boolean access$2002(RGBColorDialog rGBColorDialog, boolean bl) {
        rGBColorDialog.updateRgb = bl;
        return rGBColorDialog.updateRgb;
    }

    static /* synthetic */ void access$2200(RGBColorDialog rGBColorDialog, float f, float f2, float f3) {
        rGBColorDialog.updatePalette(f, f2, f3);
    }

    static /* synthetic */ void access$2300(RGBColorDialog rGBColorDialog, float f, float f2, float f3) {
        rGBColorDialog.updateSlider(f, f2, f3);
    }

    static /* synthetic */ void access$2400(RGBColorDialog rGBColorDialog, float f, float f2, float f3) {
        rGBColorDialog.updateHSBTextFields(f, f2, f3);
    }

    static /* synthetic */ void access$2500(RGBColorDialog rGBColorDialog, Color color) {
        rGBColorDialog.updateRGBTextFields(color);
    }

    static /* synthetic */ Color access$1002(RGBColorDialog rGBColorDialog, Color color) {
        rGBColorDialog.selectedColor = color;
        return rGBColorDialog.selectedColor;
    }

    static /* synthetic */ Point access$2600(RGBColorDialog rGBColorDialog) {
        return rGBColorDialog.paletteSelection;
    }
}

