/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.filedesigner.types.Key;
import com.iscobol.filedesigner.types.KeyList;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.RefDataSetInfo;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.dialogs.ReferencedDataSetsDialog;
import com.iscobol.screenpainter.propertysheet.ComboEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import java.util.Vector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ReferencedDataSetsDialog
extends Dialog {
    private Button addBtn;
    private Button addAllBtn;
    private Button removeAllBtn;
    private Button removeBtn;
    private Table dsTable;
    private Table refDsTable;
    private TableEditor refDsTableEditor;
    private Vector referencedDataSets = new Vector();
    private ScreenFD_SL targetDataLayout;
    private DataSet[] dataSets;
    private DataSet targetDataSet;
    private int initialSelection;

    public ReferencedDataSetsDialog(Shell shell, DataSet[] dataSetArray, ScreenFD_SL screenFD_SL, DataSet dataSet, int n) {
        super(shell);
        this.dataSets = dataSetArray;
        this.targetDataLayout = screenFD_SL;
        this.targetDataSet = dataSet;
        this.initialSelection = n;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Set Reference Field");
    }

    protected Control createDialogArea(Composite composite) {
        TableItem tableItem;
        int n;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        this.addBtn = new Button(composite2, 8);
        this.addBtn.setText("Add");
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addAllBtn = new Button(composite2, 8);
        this.addAllBtn.setText("Add all");
        this.addAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn = new Button(composite2, 8);
        this.removeBtn.setText("Remove");
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeAllBtn = new Button(composite2, 8);
        this.removeAllBtn.setText("Remove all");
        this.removeAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dsTable = new Table(composite2, 67588);
        this.dsTable.setLinesVisible(true);
        this.dsTable.setHeaderVisible(true);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.heightHint = 150;
        gridData.horizontalSpan = 2;
        this.dsTable.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.dsTable, 0);
        tableColumn.setText("Available Data Sets");
        tableColumn.setWidth(200);
        this.refDsTable = new Table(composite2, 67588);
        this.refDsTable.setLinesVisible(true);
        this.refDsTable.setHeaderVisible(true);
        gridData = new GridData(768);
        gridData.widthHint = 600;
        gridData.heightHint = 150;
        gridData.horizontalSpan = 2;
        this.refDsTable.setLayoutData((Object)gridData);
        tableColumn = new TableColumn(this.refDsTable, 0);
        tableColumn.setText("Data Sets");
        tableColumn.setWidth(150);
        tableColumn = new TableColumn(this.refDsTable, 0);
        tableColumn.setText("Reference Field");
        tableColumn.setWidth(450);
        this.refDsTableEditor = new TableEditor(this.refDsTable);
        this.refDsTableEditor.grabHorizontal = true;
        RefDataSetInfo[] refDataSetInfoArray = this.targetDataSet.getReferencedDataSets();
        if (refDataSetInfoArray != null) {
            for (n = 0; n < refDataSetInfoArray.length; ++n) {
                tableItem = null;
                for (int i = 0; i < this.dataSets.length && tableItem == null; ++i) {
                    if (this.dataSets[i] == this.targetDataSet || !this.dataSets[i].getName().equals(refDataSetInfoArray[n].getDataSetName())) continue;
                    tableItem = this.dataSets[i];
                }
                if (tableItem == null) continue;
                this.addRefDataSetInfo(tableItem, refDataSetInfoArray[n]);
            }
        }
        for (n = 0; n < this.dataSets.length; ++n) {
            if (this.dataSets[n] == this.targetDataSet || this.searchItem(this.refDsTable, this.dataSets[n].getName())) continue;
            tableItem = new TableItem(this.dsTable, 0);
            tableItem.setText(this.dataSets[n].getName());
            tableItem.setData((Object)this.dataSets[n]);
        }
        this.refDsTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.initialSelection >= 0 && this.refDsTable.getItemCount() > this.initialSelection) {
            this.refDsTable.select(this.initialSelection);
        }
        this.updateButtonEnabledState();
        return composite2;
    }

    private void updateButtonEnabledState() {
        this.addBtn.setEnabled(this.dsTable.getItemCount() > 0);
        this.addAllBtn.setEnabled(this.dsTable.getItemCount() > 0);
        this.removeBtn.setEnabled(this.refDsTable.getItemCount() > 0);
        this.removeAllBtn.setEnabled(this.refDsTable.getItemCount() > 0);
    }

    private int[] getItemForLocation(Table table, int n, int n2) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void handleRefDsTableSelectionEvent(MouseEvent mouseEvent) {
        int[] nArray = this.getItemForLocation(this.refDsTable, mouseEvent.x, mouseEvent.y);
        if (nArray == null) {
            return;
        }
        if (nArray[1] == 1) {
            ComboEditor comboEditor = new ComboEditor();
            TableItem tableItem = this.refDsTable.getItem(nArray[0]);
            RefDataSetInfo refDataSetInfo = (RefDataSetInfo)tableItem.getData("info");
            int[] nArray2 = new int[]{0};
            String[] stringArray = new String[]{};
            if (this.targetDataLayout != null) {
                stringArray = this.getComboItems(this.targetDataLayout, nArray2);
                comboEditor.setItems(stringArray);
            }
            comboEditor.createEditor((Composite)this.refDsTable);
            MyValueListener myValueListener = new MyValueListener(stringArray, refDataSetInfo, nArray2[0], tableItem);
            comboEditor.setListener((ValueListener)myValueListener);
            this.refDsTableEditor.setEditor(comboEditor.getEditor(), tableItem, 1);
            String string = null;
            if (refDataSetInfo.getFieldName() != null && refDataSetInfo.getFieldName().length() > 0) {
                string = refDataSetInfo.getFieldName();
            } else if (refDataSetInfo.getKeyName() != null && refDataSetInfo.getKeyName().length() > 0) {
                string = refDataSetInfo.getKeyName();
            }
            if (string != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    comboEditor.setValue((Object)new Integer(i));
                    break;
                }
            }
            comboEditor.selectAll();
            comboEditor.setFocus();
        }
    }

    private String[] getComboItems(ScreenFD_SL screenFD_SL, int[] nArray) {
        VariableTypeList variableTypeList = screenFD_SL.getFdItems();
        Vector<String> vector = new Vector<String>();
        int n = variableTypeList.getSettingCount();
        for (int i = 0; i < n; ++i) {
            this.getComboItems(vector, (VariableType)variableTypeList.getSettingAt(i));
        }
        nArray[0] = vector.size();
        KeyList keyList = screenFD_SL.getFileDescriptor().getKeys();
        n = keyList.getSettingCount();
        for (int i = 0; i < n; ++i) {
            vector.addElement(((Key)keyList.getSettingAt(i)).getName());
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void getComboItems(Vector vector, VariableType variableType) {
        if (this.isRefField(variableType)) {
            vector.addElement(variableType.getName());
            int n = variableType.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getComboItems(vector, (VariableType)variableType.getChildAt(i));
            }
        }
    }

    private boolean isRefField(VariableType variableType) {
        return !variableType.isFiller() && (variableType.getLevelAsInt() == 77 || variableType.getLevelAsInt() >= 0 && variableType.getLevelAsInt() <= 45);
    }

    private boolean searchItem(Table table, String string) {
        TableItem[] tableItemArray = table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            if (!tableItemArray[i].getText(0).equals(string)) continue;
            return true;
        }
        return false;
    }

    private void removeDataSetInfo(DataSet dataSet, RefDataSetInfo refDataSetInfo) {
        this.referencedDataSets.remove(refDataSetInfo);
        TableItem tableItem = new TableItem(this.dsTable, 0);
        tableItem.setText(dataSet.getName());
        tableItem.setData((Object)dataSet);
    }

    private boolean addRefDataSetInfo(DataSet dataSet, RefDataSetInfo refDataSetInfo) {
        if (this.searchItem(this.refDsTable, dataSet.getName())) {
            return false;
        }
        TableItem tableItem = new TableItem(this.refDsTable, 0);
        tableItem.setText(0, dataSet.getName());
        String string = null;
        if (refDataSetInfo == null) {
            refDataSetInfo = new RefDataSetInfo();
            refDataSetInfo.setDataSetName(dataSet.getName());
            if (this.targetDataLayout != null) {
                KeyList keyList = this.targetDataLayout.getFileDescriptor().getKeys();
                VariableTypeList variableTypeList = this.targetDataLayout.getFdItems();
                if (keyList.getSettingCount() > 0) {
                    refDataSetInfo.setKeyName(((Key)keyList.getSettingAt(0)).getName());
                    string = refDataSetInfo.getKeyName();
                } else if (variableTypeList.getSettingCount() > 0) {
                    refDataSetInfo.setFieldName(((VariableType)variableTypeList.getSettingAt(0)).getName());
                    string = refDataSetInfo.getFieldName();
                }
            }
        } else if (refDataSetInfo.getFieldName() != null && refDataSetInfo.getFieldName().length() > 0) {
            string = refDataSetInfo.getFieldName();
        } else if (refDataSetInfo.getKeyName() != null && refDataSetInfo.getKeyName().length() > 0) {
            string = refDataSetInfo.getKeyName();
        }
        if (string != null) {
            tableItem.setText(1, string);
        }
        tableItem.setData("info", (Object)refDataSetInfo);
        tableItem.setData("dataset", (Object)dataSet);
        this.referencedDataSets.addElement(refDataSetInfo);
        return true;
    }

    public RefDataSetInfo[] openDialog() {
        if (this.open() == 0) {
            RefDataSetInfo[] refDataSetInfoArray = new RefDataSetInfo[this.referencedDataSets.size()];
            this.referencedDataSets.toArray(refDataSetInfoArray);
            return refDataSetInfoArray;
        }
        return null;
    }

    static /* synthetic */ Table access$000(ReferencedDataSetsDialog referencedDataSetsDialog) {
        return referencedDataSetsDialog.dsTable;
    }

    static /* synthetic */ boolean access$100(ReferencedDataSetsDialog referencedDataSetsDialog, DataSet dataSet, RefDataSetInfo refDataSetInfo) {
        return referencedDataSetsDialog.addRefDataSetInfo(dataSet, refDataSetInfo);
    }

    static /* synthetic */ void access$200(ReferencedDataSetsDialog referencedDataSetsDialog) {
        referencedDataSetsDialog.updateButtonEnabledState();
    }

    static /* synthetic */ Table access$300(ReferencedDataSetsDialog referencedDataSetsDialog) {
        return referencedDataSetsDialog.refDsTable;
    }

    static /* synthetic */ void access$400(ReferencedDataSetsDialog referencedDataSetsDialog, DataSet dataSet, RefDataSetInfo refDataSetInfo) {
        referencedDataSetsDialog.removeDataSetInfo(dataSet, refDataSetInfo);
    }

    static /* synthetic */ void access$500(ReferencedDataSetsDialog referencedDataSetsDialog, MouseEvent mouseEvent) {
        referencedDataSetsDialog.handleRefDsTableSelectionEvent(mouseEvent);
    }
}

