/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectionModeDialog
extends Dialog {
    private Button enabledBtn;
    private Button singleSelBtn;
    private Button singleIntSelBtn;
    private Button multiIntSelBtn;
    private Button rowBtn;
    private Button colBtn;
    private Button cellBtn;
    private int value;

    public SelectionModeDialog(Shell shell, String string) {
        super(shell);
        try {
            this.value = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Selection mode settings");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.enabledBtn = new Button(composite2, 32);
        this.enabledBtn.setText("Enabled");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.enabledBtn.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        gridLayout.horizontalSpacing = 100;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        group.setText("Selection Mode");
        this.singleSelBtn = new Button((Composite)group, 16);
        this.singleSelBtn.setText("Single Selection");
        this.singleSelBtn.setData((Object)new Integer(1));
        this.singleIntSelBtn = new Button((Composite)group, 16);
        this.singleIntSelBtn.setText("Single Interval Selection");
        this.singleIntSelBtn.setData((Object)new Integer(2));
        this.multiIntSelBtn = new Button((Composite)group, 16);
        this.multiIntSelBtn.setText("Multiple Interval Selection");
        this.multiIntSelBtn.setData((Object)new Integer(4));
        Group group2 = new Group(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        gridLayout.marginLeft = 20;
        gridLayout.marginRight = 20;
        gridLayout.horizontalSpacing = 100;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        group2.setLayoutData((Object)gridData);
        group2.setText("Selection Option");
        this.rowBtn = new Button((Composite)group2, 32);
        this.rowBtn.setText("Row Selection");
        this.rowBtn.setData((Object)new Integer(8));
        this.colBtn = new Button((Composite)group2, 32);
        this.colBtn.setText("Column Selection");
        this.colBtn.setData((Object)new Integer(16));
        this.cellBtn = new Button((Composite)group2, 32);
        this.cellBtn.setText("Cell Selection");
        this.cellBtn.setData((Object)new Integer(32));
        this.setSelectionModeEnabled(this.value > 0);
        if ((this.value & 2) == 2) {
            this.singleIntSelBtn.setSelection(true);
        } else if ((this.value & 4) == 4) {
            this.multiIntSelBtn.setSelection(true);
        } else {
            this.singleSelBtn.setSelection(true);
        }
        if ((this.value & 0x20) == 32) {
            this.cellBtn.setSelection(true);
        }
        if ((this.value & 8) == 8) {
            this.rowBtn.setSelection(true);
        }
        if ((this.value & 0x10) == 16) {
            this.colBtn.setSelection(true);
        }
        this.enabledBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void setSelectionModeEnabled(boolean bl) {
        this.enabledBtn.setSelection(bl);
        this.singleSelBtn.setEnabled(bl);
        this.singleIntSelBtn.setEnabled(bl);
        this.multiIntSelBtn.setEnabled(bl);
        this.rowBtn.setEnabled(bl);
        this.colBtn.setEnabled(bl);
        this.cellBtn.setEnabled(bl);
    }

    public void okPressed() {
        this.value = 0;
        if (this.enabledBtn.getSelection()) {
            for (Button button : new Button[]{this.singleSelBtn, this.singleIntSelBtn, this.multiIntSelBtn, this.rowBtn, this.colBtn, this.cellBtn}) {
                if (!button.getSelection()) continue;
                this.value += ((Integer)button.getData()).intValue();
            }
        }
        super.okPressed();
    }

    public String openDialog() {
        if (this.open() != 0) {
            return null;
        }
        return Integer.toString(this.value);
    }

    static /* synthetic */ Button access$000(SelectionModeDialog selectionModeDialog) {
        return selectionModeDialog.enabledBtn;
    }

    static /* synthetic */ void access$100(SelectionModeDialog selectionModeDialog, boolean bl) {
        selectionModeDialog.setSelectionModeEnabled(bl);
    }
}

