/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SortTypeDialog
extends Dialog {
    private final String[][] typesAndValues = new String[][]{{"None", ""}, {"Alphanumeric sorting, case-insensitive", "X"}, {"Alphanumeric sorting, case-sensitive", "U"}, {"Numeric sorting", "9"}, {"Integer sorting", "I"}, {"Positive integer sorting", "P"}, {"Date sorting", "D"}};
    private static final String[] dataMasks = new String[]{"MDY", "DMY", "YMD"};
    private CCombo orderCmb;
    private CCombo typeCmb;
    private CCombo dataMaskCmb;
    private String value;
    private Label dataMaskLbl;

    public SortTypeDialog(Shell shell, String string) {
        super(shell);
        this.value = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Sort-Type settings");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Type:");
        this.typeCmb = new CCombo(composite2, 2056);
        for (int i = 0; i < this.typesAndValues.length; ++i) {
            this.typeCmb.add(this.typesAndValues[i][0]);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.typeCmb.setLayoutData((Object)gridData);
        this.dataMaskLbl = new Label(composite2, 0);
        this.dataMaskLbl.setText("Data mask:");
        this.dataMaskCmb = new CCombo(composite2, 2056);
        this.dataMaskCmb.setItems(dataMasks);
        this.dataMaskCmb.setEnabled(false);
        label = new Label(composite2, 0);
        label.setText("Order:");
        this.orderCmb = new CCombo(composite2, 2056);
        this.orderCmb.setItems(new String[]{"Ascending", "Descending"});
        gridData = new GridData(768);
        this.orderCmb.setLayoutData((Object)gridData);
        boolean bl = false;
        int n = 0;
        String string = this.value;
        string = string != null ? string.toUpperCase() : "";
        if (string.length() == 0 || string.charAt(0) == 'A' || string.charAt(0) == 'Z' || string.charAt(0) == '-') {
            this.typeCmb.select(0);
            this.dataMaskCmb.select(0);
            this.orderCmb.select(0);
        } else {
            block0 : switch (string.charAt(0)) {
                case 'X': {
                    this.typeCmb.select(1);
                    break;
                }
                case 'L': 
                case 'U': {
                    this.typeCmb.select(2);
                    break;
                }
                case '9': 
                case 'N': {
                    this.typeCmb.select(3);
                    break;
                }
                case 'I': {
                    this.typeCmb.select(4);
                    break;
                }
                case 'P': {
                    this.typeCmb.select(5);
                    break;
                }
                case 'D': 
                case 'E': {
                    int n2;
                    this.typeCmb.select(6);
                    bl = true;
                    int n3 = string.indexOf(40);
                    if (n3 <= 0 || (n2 = string.indexOf(41, n3 + 1)) <= n3) break;
                    String string2 = string.substring(n3, n2);
                    for (int i = 0; i < dataMasks.length; ++i) {
                        if (!dataMasks[i].equals(string2)) continue;
                        n = i;
                        break block0;
                    }
                    break;
                }
                default: {
                    this.typeCmb.select(0);
                }
            }
            if (string.indexOf(94) >= 0) {
                this.orderCmb.select(1);
            } else {
                this.orderCmb.select(0);
            }
        }
        this.setDataMaskEnabled(bl);
        this.dataMaskCmb.select(n);
        this.typeCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void setDataMaskEnabled(boolean bl) {
        this.dataMaskLbl.setEnabled(bl);
        this.dataMaskCmb.setEnabled(bl);
    }

    public void okPressed() {
        int n = this.typeCmb.getSelectionIndex();
        if (n > 0) {
            this.value = this.typesAndValues[n][1];
            if (this.orderCmb.getSelectionIndex() == 1) {
                this.value = this.value + "^";
            }
            if (n == 6) {
                this.value = this.value + "(" + this.dataMaskCmb.getText() + ")";
            }
        } else {
            this.value = "-";
        }
        super.okPressed();
    }

    public String openDialog() {
        if (this.open() != 0) {
            return null;
        }
        return this.value;
    }

    static /* synthetic */ CCombo access$000(SortTypeDialog sortTypeDialog) {
        return sortTypeDialog.typeCmb;
    }

    static /* synthetic */ void access$100(SortTypeDialog sortTypeDialog, boolean bl) {
        sortTypeDialog.setDataMaskEnabled(bl);
    }
}

