/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.dialogs;

import com.iscobol.plugins.editor.util.TreeStructuredData;
import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.dialogs.TabOrderDialog;
import com.iscobol.screenpainter.model.WindowModel;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TabOrderDialog
extends Dialog {
    private static final String TOOLBARS = "Tool-Bars";
    private static final String SCREEN = "Screen";
    private ToolItem up;
    private ToolItem down;
    private ToolItem top;
    private ToolItem bottom;
    private ToolBar toolbar;
    private Tree tree;
    private WindowModel windowModel;
    private TreeStructuredData elementTree = new TreeStructuredData();
    private Listener listener;
    private boolean dndAllowed;
    private ScreenElement initialSelection;

    public TabOrderDialog(Shell shell, WindowModel windowModel, ScreenElement screenElement, Listener listener) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x20 | 0x40);
        this.windowModel = windowModel;
        this.listener = listener;
        this.initialSelection = screenElement;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ISPBundle.getString((String)"tab_order_title"));
        shell.setSize(500, 600);
    }

    private void setInitialSelection() {
        if (this.initialSelection == null) {
            return;
        }
        this.setInitialSelection(this.tree.getItems());
        this.treeSelectionChanged();
    }

    private boolean setInitialSelection(TreeItem[] treeItemArray) {
        for (TreeItem treeItem : treeItemArray) {
            TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
            if (treeStructuredData.getData() == this.initialSelection) {
                this.tree.setSelection(treeItem);
                return true;
            }
            if (!this.setInitialSelection(treeItem.getItems())) continue;
            return true;
        }
        return false;
    }

    private boolean areContiguousItems(TreeItem[] treeItemArray) {
        TreeItem treeItem = treeItemArray[0].getParentItem();
        for (int i = 1; i < treeItemArray.length; ++i) {
            if (!(treeItem != null ? treeItem.indexOf(treeItemArray[i]) > treeItem.indexOf(treeItemArray[i - 1]) + 1 : this.tree.indexOf(treeItemArray[i]) > this.tree.indexOf(treeItemArray[i - 1]) + 1)) continue;
            return false;
        }
        return true;
    }

    private int indexOf(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        return treeItem2 != null ? treeItem2.indexOf(treeItem) : this.tree.indexOf(treeItem);
    }

    private TreeItem getItemBefore(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        return treeItem2 != null ? treeItem2.getItem(treeItem2.indexOf(treeItem) - 1) : this.tree.getItem(this.tree.indexOf(treeItem) - 1);
    }

    private TreeItem getItemAfter(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        return treeItem2 != null ? treeItem2.getItem(treeItem2.indexOf(treeItem) + 1) : this.tree.getItem(this.tree.indexOf(treeItem) + 1);
    }

    private TreeItem getSiblingAt(TreeItem treeItem, int n) {
        TreeItem treeItem2 = treeItem.getParentItem();
        return treeItem2 != null ? treeItem2.getItem(n) : this.tree.getItem(n);
    }

    private int getItemCount(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.getParentItem();
        return treeItem2 != null ? treeItem2.getItemCount() : this.tree.getItemCount();
    }

    protected Control createDialogArea(Composite composite) {
        IToolbar[] iToolbarArray;
        TreeItem treeItem;
        TreeStructuredData treeStructuredData;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.toolbar = new ToolBar(composite2, 8519936);
        GridData gridData = new GridData(768);
        this.toolbar.setLayoutData((Object)gridData);
        this.top = new ToolItem(this.toolbar, 8);
        this.top.setToolTipText("Top");
        this.top.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_top.png"));
        this.up = new ToolItem(this.toolbar, 8);
        this.up.setToolTipText("Up");
        this.up.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_up.png"));
        this.down = new ToolItem(this.toolbar, 8);
        this.down.setToolTipText("Down");
        this.down.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_down.png"));
        this.bottom = new ToolItem(this.toolbar, 8);
        this.bottom.setToolTipText("Bottom");
        this.bottom.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/move_bottom.png"));
        this.tree = new Tree(composite2, 2562);
        gridData = new GridData(1808);
        this.tree.setLayoutData((Object)gridData);
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        this.top.setEnabled(false);
        this.bottom.setEnabled(false);
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.windowModel.getTarget();
        if (abstractBeanWindow.getToolbarCount() > 0) {
            treeStructuredData = new TreeStructuredData((Object)TOOLBARS);
            this.elementTree.addItem(treeStructuredData);
            treeItem = new TreeItem(this.tree, 0);
            treeItem.setText(TOOLBARS);
            treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/toolbarlist.png"));
            treeItem.setData((Object)treeStructuredData);
            iToolbarArray = abstractBeanWindow.getToolbars();
            this.addItems((ScreenElement[])iToolbarArray, treeStructuredData, treeItem, new int[1]);
        }
        treeStructuredData = new TreeStructuredData((Object)SCREEN);
        this.elementTree.addItem(treeStructuredData);
        treeItem = new TreeItem(this.tree, 0);
        treeItem.setText(SCREEN);
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/componentlist.png"));
        treeItem.setData((Object)treeStructuredData);
        iToolbarArray = abstractBeanWindow.getComponents();
        this.addItems((ScreenElement[])iToolbarArray, treeStructuredData, treeItem, new int[1]);
        this.setInitialSelection();
        this.up.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.down.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.top.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.bottom.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        boolean[] blArray = new boolean[1];
        DragSource dragSource = new DragSource((Control)this.tree, 2);
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        Transfer[] transferArray = new Transfer[]{localSelectionTransfer};
        dragSource.setTransfer(transferArray);
        dragSource.addDragListener((DragSourceListener)new /* Unavailable Anonymous Inner Class!! */);
        DropTarget dropTarget = new DropTarget((Control)this.tree, 2);
        dropTarget.setTransfer(transferArray);
        DropTargetEffect dropTargetEffect = new DropTargetEffect((Control)this.tree);
        dropTarget.addDropListener((DropTargetListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void swapItems(TreeItem treeItem, TreeItem treeItem2) {
        TreeStructuredData treeStructuredData = (TreeStructuredData)treeItem.getData();
        TreeStructuredData treeStructuredData2 = (TreeStructuredData)treeItem2.getData();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TreeItem treeItem3 = treeItem.getParentItem(); treeItem3 != null; treeItem3 = treeItem3.getParentItem()) {
            arrayList.add(0, this.indexOf(treeItem3));
        }
        int n = this.indexOf(treeItem);
        treeItem.setText(this.getItemText((ScreenElement)treeStructuredData2.getData(), n + 1));
        treeItem.setImage(this.getItemImage((ScreenElement)treeStructuredData2.getData()));
        int n2 = this.indexOf(treeItem2);
        treeItem2.setText(this.getItemText((ScreenElement)treeStructuredData.getData(), n2 + 1));
        treeItem2.setImage(this.getItemImage((ScreenElement)treeStructuredData.getData()));
        treeItem.setData((Object)treeStructuredData2);
        treeItem2.setData((Object)treeStructuredData);
        treeItem.removeAll();
        this.addItems(treeStructuredData2, treeItem);
        treeItem2.removeAll();
        this.addItems(treeStructuredData, treeItem2);
        if (this.listener != null) {
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            this.listener.swapped(nArray, n, n2);
        }
    }

    private void addItems(ScreenElement[] screenElementArray, TreeStructuredData treeStructuredData, TreeItem treeItem, int[] nArray) {
        for (ScreenElement screenElement : screenElementArray) {
            TreeStructuredData treeStructuredData2 = new TreeStructuredData((Object)screenElement);
            treeStructuredData.addItem(treeStructuredData2);
            if (screenElement instanceof GroupBeanControl) {
                this.addItems((ScreenElement[])((GroupBeanControl)screenElement).getComponents(), treeStructuredData2, treeItem, nArray);
                continue;
            }
            nArray[0] = nArray[0] + 1;
            String string = this.getItemText(screenElement, nArray[0]);
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setText(string);
            treeItem2.setImage(this.getItemImage(screenElement));
            treeItem2.setData((Object)treeStructuredData2);
            if (screenElement instanceof AbstractTabbedPane) {
                this.addItems((ScreenElement[])((AbstractTabbedPane)screenElement).getPages(), treeStructuredData2, treeItem2, new int[1]);
                continue;
            }
            if (!(screenElement instanceof ComponentsContainer)) continue;
            this.addItems((ScreenElement[])((ComponentsContainer)screenElement).getComponents(), treeStructuredData2, treeItem2, new int[1]);
        }
    }

    private void addItems(TreeStructuredData<ScreenElement> treeStructuredData, TreeItem treeItem) {
        int n = 1;
        for (TreeStructuredData treeStructuredData2 : treeStructuredData.getItems()) {
            TreeItem treeItem2 = new TreeItem(treeItem, 0);
            treeItem2.setText(this.getItemText((ScreenElement)treeStructuredData2.getData(), n++));
            treeItem2.setImage(this.getItemImage((ScreenElement)treeStructuredData2.getData()));
            treeItem2.setData((Object)treeStructuredData2);
            this.addItems(treeStructuredData2, treeItem2);
        }
    }

    private String getItemText(ScreenElement screenElement, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append(": ");
        stringBuilder.append(screenElement.getName());
        stringBuilder.append(" (");
        stringBuilder.append(IscobolBeanConstants.getTypeName((int)screenElement.getType()));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private Image getItemImage(ScreenElement screenElement) {
        String string = IscobolBeanConstants.getImageName((int)screenElement.getType());
        if (string != null) {
            return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage(string);
        }
        return null;
    }

    public boolean openDialog() {
        return this.open() == 0;
    }

    private void treeSelectionChanged() {
        TreeItem[] treeItemArray = this.tree.getSelection();
        TreeItem treeItem = null;
        boolean bl = true;
        boolean bl2 = true;
        this.dndAllowed = true;
        if (treeItemArray.length > 0 && this.areContiguousItems(treeItemArray)) {
            for (int i = 0; i < treeItemArray.length; ++i) {
                if (i == 0) {
                    treeItem = treeItemArray[i].getParentItem();
                    if (treeItem != null) continue;
                    bl = false;
                    bl2 = false;
                    this.dndAllowed = false;
                } else {
                    if (treeItemArray[i].getParentItem() == treeItem) continue;
                    bl = false;
                    bl2 = false;
                    this.dndAllowed = false;
                }
                break;
            }
        } else {
            bl = false;
            bl2 = false;
            this.dndAllowed = false;
        }
        bl = bl && this.indexOf(treeItemArray[0]) > 0;
        bl2 = bl2 && this.indexOf(treeItemArray[treeItemArray.length - 1]) < this.getItemCount(treeItemArray[0]) - 1;
        this.up.setEnabled(bl);
        this.top.setEnabled(bl);
        this.down.setEnabled(bl2);
        this.bottom.setEnabled(bl2);
    }

    private void up(TreeItem[] treeItemArray) {
        if (treeItemArray.length > 0) {
            if (treeItemArray.length == 1) {
                int n = this.indexOf(treeItemArray[0]);
                if (n > 0) {
                    TreeItem treeItem = this.getItemBefore(treeItemArray[0]);
                    this.swapItems(treeItemArray[0], treeItem);
                    this.tree.setSelection(treeItem);
                    this.treeSelectionChanged();
                }
            } else {
                int n = this.indexOf(treeItemArray[0]);
                if (n > 0) {
                    for (int i = 0; i < treeItemArray.length; ++i) {
                        this.swapItems(treeItemArray[i], this.getItemBefore(treeItemArray[i]));
                    }
                    TreeItem[] treeItemArray2 = new TreeItem[treeItemArray.length];
                    int n2 = this.indexOf(treeItemArray[0]) - 1;
                    for (int i = 0; i < treeItemArray.length; ++i) {
                        treeItemArray2[i] = this.getSiblingAt(treeItemArray[0], n2++);
                    }
                    this.tree.setSelection(treeItemArray2);
                    this.treeSelectionChanged();
                }
            }
        }
    }

    private void down(TreeItem[] treeItemArray) {
        if (treeItemArray.length > 0) {
            if (treeItemArray.length == 1) {
                int n = this.indexOf(treeItemArray[0]);
                if (n < this.getItemCount(treeItemArray[0]) - 1) {
                    TreeItem treeItem = this.getItemAfter(treeItemArray[0]);
                    this.swapItems(treeItemArray[0], treeItem);
                    this.tree.setSelection(treeItem);
                    this.treeSelectionChanged();
                }
            } else if (this.indexOf(treeItemArray[treeItemArray.length - 1]) < this.getItemCount(treeItemArray[0]) - 1) {
                for (int i = treeItemArray.length - 1; i >= 0; --i) {
                    this.swapItems(treeItemArray[i], this.getItemAfter(treeItemArray[i]));
                }
                TreeItem[] treeItemArray2 = new TreeItem[treeItemArray.length];
                int n = this.indexOf(treeItemArray[0]) + 1;
                for (int i = 0; i < treeItemArray.length; ++i) {
                    treeItemArray2[i] = this.getSiblingAt(treeItemArray[0], n++);
                }
                this.tree.setSelection(treeItemArray2);
                this.treeSelectionChanged();
            }
        }
    }

    static /* synthetic */ Tree access$000(TabOrderDialog tabOrderDialog) {
        return tabOrderDialog.tree;
    }

    static /* synthetic */ void access$100(TabOrderDialog tabOrderDialog, TreeItem[] treeItemArray) {
        tabOrderDialog.up(treeItemArray);
    }

    static /* synthetic */ void access$200(TabOrderDialog tabOrderDialog, TreeItem[] treeItemArray) {
        tabOrderDialog.down(treeItemArray);
    }

    static /* synthetic */ int access$300(TabOrderDialog tabOrderDialog, TreeItem treeItem) {
        return tabOrderDialog.indexOf(treeItem);
    }

    static /* synthetic */ int access$400(TabOrderDialog tabOrderDialog, TreeItem treeItem) {
        return tabOrderDialog.getItemCount(treeItem);
    }

    static /* synthetic */ void access$500(TabOrderDialog tabOrderDialog) {
        tabOrderDialog.treeSelectionChanged();
    }

    static /* synthetic */ boolean access$600(TabOrderDialog tabOrderDialog) {
        return tabOrderDialog.dndAllowed;
    }
}

