/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.findinobject;

import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.findinobject.AbstractFindInObjectQuery;
import com.iscobol.plugins.editor.findinobject.FindInObjectMatchReference;
import com.iscobol.plugins.editor.findinobject.FindInObjectResult;
import com.iscobol.plugins.editor.findinobject.IFindInObjectHelper;
import com.iscobol.plugins.editor.views.IscobolProgramAdapter;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportSection;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanStatusbar;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.FDAttributes;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.beans.types.XFDAttributes;
import com.iscobol.screenpainter.findinobject.FindInObjectMatch;
import com.iscobol.screenpainter.findinobject.FindInObjectUtilities;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.VariableSettingsContentPane;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.DataSetAdapter;
import com.iscobol.screenpainter.util.adapters.EventParagraphsAdapter;
import com.iscobol.screenpainter.util.adapters.FDAdapter;
import com.iscobol.screenpainter.util.adapters.FDEventParagraphsAdapter;
import com.iscobol.screenpainter.util.adapters.FDListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.FileListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.FileSectionAdapter;
import com.iscobol.screenpainter.util.adapters.LinkageSectionAdapter;
import com.iscobol.screenpainter.util.adapters.ProgramListWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ProjectWorkbenchAdapter;
import com.iscobol.screenpainter.util.adapters.ReportAdapter;
import com.iscobol.screenpainter.util.adapters.ReportListAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionAdapter;
import com.iscobol.screenpainter.util.adapters.ScreenSectionListAdapter;
import com.iscobol.screenpainter.util.adapters.WorkingStorageAdapter;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.ISearchResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class FindInObjectQuery
extends AbstractFindInObjectQuery {
    private FindInObjectResult result = new FindInObjectResult((AbstractFindInObjectQuery)this);

    public FindInObjectQuery() {
    }

    public FindInObjectQuery(Object object, String string, boolean bl, boolean bl2, boolean bl3) {
        super(object, string, bl, bl2, bl3);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Find '");
        stringBuilder.append(this.searchText);
        stringBuilder.append("' in ");
        stringBuilder.append(FindInObjectUtilities.getLabelFor((Object)this.searchTarget));
        int n = 0;
        if (this.matchCase) {
            if (n == 0) {
                stringBuilder.append(" (");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("match case");
            ++n;
        }
        if (this.wholeWord) {
            if (n == 0) {
                stringBuilder.append(" (");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("whole word");
            ++n;
        }
        if (this.findPropName) {
            if (n == 0) {
                stringBuilder.append(" (");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("find property name");
            ++n;
        }
        if (n > 0) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        this.matches.removeAllElements();
        try {
            this.findInObject(iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        this.result.setMatches(this.matches);
        return Status.OK_STATUS;
    }

    private void findInObject(IProgressMonitor iProgressMonitor) {
        if (this.searchTarget instanceof IProject) {
            this.findInProject((IProject)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof IFolder) {
            this.findInContainer((IContainer)((IFolder)this.searchTarget), iProgressMonitor);
        } else if (this.searchTarget instanceof IFile) {
            this.findInFile((IFile)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof ProgramListWorkbenchAdapter) {
            this.findInProgramList((ProgramListWorkbenchAdapter)this.searchTarget, iProgressMonitor, this.getLabel());
        } else if (this.searchTarget instanceof ScreenProgramAdapter) {
            this.findInScreenProgram((ScreenProgramAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof FDListWorkbenchAdapter) {
            this.findInFDList((FDListWorkbenchAdapter)this.searchTarget, iProgressMonitor, this.getLabel());
        } else if (this.searchTarget instanceof FileListWorkbenchAdapter) {
            this.findInFileList((FileListWorkbenchAdapter)this.searchTarget, iProgressMonitor, this.getLabel());
        } else if (this.searchTarget instanceof ProjectWorkbenchAdapter) {
            this.findInProject((ProjectWorkbenchAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof FDAdapter) {
            this.findInFD((FDAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof DataSetAdapter) {
            DataSetAdapter dataSetAdapter = (DataSetAdapter)this.searchTarget;
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DATASET, dataSetAdapter.getScreenProgram().getFileSection().findDataSet(dataSetAdapter.getDataSet().getName()), "")};
            this.findInDataSet((DataSetAdapter)this.searchTarget, findInObjectMatchReferenceArray, iProgressMonitor);
        } else if (this.searchTarget instanceof ScreenSectionAdapter) {
            ScreenSectionAdapter screenSectionAdapter = (ScreenSectionAdapter)this.searchTarget;
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_SCREEN, screenSectionAdapter.getScreenProgram().findScreenSection(screenSectionAdapter.getWindow().getName()), "")};
            this.findInScreenSection((ScreenSectionAdapter)this.searchTarget, findInObjectMatchReferenceArray, iProgressMonitor);
        } else if (this.searchTarget instanceof ScreenSectionListAdapter) {
            this.findInScreenSectionList((ScreenSectionListAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof ReportAdapter) {
            ReportAdapter reportAdapter = (ReportAdapter)this.searchTarget;
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT, reportAdapter.getScreenProgram().findReport(reportAdapter.getReport().getName()), "")};
            this.findInReport((ReportAdapter)this.searchTarget, findInObjectMatchReferenceArray, iProgressMonitor);
        } else if (this.searchTarget instanceof ReportListAdapter) {
            this.findInReportList((ReportListAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof LinkageSectionAdapter) {
            this.findInLinkageSection((LinkageSectionAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof WorkingStorageAdapter) {
            this.findInWorkingStorage((WorkingStorageAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof FileSectionAdapter) {
            this.findInFileSection((FileSectionAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof EventParagraphsAdapter) {
            this.findInEventParagraphs((EventParagraphsAdapter)this.searchTarget, iProgressMonitor);
        } else if (this.searchTarget instanceof FDEventParagraphsAdapter) {
            this.findInFDEventParagraphs((FDEventParagraphsAdapter)this.searchTarget, iProgressMonitor);
        } else {
            for (IFindInObjectHelper iFindInObjectHelper : IscobolEditorPlugin.getDefault().getFindInObjectHelpers()) {
                if (iFindInObjectHelper.findInObject(this.searchTarget, (AbstractFindInObjectQuery)this, iProgressMonitor)) break;
            }
        }
    }

    private void findInProgramList(ProgramListWorkbenchAdapter programListWorkbenchAdapter, IProgressMonitor iProgressMonitor, String string) {
        Object[] objectArray = programListWorkbenchAdapter.getChildren();
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(string, objectArray.length);
        }
        for (Object object : objectArray) {
            this.checkMonitor(iProgressMonitor);
            if (object instanceof ScreenProgramAdapter) {
                IFindInObjectHelper[] iFindInObjectHelperArray = (IFindInObjectHelper[])object;
                if (iProgressMonitor != null) {
                    iProgressMonitor.subTask("Find in " + FindInObjectUtilities.getLabelFor((Object)iFindInObjectHelperArray));
                }
                this.findInScreenProgram((ScreenProgramAdapter)iFindInObjectHelperArray, iProgressMonitor);
            } else if (object instanceof IscobolProgramAdapter) {
                for (IFindInObjectHelper iFindInObjectHelper : IscobolEditorPlugin.getDefault().getFindInObjectHelpers()) {
                    if (iFindInObjectHelper.findInProgram((IscobolProgramAdapter)object, (AbstractFindInObjectQuery)this, iProgressMonitor)) break;
                }
            }
            if (iProgressMonitor == null) continue;
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void findInProject(ProjectWorkbenchAdapter projectWorkbenchAdapter, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(this.getLabel(), 3);
        }
        this.checkMonitor(iProgressMonitor);
        this.findInProgramList(projectWorkbenchAdapter.getProgramList(), (IProgressMonitor)(iProgressMonitor != null ? new SubProgressMonitor(iProgressMonitor, 1) : iProgressMonitor), "Find in " + projectWorkbenchAdapter.getProgramList().getLabel());
        this.checkMonitor(iProgressMonitor);
        this.findInFDList(projectWorkbenchAdapter.getFdList(), (IProgressMonitor)(iProgressMonitor != null ? new SubProgressMonitor(iProgressMonitor, 1) : iProgressMonitor), "Find in " + projectWorkbenchAdapter.getFdList().getLabel());
        this.checkMonitor(iProgressMonitor);
        this.findInFileList(projectWorkbenchAdapter.getFileList(), (IProgressMonitor)(iProgressMonitor != null ? new SubProgressMonitor(iProgressMonitor, 1) : iProgressMonitor), "Find in " + projectWorkbenchAdapter.getFileList().getLabel());
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void checkMonitor(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void findInScreenProgram(ScreenProgramAdapter screenProgramAdapter, IProgressMonitor iProgressMonitor) {
        this.findInScreenSectionList(screenProgramAdapter.getScreenList(), iProgressMonitor);
        this.findInReportList(screenProgramAdapter.getReportList(), iProgressMonitor);
        this.findInWorkingStorage(screenProgramAdapter.getWorking(), iProgressMonitor);
        this.findInLinkageSection(screenProgramAdapter.getLinkage(), iProgressMonitor);
        this.findInFileSection(screenProgramAdapter.getFileSection(), iProgressMonitor);
        this.findInEventParagraphs(screenProgramAdapter.getEventPar(), iProgressMonitor);
    }

    private void findInScreenSection(ScreenSectionAdapter screenSectionAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        FindInObjectMatchReference findInObjectMatchReference;
        AbstractBeanWindow abstractBeanWindow = screenSectionAdapter.getWindow();
        this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanWindow, findInObjectMatchReferenceArray, null, iProgressMonitor);
        AbstractBeanControl[] abstractBeanControlArray = abstractBeanWindow.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
            this.findInComponent(screenSectionAdapter, abstractBeanControlArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
        IToolbar[] iToolbarArray = abstractBeanWindow.getToolbars();
        for (int i = 0; i < iToolbarArray.length; ++i) {
            findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_TOOLBAR, i, "");
            if (iToolbarArray[i] instanceof AbstractBeanToolbar) {
                this.findInToolbar(screenSectionAdapter, (AbstractBeanToolbar)iToolbarArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
                continue;
            }
            this.findInRibbon(screenSectionAdapter, (AbstractRibbon)iToolbarArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
        Menu[] menuArray = abstractBeanWindow.getMenus();
        for (int i = 0; i < menuArray.length; ++i) {
            findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_MENU, i, "");
            this.findInMenu(screenSectionAdapter, menuArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
        AbstractBeanStatusbar abstractBeanStatusbar = abstractBeanWindow.getStatusbar();
        if (abstractBeanStatusbar != null) {
            findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_STATUSBAR, 0, "");
            this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanStatusbar, FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), null, iProgressMonitor);
        }
    }

    private void findInReport(ReportAdapter reportAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        Report report = reportAdapter.getReport();
        this.findInJavaBean(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, (Object)report, findInObjectMatchReferenceArray, null, iProgressMonitor);
        ReportSection[] reportSectionArray = report.getAllSections();
        for (int i = 0; i < reportSectionArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT_SECTION, i, "");
            this.findInReportSection(reportAdapter, reportSectionArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void findInReportSection(ReportAdapter reportAdapter, ReportSection reportSection, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, (Object)reportSection, findInObjectMatchReferenceArray, null, iProgressMonitor);
        ReportControl[] reportControlArray = reportSection.getComponents();
        for (int i = 0; i < reportControlArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT_COMPONENT, i, "");
            this.findInReportComponent(reportAdapter, reportControlArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void findInToolbar(ScreenSectionAdapter screenSectionAdapter, AbstractBeanToolbar abstractBeanToolbar, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanToolbar, findInObjectMatchReferenceArray, null, iProgressMonitor);
        AbstractBeanControl[] abstractBeanControlArray = abstractBeanToolbar.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
            this.findInComponent(screenSectionAdapter, abstractBeanControlArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void findInRibbon(ScreenSectionAdapter screenSectionAdapter, AbstractRibbon abstractRibbon, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractRibbon, findInObjectMatchReferenceArray, null, iProgressMonitor);
        TabPage[] tabPageArray = abstractRibbon.getPages();
        for (int i = 0; i < tabPageArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PAGE, i, "");
            this.findInTabPage(screenSectionAdapter, tabPageArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void findInMenu(ScreenSectionAdapter screenSectionAdapter, Menu menu, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)menu, findInObjectMatchReferenceArray, null, iProgressMonitor);
    }

    private void findInTabPage(ScreenSectionAdapter screenSectionAdapter, TabPage tabPage, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)tabPage, findInObjectMatchReferenceArray, null, iProgressMonitor);
        AbstractBeanControl[] abstractBeanControlArray = tabPage.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
            this.findInComponent(screenSectionAdapter, abstractBeanControlArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
        }
    }

    private void findInReportComponent(ReportAdapter reportAdapter, ReportControl reportControl, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(reportAdapter.getProgramFile(), (IscobolWorkbenchAdapter)reportAdapter, (Object)reportControl, findInObjectMatchReferenceArray, null, iProgressMonitor);
    }

    private void findInComponent(ScreenSectionAdapter screenSectionAdapter, AbstractBeanControl abstractBeanControl, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        block3: {
            block2: {
                this.findInJavaBean(screenSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)screenSectionAdapter, (Object)abstractBeanControl, findInObjectMatchReferenceArray, null, iProgressMonitor);
                if (!(abstractBeanControl instanceof AbstractTabbedPane)) break block2;
                TabPage[] tabPageArray = ((AbstractTabbedPane)abstractBeanControl).getPages();
                for (int i = 0; i < tabPageArray.length; ++i) {
                    FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PAGE, i, "");
                    this.findInTabPage(screenSectionAdapter, tabPageArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
                }
                break block3;
            }
            if (!(abstractBeanControl instanceof ComponentsContainer)) break block3;
            AbstractBeanControl[] abstractBeanControlArray = ((ComponentsContainer)abstractBeanControl).getComponents();
            for (int i = 0; i < abstractBeanControlArray.length; ++i) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_COMPONENT, i, "");
                this.findInComponent(screenSectionAdapter, abstractBeanControlArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), iProgressMonitor);
            }
        }
    }

    private void findInSettingList(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, SettingItemList settingItemList, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        SettingItem[] settingItemArray = new SettingItem[settingItemList.getSettingCount()];
        settingItemList.toArray(settingItemArray);
        for (int i = 0; i < settingItemArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            String string2 = string == null ? settingItemArray[i].toString() : string + ":" + settingItemArray[i].toString();
            this.findInSettingItem(iFile, iscobolWorkbenchAdapter, settingItemArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), string2, iProgressMonitor);
        }
    }

    private void findInArray(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, Object[] objectArray, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        for (int i = 0; i < objectArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            String string2 = string == null ? objectArray[i].toString() : string + ":" + objectArray[i].toString();
            this.findInJavaBean(iFile, iscobolWorkbenchAdapter, objectArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), string2, iProgressMonitor);
        }
    }

    private void findInSettingItem(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, SettingItem settingItem, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(iFile, iscobolWorkbenchAdapter, (Object)settingItem, findInObjectMatchReferenceArray, string, iProgressMonitor);
        if (settingItem instanceof SettingTreeItem) {
            SettingTreeItem settingTreeItem = (SettingTreeItem)settingItem;
            SettingTreeItem[] settingTreeItemArray = settingTreeItem.getChildren();
            for (int i = 0; i < settingTreeItemArray.length; ++i) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
                this.findInSettingItem(iFile, iscobolWorkbenchAdapter, (SettingItem)settingTreeItemArray[i], FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), settingTreeItemArray[i].toString(), iProgressMonitor);
            }
        }
    }

    private void findInJavaBean(IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter, Object object, FindInObjectMatchReference[] findInObjectMatchReferenceArray, String string, IProgressMonitor iProgressMonitor) {
        PropertyDescriptor[] propertyDescriptorArray = PropertyDescriptorRegistry.getJPropertyDescriptors(object.getClass());
        String string2 = this.searchText;
        if (!this.matchCase) {
            string2 = string2.toLowerCase();
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference;
            if (IscobolBeanConstants.isHiddenProperty((String)propertyDescriptorArray[i].getName())) continue;
            String string3 = null;
            Object object2 = FindInObjectQuery.getPropValue((PropertyDescriptor)propertyDescriptorArray[i], (Object)object);
            if (object2 instanceof SettingItemList) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, propertyDescriptorArray[i].getName());
                this.findInSettingList(iFile, iscobolWorkbenchAdapter, (SettingItemList)object2, FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), "[" + FindInObjectUtilities.getLabelFor((Object)object) + "]", iProgressMonitor);
            } else if (object2 instanceof Object[]) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, propertyDescriptorArray[i].getName());
                this.findInArray(iFile, iscobolWorkbenchAdapter, (Object[])object2, FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), "[" + FindInObjectUtilities.getLabelFor((Object)object) + "]", iProgressMonitor);
            } else if (object2 instanceof XFDAttributes) {
                findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_EFD_ATTR, 0, propertyDescriptorArray[i].getName());
                this.findInJavaBean(iFile, iscobolWorkbenchAdapter, object2, FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), "[EFD Attributes]: ", iProgressMonitor);
            }
            String string4 = "value of property '" + propertyDescriptorArray[i].getDisplayName() + "'";
            object2 = FindInObjectQuery.getPropValue((PropertyDescriptor)propertyDescriptorArray[i], (Object)object);
            if (object2 != null && (string3 = object2.toString()).length() == 0) {
                string3 = null;
            }
            if (string3 != null) {
                this.compareString(string2, string3, string, string4, object, propertyDescriptorArray[i], findInObjectMatchReferenceArray, iFile, iscobolWorkbenchAdapter);
            }
            if (!this.findPropName) continue;
            string3 = propertyDescriptorArray[i].getDisplayName();
            string4 = "property '" + propertyDescriptorArray[i].getDisplayName() + "'";
            this.compareString(string2, string3, string, string4, object, propertyDescriptorArray[i], findInObjectMatchReferenceArray, iFile, iscobolWorkbenchAdapter);
        }
    }

    private void compareString(String string, String string2, String string3, String string4, Object object, PropertyDescriptor propertyDescriptor, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter) {
        if (!this.matchCase) {
            string2 = string2.toLowerCase();
        }
        string4 = string3 != null ? string3 + " " + string4 : "[" + FindInObjectUtilities.getLabelFor((Object)object) + "]: " + string4;
        if (this.wholeWord) {
            if (string2.equals(string)) {
                FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, propertyDescriptor.getName());
                this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), string4));
            }
        } else if (string2.indexOf(string) >= 0) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_PROPERTY, 0, propertyDescriptor.getName());
            this.matches.addElement(new FindInObjectMatch(iFile, iscobolWorkbenchAdapter, FindInObjectMatchReference.addRef((FindInObjectMatchReference[])findInObjectMatchReferenceArray, (FindInObjectMatchReference)findInObjectMatchReference), string4));
        }
    }

    private void findInScreenSectionList(ScreenSectionListAdapter screenSectionListAdapter, IProgressMonitor iProgressMonitor) {
        Object[] objectArray = screenSectionListAdapter.getChildren();
        for (int i = 0; i < objectArray.length; ++i) {
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_SCREEN, i, "")};
            this.findInScreenSection((ScreenSectionAdapter)objectArray[i], findInObjectMatchReferenceArray, iProgressMonitor);
        }
    }

    private void findInReportList(ReportListAdapter reportListAdapter, IProgressMonitor iProgressMonitor) {
        Object[] objectArray = reportListAdapter.getChildren();
        for (int i = 0; i < objectArray.length; ++i) {
            FindInObjectMatchReference[] findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_REPORT, i, "")};
            this.findInReport((ReportAdapter)objectArray[i], findInObjectMatchReferenceArray, iProgressMonitor);
        }
    }

    private void findInLinkageSection(LinkageSectionAdapter linkageSectionAdapter, IProgressMonitor iProgressMonitor) {
        VariableTypeList variableTypeList = linkageSectionAdapter.getScreenProgram().getResourceRegistry().getVariableTypeList();
        VariableType[] variableTypeArray = new VariableType[variableTypeList.getSettingCount()];
        variableTypeList.toArray((SettingItem[])variableTypeArray);
        int n = 0;
        for (int i = 0; i < variableTypeArray.length; ++i) {
            if (!VariableSettingsContentPane.canAdd((VariableType)variableTypeArray[i], (int)2)) continue;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, n, "");
            this.findInSettingItem(linkageSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)linkageSectionAdapter, (SettingItem)variableTypeArray[i], new FindInObjectMatchReference[]{findInObjectMatchReference}, variableTypeArray[i].toString(), iProgressMonitor);
            ++n;
        }
    }

    private void findInWorkingStorage(WorkingStorageAdapter workingStorageAdapter, IProgressMonitor iProgressMonitor) {
        VariableTypeList variableTypeList = workingStorageAdapter.getScreenProgram().getResourceRegistry().getVariableTypeList();
        VariableType[] variableTypeArray = new VariableType[variableTypeList.getSettingCount()];
        variableTypeList.toArray((SettingItem[])variableTypeArray);
        int n = 0;
        for (int i = 0; i < variableTypeArray.length; ++i) {
            if (!VariableSettingsContentPane.canAdd((VariableType)variableTypeArray[i], (int)1)) continue;
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, n, "");
            this.findInSettingItem(workingStorageAdapter.getProgramFile(), (IscobolWorkbenchAdapter)workingStorageAdapter, (SettingItem)variableTypeArray[i], new FindInObjectMatchReference[]{findInObjectMatchReference}, variableTypeArray[i].toString(), iProgressMonitor);
            ++n;
        }
    }

    private void findInFileSection(FileSectionAdapter fileSectionAdapter, IProgressMonitor iProgressMonitor) {
        FindInObjectMatchReference[] findInObjectMatchReferenceArray;
        Object[] objectArray = fileSectionAdapter.getChildren();
        for (int i = 0; i < objectArray.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DATASET, i, "")};
            this.findInJavaBean(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)((DataSetAdapter)objectArray[i]), (Object)((DataSetAdapter)objectArray[i]).getDataSet(), findInObjectMatchReferenceArray, null, iProgressMonitor);
        }
        FDAttributes[] fDAttributesArray = fileSectionAdapter.getScreenProgram().getFileSection().getFDAttributes();
        for (int i = 0; i < fDAttributesArray.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_FD_ATTR, i, "")};
            this.findInJavaBean(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, (Object)fDAttributesArray[i], findInObjectMatchReferenceArray, null, iProgressMonitor);
        }
        FileEntry[] fileEntryArray = fileSectionAdapter.getScreenProgram().getFileSection().getFDEntries();
        for (int i = 0; i < fileEntryArray.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_FD_ENTRY, i, "")};
            this.findInJavaBean(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, (Object)fileEntryArray[i], findInObjectMatchReferenceArray, null, iProgressMonitor);
        }
        FileEntry[] fileEntryArray2 = fileSectionAdapter.getScreenProgram().getFileSection().getSLEntries();
        for (int i = 0; i < fileEntryArray2.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_SL_ENTRY, i, "")};
            this.findInJavaBean(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, (Object)fileEntryArray2[i], findInObjectMatchReferenceArray, null, iProgressMonitor);
        }
        FileEntry[] fileEntryArray3 = fileSectionAdapter.getScreenProgram().getFileSection().getDeclarativeEntries();
        for (int i = 0; i < fileEntryArray3.length; ++i) {
            findInObjectMatchReferenceArray = new FindInObjectMatchReference[]{new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_DC_ENTRY, i, "")};
            this.findInJavaBean(fileSectionAdapter.getProgramFile(), (IscobolWorkbenchAdapter)fileSectionAdapter, (Object)fileEntryArray3[i], findInObjectMatchReferenceArray, null, iProgressMonitor);
        }
    }

    private void findInFileList(FileListWorkbenchAdapter fileListWorkbenchAdapter, IProgressMonitor iProgressMonitor, String string) {
        this.findInMembers(fileListWorkbenchAdapter.getMembers(), iProgressMonitor, string);
    }

    private void findInFDList(FDListWorkbenchAdapter fDListWorkbenchAdapter, IProgressMonitor iProgressMonitor, String string) {
        Object[] objectArray = fDListWorkbenchAdapter.getChildren();
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(string, objectArray.length);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.checkMonitor(iProgressMonitor);
            FDAdapter fDAdapter = (FDAdapter)objectArray[i];
            if (iProgressMonitor != null) {
                iProgressMonitor.subTask("Find in " + FindInObjectUtilities.getLabelFor((Object)fDAdapter));
            }
            this.findInFD(fDAdapter, iProgressMonitor);
            if (iProgressMonitor == null) continue;
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void findInFD(FDAdapter fDAdapter, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(fDAdapter.getDataLayoutFile(), (IscobolWorkbenchAdapter)fDAdapter, (Object)fDAdapter.getDataLayout().getFileDescriptor(), new FindInObjectMatchReference[0], null, iProgressMonitor);
        VariableTypeList variableTypeList = fDAdapter.getDataLayout().getFdItems();
        VariableType[] variableTypeArray = new VariableType[variableTypeList.getSettingCount()];
        variableTypeList.toArray((SettingItem[])variableTypeArray);
        for (int i = 0; i < variableTypeArray.length; ++i) {
            FindInObjectMatchReference findInObjectMatchReference = new FindInObjectMatchReference((Enum)FindInObjectMatch.ReferenceType.REF_INDEX, i, "");
            this.findInSettingItem(fDAdapter.getDataLayoutFile(), (IscobolWorkbenchAdapter)fDAdapter, (SettingItem)variableTypeArray[i], new FindInObjectMatchReference[]{findInObjectMatchReference}, variableTypeArray[i].toString(), iProgressMonitor);
        }
        this.findInFDEventParagraphs(fDAdapter.getEventPar(), iProgressMonitor);
    }

    private void findInEventParagraphs(EventParagraphsAdapter eventParagraphsAdapter, IProgressMonitor iProgressMonitor) {
        LineNumberReader lineNumberReader = null;
        lineNumberReader = new LineNumberReader(new StringReader(eventParagraphsAdapter.getScreenProgram().getEventParagraphs().getBody()));
        try {
            this.findInFile(lineNumberReader, null, (IscobolWorkbenchAdapter)eventParagraphsAdapter);
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void findInFDEventParagraphs(FDEventParagraphsAdapter fDEventParagraphsAdapter, IProgressMonitor iProgressMonitor) {
        LineNumberReader lineNumberReader = null;
        lineNumberReader = new LineNumberReader(new StringReader(fDEventParagraphsAdapter.getDataLayout().getEventParagraphs().getBody()));
        try {
            this.findInFile(lineNumberReader, null, (IscobolWorkbenchAdapter)fDEventParagraphsAdapter);
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void findInProject(IProject iProject, IProgressMonitor iProgressMonitor) {
        IProjectNature iProjectNature = null;
        try {
            if (iProject.isOpen()) {
                iProjectNature = iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature");
            }
        }
        catch (CoreException coreException) {
            PluginUtilities.log((Throwable)coreException);
        }
        if (iProjectNature != null) {
            this.findInProject(new ProjectWorkbenchAdapter(iProject), iProgressMonitor);
        } else {
            this.findInContainer((IContainer)iProject, iProgressMonitor);
        }
    }

    private void getFiles(IFolder iFolder, Vector vector) {
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iFolder.members();
        }
        catch (CoreException coreException) {
            return;
        }
        for (int i = 0; i < iResourceArray.length; ++i) {
            if (iResourceArray[i] instanceof IFolder) {
                this.getFiles((IFolder)iResourceArray[i], vector);
                continue;
            }
            if (!(iResourceArray[i] instanceof IFile)) continue;
            vector.addElement(iResourceArray[i]);
        }
    }

    private void findInContainer(IContainer iContainer, IProgressMonitor iProgressMonitor) {
        IResource[] iResourceArray = null;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            return;
        }
        this.findInMembers(iResourceArray, iProgressMonitor, this.getLabel());
    }

    private void findInMembers(IResource[] iResourceArray, IProgressMonitor iProgressMonitor, String string) {
        int n;
        Vector<IResource> vector = new Vector<IResource>();
        for (n = 0; n < iResourceArray.length; ++n) {
            if (iResourceArray[n] instanceof IFolder) {
                this.getFiles((IFolder)iResourceArray[n], vector);
                continue;
            }
            if (!(iResourceArray[n] instanceof IFile)) continue;
            vector.addElement(iResourceArray[n]);
        }
        n = vector.size();
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(string, n);
        }
        for (int i = 0; i < n; ++i) {
            this.checkMonitor(iProgressMonitor);
            IFile iFile = (IFile)vector.elementAt(i);
            if (iProgressMonitor != null) {
                iProgressMonitor.subTask("Find in " + FindInObjectUtilities.getLabelFor((Object)iFile));
            }
            this.findInFile(iFile, iProgressMonitor);
            if (iProgressMonitor == null) continue;
            iProgressMonitor.worked(1);
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    private void findInFile(LineNumberReader lineNumberReader, IFile iFile, IscobolWorkbenchAdapter iscobolWorkbenchAdapter) throws IOException {
        String string = this.searchText;
        if (!this.matchCase) {
            string = string.toLowerCase();
        }
        String string2 = lineNumberReader.readLine();
        while (string2 != null) {
            if (!this.matchCase) {
                string2 = string2.toLowerCase();
            }
            int n = 0;
            while ((n = string2.indexOf(string, n)) >= 0) {
                if (this.wholeWord) {
                    if (!(n != 0 && string2.charAt(n - 1) != ' ' || n + string.length() != string2.length() && string2.charAt(n + string.length()) != ' ')) {
                        if (iFile != null) {
                            this.matches.addElement(new FindInObjectMatch(iFile, lineNumberReader.getLineNumber(), n, string.length(), string2));
                        } else if (iscobolWorkbenchAdapter instanceof EventParagraphsAdapter) {
                            this.matches.addElement(FindInObjectMatch.getSPEventParagraphMatch((IscobolWorkbenchAdapter)iscobolWorkbenchAdapter, (int)lineNumberReader.getLineNumber(), (int)n, (int)string.length(), (String)string2));
                        } else if (iscobolWorkbenchAdapter instanceof FDEventParagraphsAdapter) {
                            this.matches.addElement(FindInObjectMatch.getFDEventParagraphMatch((IscobolWorkbenchAdapter)iscobolWorkbenchAdapter, (int)lineNumberReader.getLineNumber(), (int)n, (int)string.length(), (String)string2));
                        }
                    }
                } else if (iFile != null) {
                    this.matches.addElement(new FindInObjectMatch(iFile, lineNumberReader.getLineNumber(), n, string.length(), string2));
                } else if (iscobolWorkbenchAdapter instanceof EventParagraphsAdapter) {
                    this.matches.addElement(FindInObjectMatch.getSPEventParagraphMatch((IscobolWorkbenchAdapter)iscobolWorkbenchAdapter, (int)lineNumberReader.getLineNumber(), (int)n, (int)string.length(), (String)string2));
                } else if (iscobolWorkbenchAdapter instanceof FDEventParagraphsAdapter) {
                    this.matches.addElement(FindInObjectMatch.getFDEventParagraphMatch((IscobolWorkbenchAdapter)iscobolWorkbenchAdapter, (int)lineNumberReader.getLineNumber(), (int)n, (int)string.length(), (String)string2));
                }
                n += string.length();
            }
            string2 = lineNumberReader.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInFile(IFile iFile, IProgressMonitor iProgressMonitor) {
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents();
            bufferedReader = new LineNumberReader(new InputStreamReader(inputStream));
            this.findInFile((LineNumberReader)bufferedReader, iFile, null);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void findInDataSet(DataSetAdapter dataSetAdapter, FindInObjectMatchReference[] findInObjectMatchReferenceArray, IProgressMonitor iProgressMonitor) {
        this.findInJavaBean(dataSetAdapter.getProgramFile(), (IscobolWorkbenchAdapter)dataSetAdapter, (Object)dataSetAdapter.getDataSet(), findInObjectMatchReferenceArray, null, iProgressMonitor);
    }

    public Object getSearchTarget() {
        return this.searchTarget;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public boolean isWholeWord() {
        return this.wholeWord;
    }

    public void setSearchTarget(Object object) {
        this.searchTarget = object;
    }

    public void setSearchText(String string) {
        this.searchText = string;
    }

    public void setMatchCase(boolean bl) {
        this.matchCase = bl;
    }

    public void setWholeWord(boolean bl) {
        this.wholeWord = bl;
    }

    public void setFindPropertyName(boolean bl) {
        this.findPropName = bl;
    }

    public boolean isFindPropertyName() {
        return this.findPropName;
    }
}

