/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.findinobject;

import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.plugins.editor.IscobolEditor;
import com.iscobol.plugins.editor.IscobolEditorPlugin;
import com.iscobol.plugins.editor.views.IscobolWorkbenchAdapter;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.ScreenElement;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * Exception performing whole class analysis ignored.
 */
public class FindInObjectUtilities {
    public static String getLabelFor(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object instanceof IscobolWorkbenchAdapter) {
            IscobolWorkbenchAdapter iscobolWorkbenchAdapter = (IscobolWorkbenchAdapter)object;
            Object object2 = iscobolWorkbenchAdapter.getParent();
            while (object2 != null) {
                if (object2 instanceof IscobolWorkbenchAdapter) {
                    stringBuilder.insert(0, ((IscobolWorkbenchAdapter)object2).getLabel() + "/");
                    object2 = ((IscobolWorkbenchAdapter)object2).getParent();
                    continue;
                }
                if (object2 instanceof IWorkspaceRoot || !(object2 instanceof IResource)) break;
                stringBuilder.insert(0, ((IResource)object2).getProject().getFullPath() + "/");
                break;
            }
            stringBuilder.append(iscobolWorkbenchAdapter.getLabel());
        } else if (object instanceof IResource) {
            IResource iResource = (IResource)object;
            stringBuilder.append(iResource.getFullPath());
        } else {
            if (object instanceof ScreenElement) {
                ScreenElement screenElement = (ScreenElement)object;
                return IscobolBeanConstants.getTypeName((int)screenElement.getType()) + " " + screenElement.getName();
            }
            if (object instanceof Menu) {
                Menu menu = (Menu)object;
                return IscobolBeanConstants.getTypeName((int)301) + " " + menu.getName();
            }
            if (object instanceof ReportElement) {
                ReportElement reportElement = (ReportElement)object;
                return IscobolBeanConstants.getTypeName((int)reportElement.getType()) + " " + reportElement.getName();
            }
            if (object instanceof DataSet) {
                DataSet dataSet = (DataSet)object;
                return dataSet.getName();
            }
            if (object instanceof FileDescriptor) {
                return "File Descriptor";
            }
        }
        return stringBuilder.toString();
    }

    public static Image getImageFor(Object object) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            String string = iFile.getFileExtension();
            boolean bl = false;
            bl = PluginUtilities.isCopyFile((IFile)iFile, (String)string);
            if (bl) {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/copy.gif");
            }
            if (string != null && string.equalsIgnoreCase("list")) {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/list.gif");
            }
            if (string != null && string.equalsIgnoreCase("err")) {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/err.gif");
            }
            if (string != null && string.equalsIgnoreCase("xml")) {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/xml.gif");
            }
            boolean bl2 = PluginUtilities.isSourceFile((IFile)iFile);
            if (bl2) {
                return IscobolEditorPlugin.getDefault().getImageProvider().getImage("/source.gif");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        IscobolWorkbenchAdapter iscobolWorkbenchAdapter = FindInObjectUtilities.getIscobolWorkbenchAdapter((Object)object);
        if (iscobolWorkbenchAdapter != null) {
            return iscobolWorkbenchAdapter.getImage();
        }
        return null;
    }

    private static IscobolWorkbenchAdapter getIscobolWorkbenchAdapter(Object object) {
        IscobolWorkbenchAdapter iscobolWorkbenchAdapter = null;
        if (object instanceof IscobolWorkbenchAdapter) {
            iscobolWorkbenchAdapter = (IscobolWorkbenchAdapter)object;
        } else if (object instanceof IAdaptable) {
            iscobolWorkbenchAdapter = (IscobolWorkbenchAdapter)((IAdaptable)object).getAdapter(IscobolWorkbenchAdapter.class);
        }
        return iscobolWorkbenchAdapter;
    }

    private static boolean canOpenWithIscobolEditor(IFile iFile) throws CoreException {
        IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((IFile)iFile);
        if (iEditorDescriptor != null && iEditorDescriptor.getId().equals(IscobolEditor.ID)) {
            return true;
        }
        if (iEditorDescriptor == null || iEditorDescriptor.getId().equals("org.eclipse.ui.DefaultTextEditor")) {
            IProject iProject = iFile.getProject();
            if (iProject == null || iProject.getNature("com.iscobol.plugins.editor.IscobolEditor.IscobolNature") == null) {
                return false;
            }
            IContainer iContainer = PluginUtilities.getSourceFolder((IProject)iProject);
            IContainer iContainer2 = iFile.getParent();
            while (iContainer2 instanceof IFolder) {
                if (iContainer2.equals(iContainer)) {
                    return true;
                }
                iContainer2 = iContainer2.getParent();
            }
            iContainer2 = PluginUtilities.getCopyFolders((IProject)iProject, (String)PluginUtilities.getCurrentSettingMode((IResource)iProject));
            for (int i = 0; i < ((IContainer)iContainer2).length; ++i) {
                iContainer = iContainer2[i];
                IContainer iContainer3 = iFile.getParent();
                while (iContainer3 instanceof IFolder) {
                    if (iContainer3.equals(iContainer)) {
                        return true;
                    }
                    iContainer3 = iContainer3.getParent();
                }
            }
        }
        return false;
    }

    public static IEditorPart openEditor(IFile iFile, IWorkbenchPage iWorkbenchPage) throws PartInitException, CoreException {
        IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((IFile)iFile);
        if (iEditorDescriptor == null || iEditorDescriptor.getId().equals(IscobolEditor.ID)) {
            return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), IscobolEditor.ID, true, 3);
        }
        if (iEditorDescriptor.getId().equals("org.eclipse.ui.DefaultTextEditor") && FindInObjectUtilities.canOpenWithIscobolEditor((IFile)iFile)) {
            return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), IscobolEditor.ID, true, 3);
        }
        if (iFile.getFileExtension() != null && iFile.getFileExtension().equals("isp")) {
            return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "iscobolscreenpainter.MultipageScreenSectionEditor", true, 3);
        }
        if (iFile.getFileExtension() != null && iFile.getFileExtension().equals("idl")) {
            return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "iscobolscreenpainter.DataLayoutEditor", true, 3);
        }
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.ui.DefaultTextEditor", true);
    }
}

