/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.handlers;

import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.handlers.ChangeBoundsHandler;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.policies.IXYLayoutEditPolicy;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AdjacentHorizontalHandler
extends ChangeBoundsHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        GraphicalEditPart[] graphicalEditPartArray = this.getSelection(executionEvent);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
        if (graphicalEditPartArray == null || graphicalEditPartArray.length < 2) {
            this.logMessage(ISPBundle.getString((String)"must_be_same_parent_msg"), shell);
            return null;
        }
        Arrays.sort(graphicalEditPartArray, new /* Unavailable Anonymous Inner Class!! */);
        int n = this.getRightMargin((EditPart)graphicalEditPartArray[0]) + 1;
        Command command = null;
        IXYLayoutEditPolicy iXYLayoutEditPolicy = this.getLayoutEditPolicy((EditPart)graphicalEditPartArray[0]);
        for (int i = 1; i < graphicalEditPartArray.length; ++i) {
            ScreenPainterModel screenPainterModel = (ScreenPainterModel)graphicalEditPartArray[i].getModel();
            Point point = screenPainterModel.getLocation();
            Dimension dimension = screenPainterModel.getSize();
            point.x = n;
            Rectangle rectangle = new Rectangle(point, dimension);
            command = this.addChangeBoundsRequestCommand(iXYLayoutEditPolicy, command, (EditPart)graphicalEditPartArray[i], rectangle);
            n += dimension.width + 1;
        }
        this.executeCommands(graphicalEditPartArray[0].getViewer(), command);
        return null;
    }

    private int getRightMargin(EditPart editPart) {
        ScreenPainterModel screenPainterModel = (ScreenPainterModel)editPart.getModel();
        Point point = screenPainterModel.getLocation();
        Dimension dimension = screenPainterModel.getSize();
        return point.x + dimension.width;
    }

    static /* synthetic */ int access$000(AdjacentHorizontalHandler adjacentHorizontalHandler, EditPart editPart) {
        return adjacentHorizontalHandler.getRightMargin(editPart);
    }
}

