/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.handlers;

import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.handlers.ChangeBoundsHandler;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.policies.IXYLayoutEditPolicy;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AlignHorizontalHandler
extends ChangeBoundsHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        GraphicalEditPart[] graphicalEditPartArray = this.getSelection(executionEvent);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
        int n = this.getAbsoluteHMargin(graphicalEditPartArray[graphicalEditPartArray.length - 1]);
        Command command = null;
        IXYLayoutEditPolicy iXYLayoutEditPolicy = this.getLayoutEditPolicy((EditPart)graphicalEditPartArray[0]);
        for (int i = 0; i < graphicalEditPartArray.length - 1; ++i) {
            Dimension dimension;
            Point point;
            int n2 = this.getAbsoluteHMargin(graphicalEditPartArray[i]);
            Rectangle rectangle = graphicalEditPartArray[i].getFigure().getBounds();
            Rectangle rectangle2 = ((GraphicalEditPart)graphicalEditPartArray[i].getParent()).getFigure().getBounds();
            int n3 = n - n2;
            int n4 = rectangle.x + n3;
            if (n4 >= rectangle2.x && n4 + rectangle.width <= rectangle2.x + rectangle2.width) {
                ScreenPainterModel screenPainterModel = (ScreenPainterModel)graphicalEditPartArray[i].getModel();
                point = screenPainterModel.getLocation();
                dimension = screenPainterModel.getSize();
                point.x += n3;
            } else {
                this.logMessage(ISPBundle.getString((String)"align_err_msg"), shell);
                return null;
            }
            Rectangle rectangle3 = new Rectangle(point, dimension);
            command = this.addChangeBoundsRequestCommand(iXYLayoutEditPolicy, command, (EditPart)graphicalEditPartArray[i], rectangle3);
        }
        this.executeCommands(graphicalEditPartArray[0].getViewer(), command);
        return null;
    }

    protected abstract int getAbsoluteHMargin(GraphicalEditPart var1);
}

