/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.handlers;

import com.iscobol.reportdesigner.ReportEditor;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenSectionEditor;
import com.iscobol.screenpainter.dialogs.ColorPaletteDialog;
import com.iscobol.screenpainter.model.RootModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.parts.ScreenDesignerEditPart;
import com.iscobol.screenpainter.util.ColorPalette;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangeColorPaletteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        EditPart editPart = this.getSelectedEditPart(executionEvent);
        if (editPart instanceof IscobolScreenPainterEditPart) {
            ScreenProgram screenProgram = ((IscobolScreenPainterEditPart)editPart).getScreenPainterModel().getScreenProgram();
            boolean bl = editPart instanceof ScreenDesignerEditPart;
            ColorPaletteDialog colorPaletteDialog = new ColorPaletteDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), screenProgram, bl);
            ColorPalette colorPalette = colorPaletteDialog.openDialog();
            if (colorPalette != null) {
                ScreenProgramEditor screenProgramEditor = null;
                if (iEditorPart instanceof ScreenProgramEditor) {
                    screenProgramEditor = (ScreenProgramEditor)iEditorPart;
                    if (bl) {
                        screenProgram.setScreenCustomColors(colorPalette.toString());
                        for (ScreenSectionEditor screenSectionEditor : screenProgramEditor.getScreenSectionEditors()) {
                            RootModel rootModel = (RootModel)screenSectionEditor.getModel();
                            rootModel.getWindowModel().firePropertyChange("iscobolsp.update", (Object)"old", (Object)"new");
                        }
                    } else {
                        screenProgram.setReportCustomColors(colorPalette.toString());
                        for (ReportEditor reportEditor : screenProgramEditor.getReportEditors()) {
                            ReportModel reportModel = (ReportModel)reportEditor.getModel();
                            reportModel.firePropertyChange("iscobolrd.update", (Object)"old", (Object)"new");
                        }
                    }
                    screenProgramEditor.setDirty(true);
                }
            }
        }
        return null;
    }

    private EditPart getSelectedEditPart(ExecutionEvent executionEvent) {
        StructuredSelection structuredSelection;
        Object object;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)iSelection).getFirstElement()) instanceof EditPart) {
            return (EditPart)object;
        }
        return null;
    }
}

