/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.handlers;

import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.reportdesigner.beans.Report;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.dialogs.ChangePrefixDialog;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.parts.ScreenDesignerEditPart;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangePrefixHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        String string;
        ScreenPainterModel screenPainterModel;
        String string2;
        String string3;
        IEditorPart iEditorPart = HandlerUtil.getActiveEditor((ExecutionEvent)executionEvent);
        EditPart editPart = this.getSelectedEditPart(executionEvent);
        if (!(editPart instanceof IscobolScreenPainterEditPart)) return null;
        ScreenPainterModel screenPainterModel2 = ((IscobolScreenPainterEditPart)editPart).getScreenPainterModel();
        ScreenProgram screenProgram = screenPainterModel2.getScreenProgram();
        boolean bl = editPart instanceof ScreenDesignerEditPart;
        AbstractBeanWindow abstractBeanWindow = null;
        Report report = null;
        WindowModel windowModel = null;
        ReportModel reportModel = null;
        if (bl) {
            string3 = "Change Screen Prefix";
            string2 = "Change screen's prefix only";
            for (screenPainterModel = screenPainterModel2; screenPainterModel != null && !(screenPainterModel instanceof WindowModel); screenPainterModel = screenPainterModel.getParent()) {
            }
            if (screenPainterModel == null) throw new ExecutionException("Invalid selection");
            windowModel = (WindowModel)screenPainterModel;
            abstractBeanWindow = (AbstractBeanWindow)windowModel.getTarget();
            string = abstractBeanWindow.getPrefix();
            if (string == null || string.length() == 0) {
                string = abstractBeanWindow.getName();
            }
        } else {
            string3 = "Change Report Prefix";
            string2 = "Change report's prefix only";
            for (screenPainterModel = screenPainterModel2; screenPainterModel != null && !(screenPainterModel instanceof ReportModel); screenPainterModel = screenPainterModel.getParent()) {
            }
            if (screenPainterModel == null) throw new ExecutionException("Invalid selection");
            reportModel = (ReportModel)screenPainterModel;
            report = (Report)reportModel.getTarget();
            string = report.getPrefix();
            if (string == null || string.length() == 0) {
                string = report.getName();
            }
        }
        screenPainterModel = new ChangePrefixDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), string3, string2, string);
        screenPainterModel.open();
        String string4 = screenPainterModel.getNewPrefix();
        if (string4 == null) return null;
        string = screenPainterModel.getOldPrefix();
        if (bl) {
            abstractBeanWindow.setPrefix(string4);
        } else {
            report.setPrefix(string4);
        }
        if (!screenPainterModel.getChangePrefixOnly()) {
            PropertyDescriptorRegistry.changePrefix((Object)(bl ? abstractBeanWindow : report), (String)string, (String)string4, (ScreenProgram)screenProgram);
            if (bl) {
                this.fireNamePropertyChange((ModelElement)windowModel);
            } else {
                this.fireNamePropertyChange((ReportModelElement)reportModel);
            }
            IIscobolNavigator iIscobolNavigator = PluginUtilities.findStructuralNavigator();
            if (iIscobolNavigator != null) {
                iIscobolNavigator.refresh((Object)screenProgram.getProject());
            }
        }
        if (!(iEditorPart instanceof ScreenProgramEditor)) return null;
        ((ScreenProgramEditor)iEditorPart).setDirty(true);
        return null;
    }

    private void fireNamePropertyChange(ModelElement modelElement) {
        modelElement.firePropertyChange("name", null, (Object)modelElement.getName());
        for (ModelElement modelElement2 : modelElement.getChildren()) {
            this.fireNamePropertyChange(modelElement2);
        }
    }

    private void fireNamePropertyChange(ReportModelElement reportModelElement) {
        reportModelElement.firePropertyChange("name", null, (Object)reportModelElement.getName());
        for (ReportModelElement reportModelElement2 : reportModelElement.getChildren()) {
            this.fireNamePropertyChange(reportModelElement2);
        }
    }

    private EditPart getSelectedEditPart(ExecutionEvent executionEvent) {
        StructuredSelection structuredSelection;
        Object object;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof StructuredSelection && (object = (structuredSelection = (StructuredSelection)iSelection).getFirstElement()) instanceof EditPart) {
            return (EditPart)object;
        }
        return null;
    }
}

