/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.handlers;

import com.iscobol.screenpainter.ConsistencyChecker;
import com.iscobol.screenpainter.util.adapters.EFDAdapter;
import com.iscobol.screenpainter.util.adapters.FDAdapter;
import com.iscobol.screenpainter.util.adapters.FileControlAdapter;
import com.iscobol.screenpainter.util.adapters.IFDAdapter;
import com.iscobol.screenpainter.util.adapters.IOHandlingAdapter;
import com.iscobol.screenpainter.util.adapters.KeyDefinitionAdapter;
import com.iscobol.screenpainter.views.ConsistencyCheckView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConsistencyCheckHandler
extends AbstractHandler {
    private ConsistencyChecker checker;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Object object;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof IStructuredSelection && (object = this.getTarget((IStructuredSelection)iSelection)) != null) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
            if (this.checker != null) {
                MessageBox messageBox = new MessageBox(shell, 33);
                messageBox.setText("Consistency Check");
                messageBox.setMessage("A Consistency Check Operation is already running");
                messageBox.open();
            } else {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                IWorkbenchPage iWorkbenchPage = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent).getActivePage();
                this.checker = new ConsistencyChecker(object);
                this.checker.addJobChangeListener((IJobChangeListener)new /* Unavailable Anonymous Inner Class!! */);
                this.checker.schedule();
                iWorkbench.getProgressService().showInDialog(shell, (Job)this.checker);
            }
        }
        return null;
    }

    private void showConsistencyCheckResult(IWorkbenchPage iWorkbenchPage) {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showConsistencyCheckResult0(IWorkbenchPage iWorkbenchPage) {
        try {
            ConsistencyCheckView consistencyCheckView = (ConsistencyCheckView)iWorkbenchPage.showView("com.iscobol.screenpainter.views.ConsistencyCheck");
            consistencyCheckView.setConsistencyCheckResult(this.checker.getConsistencyCheckResult());
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    protected Object getTarget(IStructuredSelection iStructuredSelection) {
        Object object = null;
        if (iStructuredSelection != null && iStructuredSelection.getFirstElement() != null && ((object = iStructuredSelection.getFirstElement()) instanceof KeyDefinitionAdapter || object instanceof FileControlAdapter || object instanceof IOHandlingAdapter || object instanceof EFDAdapter)) {
            object = new FDAdapter(((IFDAdapter)object).getDataLayoutFile());
        }
        return object;
    }

    static /* synthetic */ void access$000(ConsistencyCheckHandler consistencyCheckHandler, IWorkbenchPage iWorkbenchPage) {
        consistencyCheckHandler.showConsistencyCheckResult(iWorkbenchPage);
    }

    static /* synthetic */ ConsistencyChecker access$102(ConsistencyCheckHandler consistencyCheckHandler, ConsistencyChecker consistencyChecker) {
        consistencyCheckHandler.checker = consistencyChecker;
        return consistencyCheckHandler.checker;
    }

    static /* synthetic */ void access$200(ConsistencyCheckHandler consistencyCheckHandler, IWorkbenchPage iWorkbenchPage) {
        consistencyCheckHandler.showConsistencyCheckResult0(iWorkbenchPage);
    }
}

