/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.handlers;

import com.iscobol.screenpainter.dialogs.FindInObjectDialog;
import com.iscobol.screenpainter.findinobject.FindInObjectQuery;
import com.iscobol.screenpainter.util.adapters.EFDAdapter;
import com.iscobol.screenpainter.util.adapters.FDAdapter;
import com.iscobol.screenpainter.util.adapters.FileControlAdapter;
import com.iscobol.screenpainter.util.adapters.IFDAdapter;
import com.iscobol.screenpainter.util.adapters.IOHandlingAdapter;
import com.iscobol.screenpainter.util.adapters.KeyDefinitionAdapter;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindInObjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (iSelection instanceof IStructuredSelection) {
            Object object = this.getTarget((IStructuredSelection)iSelection);
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)executionEvent);
            if (object != null) {
                this.showFindInObjectDialog(shell, object);
            } else {
                this.showErrorMessage(shell);
            }
        }
        return null;
    }

    protected void showFindInObjectDialog(Shell shell, Object object) {
        FindInObjectDialog findInObjectDialog = new FindInObjectDialog(shell, object);
        FindInObjectQuery findInObjectQuery = findInObjectDialog.openDialog();
        if (findInObjectQuery != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)findInObjectQuery);
        }
    }

    protected void showErrorMessage(Shell shell) {
        MessageBox messageBox = new MessageBox(shell, 33);
        messageBox.setText("Find in Object");
        messageBox.setMessage("Please select an item on the Structural/File/Data view");
        messageBox.open();
    }

    protected Object getTarget(IStructuredSelection iStructuredSelection) {
        Object object = null;
        if (iStructuredSelection != null && iStructuredSelection.getFirstElement() != null && ((object = iStructuredSelection.getFirstElement()) instanceof KeyDefinitionAdapter || object instanceof FileControlAdapter || object instanceof IOHandlingAdapter || object instanceof EFDAdapter)) {
            object = new FDAdapter(((IFDAdapter)object).getDataLayoutFile());
        }
        return object;
    }
}

