/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.launch;

import com.iscobol.plugins.editor.launch.IscobolLaunchShortcut;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.IScreenProgramAdapter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;

public class ISPLaunchShortcut
implements ILaunchShortcut {
    protected boolean wd2Launch;

    public void launch(ISelection iSelection, String string) {
        if (!(iSelection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)iSelection;
        if (structuredSelection.isEmpty() || !(structuredSelection.getFirstElement() instanceof IScreenProgramAdapter)) {
            return;
        }
        ScreenProgram screenProgram = ((IScreenProgramAdapter)structuredSelection.getFirstElement()).getScreenProgram();
        IFile iFile = this.getSourceFile(screenProgram);
        if (iFile != null) {
            try {
                IscobolLaunchShortcut.launch((IFile)iFile, (String)string, (boolean)this.wd2Launch);
            }
            catch (CoreException coreException) {
                PluginUtilities.log((Throwable)coreException);
            }
        }
    }

    private IFile getSourceFile(ScreenProgram screenProgram) {
        String string = screenProgram.getProgramName() + screenProgram.getProgramFileSuffix();
        IContainer iContainer = null;
        try {
            iContainer = PluginUtilities.getSourceFolder((IProject)screenProgram.getProject());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        IResource iResource = PluginUtilities.findMember((IContainer)iContainer, (IPath)new Path(string));
        if (!(iResource instanceof IFile) || iResource.getLocalTimeStamp() < screenProgram.getFile().getLocalTimeStamp()) {
            return new CodeGenerator(screenProgram).generate();
        }
        return (IFile)iResource;
    }

    public void launch(IEditorPart iEditorPart, String string) {
        if (!(iEditorPart instanceof ScreenProgramEditor)) {
            return;
        }
        ScreenProgramEditor screenProgramEditor = (ScreenProgramEditor)iEditorPart;
        ScreenProgram screenProgram = new ScreenProgram(screenProgramEditor.getScreenProgram().getFile());
        boolean bl = this.isWorkspaceAutoBuilding();
        this.setWorkspaceAutoBuilding(false);
        IFile iFile = this.getSourceFile(screenProgram);
        if (iFile != null) {
            try {
                IscobolLaunchShortcut.launch((IFile)iFile, (String)string, (boolean)this.wd2Launch);
            }
            catch (CoreException coreException) {
                PluginUtilities.log((Throwable)coreException);
            }
        }
        this.setWorkspaceAutoBuilding(bl);
    }

    private boolean isWorkspaceAutoBuilding() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private void setWorkspaceAutoBuilding(boolean bl) {
        IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
        iWorkspaceDescription.setAutoBuilding(bl);
        try {
            ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

