/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBar;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import org.eclipse.draw2d.geometry.Dimension;

public class BarModel
extends ComponentModel {
    private static final long serialVersionUID = 5256L;
    private boolean horizontal;
    private int width = 1;
    private boolean changingBounds = false;

    public BarModel(int n) {
        super(n);
    }

    public BarModel(AbstractBeanControl abstractBeanControl) {
        super(abstractBeanControl);
        AbstractBar abstractBar = (AbstractBar)abstractBeanControl;
        this.horizontal = abstractBar.isHorizontal();
        this.width = abstractBar.getWidth();
        this.size = this.horizontal ? new Dimension((int)abstractBeanControl.getSizePixels(), this.width) : new Dimension(this.width, (int)abstractBeanControl.getLinesPixels());
    }

    void handleSetValues(ScreenProgram screenProgram, Object object, boolean bl) {
    }

    public void setPropertyValue(Object object, Object object2) {
        if ("horizontal".equals(object)) {
            this.setHorizontal((Integer)object2 > 0);
        } else if ("width".equals(object)) {
            this.setWidth(Integer.parseInt(object2.toString()));
        } else if (!this.changingBounds && ("size".equals(object) || "size pixels".equals(object) ? !((AbstractBar)this.getTarget()).isHorizontal() : ("lines".equals(object) || "lines pixels".equals(object)) && ((AbstractBar)this.getTarget()).isHorizontal())) {
            return;
        }
        super.setPropertyValue(object, object2);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.changingBounds = true;
        this.width = n;
        Dimension dimension = this.getSize();
        if (this.horizontal) {
            dimension.height = this.width;
        } else {
            dimension.width = this.width;
        }
        super.setSize(dimension);
        this.changingBounds = false;
    }

    public void setHorizontal(boolean bl) {
        this.changingBounds = true;
        boolean bl2 = this.horizontal;
        this.horizontal = bl;
        Dimension dimension = this.getSize();
        if (this.horizontal != bl2) {
            int n = dimension.width;
            dimension.width = dimension.height;
            dimension.height = n;
        }
        super.setSize(dimension);
        ((AbstractBar)this.target).setHorizontal(bl);
        this.changingBounds = false;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setSize(Dimension dimension) {
        if (dimension != null) {
            VariableType variableType;
            int n;
            String string;
            String string2;
            String string3;
            AbstractBar abstractBar = (AbstractBar)this.target;
            ScreenProgram screenProgram = this.getParentWindow().getScreenProgram();
            if (this.horizontal) {
                string3 = String.valueOf(dimension.width);
                string2 = abstractBar.getSizeVariable();
                dimension.height = this.width;
                string = "size pixels";
                n = 2;
            } else {
                string3 = String.valueOf(dimension.height);
                string2 = abstractBar.getLinesVariable();
                dimension.width = this.width;
                string = "lines pixels";
                n = 1;
            }
            this.size.setSize(dimension);
            PropertyDescriptorRegistry.setProperty((Object)this.getTarget(), (String)string, (Object)string3, (ScreenProgram)screenProgram);
            boolean bl = this.getParentWindow().isUnitPixel();
            if (string2 != null && (variableType = screenProgram.getProgramVariable(string2)) != null && this.canModify(variableType)) {
                this.changeVariableValue(variableType, n, bl);
            }
            this.firePropertyChange("Component.Size", null, (Object)this.size);
        }
    }
}

