/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model;

import com.iscobol.plugins.editor.util.TreeStructuredData;
import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBitmap;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.AbstractCheckBox;
import com.iscobol.screenpainter.beans.AbstractComboBox;
import com.iscobol.screenpainter.beans.AbstractEntryField;
import com.iscobol.screenpainter.beans.AbstractGrid;
import com.iscobol.screenpainter.beans.AbstractLabel;
import com.iscobol.screenpainter.beans.AbstractRadioButton;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.GroupBeanControl;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.swing.SwingAccordion;
import com.iscobol.screenpainter.beans.swing.SwingBar;
import com.iscobol.screenpainter.beans.swing.SwingBitmap;
import com.iscobol.screenpainter.beans.swing.SwingCheckBox;
import com.iscobol.screenpainter.beans.swing.SwingCheckListBox;
import com.iscobol.screenpainter.beans.swing.SwingComboBox;
import com.iscobol.screenpainter.beans.swing.SwingDateEntry;
import com.iscobol.screenpainter.beans.swing.SwingEntryField;
import com.iscobol.screenpainter.beans.swing.SwingFrame;
import com.iscobol.screenpainter.beans.swing.SwingGrid;
import com.iscobol.screenpainter.beans.swing.SwingJavaBean;
import com.iscobol.screenpainter.beans.swing.SwingLabel;
import com.iscobol.screenpainter.beans.swing.SwingListBox;
import com.iscobol.screenpainter.beans.swing.SwingPushButton;
import com.iscobol.screenpainter.beans.swing.SwingRadioButton;
import com.iscobol.screenpainter.beans.swing.SwingScrollbar;
import com.iscobol.screenpainter.beans.swing.SwingSlider;
import com.iscobol.screenpainter.beans.swing.SwingTab;
import com.iscobol.screenpainter.beans.swing.SwingTreeView;
import com.iscobol.screenpainter.beans.swing.SwingWebBrowser;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.model.ComboBoxModel;
import com.iscobol.screenpainter.model.ContainerModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.ScreenPainterModelWithTitle;
import com.iscobol.screenpainter.model.ScreenSectionModel;
import com.iscobol.screenpainter.model.ToolbarModel;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;

public class ComponentModel
extends ModelElement
implements ScreenPainterModelWithTitle {
    private static final long serialVersionUID = 1L;
    protected static final int LINES = 1;
    protected static final int SIZE = 2;
    protected static final int LINE = 3;
    protected static final int COL = 4;
    protected AbstractBeanControl target;
    private boolean creatingComponent;
    private boolean editorComponent;
    private int type;
    private ComponentModel onHeaderButton;
    private ComponentModel onPageButton;

    public ComponentModel(int n) {
        this.type = n;
        this.createTarget();
    }

    public ComponentModel(AbstractBeanControl abstractBeanControl) {
        this.target = abstractBeanControl;
        this.type = abstractBeanControl.getType();
        this.location = new Point((int)abstractBeanControl.getColumnPixels() - 1, (int)abstractBeanControl.getLinePixels() - 1);
        this.size = new Dimension(this.getModelWidth((int)abstractBeanControl.getSizePixels()), this.getModelHeight((int)abstractBeanControl.getLinesPixels()));
    }

    public boolean isTransparent() {
        switch (this.getType()) {
            case 104: {
                return ((AbstractCheckBox)this.getTarget()).isTransparent();
            }
            case 103: {
                return ((AbstractRadioButton)this.getTarget()).isTransparent();
            }
            case 105: {
                return ((AbstractLabel)this.getTarget()).isTransparent();
            }
        }
        return false;
    }

    public Image getIcon() {
        String string = IscobolBeanConstants.getImageName((int)this.type);
        if (string != null) {
            return IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage(string);
        }
        return null;
    }

    public boolean isWd2Unsupported() {
        IProject iProject;
        ScreenProgram screenProgram = this.getScreenProgram();
        return screenProgram != null && (iProject = screenProgram.getProject()) != null && "true".equals(PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobolsp.showonlywd2supported")) && Factory.getWd2UnsupportedControlsTypes((IProject)iProject).contains(IscobolBeanConstants.getGuiControlType((int)this.getType()));
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.target.getName();
    }

    public String getTitle() {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 113: {
                return (String)this.getPropertyValue((Object)"title");
            }
        }
        return null;
    }

    public void setTitle(String string) {
        switch (this.type) {
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 113: {
                this.setPropertyValue((Object)"title", (Object)string);
            }
        }
    }

    public void setLocation(Point point) {
        if (point != null) {
            Point point2 = this.getTargetLocation();
            if (point.x != point2.x) {
                this.setPropertyValue((Object)"column pixels", (Object)Integer.toString(point.x + 1));
            }
            if (point.y != point2.y) {
                this.setPropertyValue((Object)"line pixels", (Object)Integer.toString(point.y + 1));
            }
        }
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension, false);
    }

    public void setSize(Dimension dimension, boolean bl) {
        if (dimension != null) {
            if (this.hasBitmap()) {
                if (this.isSizeDefault()) {
                    dimension.width -= 8;
                }
                if (this.isLinesDefault()) {
                    dimension.height -= 8;
                }
            }
            if (bl || dimension.width != this.size.width) {
                this.setPropertyValue((Object)"size pixels", (Object)Integer.toString(dimension.width));
            }
            if (bl || dimension.height != this.size.height) {
                this.setPropertyValue((Object)"lines pixels", (Object)Integer.toString(dimension.height));
            }
        }
    }

    public void handleSetValue(String string, Object object, ScreenProgram screenProgram) {
    }

    public void update() {
        this.target.refreshComponent();
        this.location.setLocation((int)this.target.getColumnPixels() - 1, (int)this.target.getLinePixels() - 1);
        this.intFirePropertyChange("GROUP-CHANGE", (Object)"0", (Object)"1");
    }

    public void intSetSize(Dimension dimension) {
        if (this.isOnRibbonHeader()) {
            dimension.height = 24;
        }
        super.intSetSize(dimension);
    }

    public void intSetLocation(Point point) {
        Point point2;
        if (!this.isOnRibbonHeader() && point != null && !(point2 = this.getRealLocation(point, this.getParent(), this.size.height)).equals((Object)this.location)) {
            this.location.setLocation(point2);
            this.intFirePropertyChange("Component.Location", null, (Object)this.location);
        }
    }

    protected Point getRealLocation(Point point, ModelElement modelElement, int n) {
        Point point2 = point.getCopy();
        if (!this.isCreatingComponent()) {
            for (ModelElement modelElement2 = modelElement; modelElement2 != null; modelElement2 = modelElement2.getParent()) {
                if (!(modelElement2 instanceof ToolbarModel)) continue;
                ToolbarModel toolbarModel = (ToolbarModel)modelElement2;
                if (!((AbstractBeanToolbar)toolbarModel.getTarget()).isMultiline()) {
                    point2.y = (toolbarModel.getToolbarHeight() - n) / 2;
                    break;
                }
                point2.y = (int)((AbstractBeanControl)this.getTarget()).getLinePixels() - 1;
                break;
            }
        }
        return point2;
    }

    protected Point getTargetLocation() {
        Point point = this.location.getCopy();
        for (ModelElement modelElement = this.getParent(); modelElement != null; modelElement = modelElement.getParent()) {
            if (!(modelElement instanceof ToolbarModel)) continue;
            ToolbarModel toolbarModel = (ToolbarModel)modelElement;
            if (((AbstractBeanToolbar)toolbarModel.getTarget()).isMultiline()) break;
            point.y = (int)((AbstractBeanControl)this.getTarget()).getLinePixels() - 1;
            break;
        }
        return point;
    }

    boolean intSetPropertyValue(Object object, Object object2, Object object3) {
        boolean bl = super.intSetPropertyValue(object, object2, object3);
        String string = object.toString();
        if (this.affectSize(string)) {
            this.intSetSize(new Dimension(this.getModelWidth((int)this.target.getSizePixels()), this.getModelHeight((int)this.target.getLinesPixels())));
        }
        return bl;
    }

    public void setPropertyValue(Object object, Object object2) {
        VariableType variableType;
        int n;
        if (this.intSetPropertyValue(object, object2, this.getTarget())) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        String string = null;
        boolean bl2 = false;
        String string2 = object.toString();
        ScreenProgram screenProgram = this.getParentWindow().getScreenProgram();
        if ("column pixels".equals(string2)) {
            if (object2.toString().trim().length() == 0) {
                object2 = "0";
            }
            n = Math.round(PropertyDescriptorRegistry.parseFloat((String)((String)object2)));
            this.target.setColumnPixels(n);
            this.updateLocations(n, (int)this.target.getLinePixels());
            bl = false;
            n2 = 4;
            string = this.target.getColumnVariable();
            bl2 = this.target.isSizeUnitPixel();
        } else if ("line pixels".equals(string2)) {
            if (object2.toString().trim().length() == 0) {
                object2 = "0";
            }
            n = Math.round(PropertyDescriptorRegistry.parseFloat((String)((String)object2)));
            this.target.setLinePixels(n);
            this.updateLocations((int)this.target.getColumnPixels(), n);
            bl = false;
            n2 = 3;
            string = this.target.getLineVariable();
            bl2 = this.target.isLinesUnitPixel();
        } else if ("lines pixels".equals(string2)) {
            if (object2.toString().trim().length() == 0) {
                object2 = "0";
            }
            n = Math.round(PropertyDescriptorRegistry.parseFloat((String)((String)object2)));
            int n3 = this.getModelHeight(n);
            this.target.setLinesPixels(n);
            if (this.target instanceof AbstractComboBox && !((ComboBoxModel)this).isVResizeEnabled()) {
                n3 = ((AbstractComboBox)this.target).getComboHeight(n3);
            }
            this.intSetSize(new Dimension(this.size.width, n3));
            this.intSetLocation(this.getLocation());
            bl = false;
            n2 = 1;
            string = this.target.getLinesVariable();
            bl2 = this.target.isLinesUnitPixel();
        } else if ("size pixels".equals(string2)) {
            if (object2.toString().trim().length() == 0) {
                object2 = "0";
            }
            n = Math.round(PropertyDescriptorRegistry.parseFloat((String)((String)object2)));
            int n4 = this.getModelWidth(n);
            this.target.setSizePixels(n);
            this.intSetSize(new Dimension(n4, this.size.height));
            bl = false;
            n2 = 2;
            string = this.target.getSizeVariable();
            bl2 = this.target.isSizeUnitPixel();
        } else if ("column".equals(string2)) {
            this.target.setColumn((String)object2);
            this.updateLocations((int)this.target.getColumnPixels(), (int)this.target.getLinePixels());
            bl = false;
            n2 = 4;
            string = this.target.getColumnVariable();
            bl2 = this.target.isSizeUnitPixel();
        } else if ("line".equals(string2)) {
            this.target.setLine((String)object2);
            this.updateLocations((int)this.target.getColumnPixels(), (int)this.target.getLinePixels());
            bl = false;
            n2 = 3;
            string = this.target.getLineVariable();
            bl2 = this.target.isLinesUnitPixel();
        } else if ("lines".equals(string2)) {
            if (object2.toString().trim().length() == 0) {
                object2 = "0";
            }
            float f = PropertyDescriptorRegistry.parseFloat((String)((String)object2));
            n = !this.target.isLinesUnitCell() && !this.target.isLinesUnitPixel() ? this.target.getControlHeight(f) : (int)(f * (float)this.getCellHeight());
            this.target.setLines(f);
            if (this.target instanceof AbstractComboBox && !((ComboBoxModel)this).isVResizeEnabled()) {
                this.intSetSize(new Dimension(this.size.width, ((AbstractComboBox)this.target).getComboHeight(n)));
            } else {
                this.intSetSize(new Dimension(this.size.width, this.getModelHeight(n)));
            }
            this.intSetLocation(this.getLocation());
            bl = false;
            n2 = 1;
            string = this.target.getLinesVariable();
            bl2 = this.target.isLinesUnitPixel();
        } else if ("size".equals(string2)) {
            if (object2.toString().trim().length() == 0) {
                object2 = "0";
            }
            float f = PropertyDescriptorRegistry.parseFloat((String)((String)object2));
            n = !this.target.isSizeUnitCell() && !this.target.isSizeUnitPixel() ? this.target.getControlWidth(f) : (int)(f * (float)this.getCellWidth());
            this.target.setSize(f);
            this.intSetSize(new Dimension(this.getModelWidth(n), this.size.height));
            bl = false;
            n2 = 2;
            string = this.target.getSizeVariable();
            bl2 = this.target.isSizeUnitPixel();
        } else {
            if ("tab order".equals(string2)) {
                ContainerModel containerModel;
                if (object2.toString().trim().length() == 0) {
                    object2 = "0";
                }
                ComponentsContainer componentsContainer = (containerModel = (ContainerModel)this.getParent()) instanceof ScreenSectionModel ? (ComponentsContainer)containerModel.getParentWindow().getTarget() : (ComponentsContainer)((ModelElement)containerModel).getTarget();
                TreeStructuredData treeStructuredData = new TreeStructuredData();
                this.loadTree(treeStructuredData, componentsContainer);
                int n5 = this.target.getTabOrder();
                int n6 = Integer.parseInt(object2.toString());
                this.target.setTabOrder(n6);
                AbstractBeanControl[] abstractBeanControlArray = IscobolBeanConstants.getAllComponents((AbstractBeanControl[])componentsContainer.getComponents());
                IscobolBeanConstants.updateTabOrders((TabOrderable[])((TabOrderable[])abstractBeanControlArray), (TabOrderable)this.target, (int)n5);
                Arrays.sort(abstractBeanControlArray, PluginUtilities.tabOrderableComparator);
                this.updateTree(abstractBeanControlArray, 0, treeStructuredData);
                this.updateChildren(treeStructuredData.getItems(), componentsContainer, new int[1]);
                ComponentModel[] componentModelArray = new ComponentModel[containerModel.getComponentCount()];
                containerModel.getComponents(componentModelArray);
                for (int i = 0; i < componentModelArray.length; ++i) {
                    componentModelArray[i].update();
                }
                ((ContainerModel)this.getParent()).updateStructure();
                return;
            }
            if ("screen-occurs".equals(string2)) {
                if (object2.toString().trim().length() == 0) {
                    object2 = "0";
                }
                this.target.setOccurs(Integer.parseInt(object2.toString()));
                this.updateLocations((int)this.target.getColumnPixels(), (int)this.target.getLinePixels());
                bl = false;
            }
        }
        Object object3 = null;
        if (bl) {
            object3 = PropertyDescriptorRegistry.getProperty((Object)this.getTarget(), (String)string2);
        }
        PropertyDescriptorRegistry.setProperty((Object)this.getTarget(), (String)string2, (Object)object2, (ScreenProgram)(n2 > 0 ? null : screenProgram));
        if (n2 > 0 && string != null && (variableType = screenProgram.getProgramVariable(string)) != null && this.canModify(variableType)) {
            this.changeVariableValue(variableType, n2, bl2);
        }
        if (bl) {
            this.firePropertyChange(string2, object3, object2);
        }
        if (this.affectSize(string2)) {
            this.intSetSize(new Dimension(this.getModelWidth((int)this.target.getSizePixels()), this.getModelHeight((int)this.target.getLinesPixels())));
        }
    }

    protected boolean canModify(VariableType variableType) {
        return !variableType.isExtVar() && variableType.getLevelAsInt() != 78;
    }

    private void updateLocations(int n, int n2) {
        if (this.isOnRibbonHeader()) {
            return;
        }
        ContainerModel containerModel = (ContainerModel)this.getParent();
        ComponentModel[] componentModelArray = new ComponentModel[containerModel.getComponentCount()];
        containerModel.getComponents(componentModelArray);
        for (int i = 0; i < componentModelArray.length; ++i) {
            Point point = componentModelArray[i] == this ? new Point(n - 1, n2 - 1) : new Point((int)componentModelArray[i].target.getColumnPixels() - 1, (int)componentModelArray[i].target.getLinePixels() - 1);
            componentModelArray[i].intSetLocation(point);
        }
    }

    private void updateChildren(TreeStructuredData<AbstractBeanControl>[] treeStructuredDataArray, ComponentsContainer componentsContainer, int[] nArray) {
        componentsContainer.removeAllComponents();
        for (int i = 0; i < treeStructuredDataArray.length; ++i) {
            AbstractBeanControl abstractBeanControl = (AbstractBeanControl)treeStructuredDataArray[i].getData();
            componentsContainer.addComponent(abstractBeanControl);
            if (abstractBeanControl instanceof GroupBeanControl) {
                this.updateChildren(treeStructuredDataArray[i].getItems(), (ComponentsContainer)((GroupBeanControl)abstractBeanControl), nArray);
                continue;
            }
            nArray[0] = nArray[0] + 1;
            abstractBeanControl.setTabOrder(nArray[0], false);
        }
    }

    private void loadTree(TreeStructuredData<AbstractBeanControl> treeStructuredData, ComponentsContainer componentsContainer) {
        AbstractBeanControl[] abstractBeanControlArray = componentsContainer.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            TreeStructuredData treeStructuredData2 = new TreeStructuredData((Object)abstractBeanControlArray[i]);
            treeStructuredData.addItem(treeStructuredData2);
            if (!(abstractBeanControlArray[i] instanceof GroupBeanControl)) continue;
            this.loadTree(treeStructuredData2, (ComponentsContainer)((GroupBeanControl)abstractBeanControlArray[i]));
        }
    }

    private int updateTree(AbstractBeanControl[] abstractBeanControlArray, int n, TreeStructuredData<AbstractBeanControl> treeStructuredData) {
        TreeStructuredData[] treeStructuredDataArray = treeStructuredData.getItems();
        for (int i = 0; i < treeStructuredDataArray.length; ++i) {
            if (treeStructuredDataArray[i].getItemCount() == 0) {
                treeStructuredDataArray[i].setData((Object)abstractBeanControlArray[n++]);
                continue;
            }
            n = this.updateTree(abstractBeanControlArray, n, treeStructuredDataArray[i]);
        }
        return n;
    }

    protected boolean affectSize(String string) {
        if (string.equals("size unit") || string.equals("lines unit") || string.equals("height-in-cells") || string.equals("width-in-cells") || string.equals("font")) {
            return true;
        }
        if (this.target instanceof AbstractButton) {
            return string.equals("bitmap");
        }
        if (this.target instanceof AbstractEntryField) {
            return string.equals("border") || string.equals("style");
        }
        if (this.target instanceof AbstractGrid) {
            return string.equals("row settings") || string.equals("column settings") || string.equals("row dividers") || string.equals("vpadding") || string.equals("hscroll") || string.equals("vscroll");
        }
        return false;
    }

    void changeVariableValue(VariableType variableType, int n, boolean bl) {
        switch (n) {
            case 3: {
                variableType.setValue(bl ? Integer.toString((int)this.target.calculateLinePixels()) : Float.toString(this.target.calculateLine()));
                break;
            }
            case 4: {
                variableType.setValue(bl ? Integer.toString((int)this.target.calculateColumnPixels()) : Float.toString(this.target.calculateColumn()));
                break;
            }
            case 1: {
                variableType.setValue(bl ? Integer.toString((int)this.target.getLinesPixels()) : Float.toString(this.target.getLines()));
                break;
            }
            case 2: {
                variableType.setValue(bl ? Integer.toString((int)this.target.getSizePixels()) : Float.toString(this.target.getSize()));
            }
        }
    }

    private boolean hasBitmap() {
        return this.target instanceof AbstractBitmap || this.target instanceof AbstractButton && ((AbstractButton)this.target).getBitmap() != null;
    }

    public boolean isEditorComponent() {
        return this.editorComponent;
    }

    protected int getModelWidth(int n) {
        if (this.hasBitmap() && this.isSizeDefault()) {
            n += 8;
        }
        return n;
    }

    protected int getModelHeight(int n) {
        if (this.hasBitmap() && this.isLinesDefault()) {
            n += 8;
        }
        return n;
    }

    private boolean isSizeDefault() {
        return !this.target.isSizeUnitPixel() && this.target.getSizeUnit().getValue() != 2 && !this.target.getWidthInCells();
    }

    private boolean isLinesDefault() {
        return !this.target.isLinesUnitPixel() && this.target.getLinesUnit().getValue() != 2 && !this.target.getHeightInCells();
    }

    public void setEditorComponent(boolean bl) {
        this.editorComponent = bl;
    }

    void changeVariableValue(Object object, String string, VariableType variableType, boolean bl) {
        if (string.endsWith(" variable")) {
            boolean bl2 = this.getParentWindow().isUnitPixel();
            boolean bl3 = this.hasBitmap();
            String string2 = string.substring(0, string.length() - " variable".length());
            if ("line".equals(string2)) {
                this.changeVariableValue(variableType, 3, bl2);
            } else if ("size".equals(string2)) {
                this.changeVariableValue(variableType, 2, bl2 || bl3);
            } else if ("lines".equals(string2)) {
                this.changeVariableValue(variableType, 1, bl2 || bl3);
            } else if ("column".equals(string2)) {
                this.changeVariableValue(variableType, 4, bl2);
            } else {
                super.changeVariableValue(object, string, variableType, bl);
            }
        }
    }

    public AbstractBeanControl createTarget() {
        if (this.target == null) {
            switch (this.type) {
                case 104: {
                    this.target = new SwingCheckBox();
                    break;
                }
                case 102: {
                    this.target = new SwingPushButton();
                    break;
                }
                case 103: {
                    this.target = new SwingRadioButton();
                    break;
                }
                case 105: {
                    this.target = new SwingLabel();
                    break;
                }
                case 14: {
                    this.target = new SwingAccordion();
                    break;
                }
                case 109: {
                    this.target = new SwingTab();
                    break;
                }
                case 101: {
                    this.target = new SwingEntryField();
                    break;
                }
                case 106: {
                    this.target = new SwingBitmap();
                    break;
                }
                case 107: {
                    this.target = new SwingListBox();
                    break;
                }
                case 120: {
                    this.target = new SwingCheckListBox();
                    break;
                }
                case 108: {
                    this.target = new SwingComboBox();
                    break;
                }
                case 113: {
                    this.target = new SwingFrame();
                    break;
                }
                case 110: {
                    this.target = new SwingGrid();
                    break;
                }
                case 114: {
                    this.target = new SwingBar();
                    break;
                }
                case 112: {
                    this.target = new SwingScrollbar();
                    break;
                }
                case 117: {
                    this.target = new SwingSlider();
                    break;
                }
                case 119: {
                    this.target = new SwingDateEntry();
                    break;
                }
                case 115: {
                    this.target = new SwingTreeView();
                    break;
                }
                case 116: {
                    this.target = new SwingWebBrowser();
                    break;
                }
                case 118: {
                    this.target = new SwingJavaBean();
                }
            }
            this.location = new Point((int)this.target.getColumnPixels() - 1, (int)this.target.getLinePixels() - 1);
            this.size = new Dimension((int)this.target.getSizePixels(), (int)this.target.getLinesPixels());
        }
        return this.target;
    }

    public Object getTarget() {
        return this.target;
    }

    public boolean isCreatingComponent() {
        return this.creatingComponent;
    }

    public void setCreatingComponent(boolean bl) {
        this.creatingComponent = bl;
    }

    public String toString() {
        String string = this.target.getIdVariable();
        return this.target.getName() + " (" + IscobolBeanConstants.getTypeName((int)this.type) + ") ID " + (string != null && string.length() > 0 ? string : Integer.toString(this.target.getId()));
    }

    public boolean isLockable() {
        return this.getTarget() instanceof AbstractBeanControl;
    }

    public boolean isOnRibbonHeader() {
        return this.getParent() instanceof RibbonModel;
    }

    public ComponentModel getOnHeaderButton() {
        return this.onHeaderButton;
    }

    public void setOnHeaderButton(ComponentModel componentModel) {
        this.onHeaderButton = componentModel;
    }

    public ComponentModel getOnPageButton() {
        return this.onPageButton;
    }

    public void setOnPageButton(ComponentModel componentModel) {
        this.onPageButton = componentModel;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.intFirePropertyChange(string, object, object2);
        if (!"on-header".equals(string)) {
            if (this.onPageButton != null) {
                this.onPageButton.intFirePropertyChange(string, object, object2);
            }
            if (this.onHeaderButton != null) {
                this.onHeaderButton.intFirePropertyChange(string, object, object2);
            }
        }
    }
}

