/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanStatusbar;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.swing.SwingStatusbar;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ScreenSectionModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.ResourcePropertySource;
import com.iscobol.screenpainter.propertysheet.ResourceRegistry;
import com.iscobol.screenpainter.util.ImageProvider;
import java.awt.FontMetrics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;

public class StatusbarModel
extends ComponentModel {
    private static final long serialVersionUID = 1L;
    private AbstractBeanStatusbar statusBar;
    private int statusBarHeight;

    public StatusbarModel(int n) {
        super(n);
        this.size = new Dimension(0, 0);
        this.location = new Point(0, 0);
        FontMetrics fontMetrics = this.statusBar.getComponent().getFontMetrics(this.statusBar.getFont().getFont());
        this.statusBarHeight = (int)((float)fontMetrics.getHeight() * this.statusBar.getLines());
    }

    public StatusbarModel(AbstractBeanStatusbar abstractBeanStatusbar, ScreenSectionModel screenSectionModel) {
        super(abstractBeanStatusbar.getType());
        this.statusBar = abstractBeanStatusbar;
        this.parent = screenSectionModel;
        FontMetrics fontMetrics = this.statusBar.getComponent().getFontMetrics(this.statusBar.getFont().getFont());
        this.statusBarHeight = (int)((float)fontMetrics.getHeight() * this.statusBar.getLines());
        this.size = new Dimension(this.getParentWindow().getScreenSize().width, this.statusBarHeight);
        this.location = new Point(0, this.getParentWindow().getScreenSize().height - this.statusBarHeight);
    }

    public String getName() {
        return this.statusBar.getName();
    }

    public void setLocation(Point point) {
        this.intSetLocation(point);
    }

    public void setSize(Dimension dimension) {
        this.intSetSize(dimension);
    }

    void changeVariableValue(VariableType variableType, int n, boolean bl) {
    }

    public int getStatusBarHeight() {
        return this.statusBarHeight;
    }

    public AbstractBeanStatusbar getStatusbar() {
        return this.statusBar;
    }

    private void computeFontHeight(FontType fontType, float f) {
        if (fontType == null) {
            return;
        }
        FontMetrics fontMetrics = this.statusBar.getComponent().getFontMetrics(fontType.getFont());
        this.statusBarHeight = (int)((float)fontMetrics.getHeight() * f);
        Dimension dimension = new Dimension(this.getParentWindow().getScreenSize().width, this.statusBarHeight);
        Point point = new Point(0, this.getParentWindow().getScreenSize().height - this.statusBarHeight);
        this.intSetSize(dimension);
        this.intSetLocation(point);
    }

    public void setPropertyValue(Object object, Object object2) {
        Object object3;
        Object object4 = PropertyDescriptorRegistry.getProperty((Object)this.getTarget(), (String)object.toString());
        if ("font".equals(object)) {
            ResourcePropertySource resourcePropertySource = (ResourcePropertySource)object2;
            object3 = (FontType)resourcePropertySource.getResource();
            object2 = object3;
            this.computeFontHeight(object3, this.statusBar.getLines());
            WindowModel windowModel = this.getParentWindow();
            ScreenProgram screenProgram = windowModel.getScreenProgram();
            ResourceRegistry resourceRegistry = screenProgram.getResourceRegistry();
            FontType fontType = (FontType)object4;
            VariableType variableType = null;
            VariableType variableType2 = null;
            if (fontType != null) {
                variableType = fontType.getHandle();
            }
            if (object3 != null) {
                resourceRegistry.registerFont(object3);
                variableType2 = object3.getHandle();
            }
            if (!(variableType == null || variableType2 != null && variableType.equals((Object)variableType2))) {
                resourceRegistry.unregisterVariable(variableType, (Object)this.target, "font");
            }
            if (!(variableType2 == null || variableType != null && variableType.equals((Object)variableType2))) {
                resourceRegistry.registerVariable(variableType2, (Object)this.target, "font");
            }
        } else if (this.intSetPropertyValue(object, object2, this.getTarget())) {
            return;
        }
        boolean bl = true;
        if ("lines".equals(object)) {
            object3 = this.statusBar.getFont();
            float f = 0.0f;
            try {
                f = PropertyDescriptorRegistry.parseFloat((String)object2.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f < 1.5f) {
                f = 1.5f;
            }
            object2 = Float.toString(f);
            this.computeFontHeight(object3, f);
            bl = false;
        }
        object3 = object.toString();
        PropertyDescriptorRegistry.setProperty((Object)this.getTarget(), (String)object3, (Object)object2, (ScreenProgram)this.getParentWindow().getScreenProgram());
        if (bl) {
            this.firePropertyChange(object.toString(), object4, object2);
        }
    }

    public Image getIcon() {
        ImageProvider imageProvider = IscobolScreenPainterPlugin.getDefault().getImageProvider();
        return imageProvider.getImage("/statusbar.png");
    }

    public AbstractBeanControl createTarget() {
        if (this.statusBar == null) {
            switch (this.getType()) {
                default: 
            }
            this.statusBar = new SwingStatusbar();
        }
        return null;
    }

    public String toString() {
        return this.statusBar.getName() + " (" + IscobolBeanConstants.getTypeName((int)this.getType()) + ")";
    }

    public Object getTarget() {
        return this.statusBar;
    }

    protected Point getRealLocation(Point point, ModelElement modelElement, int n) {
        return point.getCopy();
    }

    protected Point getTargetLocation() {
        return this.location.getCopy();
    }
}

