/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model;

import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.TabPageModel;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TabControlModel
extends ComponentModel {
    private static final long serialVersionUID = 1L;
    public static final String TABPAGE_ADDED_PROP = "TabPageAdded";
    public static final String TABPAGE_REMOVED_PROP = "TabPageRemoved";
    protected List pages = new ArrayList();

    public TabControlModel(int n) {
        super(n);
    }

    public TabControlModel(AbstractBeanControl abstractBeanControl) {
        super(abstractBeanControl);
        this.addChildren();
    }

    public void addPage(TabPageModel tabPageModel) {
        this.addPage(-1, tabPageModel, true);
    }

    public void addPage(int n, TabPageModel tabPageModel) {
        this.addPage(n, tabPageModel, true);
    }

    public void addPage(int n, TabPageModel tabPageModel, boolean bl) {
        if (tabPageModel != null) {
            if (n < 0 || n >= this.pages.size()) {
                this.pages.add(tabPageModel);
            } else {
                this.pages.add(n, tabPageModel);
            }
            ((AbstractTabbedPane)this.getTarget()).addPage(n, (TabPage)tabPageModel.getTarget());
            if (bl) {
                this.firePropertyChange(TABPAGE_ADDED_PROP, null, (Object)tabPageModel);
            }
        }
    }

    public int removePage(TabPageModel tabPageModel) {
        return this.removePage(tabPageModel, true);
    }

    public int removePage(TabPageModel tabPageModel, boolean bl) {
        if (tabPageModel != null) {
            int n = this.pages.indexOf(tabPageModel);
            if (n >= 0) {
                this.pages.remove(n);
                ((AbstractTabbedPane)this.getTarget()).removePage((TabPage)tabPageModel.getTarget());
                if (bl) {
                    this.firePropertyChange(TABPAGE_REMOVED_PROP, null, (Object)tabPageModel);
                }
            }
            return n;
        }
        return -1;
    }

    public int getButtonsHeight() {
        return ((AbstractTabbedPane)this.target).getButtonsHeight();
    }

    public List getPages() {
        return this.pages;
    }

    public List<ModelElement> getChildren() {
        return this.pages;
    }

    public void getPages(TabPageModel[] tabPageModelArray) {
        this.pages.toArray(tabPageModelArray);
    }

    public int getPageCount() {
        return this.pages.size();
    }

    protected void addChildren() {
        TabPage[] tabPageArray = ((AbstractTabbedPane)this.getTarget()).getPages();
        Arrays.sort(tabPageArray, PluginUtilities.tabOrderableComparator);
        for (int i = 0; i < tabPageArray.length; ++i) {
            TabPageModel tabPageModel = new TabPageModel(tabPageArray[i]);
            this.pages.add(tabPageModel);
            tabPageModel.setParent((ModelElement)this);
        }
    }

    public void updateStructure() {
        this.pages.clear();
        this.addChildren();
        this.firePropertyChange("Element.UpdateStructure", null, (Object)this.pages);
    }
}

