/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.model.IToolbarModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.ToolbarModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.util.ImageProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ToolbarContainerModel
extends ModelElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TOOLBAR_ADDED_PROP = "ToolbarAdded";
    public static final String TOOLBAR_REMOVED_PROP = "ToolbarRemoved";
    protected List toolbars = new ArrayList();

    public ToolbarContainerModel(WindowModel windowModel) {
        this.parent = windowModel;
        this.addChildren();
        this.location = new Point(0, 0);
        this.size = new Dimension(0, 0);
    }

    public void setLocation(Point point) {
    }

    public void setSize(Dimension dimension) {
    }

    public int getType() {
        return -1;
    }

    protected void addChildren() {
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.parent.getTarget();
        IToolbar[] iToolbarArray = abstractBeanWindow.getToolbars();
        Arrays.sort(iToolbarArray, PluginUtilities.tabOrderableComparator);
        for (IToolbar iToolbar : iToolbarArray) {
            iToolbar.setPalette(abstractBeanWindow.getPalette());
            Object object = iToolbar instanceof AbstractBeanToolbar ? new ToolbarModel((AbstractBeanToolbar)iToolbar, this) : new RibbonModel((AbstractRibbon)iToolbar, this);
            this.toolbars.add(object);
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors(int n) {
        return new IPropertyDescriptor[0];
    }

    public Image getIcon() {
        ImageProvider imageProvider = IscobolScreenPainterPlugin.getDefault().getImageProvider();
        return imageProvider.getImage("/toolbarlist.png");
    }

    public Object getTarget() {
        return null;
    }

    public void setPropertyValue(Object object, Object object2) {
    }

    public int getToolbarCount() {
        return this.toolbars.size();
    }

    public int getHeight() {
        int n = 0;
        for (int i = 0; i < this.getToolbarCount(); ++i) {
            n += ((IToolbarModel)this.toolbars.get(i)).getToolbarHeight();
        }
        return n;
    }

    public List<ModelElement> getChildren() {
        return this.toolbars;
    }

    public void addToolbar(IToolbarModel iToolbarModel) {
        this.addToolbar(-1, iToolbarModel, true);
    }

    public void addToolbar(int n, IToolbarModel iToolbarModel) {
        this.addToolbar(n, iToolbarModel, true);
    }

    public void addToolbar(int n, IToolbarModel iToolbarModel, boolean bl) {
        if (iToolbarModel != null) {
            if (n < 0 || n >= this.toolbars.size()) {
                this.toolbars.add(iToolbarModel);
            } else {
                this.toolbars.add(n, iToolbarModel);
            }
            ((AbstractBeanWindow)this.parent.getTarget()).addToolbar(n, (IToolbar)iToolbarModel.getTarget());
            if (bl) {
                this.firePropertyChange(TOOLBAR_ADDED_PROP, null, (Object)iToolbarModel);
            }
            this.getParent().firePropertyChange(TOOLBAR_ADDED_PROP, null, (Object)iToolbarModel);
        }
    }

    public int removeToolbar(IToolbarModel iToolbarModel) {
        return this.removeToolbar(iToolbarModel, true);
    }

    public int removeToolbar(IToolbarModel iToolbarModel, boolean bl) {
        if (iToolbarModel != null) {
            int n = this.toolbars.indexOf(iToolbarModel);
            if (n >= 0) {
                this.toolbars.remove(n);
                ((AbstractBeanWindow)this.parent.getTarget()).removeToolbar((IToolbar)iToolbarModel.getTarget());
                if (bl) {
                    this.firePropertyChange(TOOLBAR_REMOVED_PROP, null, (Object)iToolbarModel);
                }
                this.getParent().firePropertyChange(TOOLBAR_REMOVED_PROP, null, (Object)iToolbarModel);
            }
            return n;
        }
        return -1;
    }

    public List<IToolbarModel> getToolbars() {
        return this.toolbars;
    }

    public void getToolbars(IToolbarModel[] iToolbarModelArray) {
        this.toolbars.toArray(iToolbarModelArray);
    }

    public void updateStructure() {
        this.toolbars.clear();
        this.addChildren();
        this.firePropertyChange("Element.UpdateStructure", null, (Object)this.toolbars);
    }
}

