/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model;

import com.iscobol.plugins.editor.views.IIscobolNavigator;
import com.iscobol.screenpainter.CodeGenerator;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ScreenSectionModel;
import com.iscobol.screenpainter.model.ToolbarContainerModel;
import com.iscobol.screenpainter.propertysheet.EventParagraphs;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.ResourceRegistry;
import com.iscobol.screenpainter.util.ImageProvider;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;

public class WindowModel
extends ModelElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UPDATE_UI_PROPERTY = "iscobolsp.updateui";
    public static final String UPDATE_PROPERTY = "iscobolsp.update";
    public static final String UPDATE_SCREEN_PROPERTY = "iscobolsp.updatescreen";
    private static final int LINES = 1;
    private static final int SIZE = 2;
    private static final int SCREEN_LINE = 3;
    private static final int SCREEN_COLUMN = 4;
    private ScreenSectionModel screen;
    private ToolbarContainerModel toolContainer;
    protected AbstractBeanWindow target;
    private ScreenProgram program;
    private Dimension screenSize = new Dimension(0, 0);
    private TreeMap<Integer, Integer> controlIds = new TreeMap();
    private TreeMap<Integer, Integer> controlExceptionValues = new TreeMap();
    private boolean forceShowTabOrder;

    public WindowModel(AbstractBeanWindow abstractBeanWindow, ScreenProgram screenProgram) {
        this.target = abstractBeanWindow;
        this.program = screenProgram;
        this.target.setPalette(screenProgram.getScreenPalette());
        this.screenSize = new Dimension(this.target.getSizePixels(), this.target.getLinesPixels());
        this.toolContainer = new ToolbarContainerModel(this);
        this.screen = new ScreenSectionModel(this);
        this.location = new Point(1, 1);
        this.registerControlIds((ResourcesProvider)this.target);
        this.registerControlExceptionValues((ResourcesProvider)this.target);
        this.initSize();
    }

    public int getWidthInset() {
        return 6;
    }

    public int getHeightInset() {
        if (this.target == null || this.target.getHasTitleBar() || this.target.getTitle() != null && this.target.getTitle().length() > 0) {
            return 25;
        }
        return 6;
    }

    public boolean isDocking() {
        return this.isType(4);
    }

    public boolean isDockable() {
        return this.isType(5);
    }

    public boolean isMDIParent() {
        return this.isType(6);
    }

    public boolean isMDIChild() {
        return this.isType(7);
    }

    public boolean isNotification() {
        return this.isType(8);
    }

    private boolean isType(int n) {
        return this.target != null && this.target.getWindowType().getValue() == n;
    }

    public String getName() {
        return this.target.getName();
    }

    public int getType() {
        return this.target.getType();
    }

    public void updateUI() {
        this.firePropertyChange(UPDATE_UI_PROPERTY, (Object)"old", (Object)"new");
    }

    public void updateScreen() {
        this.firePropertyChange(UPDATE_SCREEN_PROPERTY, (Object)"old", (Object)"new");
    }

    public void updateControlDecorations(String string) {
        this.firePropertyChange(string, (Object)"old", (Object)"new");
    }

    public void setScreenProgram(ScreenProgram screenProgram) {
        this.program = screenProgram;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.program.getResourceRegistry();
    }

    public ScreenProgram getScreenProgram() {
        return this.program;
    }

    public EventParagraphs getEventParagraphs() {
        return this.program.getEventParagraphs();
    }

    private void initSize() {
        this.size = this.screenSize.getCopy();
        this.size.height += this.toolContainer.getHeight();
        this.size.height += this.getHeightInset();
        this.size.width += this.getWidthInset();
    }

    public ToolbarContainerModel getToolbarContainer() {
        return this.toolContainer;
    }

    public ScreenSectionModel getScreenSection() {
        return this.screen;
    }

    public List<ModelElement> getChildren() {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        arrayList.add((ModelElement)this.toolContainer);
        arrayList.add((ModelElement)this.screen);
        return arrayList;
    }

    public void setPropertyValue(Object object, Object object2) {
        if ("name".equals(object)) {
            int n;
            ScreenProgramEditor screenProgramEditor;
            AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getTarget();
            String string = abstractBeanWindow.getName();
            String string2 = object2.toString();
            CodeGenerator codeGenerator = new CodeGenerator(this.getScreenProgram());
            String[] stringArray = codeGenerator.getScreenParNames(abstractBeanWindow, new HashMap());
            this.setNewValue(this.getTarget(), object.toString(), (Object)string2, true, this.getScreenProgram());
            for (int i = 0; i < stringArray.length; ++i) {
                this.getResourceRegistry().renameParagraph(stringArray[i], stringArray[i].replace(string, string2));
            }
            IIscobolNavigator iIscobolNavigator = PluginUtilities.findStructuralNavigator();
            if (iIscobolNavigator != null) {
                iIscobolNavigator.refresh((Object)new ScreenProgramAdapter(this.getScreenProgram().getFile()));
            }
            if ((screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor()) != null && (n = screenProgramEditor.indexOfScreenSection(string2)) >= 0) {
                screenProgramEditor.setPageText(n, ((AbstractBeanWindow)this.getTarget()).getName());
            }
            return;
        }
        if (this.intSetPropertyValue(object, object2, this.getTarget())) {
            return;
        }
        boolean bl = true;
        ScreenProgram screenProgram = this.getScreenProgram();
        if ("lines pixels".equals(object)) {
            Dimension dimension = this.getSize();
            dimension.height = Integer.parseInt((String)object2) + this.getToolbarContainer().getHeight() + this.getHeightInset();
            bl = false;
            this.setSize(dimension);
        } else if ("size pixels".equals(object)) {
            Dimension dimension = this.getSize();
            dimension.width = Integer.parseInt((String)object2) + this.getWidthInset();
            bl = false;
            this.setSize(dimension);
        } else if ("lines".equals(object)) {
            Dimension dimension = this.getSize();
            dimension.height = (int)(PropertyDescriptorRegistry.parseFloat((String)((String)object2)) * (float)this.getCellHeight()) + this.getToolbarContainer().getHeight() + this.getHeightInset();
            bl = false;
            this.setSize(dimension);
        } else if ("size".equals(object)) {
            Dimension dimension = this.getSize();
            dimension.width = (int)(PropertyDescriptorRegistry.parseFloat((String)((String)object2)) * (float)this.getCellWidth()) + this.getWidthInset();
            bl = false;
            this.setSize(dimension);
        } else if ("screen line".equals(object)) {
            VariableType variableType;
            this.target.setScreenLine(PropertyDescriptorRegistry.parseFloat((String)((String)object2)));
            String string = this.target.getScreenLineVariable();
            if (string != null && (variableType = this.getScreenProgram().getProgramVariable(string)) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
                variableType.setValue(Integer.toString(this.target.getScreenLinePixels()));
            }
            bl = false;
            screenProgram = null;
        } else if ("screen column".equals(object)) {
            VariableType variableType;
            this.target.setScreenColumn(PropertyDescriptorRegistry.parseFloat((String)((String)object2)));
            String string = this.target.getScreenColumnVariable();
            if (string != null && (variableType = this.getScreenProgram().getProgramVariable(string)) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
                variableType.setValue(Integer.toString(this.target.getScreenColumnPixels()));
            }
            bl = false;
            screenProgram = null;
        } else if ("screen line pixels".equals(object)) {
            VariableType variableType;
            this.target.setScreenLinePixels(Integer.parseInt((String)object2));
            String string = this.target.getScreenLineVariable();
            if (string != null && (variableType = this.getScreenProgram().getProgramVariable(string)) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
                variableType.setValue(Integer.toString(this.target.getScreenLinePixels()));
            }
            bl = false;
            screenProgram = null;
        } else if ("screen column pixels".equals(object)) {
            VariableType variableType;
            this.target.setScreenColumnPixels(Integer.parseInt((String)object2));
            String string = this.target.getScreenColumnVariable();
            if (string != null && (variableType = this.getScreenProgram().getProgramVariable(string)) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
                variableType.setValue(Integer.toString(this.target.getScreenColumnPixels()));
            }
            bl = false;
            screenProgram = null;
        }
        this.setNewValue(this.getTarget(), object.toString(), object2, bl, screenProgram);
    }

    private void changeVariableValue(VariableType variableType, int n, boolean bl) {
        switch (n) {
            case 1: {
                variableType.setValue(bl ? Integer.toString(this.target.getLinesPixels()) : Float.toString(this.target.getLines()));
                break;
            }
            case 2: {
                variableType.setValue(bl ? Integer.toString(this.target.getSizePixels()) : Float.toString(this.target.getSize()));
            }
            case 3: {
                variableType.setValue(Integer.toString(this.target.getScreenLinePixels()));
                break;
            }
            case 4: {
                variableType.setValue(Integer.toString(this.target.getScreenColumnPixels()));
            }
        }
    }

    void changeVariableValue(Object object, String string, VariableType variableType, boolean bl) {
        if (string.endsWith(" variable")) {
            boolean bl2 = this.getParentWindow().isUnitPixel();
            String string2 = string.substring(0, string.length() - " variable".length());
            if ("size".equals(string2)) {
                this.changeVariableValue(variableType, 2, bl2);
            } else if ("lines".equals(string2)) {
                this.changeVariableValue(variableType, 1, bl2);
            } else if ("screen line".equals(string2)) {
                this.changeVariableValue(variableType, 3, bl2);
            } else if ("screen column".equals(string2)) {
                this.changeVariableValue(variableType, 4, bl2);
            } else {
                super.changeVariableValue(object, string, variableType, bl);
            }
        }
    }

    private void setNewValue(Object object, String string, Object object2, boolean bl, ScreenProgram screenProgram) {
        Object object3 = null;
        if (bl) {
            object3 = PropertyDescriptorRegistry.getProperty((Object)this.getTarget(), (String)string);
        }
        PropertyDescriptorRegistry.setProperty((Object)this.getTarget(), (String)string, (Object)object2, (ScreenProgram)screenProgram);
        if (bl) {
            this.firePropertyChange(string, object3, object2);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
        this.screen.firePropertyChange(string, object, object2);
    }

    public void setSize(Dimension dimension) {
        if (dimension != null) {
            VariableType variableType;
            String string;
            boolean bl = dimension.width != this.size.width;
            boolean bl2 = dimension.height != this.size.height;
            this.size.setSize(dimension);
            dimension.height -= this.getToolbarContainer().getHeight();
            dimension.height -= this.getHeightInset();
            dimension.width -= this.getWidthInset();
            this.intSetScreenSize(dimension);
            this.screen.firePropertyChange("Component.Size", null, (Object)this.size);
            this.firePropertyChange("Component.Size", null, (Object)this.size);
            if (bl) {
                this.target.setSizePixels(dimension.width);
                string = this.target.getSizeVariable();
                if (string != null && (variableType = this.getScreenProgram().getProgramVariable(string)) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
                    variableType.setValue(this.isUnitPixel() ? Integer.toString(this.target.getSizePixels()) : Float.toString(this.target.getSize()));
                }
            }
            if (bl2) {
                this.target.setLinesPixels(dimension.height);
                string = this.target.getLinesVariable();
                if (string != null && (variableType = this.getScreenProgram().getProgramVariable(string)) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
                    variableType.setValue(this.isUnitPixel() ? Integer.toString(this.target.getLinesPixels()) : Float.toString(this.target.getLines()));
                }
            }
        }
    }

    public void setLocation(Point point) {
    }

    private void intSetScreenSize(Dimension dimension) {
        this.screenSize.setSize(dimension);
        if (this.screen.getStatusBar() != null) {
            int n = this.screen.getStatusBar().getStatusBarHeight();
            this.screen.getStatusBar().setSize(new Dimension(this.screenSize.width, n));
            this.screen.getStatusBar().setLocation(new Point(0, this.screenSize.height - n));
        }
    }

    public void setScreenSize(Dimension dimension) {
        if (dimension != null) {
            this.intSetScreenSize(dimension);
            this.firePropertyChange("Component.Size", null, (Object)this.size);
        }
    }

    public Dimension getScreenSize() {
        return this.screenSize.getCopy();
    }

    public boolean isCell() {
        return this.target.isCell();
    }

    public boolean isUnitPixel() {
        return this.target.getUnit().getValue() == 1;
    }

    public boolean isMeasuringControlFont() {
        return this.target.isCell() && this.target.getCellMeasure().getValue() == 1;
    }

    public Image getIcon() {
        ImageProvider imageProvider = IscobolScreenPainterPlugin.getDefault().getImageProvider();
        return imageProvider.getImage("/screen.png");
    }

    public Object getTarget() {
        return this.target;
    }

    public String toString() {
        return this.target.getName();
    }

    public void registerControlId(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.controlIds.get(n2);
        int n4 = n3 != null ? n3 + 1 : 1;
        this.controlIds.put(n2, new Integer(n4));
    }

    public void unregisterControlId(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.controlIds.get(n2);
        if (n3 != null) {
            if (n3 > 1) {
                this.controlIds.put(n2, new Integer(n3 - 1));
            } else {
                this.controlIds.remove(n2);
            }
        }
    }

    public int getDefaultId() {
        int n = 1;
        while (this.controlIdAlreadyExists(n)) {
            ++n;
        }
        return n;
    }

    public boolean controlIdAlreadyExists(int n) {
        return this.controlIds.containsKey(new Integer(n));
    }

    public void registerControlIds(ResourcesProvider resourcesProvider) {
        Vector vector = resourcesProvider.getControlIds();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.registerControlId(((Integer)vector.elementAt(i)).intValue());
        }
    }

    public void unregisterControlIds(ResourcesProvider resourcesProvider) {
        Vector vector = resourcesProvider.getControlIds();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.unregisterControlId(((Integer)vector.elementAt(i)).intValue());
        }
    }

    public void registerControlExceptionValue(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.controlExceptionValues.get(n2);
        int n4 = n3 != null ? n3 + 1 : 1;
        this.controlExceptionValues.put(n2, new Integer(n4));
    }

    public void unregisterControlExceptionValue(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.controlExceptionValues.get(n2);
        if (n3 != null) {
            if (n3 > 1) {
                this.controlExceptionValues.put(n2, new Integer(n3 - 1));
            } else {
                this.controlExceptionValues.remove(n2);
            }
        }
    }

    public Set<Integer> getControlExceptionValues() {
        return this.controlExceptionValues.keySet();
    }

    public int getDefaultExceptionValue() {
        int n = 1000;
        while (this.controlExceptionValueAlreadyExists(n)) {
            ++n;
        }
        return n;
    }

    public boolean controlExceptionValueAlreadyExists(int n) {
        return this.controlExceptionValues.containsKey(new Integer(n));
    }

    public void registerControlExceptionValues(ResourcesProvider resourcesProvider) {
        Vector vector = resourcesProvider.getControlExceptionValues();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.registerControlExceptionValue(((Integer)vector.elementAt(i)).intValue());
        }
    }

    public void unregisterControlExceptionValues(ResourcesProvider resourcesProvider) {
        Vector vector = resourcesProvider.getControlExceptionValues();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.unregisterControlExceptionValue(((Integer)vector.elementAt(i)).intValue());
        }
    }

    public String getDefaultName(int n) {
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getTarget();
        String string = abstractBeanWindow.getPrefix();
        if (string == null || string.length() == 0) {
            string = abstractBeanWindow.getName();
        }
        return this.program.getDefaultScreenElementName(string, n);
    }

    public void registerControlName(String string) {
        this.program.registerControlName(string);
    }

    public boolean isLockable() {
        return true;
    }

    public boolean isForceShowTabOrder() {
        return this.forceShowTabOrder;
    }

    public void setForceShowTabOrder(boolean bl) {
        this.forceShowTabOrder = bl;
        this.updateControlDecorations("iscobolsp.showtaborder");
    }
}

